/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.floats;

import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigDecimal;

public final class FloatUtils {
    private FloatUtils() {
    }

    public static int skipAsciiWhitespace(String str, int start, int len) {
        int offset;
        for (offset = start; offset < len && FloatUtils.isAsciiSpace(str.charAt(offset)); ++offset) {
        }
        return offset;
    }

    private static boolean isAsciiSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r';
    }

    @CompilerDirectives.TruffleBoundary
    public static String removeUnicodeAndUnderscores(String src) {
        if (!FloatUtils.needsCleanup(src)) {
            return src;
        }
        int len = src.length();
        StringBuilder sb = new StringBuilder(len);
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch == '_') {
                if (prev < '0' || prev > '9') {
                    return null;
                }
            } else {
                if (Character.isWhitespace(ch)) {
                    ch = ' ';
                } else if (ch >= '\u007f') {
                    int digit = Character.digit(ch, 10);
                    if (digit < 0) {
                        return null;
                    }
                    ch = Character.forDigit(digit, 10);
                }
                sb.append(ch);
                if (prev == '_' && (ch < '0' || ch > '9')) {
                    return null;
                }
            }
            prev = ch;
        }
        if (prev == '_') {
            return null;
        }
        return sb.toString();
    }

    private static boolean needsCleanup(String src) {
        int len = src.length();
        for (int i = 0; i < len; ++i) {
            char ch = src.charAt(i);
            if (ch <= '\u007f' && ch != '_') continue;
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static StringToDoubleResult stringToDouble(String str, int start, int len) {
        boolean negate = false;
        int i = start;
        if (i >= len) {
            return null;
        }
        char firstChar = str.charAt(i);
        if (firstChar == '-' || firstChar == '+') {
            boolean bl = negate = firstChar == '-';
            if (++i >= len) {
                return null;
            }
            firstChar = str.charAt(i);
        }
        if (firstChar != '.' && (firstChar < '0' || firstChar > '9')) {
            if (str.regionMatches(true, i, "inf", 0, 3)) {
                if (str.regionMatches(true, i += 3, "inity", 0, 5)) {
                    i += 5;
                }
                return new StringToDoubleResult(negate ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY, i);
            }
            if (str.regionMatches(true, i, "nan", 0, 3)) {
                return new StringToDoubleResult(negate ? Math.copySign(Double.NaN, -1.0) : Double.NaN, i += 3);
            }
            return null;
        }
        boolean seenDot = false;
        boolean seenDigit = false;
        while (i < len) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                seenDigit = true;
            } else if (ch == '.') {
                if (seenDot) {
                    return null;
                }
                seenDot = true;
            } else {
                char ch2;
                if (ch != 'e' && ch != 'E') break;
                if (!seenDigit) {
                    return null;
                }
                if (i + 1 < len && ((ch2 = str.charAt(i + 1)) == '+' || ch2 == '-')) {
                    ++i;
                }
                seenDigit = false;
                seenDot = true;
            }
            ++i;
        }
        if (!seenDigit) {
            return null;
        }
        try {
            String substr = str.substring(start, i);
            double d = FloatUtils.parseValidString(substr);
            return new StringToDoubleResult(d, i);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static double parseValidString(String substr) {
        double d = Double.parseDouble(substr);
        if (!Double.isFinite(d)) {
            d = new BigDecimal(substr).doubleValue();
        }
        return d;
    }

    @CompilerDirectives.ValueType
    public static class StringToDoubleResult {
        public final double value;
        public final int position;

        public StringToDoubleResult(double value, int position) {
            this.value = value;
            this.position = position;
        }
    }
}

