/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.GeneratorYieldResult;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public class PGenerator
extends PythonBuiltinObject {
    private TruffleString name;
    private TruffleString qualname;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    protected final RootCallTarget[] callTargets;
    protected final Object[] arguments;
    private boolean finished;
    private PCode code;
    private int currentCallTarget;
    private final PBytecodeRootNode bytecodeRootNode;
    private final FrameInfo frameInfo;
    private boolean running;
    private final boolean isCoroutine;
    private final boolean isAsyncGen;

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments, PythonBuiltinClassType cls, boolean isIterableCoroutine) {
        rootNode.createGeneratorFrame(arguments);
        return new PGenerator(lang, name, qualname, rootNode, callTargets, arguments, cls, isIterableCoroutine);
    }

    public static PGenerator create(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments, PythonBuiltinClassType cls) {
        return PGenerator.create(lang, name, qualname, rootNode, callTargets, arguments, cls, false);
    }

    protected PGenerator(PythonLanguage lang, TruffleString name, TruffleString qualname, PBytecodeRootNode rootNode, RootCallTarget[] callTargets, Object[] arguments, PythonBuiltinClassType cls, boolean isIterableCoroutine) {
        super((Object)cls, cls.getInstanceShape(lang));
        this.name = name;
        this.qualname = qualname;
        this.callTargets = callTargets;
        this.currentCallTarget = 0;
        this.arguments = arguments;
        this.finished = false;
        this.bytecodeRootNode = rootNode;
        this.frameInfo = (FrameInfo)rootNode.getFrameDescriptor().getInfo();
        this.isCoroutine = isIterableCoroutine || cls == PythonBuiltinClassType.PCoroutine;
        this.isAsyncGen = cls == PythonBuiltinClassType.PAsyncGenerator;
    }

    public final void handleResult(PythonLanguage language, GeneratorYieldResult result) {
        this.currentCallTarget = result.resumeBci;
        if (this.callTargets[this.currentCallTarget] == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            PBytecodeGeneratorRootNode rootNode = new PBytecodeGeneratorRootNode(language, this.bytecodeRootNode, result.resumeBci, result.resumeStackTop);
            this.callTargets[this.currentCallTarget] = rootNode.getCallTarget();
        }
    }

    public final RootCallTarget getCurrentCallTarget() {
        return this.callTargets[this.currentCallTarget];
    }

    public final Object getYieldFrom() {
        if (this.running || this.finished) {
            return null;
        }
        return this.frameInfo.getYieldFrom((Frame)PArguments.getGeneratorFrame(this.arguments), this.getBci(), this.getCurrentRootNode().getResumeStackTop());
    }

    private PBytecodeGeneratorRootNode getCurrentRootNode() {
        return (PBytecodeGeneratorRootNode)this.getCurrentCallTarget().getRootNode();
    }

    public final boolean isStarted() {
        return this.currentCallTarget != 0 && !this.running;
    }

    public final int getBci() {
        if (!this.isStarted()) {
            return -1;
        }
        if (this.finished) {
            return this.bytecodeRootNode.getCodeUnit().code.length;
        }
        return this.getCurrentRootNode().getResumeBci();
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void markAsFinished() {
        this.finished = true;
    }

    @Override
    public final String toString() {
        return "<generator object " + this.name + " at " + this.hashCode() + ">";
    }

    public final PCode getOrCreateCode(Node inliningTarget, InlinedConditionProfile hasCodeProfile, PythonObjectFactory factory) {
        if (hasCodeProfile.profile(inliningTarget, this.code == null)) {
            RootCallTarget callTarget = this.bytecodeRootNode.getCallTarget();
            this.code = factory.createCode(callTarget);
        }
        return this.code;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public final void setRunning(boolean running) {
        assert (!running || !this.running) : "Attempted to set an already running generator as running";
        this.running = running;
    }

    public final TruffleString getName() {
        return this.name;
    }

    public final void setName(TruffleString name) {
        this.name = name;
    }

    public final TruffleString getQualname() {
        return this.qualname;
    }

    public final void setQualname(TruffleString qualname) {
        this.qualname = qualname;
    }

    public final boolean isCoroutine() {
        return this.isCoroutine;
    }

    public final boolean isAsyncGen() {
        return this.isAsyncGen;
    }
}

