/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.math.BigInteger;

@ExportLibrary(value=InteropLibrary.class)
public final class PInt
extends PythonBuiltinObject {
    public static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_BYTE = BigInteger.valueOf(127L);
    private static final BigInteger MIN_BYTE = BigInteger.valueOf(-128L);
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private final BigInteger value;

    public PInt(Object clazz, Shape instanceShape, BigInteger value) {
        super(PInt.ensurePBCT(clazz), instanceShape);
        assert (value != null);
        this.value = value;
    }

    private static Object ensurePBCT(Object clazz) {
        if (clazz instanceof PythonBuiltinClass && ((PythonBuiltinClass)clazz).getType() == PythonBuiltinClassType.PInt) {
            return PythonBuiltinClassType.PInt;
        }
        return clazz;
    }

    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public boolean isOne() {
        return this.value.equals(BigInteger.ONE);
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    @ExportMessage
    public boolean isBoolean(@CachedLibrary(value="this") InteropLibrary self) {
        PythonContext context = PythonContext.get((Node)self);
        return this == context.getTrue() || this == context.getFalse();
    }

    @ExportMessage
    public boolean asBoolean(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        PythonContext context = PythonContext.get((Node)self);
        if (this == context.getTrue()) {
            return true;
        }
        if (this == context.getFalse()) {
            return false;
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean isNumber(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) {
        PythonContext context = PythonContext.get((Node)self);
        return !isBoolean.profile(inliningTarget, this == context.getTrue() || this == context.getFalse());
    }

    @ExportMessage
    public boolean fitsInByte(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            return this.fitsIn(MIN_BYTE, MAX_BYTE);
        }
        return false;
    }

    @ExportMessage
    public byte asByte(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            try {
                return this.byteValueExact();
            }
            catch (ArithmeticException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean fitsInShort(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            return this.fitsIn(MIN_SHORT, MAX_SHORT);
        }
        return false;
    }

    @ExportMessage(limit="1")
    short asShort(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this.intValue()") InteropLibrary interop) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, interop)) {
            try {
                return interop.asShort((Object)this.intValueExact());
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean fitsInInt(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            return this.fitsIn(MIN_INT, MAX_INT);
        }
        return false;
    }

    @ExportMessage
    public int asInt(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            try {
                return this.intValueExact();
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean fitsInLong(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            return this.fitsIn(MIN_LONG, MAX_LONG);
        }
        return false;
    }

    @ExportMessage
    public long asLong(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, self)) {
            try {
                return this.longValueExact();
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage(limit="1")
    boolean fitsInFloat(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this.longValue()") InteropLibrary interop) {
        try {
            return this.fitsInLong(inliningTarget, isBoolean, interop) && interop.fitsInFloat((Object)this.longValueExact());
        }
        catch (OverflowException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @ExportMessage(limit="1")
    float asFloat(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this.longValue()") InteropLibrary interop) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, interop)) {
            try {
                return interop.asFloat((Object)this.longValueExact());
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage(limit="1")
    boolean fitsInDouble(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this.longValue()") InteropLibrary interop) {
        try {
            return this.fitsInLong(inliningTarget, isBoolean, interop) && interop.fitsInDouble((Object)this.longValueExact());
        }
        catch (OverflowException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @ExportMessage(limit="1")
    double asDouble(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="isBoolean") @Cached InlinedConditionProfile isBoolean, @CachedLibrary(value="this.longValue()") InteropLibrary interop) throws UnsupportedMessageException {
        if (this.isNumber(inliningTarget, isBoolean, interop)) {
            try {
                return interop.asDouble((Object)this.longValueExact());
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw UnsupportedMessageException.create();
            }
        }
        throw UnsupportedMessageException.create();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(PInt right) {
        return PInt.compareTo(this.value, right.getValue());
    }

    @Override
    public int compareTo(BigInteger right) {
        return PInt.compareTo(this.value, right);
    }

    @CompilerDirectives.TruffleBoundary
    private static int compareTo(BigInteger left, BigInteger right) {
        return left.compareTo(right);
    }

    @Override
    public int compareTo(long i) {
        return PInt.compareTo(this.value, i);
    }

    @CompilerDirectives.TruffleBoundary
    private static int compareTo(BigInteger left, long right) {
        return left.compareTo(PInt.longToBigInteger(right));
    }

    @Override
    public String toString() {
        return PInt.toString(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(int integer) {
        return Integer.toString(integer);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toString(long integer) {
        return Long.toString(integer);
    }

    @CompilerDirectives.TruffleBoundary
    private static String toString(BigInteger value) {
        return value.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String toHexString(long value) {
        return Long.toHexString(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger longToBigInteger(long value) {
        return BigInteger.valueOf(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger longToUnsignedBigInteger(long n) {
        return BigInteger.valueOf(n).add(BigInteger.ONE.shiftLeft(64));
    }

    public double doubleValue() {
        return PInt.doubleValue(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValue(BigInteger value) {
        return value.doubleValue();
    }

    public double doubleValueWithOverflow(PRaiseNode raise) {
        return PInt.doubleValueWithOverflow(this.value, raise);
    }

    public double doubleValueWithOverflow(Node inliningTarget, PRaiseNode.Lazy raise) {
        return PInt.doubleValueWithOverflow(inliningTarget, this.value, raise);
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValueWithOverflow(BigInteger value, PRaiseNode raise) {
        double d = value.doubleValue();
        if (Double.isInfinite(d)) {
            throw raise.raise(PythonErrorType.OverflowError, ErrorMessages.INT_TOO_LARGE_TO_CONVERT_TO_FLOAT);
        }
        return d;
    }

    @CompilerDirectives.TruffleBoundary
    public static double doubleValueWithOverflow(Node inliningTarget, BigInteger value, PRaiseNode.Lazy raise) {
        double d = value.doubleValue();
        if (Double.isInfinite(d)) {
            throw raise.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.INT_TOO_LARGE_TO_CONVERT_TO_FLOAT);
        }
        return d;
    }

    public int intValue() {
        return PInt.intValue(this.value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int intValue(BigInteger value) {
        return value.intValue();
    }

    public int intValueExact() throws OverflowException {
        return PInt.intValueExact(this.value);
    }

    public long longValue() {
        return PInt.longValue(this.value);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static long longValue(BigInteger integer) {
        return integer.longValue();
    }

    public long longValueExact() throws OverflowException {
        return PInt.longValueExact(this.value);
    }

    public static long longValueExact(BigInteger x) throws OverflowException {
        if (!PInt.bigIntegerFitsInLong(x)) {
            throw OverflowException.INSTANCE;
        }
        return PInt.longValue(x);
    }

    public static boolean bigIntegerFitsInLong(BigInteger x) {
        return PInt.fitsIn(x, MIN_LONG, MAX_LONG);
    }

    public PInt max(PInt val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public PInt min(PInt val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger inc() {
        return this.value.add(BigInteger.ONE);
    }

    public int bitLength() {
        return PInt.bitLength(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static int bitLength(BigInteger value) {
        return value.bitLength();
    }

    public int bitCount() {
        return PInt.bitCount(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    private static int bitCount(BigInteger value) {
        return value.bitCount();
    }

    public boolean isZeroOrPositive() {
        return this.value.signum() >= 0;
    }

    public boolean isZeroOrNegative() {
        return this.value.signum() <= 0;
    }

    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    public static int intValue(boolean bool) {
        return bool ? 1 : 0;
    }

    public static double doubleValue(boolean right) {
        return right ? 1.0 : 0.0;
    }

    public static int intValueExact(long val) throws OverflowException {
        if (!PInt.isIntRange(val)) {
            throw OverflowException.INSTANCE;
        }
        return (int)val;
    }

    public static int intValueExact(BigInteger x) throws OverflowException {
        if (!PInt.fitsIn(x, MIN_INT, MAX_INT)) {
            throw OverflowException.INSTANCE;
        }
        return PInt.intValue(x);
    }

    public static char charValueExact(int val) throws OverflowException {
        char t = (char)val;
        if (t != val) {
            throw OverflowException.INSTANCE;
        }
        return t;
    }

    public static char charValueExact(long val) throws OverflowException {
        char t = (char)val;
        if ((long)t != val) {
            throw OverflowException.INSTANCE;
        }
        return t;
    }

    public static boolean isByteRange(int val) {
        return val >= 0 && val < 256;
    }

    public static boolean isByteRange(long val) {
        return val >= 0L && val < 256L;
    }

    public static byte byteValueExact(int val) throws OverflowException {
        if (!PInt.isByteRange(val)) {
            throw OverflowException.INSTANCE;
        }
        return (byte)val;
    }

    public static byte byteValueExact(long val) throws OverflowException {
        if (!PInt.isByteRange(val)) {
            throw OverflowException.INSTANCE;
        }
        return (byte)val;
    }

    public byte byteValueExact() {
        return PInt.byteValueExact(this.value);
    }

    @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
    private static byte byteValueExact(BigInteger value) {
        return value.byteValueExact();
    }

    public byte[] toByteArray() {
        return PInt.toByteArray(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] toByteArray(BigInteger delegate) {
        return delegate.toByteArray();
    }

    public static boolean isIntRange(long val) {
        return val == (long)((int)val);
    }

    public BigInteger abs() {
        if (this.value.signum() < 0) {
            return PInt.abs(this.value);
        }
        return this.value;
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInteger abs(BigInteger value) {
        return value.abs();
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger multiply(BigInteger other) {
        return this.value.multiply(other);
    }

    public BigInteger multiply(PInt other) {
        return this.multiply(other.value);
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger add(BigInteger other) {
        return this.value.add(other);
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger subtract(BigInteger other) {
        return this.value.subtract(other);
    }

    public BigInteger subtract(PInt other) {
        return this.subtract(other.getValue());
    }

    public BigInteger add(PInt other) {
        return this.add(other.value);
    }

    @ExportMessage.Ignore
    public long hash() {
        return PInt.hashBigInteger(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    public static long hashBigInteger(BigInteger i) {
        long h = i.remainder(BigInteger.valueOf(0x1FFFFFFFFFFFFFFFL)).longValue();
        return h == -1L ? -2L : h;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static boolean fitsIn(BigInteger value, BigInteger left, BigInteger right) {
        return value.compareTo(left) >= 0 && value.compareTo(right) <= 0;
    }

    private boolean fitsIn(BigInteger left, BigInteger right) {
        return PInt.fitsIn(this.value, left, right);
    }

    public static Object createPythonIntFromUnsignedLong(Node inliningTarget, PythonObjectFactory factory, InlinedConditionProfile profile, long value) {
        return profile.profile(inliningTarget, value >= 0L) ? Long.valueOf(value) : factory.createInt(PInt.longToUnsignedBigInt(value));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger longToUnsignedBigInt(long l) {
        return BigInteger.valueOf(l >>> 32).shiftLeft(32).add(BigInteger.valueOf(l & 0xFFFFFFFFL));
    }
}

