/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.ForeignIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.PForeignArrayIterator;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PForeignArrayIterator})
public final class ForeignIteratorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PForeignArrayIterator doForeignArrayIterator(PForeignArrayIterator self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object next(PForeignArrayIterator foreignIter, @Bind(value="this") Node inliningTarget, @Cached PForeignToPTypeNode fromForeignNode, @Cached PyNumberAsSizeNode asSizeNode, @CachedLibrary(limit="3") InteropLibrary interop, @Cached GilNode gil) {
            if (foreignIter.getCursor() >= foreignIter.getSize(interop, inliningTarget, asSizeNode)) {
                throw this.raiseStopIteration();
            }
            gil.release(true);
            try {
                Object element = interop.readArrayElement(foreignIter.getForeignArray(), (long)foreignIter.advance());
                Object object = fromForeignNode.executeConvert(element);
                return object;
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw this.raiseStopIteration();
            }
            finally {
                gil.acquire();
            }
        }
    }
}

