/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.ArrayNodes;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.dict.PHashingStorageIterator;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.PArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBaseSetIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PPrimitiveIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIterator, PythonBuiltinClassType.PArrayIterator, PythonBuiltinClassType.PDictItemIterator, PythonBuiltinClassType.PDictReverseItemIterator, PythonBuiltinClassType.PDictKeyIterator, PythonBuiltinClassType.PDictReverseKeyIterator, PythonBuiltinClassType.PDictValueIterator, PythonBuiltinClassType.PDictReverseValueIterator})
public final class IteratorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static Object reduce(PBigRangeIterator self, Object index, @Bind(value="this") Node inliningTarget, @Cached CastToJavaBigIntegerNode castToJavaBigIntegerNode) {
            BigInteger idx = castToJavaBigIntegerNode.execute(inliningTarget, index);
            if (idx.compareTo(BigInteger.ZERO) < 0) {
                idx = BigInteger.ZERO;
            }
            self.setLongIndex(idx);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPBigRangeIterator(self)"})
        public static Object reduce(VirtualFrame frame, PBuiltinIterator self, Object index, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int idx = asSizeNode.executeExact((Frame)frame, inliningTarget, index);
            if (idx < 0) {
                idx = 0;
            }
            self.index = idx;
            return PNone.NONE;
        }

        protected static boolean isPBigRangeIterator(Object obj) {
            return obj instanceof PBigRangeIterator;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        PyObjectGetAttr getAttrNode;

        @Specialization
        public Object reduce(VirtualFrame frame, PArrayIterator self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile exhaustedProfile) {
            PythonContext context = PythonContext.get(this);
            if (!exhaustedProfile.profile(inliningTarget, self.isExhausted())) {
                return this.reduceInternal(frame, self.array, self.getIndex(), context);
            }
            return this.reduceInternal(frame, this.factory().createEmptyTuple(), context);
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PHashingStorageIterator self, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode storageNode) {
            int index = self.index;
            boolean isExhausted = self.isExhausted();
            int state = self.getIterator().getState();
            PList list = this.factory().createList(storageNode.execute(frame, self));
            self.getIterator().setState(state);
            self.setExhausted(isExhausted);
            self.index = index;
            return this.reduceInternal(frame, list, PythonContext.get(this));
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PIntegerSequenceIterator self) {
            PythonContext context = PythonContext.get(this);
            if (self.isExhausted()) {
                return this.reduceInternal(frame, this.factory().createList(), null, context);
            }
            return this.reduceInternal(frame, self.getObject(), self.getIndex(), context);
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PPrimitiveIterator self) {
            PythonContext context = PythonContext.get(this);
            if (self.isExhausted()) {
                return this.reduceInternal(frame, this.factory().createList(), null, context);
            }
            return this.reduceInternal(frame, self.getObject(), self.getIndex(), context);
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PStringIterator self) {
            PythonContext context = PythonContext.get(this);
            if (self.isExhausted()) {
                return this.reduceInternal(frame, StringLiterals.T_EMPTY_STRING, null, context);
            }
            return this.reduceInternal(frame, self.value, self.getIndex(), context);
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PIntRangeIterator self) {
            int start = self.getStart();
            int stop = self.getStop();
            int step = self.getStep();
            int len = self.getLen();
            return this.reduceInternal(frame, this.factory().createIntRange(start, stop, step, len), self.getIndex(), PythonContext.get(this));
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PBigRangeIterator self) {
            PInt start = self.getStart();
            PInt stop = self.getStop();
            PInt step = self.getStep();
            PInt len = self.getLen();
            return this.reduceInternal(frame, this.factory().createBigRange(start, stop, step, len), self.getLongIndex(this.factory()), PythonContext.get(this));
        }

        @Specialization(guards={"self.isPSequence()"})
        public Object reduce(VirtualFrame frame, PSequenceIterator self) {
            PythonContext context = PythonContext.get(this);
            if (self.isExhausted()) {
                return this.reduceInternal(frame, this.factory().createTuple(new Object[0]), null, context);
            }
            return this.reduceInternal(frame, self.getPSequence(), self.getIndex(), context);
        }

        @Specialization(guards={"!self.isPSequence()"})
        public Object reduceNonSeq(VirtualFrame frame, PSequenceIterator self) {
            PythonContext context = PythonContext.get(this);
            if (!self.isExhausted()) {
                return this.reduceInternal(frame, self.getObject(), self.getIndex(), context);
            }
            return this.reduceInternal(frame, this.factory().createTuple(new Object[0]), null, context);
        }

        private PTuple reduceInternal(VirtualFrame frame, Object arg, PythonContext context) {
            return this.reduceInternal(frame, arg, null, context);
        }

        private PTuple reduceInternal(VirtualFrame frame, Object arg, Object state, PythonContext context) {
            PythonModule builtins = context.getBuiltins();
            Object iter = this.getGetAttrNode().executeCached((Frame)frame, builtins, BuiltinNames.T_ITER);
            PTuple args = this.factory().createTuple(new Object[]{arg});
            if (state != null) {
                return this.factory().createTuple(new Object[]{iter, args, state});
            }
            return this.factory().createTuple(new Object[]{iter, args});
        }

        private PyObjectGetAttr getGetAttrNode() {
            if (this.getAttrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getAttrNode = (PyObjectGetAttr)this.insert(PyObjectGetAttr.create());
            }
            return this.getAttrNode;
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        public static int exhausted(PBuiltinIterator self) {
            return 0;
        }

        @Specialization
        public static int lengthHint(PArrayIterator self) {
            return self.array.getLength() - self.getIndex();
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(VirtualFrame frame, PDictView.PBaseDictIterator self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, self.checkSizeChanged(inliningTarget, lenNode))) {
                return 0;
            }
            return self.getSize() - self.getIndex();
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PIntegerSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PObjectSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PIntRangeIterator self) {
            return self.getRemainingLength();
        }

        @Specialization(guards={"!self.isExhausted()"})
        public Object lengthHint(PBigRangeIterator self) {
            return this.factory().createInt(self.getRemainingLength());
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PDoubleSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PLongSequenceIterator self) {
            int len = self.sequence.length() - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PBaseSetIterator self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached InlinedConditionProfile profile) {
            int size = self.getSize();
            int lenSet = lenNode.execute(inliningTarget, self.getHashingStorage());
            if (profile.profile(inliningTarget, lenSet != size)) {
                return 0;
            }
            int len = size - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()"})
        public static int lengthHint(PStringIterator self, @Cached TruffleString.CodePointLengthNode codePointLengthNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)self.value, PythonUtils.TS_ENCODING) - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        public static int lengthHint(PSequenceIterator self, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.LenNode lenNode) {
            int len = lenNode.execute(inliningTarget, self.getPSequence()) - self.getIndex();
            return len < 0 ? 0 : len;
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        public static int lengthHint(VirtualFrame frame, PSequenceIterator self, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            int len = sizeNode.execute((Frame)frame, inliningTarget, self.getObject()) - self.getIndex();
            return len < 0 ? 0 : len;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        public static final Object STOP_MARKER = new Object();
        private final boolean throwStopIteration;

        NextNode() {
            this.throwStopIteration = true;
        }

        NextNode(boolean throwStopIteration) {
            this.throwStopIteration = throwStopIteration;
        }

        public abstract Object execute(VirtualFrame var1, PBuiltinIterator var2);

        private Object stopIteration(PBuiltinIterator self) {
            self.setExhausted();
            if (this.throwStopIteration) {
                throw this.raiseStopIteration();
            }
            return STOP_MARKER;
        }

        @Specialization(guards={"self.isExhausted()"})
        Object exhausted(PBuiltinIterator self) {
            if (this.throwStopIteration) {
                throw this.raiseStopIteration();
            }
            return STOP_MARKER;
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PArrayIterator self, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile itemTypeProfile, @Cached ArrayNodes.GetValueNode getValueNode) {
            PArray array = self.array;
            if (self.getIndex() < array.getLength()) {
                return itemTypeProfile.profile(inliningTarget, getValueNode.execute(inliningTarget, array, self.index++));
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PIntegerSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getIntItemNormalized(self.index++);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PObjectSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getItemNormalized(self.index++);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PIntRangeIterator self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, self.hasNextInt())) {
                return self.nextInt();
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PBigRangeIterator self) {
            if (self.hasNextBigInt()) {
                return this.factory().createInt(self.nextBigInt());
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PDoubleSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getDoubleItemNormalized(self.index++);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PLongSequenceIterator self) {
            if (self.getIndex() < self.sequence.length()) {
                return self.sequence.getLongItemNormalized(self.index++);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object next(PStringIterator self, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode) {
            if (self.getIndex() < codePointLengthNode.execute((AbstractTruffleString)self.value, PythonUtils.TS_ENCODING)) {
                return substringNode.execute((AbstractTruffleString)self.value, self.index++, 1, PythonUtils.TS_ENCODING, false);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()"})
        Object nextHashingStorageIter(PHashingStorageIterator self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile sizeChanged, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageIteratorNext nextNode, @Cached PHashingStorageIteratorNextValue itValueNode, @Cached.Exclusive @Cached InlinedConditionProfile profile) {
            HashingStorageNodes.HashingStorageIterator it;
            HashingStorage storage = self.getHashingStorage();
            if (profile.profile(inliningTarget, nextNode.execute(inliningTarget, storage, it = self.getIterator()))) {
                if (sizeChanged.profile(inliningTarget, self.checkSizeChanged(inliningTarget, lenNode))) {
                    String name = PBaseSetIterator.isInstance(self) ? "Set" : "dictionary";
                    throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, name);
                }
                ++self.index;
                return itValueNode.execute(inliningTarget, self, storage, it);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()", "self.isPSequence()"})
        Object next(PSequenceIterator self, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getStorage, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode) {
            SequenceStorage s = getStorage.execute(inliningTarget, self.getPSequence());
            if (self.getIndex() < s.length()) {
                return getItemNode.execute(s, self.index++);
            }
            return this.stopIteration(self);
        }

        @Specialization(guards={"!self.isExhausted()", "!self.isPSequence()"})
        Object next(VirtualFrame frame, PSequenceIterator self, @Bind(value="this") Node inliningTarget, @Cached PySequenceGetItemNode getItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
            try {
                return getItem.execute((Frame)frame, self.getObject(), self.index++);
            }
            catch (PException e) {
                e.expectIndexError(inliningTarget, profile);
                return this.stopIteration(self);
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class PHashingStorageIteratorNextValue
        extends Node {
            PHashingStorageIteratorNextValue() {
            }

            abstract Object execute(Node var1, PHashingStorageIterator var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4);

            @Specialization
            static Object doDictValue(Node inliningTarget, PDictView.PDictValueIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="val") @Cached HashingStorageNodes.HashingStorageIteratorValue itValueNode) {
                return itValueNode.execute(inliningTarget, storage, it);
            }

            @Specialization
            static Object doDictKey(Node inliningTarget, PDictView.PDictKeyIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode) {
                return itKeyNode.execute(inliningTarget, storage, it);
            }

            @Specialization
            static PTuple doDictItem(Node inliningTarget, PDictView.PDictItemIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="val") @Cached HashingStorageNodes.HashingStorageIteratorValue itValueNode, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode, @Cached(inline=false) PythonObjectFactory factory) {
                return factory.createTuple(new Object[]{itKeyNode.execute(inliningTarget, storage, it), itValueNode.execute(inliningTarget, storage, it)});
            }

            @Specialization
            static Object doSetKey(Node inliningTarget, PBaseSetIterator self, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, @Cached.Shared(value="key") @Cached HashingStorageNodes.HashingStorageIteratorKey itKeyNode) {
                return itKeyNode.execute(inliningTarget, storage, it);
            }
        }
    }
}

