/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.itertools.CycleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PCycle;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCycle})
public final class CycleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CycleBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2, Object var3);

        @Specialization
        Object setState(VirtualFrame frame, PCycle self, Object state, @Bind(value="this") Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isTypeErrorProfile, @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached PyNumberAsSizeNode asSizeNode) {
            boolean firstPass;
            if (!(state instanceof PTuple) || (Integer)lenNode.execute(frame, state) != 2) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "2-tuple");
            }
            Object obj = getItemNode.execute(frame, state, (Object)0);
            if (!(obj instanceof PList)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.STATE_ARGUMENT_D_MUST_BE_A_S, 1, "Plist");
            }
            PList saved = (PList)obj;
            try {
                firstPass = asSizeNode.executeLossy((Frame)frame, inliningTarget, getItemNode.execute(frame, state, (Object)1)) != 0;
            }
            catch (PException e) {
                e.expectTypeError(inliningTarget, isTypeErrorProfile);
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.STATE_ARGUMENT_D_MUST_BE_A_S, 2, "int");
            }
            Object[] savedArray = toArrayNode.execute(inliningTarget, saved.getSequenceStorage());
            self.setSaved(SetStateNode.toList(savedArray));
            self.setFirstpass(firstPass);
            self.setIndex(0);
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static ArrayList<Object> toList(Object[] savedArray) {
            return new ArrayList<Object>(Arrays.asList(savedArray));
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"hasIterable(self)"})
        Object reduce(PCycle self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClass) {
            Object type = getClass.execute(inliningTarget, self);
            PTuple iterableTuple = this.factory().createTuple(new Object[]{self.getIterable()});
            PTuple tuple = this.factory().createTuple(new Object[]{this.getSavedList(self), self.isFirstpass()});
            return this.factory().createTuple(new Object[]{type, iterableTuple, tuple});
        }

        @Specialization(guards={"!hasIterable(self)"})
        Object reduceNoIterable(VirtualFrame frame, PCycle self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClass, @Cached PyObjectLookupAttr lookupAttrNode, @Cached CallUnaryMethodNode callNode, @Cached PyObjectGetIter getIterNode, @Cached InlinedBranchProfile indexProfile) {
            Object type = getClass.execute(inliningTarget, self);
            PList savedList = this.getSavedList(self);
            Object it = getIterNode.execute((Frame)frame, inliningTarget, savedList);
            if (self.getIndex() > 0) {
                indexProfile.enter(inliningTarget);
                Object setStateCallable = lookupAttrNode.execute((Frame)frame, inliningTarget, it, SpecialMethodNames.T___SETSTATE__);
                callNode.executeObject((Frame)frame, setStateCallable, self.getIndex());
            }
            PTuple iteratorTuple = this.factory().createTuple(new Object[]{it});
            PTuple tuple = this.factory().createTuple(new Object[]{savedList, true});
            return this.factory().createTuple(new Object[]{type, iteratorTuple, tuple});
        }

        PList getSavedList(PCycle self) {
            return this.factory().createList(ReduceNode.toArray(self.getSaved()));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] toArray(List<Object> l) {
            return l.toArray(new Object[l.size()]);
        }

        protected boolean hasIterable(PCycle self) {
            return self.getIterable() != null;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object next(VirtualFrame frame, PCycle self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, @Cached InlinedBranchProfile iterableProfile, @Cached InlinedBranchProfile firstPassProfile) {
            if (self.getIterable() != null) {
                iterableProfile.enter(inliningTarget);
                try {
                    Object item = nextNode.execute(frame, self.getIterable(), PNone.NO_VALUE);
                    if (!self.isFirstpass()) {
                        firstPassProfile.enter(inliningTarget);
                        this.add(self.getSaved(), item);
                    }
                    return item;
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, isStopIterationProfile);
                    self.setIterable(null);
                }
            }
            if (this.isEmpty(self.getSaved())) {
                throw this.raiseStopIteration();
            }
            Object item = this.get(self.getSaved(), self.getIndex());
            self.setIndex(self.getIndex() + 1);
            if (self.getIndex() >= this.size(self.getSaved())) {
                self.setIndex(0);
            }
            return item;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean isEmpty(List<Object> l) {
            return l.isEmpty();
        }

        @CompilerDirectives.TruffleBoundary
        private Object add(List<Object> l, Object item) {
            return l.add(item);
        }

        @CompilerDirectives.TruffleBoundary
        private Object get(List<Object> l, int idx) {
            return l.get(idx);
        }

        @CompilerDirectives.TruffleBoundary
        private int size(List<Object> l) {
            return l.size();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PCycle self) {
            return self;
        }
    }
}

