/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.AbstractFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.method.AbstractBuiltinMethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.MethodWrapper})
public final class AbstractBuiltinMethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AbstractBuiltinMethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class MethodQualName
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString getQualName(VirtualFrame frame, PMethod method, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___NAME__)") @Cached.Shared GetAttributeNode getNameAttrNode, @Cached(value="create(T___QUALNAME__)") @Cached.Shared GetAttributeNode getQualNameAttrNode, @Cached @Cached.Shared TypeNodes.IsTypeNode isTypeNode, @Cached @Cached.Shared CastToTruffleStringNode castToStringNode, @Cached @Cached.Shared InlinedConditionProfile isGlobalProfile, @Cached @Cached.Shared GetClassNode getClassNode, @Cached @Cached.Shared StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return this.makeQualname(frame, inliningTarget, method, method.getSelf(), getQualNameAttrNode, getNameAttrNode, castToStringNode, getClassNode, isTypeNode, isGlobalProfile, simpleTruffleStringFormatNode);
        }

        @Specialization
        TruffleString getQualName(VirtualFrame frame, PBuiltinMethod method, @Bind(value="this") Node inliningTarget, @Cached(value="create(T___NAME__)") @Cached.Shared GetAttributeNode getNameAttrNode, @Cached(value="create(T___QUALNAME__)") @Cached.Shared GetAttributeNode getQualNameAttrNode, @Cached @Cached.Shared TypeNodes.IsTypeNode isTypeNode, @Cached @Cached.Shared CastToTruffleStringNode castToStringNode, @Cached @Cached.Shared InlinedConditionProfile isGlobalProfile, @Cached @Cached.Shared GetClassNode getClassNode, @Cached @Cached.Shared StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return this.makeQualname(frame, inliningTarget, method, method.getSelf(), getQualNameAttrNode, getNameAttrNode, castToStringNode, getClassNode, isTypeNode, isGlobalProfile, simpleTruffleStringFormatNode);
        }

        private TruffleString makeQualname(VirtualFrame frame, Node inliningTarget, Object method, Object self, GetAttributeNode getQualNameAttrNode, GetAttributeNode getNameAttrNode, CastToTruffleStringNode castToStringNode, GetClassNode getClassNode, TypeNodes.IsTypeNode isTypeNode, InlinedConditionProfile isGlobalProfile, StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeQualName;
            TruffleString methodName;
            try {
                methodName = castToStringNode.execute(inliningTarget, getNameAttrNode.executeObject(frame, method));
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_UNICODE_OBJECT, SpecialAttributeNames.T___NAME__);
            }
            if (isGlobalProfile.profile(inliningTarget, self == null || self instanceof PythonModule)) {
                return methodName;
            }
            Object type = isTypeNode.execute(inliningTarget, self) ? self : getClassNode.execute(inliningTarget, self);
            try {
                typeQualName = castToStringNode.execute(inliningTarget, getQualNameAttrNode.executeObject(frame, type));
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_UNICODE_OBJECT, SpecialAttributeNames.T___QUALNAME__);
            }
            return simpleTruffleStringFormatNode.format("%s.%s", typeQualName, methodName);
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class MethodName
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getName(VirtualFrame frame, PBuiltinMethod method, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode) {
            return getNameAttrNode.executeObject(frame, method.getFunction());
        }

        @Specialization
        static Object getName(VirtualFrame frame, PMethod method, @Cached.Shared @Cached(value="create(T___NAME__)") GetAttributeNode getNameAttrNode) {
            return getNameAttrNode.executeObject(frame, method.getFunction());
        }
    }

    @Builtin(name="__text_signature__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class TextSignatureNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        AbstractFunctionBuiltins.TextSignatureNode subNode = AbstractFunctionBuiltins.TextSignatureNode.create();

        @Specialization
        Object getTextSignature(VirtualFrame frame, PBuiltinMethod self, Object value) {
            return this.subNode.execute(frame, self.getFunction(), value);
        }

        @Specialization
        Object getTextSignature(VirtualFrame frame, PMethod self, Object value) {
            return this.subNode.execute(frame, self.getFunction(), value);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        static boolean isBuiltinFunction(PBuiltinMethod self) {
            return self.getSelf() instanceof PythonModule;
        }

        static boolean isBuiltinFunction(PMethod self) {
            return self.getSelf() instanceof PythonModule && self.getFunction() instanceof PFunction && ((PFunction)self.getFunction()).isBuiltin();
        }

        @Specialization(guards={"isBuiltinFunction(self)"})
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PMethod self, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode.GetFixedAttributeNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<built-in function %s>", getNameNode.executeObject(frame, self.getFunction()));
        }

        @Specialization(guards={"isBuiltinFunction(self)"})
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PBuiltinMethod self, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode.GetFixedAttributeNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<built-in function %s>", getNameNode.executeObject(frame, self.getFunction()));
        }

        @Specialization(guards={"!isBuiltinFunction(self)"})
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PBuiltinMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode.GetFixedAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<built-in method %s of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @Specialization(guards={"!isBuiltinFunction(self)"})
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode.GetFixedAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<built-in method %s of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @NeverDefault
        protected static GetAttributeNode.GetFixedAttributeNode createGetAttributeNode() {
            return GetAttributeNode.GetFixedAttributeNode.create(SpecialAttributeNames.T___NAME__);
        }
    }
}

