/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.thread;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.LockBuiltins;
import com.oracle.graal.python.builtins.objects.thread.PSemLock;
import com.oracle.graal.python.builtins.objects.thread.SemLockBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.thread.SemLockBuiltinsFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import java.util.concurrent.Semaphore;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSemLock})
public final class SemLockBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SemLockBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("SEM_VALUE_MAX", (Object)Integer.MAX_VALUE);
        super.initialize(core);
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitLockNode
    extends PythonBuiltinNode {
        ExitLockNode() {
        }

        @Specialization
        Object exit(AbstractPythonLock self, Object type, Object value, Object traceback) {
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="release", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReleaseLockNode
    extends PythonUnaryBuiltinNode {
        ReleaseLockNode() {
        }

        @Specialization
        Object doRelease(PSemLock self) {
            if (self.getKind() == 0) {
                if (!self.isMine()) {
                    throw this.raise(PythonBuiltinClassType.AssertionError, ErrorMessages.ATTEMP_TO_RELEASE_RECURSIVE_LOCK);
                }
                if (self.getCount() > 1) {
                    self.decreaseCount();
                    return PNone.NONE;
                }
                assert (self.getCount() == 1);
            }
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="_rebuild", minNumOfPositionalArgs=4, parameterNames={"handle", "kind", "maxvalue", "name"})
    @ArgumentsClinic(value={@ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    static abstract class RebuildNode
    extends PythonClinicBuiltinNode {
        RebuildNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SemLockBuiltinsClinicProviders.RebuildNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object doEnter(Object handle, int kind, Object maxvalue, TruffleString name) {
            PythonContext.SharedMultiprocessingData multiprocessing = this.getContext().getSharedMultiprocessingData();
            Semaphore semaphore = multiprocessing.getNamedSemaphore(name);
            if (semaphore == null) {
                semaphore = RebuildNode.newSemaphore(0);
            }
            return this.factory().createSemLock((Object)PythonBuiltinClassType.PSemLock, name, kind, semaphore);
        }

        @CompilerDirectives.TruffleBoundary
        private static Semaphore newSemaphore(int value) {
            return new Semaphore(value);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @GenerateNodeFactory
    static abstract class EnterLockNode
    extends PythonTernaryBuiltinNode {
        EnterLockNode() {
        }

        @Specialization
        Object doEnter(VirtualFrame frame, AbstractPythonLock self, Object blocking, Object timeout, @Cached LockBuiltins.AcquireLockNode acquireLockNode) {
            return acquireLockNode.execute(frame, self, blocking, timeout);
        }
    }

    @Builtin(name="acquire", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="LockBuiltins.DEFAULT_BLOCKING")
    @GenerateNodeFactory
    static abstract class AcquireNode
    extends PythonTernaryClinicBuiltinNode {
        AcquireNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SemLockBuiltinsClinicProviders.AcquireNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isFast(PSemLock self) {
            return self.getKind() == 0 && self.isMine();
        }

        @Specialization(guards={"isFast(self)"})
        boolean fast(PSemLock self, boolean blocking, Object timeout) {
            self.increaseCount();
            return true;
        }

        @Specialization(guards={"!isFast(self)"})
        Object slow(VirtualFrame frame, PSemLock self, boolean blocking, Object timeout, @Cached LockBuiltins.AcquireLockNode acquireLockNode) {
            Object tout = timeout;
            if (!blocking) {
                tout = -1.0;
            }
            return acquireLockNode.execute(frame, self, blocking, tout);
        }
    }

    @Builtin(name="kind", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetKindNode
    extends PythonUnaryBuiltinNode {
        GetKindNode() {
        }

        @Specialization
        int getKind(PSemLock self) {
            return self.getKind();
        }
    }

    @Builtin(name="maxvalue", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetMaxValue
    extends PythonUnaryBuiltinNode {
        GetMaxValue() {
        }

        @Specialization
        Object getMax(PSemLock self) {
            return Integer.MAX_VALUE;
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        GetNameNode() {
        }

        @Specialization
        TruffleString getName(PSemLock self) {
            return self.getName();
        }
    }

    @Builtin(name="handle", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetHandleNode
    extends PythonUnaryBuiltinNode {
        GetHandleNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int getHandle(PSemLock self) {
            return self.hashCode();
        }
    }

    @Builtin(name="_get_value", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends PythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization
        int getValue(PSemLock self) {
            return self.getValue();
        }
    }

    @Builtin(name="_is_zero", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsZeroNode
    extends PythonUnaryBuiltinNode {
        IsZeroNode() {
        }

        @Specialization
        boolean isZero(PSemLock self) {
            return self.isZero();
        }
    }

    @Builtin(name="_is_mine", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsMineNode
    extends PythonUnaryBuiltinNode {
        IsMineNode() {
        }

        @Specialization
        boolean isMine(PSemLock self) {
            return self.isMine();
        }
    }

    @Builtin(name="_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CountNode
    extends PythonUnaryBuiltinNode {
        CountNode() {
        }

        @Specialization
        int getCount(PSemLock self) {
            return self.getCount();
        }
    }
}

