/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.traceback;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.traceback.TracebackBuiltinsFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTraceback})
public final class TracebackBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TracebackBuiltinsFactory.getFactories();
    }

    @Builtin(name="tb_lineno", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetTracebackLinenoNode
    extends PythonBuiltinNode {
        @Specialization
        Object get(PTraceback self, @Bind(value="this") Node inliningTarget, @Cached MaterializeTruffleStacktraceNode materializeTruffleStacktraceNode) {
            materializeTruffleStacktraceNode.execute(inliningTarget, self);
            return self.getLineno();
        }
    }

    @Builtin(name="tb_lasti", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetTracebackLastINode
    extends PythonBuiltinNode {
        @Specialization
        Object get(PTraceback self) {
            return self.getLasti();
        }
    }

    @Builtin(name="tb_next", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class GetTracebackNextNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PTraceback self, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached MaterializeTruffleStacktraceNode materializeTruffleStacktraceNode) {
            materializeTruffleStacktraceNode.execute(inliningTarget, self);
            return self.getNext() != null ? self.getNext() : PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(next)"})
        Object set(PTraceback self, PTraceback next, @Bind(value="this") Node inliningTarget, @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached MaterializeTruffleStacktraceNode materializeTruffleStacktraceNode) {
            PTraceback tb = next;
            while (loopProfile.profile(inliningTarget, tb != null)) {
                if (tb == self) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TRACEBACK_LOOP_DETECTED);
                }
                tb = tb.getNext();
            }
            materializeTruffleStacktraceNode.execute(inliningTarget, self);
            self.setNext(next);
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(next)"})
        static Object clear(PTraceback self, PNone next, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached MaterializeTruffleStacktraceNode materializeTruffleStacktraceNode) {
            materializeTruffleStacktraceNode.execute(inliningTarget, self);
            self.setNext(null);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(next)", "!isPTraceback(next)"})
        Object setError(PTraceback self, Object next) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_TRACEBACK_OBJ, next);
        }
    }

    @Builtin(name="tb_frame", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetTracebackFrameNode
    extends PythonBuiltinNode {
        public abstract PFrame execute(VirtualFrame var1, Object var2);

        @NeverDefault
        public static GetTracebackFrameNode create() {
            return TracebackBuiltinsFactory.GetTracebackFrameNodeFactory.create(null);
        }

        @Specialization(guards={"hasPFrame(tb)"})
        static PFrame getExisting(PTraceback tb) {
            return tb.getFrame();
        }

        @Specialization(guards={"!hasPFrame(tb)", "hasFrameInfo(tb)", "isMaterialized(tb.getFrameInfo())", "hasVisibleFrame(tb)"})
        static PFrame doMaterializedFrame(PTraceback tb) {
            PFrame.Reference frameInfo = tb.getFrameInfo();
            assert (frameInfo.isEscaped()) : "cannot create traceback for non-escaped frame";
            PFrame escapedFrame = frameInfo.getPyFrame();
            assert (escapedFrame != null);
            tb.setFrame(escapedFrame);
            return escapedFrame;
        }

        @Specialization(guards={"!hasPFrame(tb)", "hasFrameInfo(tb)", "!isMaterialized(tb.getFrameInfo())", "hasVisibleFrame(tb)"})
        static PFrame doOnStack(VirtualFrame frame, PTraceback tb, @Bind(value="this") Node inliningTarget, @Cached MaterializeFrameNode materializeNode, @Cached ReadCallerFrameNode readCallerFrame, @Cached InlinedConditionProfile isCurFrameProfile) {
            PFrame escapedFrame;
            PFrame.Reference frameInfo = tb.getFrameInfo();
            assert (frameInfo.isEscaped()) : "cannot create traceback for non-escaped frame";
            if (isCurFrameProfile.profile(inliningTarget, PArguments.getCurrentFrameInfo((Frame)frame) == frameInfo)) {
                escapedFrame = materializeNode.execute((Frame)frame, false);
            } else {
                int i = 0;
                while ((escapedFrame = readCallerFrame.executeWith(frame, i)) != null && escapedFrame.getRef() != frameInfo) {
                    ++i;
                }
            }
            assert (escapedFrame != null) : "Failed to find escaped frame on stack";
            tb.setFrame(escapedFrame);
            return escapedFrame;
        }

        @Specialization(guards={"!hasVisibleFrame(tb)"})
        static PFrame doFromTruffle(PTraceback tb, @Bind(value="this") Node inliningTarget, @Cached MaterializeTruffleStacktraceNode materializeTruffleStacktraceNode) {
            materializeTruffleStacktraceNode.execute(inliningTarget, tb);
            return tb.getFrame();
        }

        protected static boolean hasPFrame(PTraceback tb) {
            return tb.getFrame() != null;
        }

        protected static boolean hasFrameInfo(PTraceback tb) {
            return tb.getFrameInfo() != null;
        }

        protected static boolean hasVisibleFrame(PTraceback tb) {
            return tb.getLazyTraceback() == null || tb.getLazyTraceback().catchingFrameWantedForTraceback();
        }

        protected static boolean isMaterialized(PFrame.Reference frameInfo) {
            return frameInfo.getPyFrame() != null;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class MaterializeTruffleStacktraceNode
    extends Node {
        public abstract void execute(Node var1, PTraceback var2);

        @Specialization(guards={"tb.isMaterialized()"})
        static void doExisting(PTraceback tb) {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!tb.isMaterialized()"})
        static void doMaterialize(Node inliningTarget, PTraceback tb, @Cached(inline=false) MaterializeFrameNode materializeFrameNode, @Cached MaterializeLazyTracebackNode materializeLazyTracebackNode, @Cached(inline=false) PythonObjectFactory factory) {
            PException pException;
            List stackTrace;
            PTraceback next = null;
            LazyTraceback lazyTraceback = tb.getLazyTraceback();
            if (lazyTraceback.getNextChain() != null) {
                next = materializeLazyTracebackNode.execute(inliningTarget, lazyTraceback.getNextChain());
            }
            if ((stackTrace = TruffleStackTrace.getStackTrace((Throwable)((Object)(pException = lazyTraceback.getException())))) != null) {
                int pyIndex = 0;
                for (int truffleIndex = pException.getTracebackStartIndex(); truffleIndex < stackTrace.size() && pyIndex < pException.getTracebackFrameCount(); ++truffleIndex) {
                    TruffleStackTraceElement element = (TruffleStackTraceElement)stackTrace.get(truffleIndex);
                    if (!LazyTraceback.elementWantedForTraceback(element)) continue;
                    PFrame pFrame = MaterializeTruffleStacktraceNode.materializeFrame(element, materializeFrameNode);
                    next = factory.createTraceback(pFrame, pFrame.getLine(), next);
                    ++pyIndex;
                }
            }
            if (lazyTraceback.catchingFrameWantedForTraceback()) {
                tb.setLineno(pException.getCatchRootNode().bciToLine(pException.getCatchBci()));
                tb.setNext(next);
            } else {
                assert (next != null);
                tb.copyFrom(next);
            }
            tb.markMaterialized();
        }

        private static PFrame materializeFrame(TruffleStackTraceElement element, MaterializeFrameNode materializeFrameNode) {
            Node location = element.getLocation();
            RootNode rootNode = element.getTarget().getRootNode();
            if (rootNode instanceof PBytecodeRootNode || rootNode instanceof PBytecodeGeneratorRootNode) {
                location = rootNode;
            }
            return materializeFrameNode.execute(location, false, true, element.getFrame());
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DirNode
    extends PythonBuiltinNode {
        @Specialization
        Object dir(PTraceback self) {
            return this.factory().createList(PTraceback.getTbFieldNames());
        }
    }
}

