/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequenceFactory;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.Arrays;
import java.util.Objects;

public class StructSequence {
    public static final TruffleString T_N_SEQUENCE_FIELDS = PythonUtils.tsLiteral("n_sequence_fields");
    public static final TruffleString T_N_FIELDS = PythonUtils.tsLiteral("n_fields");
    public static final TruffleString T_N_UNNAMED_FIELDS = PythonUtils.tsLiteral("n_unnamed_fields");

    @CompilerDirectives.TruffleBoundary
    public static void initType(Python3Core core, BuiltinTypeDescriptor desc) {
        StructSequence.initType(core.factory(), core.getLanguage(), core.lookupType(desc.type), desc);
    }

    @CompilerDirectives.TruffleBoundary
    public static void initType(PythonLanguage language, Object klass, Descriptor desc) {
        StructSequence.initType(PythonContext.get(null).factory(), language, klass, desc);
    }

    @CompilerDirectives.TruffleBoundary
    public static void initType(PythonObjectSlowPathFactory factory, PythonLanguage language, Object klass, Descriptor desc) {
        assert (IsSubtypeNode.getUncached().execute(klass, (Object)PythonBuiltinClassType.PTuple));
        int unnamedFields = 0;
        for (int idx = 0; idx < desc.fieldNames.length; ++idx) {
            if (desc.fieldNames[idx] != null) {
                TruffleString doc = desc.fieldDocStrings == null ? null : desc.fieldDocStrings[idx];
                StructSequence.createMember(factory, language, klass, desc.fieldNames[idx], doc, idx);
                continue;
            }
            ++unnamedFields;
        }
        StructSequence.createMethod(factory, language, klass, desc, ReprNode.class, StructSequenceFactory.ReprNodeGen::create);
        StructSequence.createMethod(factory, language, klass, desc, ReduceNode.class, StructSequenceFactory.ReduceNodeGen::create);
        WriteAttributeToObjectNode writeAttrNode = WriteAttributeToObjectNode.getUncached(true);
        if (desc.docString != null) {
            writeAttrNode.execute(klass, SpecialAttributeNames.T___DOC__, (Object)desc.docString);
        }
        writeAttrNode.execute(klass, T_N_SEQUENCE_FIELDS, (Object)desc.inSequence);
        writeAttrNode.execute(klass, T_N_FIELDS, (Object)desc.fieldNames.length);
        writeAttrNode.execute(klass, T_N_UNNAMED_FIELDS, (Object)unnamedFields);
        if (ReadAttributeFromObjectNode.getUncachedForceType().execute(klass, SpecialMethodNames.T___NEW__) == PNone.NO_VALUE) {
            if (desc.allowInstances) {
                StructSequence.createConstructor(factory, language, klass, desc, NewNode.class, StructSequenceFactory.NewNodeGen::create);
            } else {
                StructSequence.createConstructor(factory, language, klass, desc, DisabledNewNode.class, d -> StructSequenceFactory.DisabledNewNodeGen.create());
            }
        }
    }

    private static void createMember(PythonObjectSlowPathFactory factory, PythonLanguage language, Object klass, TruffleString name, TruffleString doc, int idx) {
        PythonUtils.createMember(factory, language, klass, GetStructMemberNode.class, name, doc, idx, l -> new GetStructMemberNode((PythonLanguage)((Object)l), idx));
    }

    private static void createMethod(PythonObjectSlowPathFactory factory, PythonLanguage language, Object klass, Descriptor desc, Class<?> nodeClass, Function<Descriptor, PythonBuiltinBaseNode> nodeSupplier) {
        PythonUtils.createMethod(factory, language, klass, nodeClass, (Object)PythonBuiltinClassType.PTuple, 0, () -> (PythonBuiltinBaseNode)nodeSupplier.apply(desc), desc);
    }

    private static void createConstructor(PythonObjectSlowPathFactory factory, PythonLanguage language, Object klass, Descriptor desc, Class<?> nodeClass, Function<Descriptor, PythonBuiltinBaseNode> nodeSupplier) {
        PythonUtils.createConstructor(factory, language, klass, nodeClass, () -> (PythonBuiltinBaseNode)nodeSupplier.apply(desc), desc);
    }

    static TruffleString getTpName(Object cls) {
        if (cls instanceof PythonBuiltinClassType) {
            return ((PythonBuiltinClassType)((Object)cls)).getPrintName();
        }
        if (cls instanceof PythonBuiltinClass) {
            return ((PythonBuiltinClass)cls).getType().getPrintName();
        }
        return TypeNodes.GetNameNode.executeUncached(cls);
    }

    public static final class BuiltinTypeDescriptor
    extends Descriptor {
        public final PythonBuiltinClassType type;

        public BuiltinTypeDescriptor(PythonBuiltinClassType type, String docString, int inSequence, String[] fieldNames, String[] fieldDocStrings, boolean allowInstances) {
            super(docString == null ? null : PythonUtils.toTruffleStringUncached(docString), inSequence, PythonUtils.toTruffleStringArrayUncached(fieldNames), PythonUtils.toTruffleStringArrayUncached(fieldDocStrings), allowInstances);
            assert (type.getBase() == PythonBuiltinClassType.PTuple);
            assert (!type.isAcceptableBase());
            this.type = type;
        }

        public BuiltinTypeDescriptor(PythonBuiltinClassType type, String docString, int inSequence, String[] fieldNames, String[] fieldDocStrings) {
            this(type, docString, inSequence, fieldNames, fieldDocStrings, true);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BuiltinTypeDescriptor)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BuiltinTypeDescriptor that = (BuiltinTypeDescriptor)o;
            return this.type == that.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.type});
        }
    }

    public static class Descriptor {
        public final TruffleString docString;
        public final int inSequence;
        public final TruffleString[] fieldNames;
        public final TruffleString[] fieldDocStrings;
        public final boolean allowInstances;

        public Descriptor(TruffleString docString, int inSequence, TruffleString[] fieldNames, TruffleString[] fieldDocStrings, boolean allowInstances) {
            assert (fieldDocStrings == null || fieldNames.length == fieldDocStrings.length);
            this.docString = docString;
            this.inSequence = inSequence;
            this.fieldNames = fieldNames;
            this.fieldDocStrings = fieldDocStrings;
            this.allowInstances = allowInstances;
        }

        public Descriptor(TruffleString docString, int inSequence, TruffleString[] fieldNames, TruffleString[] fieldDocStrings) {
            this(docString, inSequence, fieldNames, fieldDocStrings, true);
        }

        TruffleString[] getFieldsForRepr() {
            TruffleString[] fieldNamesForRepr = new TruffleString[this.inSequence];
            int k = 0;
            for (int idx = 0; idx < this.fieldNames.length && k < this.inSequence; ++idx) {
                if (this.fieldNames[idx] == null) continue;
                fieldNamesForRepr[k++] = this.fieldNames[idx];
            }
            assert (k == this.inSequence);
            return fieldNamesForRepr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Descriptor)) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return this.inSequence == that.inSequence && this.allowInstances == that.allowInstances && Objects.equals(this.docString, that.docString) && Arrays.equals(this.fieldNames, that.fieldNames) && Arrays.equals(this.fieldDocStrings, that.fieldDocStrings);
        }

        public int hashCode() {
            int result = Objects.hash(this.docString, this.inSequence, this.allowInstances);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            result = 31 * result + Arrays.hashCode(this.fieldDocStrings);
            return result;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final TruffleString[] fieldNames;

        ReprNode(Descriptor desc) {
            this.fieldNames = desc.getFieldsForRepr();
        }

        @Specialization
        public TruffleString repr(VirtualFrame frame, PTuple self, @Bind(value="this") Node inliningTarget, @Cached ObjectNodes.GetFullyQualifiedClassNameNode getFullyQualifiedClassNameNode, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)getFullyQualifiedClassNameNode.execute((Frame)frame, inliningTarget, self));
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
            SequenceStorage tupleStore = self.getSequenceStorage();
            if (this.fieldNames.length > 0) {
                appendStringNode.execute(sb, (AbstractTruffleString)this.fieldNames[0]);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, getItemNode.execute(tupleStore, 0)));
                for (int i = 1; i < this.fieldNames.length; ++i) {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    appendStringNode.execute(sb, (AbstractTruffleString)this.fieldNames[i]);
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                    appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, getItemNode.execute(tupleStore, i)));
                }
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final TruffleString[] fieldNames;
        private final int inSequence;

        ReduceNode(Descriptor desc) {
            this.fieldNames = desc.fieldNames;
            this.inSequence = desc.inSequence;
        }

        @Specialization
        public PTuple reduce(PTuple self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached GetClassNode getClass) {
            PDict dict;
            PTuple seq;
            assert (self.getSequenceStorage() instanceof ObjectSequenceStorage);
            Object[] data = ((ObjectSequenceStorage)CompilerDirectives.castExact((Object)self.getSequenceStorage(), ObjectSequenceStorage.class)).getInternalArray();
            assert (data.length == this.fieldNames.length);
            if (this.fieldNames.length == this.inSequence) {
                seq = this.factory().createTuple(data);
                dict = this.factory().createDict();
            } else {
                HashingStorage storage = EconomicMapStorage.create(this.fieldNames.length - this.inSequence);
                for (int i = this.inSequence; i < this.fieldNames.length; ++i) {
                    storage = setHashingStorageItem.execute(inliningTarget, storage, this.fieldNames[i], data[i]);
                }
                seq = this.factory().createTuple(Arrays.copyOf(data, this.inSequence));
                dict = this.factory().createDict(storage);
            }
            PTuple seqDictPair = this.factory().createTuple(new Object[]{seq, dict});
            return this.factory().createTuple(new Object[]{getClass.execute(inliningTarget, self), seqDictPair});
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=2, parameterNames={"$cls", "sequence", "dict"})
    public static abstract class NewNode
    extends PythonTernaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final TruffleString[] fieldNames;
        private final int inSequence;

        NewNode(Descriptor desc) {
            this.fieldNames = desc.fieldNames;
            this.inSequence = desc.inSequence;
        }

        @NeverDefault
        public static NewNode create(Descriptor desc) {
            return StructSequenceFactory.NewNodeGen.create(desc);
        }

        @Specialization(guards={"isNoValue(dict)"})
        PTuple withoutDict(VirtualFrame frame, Object cls, Object sequence, PNone dict, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ListNodes.FastConstructListNode fastConstructListNode, @Cached.Exclusive @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notASequenceProfile, @Cached.Exclusive @Cached InlinedBranchProfile wrongLenProfile, @Cached.Exclusive @Cached InlinedBranchProfile needsReallocProfile) {
            Object[] src = this.sequenceToArray(frame, inliningTarget, sequence, fastConstructListNode, toArrayNode, notASequenceProfile);
            Object[] dst = this.processSequence(inliningTarget, cls, src, wrongLenProfile, needsReallocProfile);
            for (int i = src.length; i < dst.length; ++i) {
                dst[i] = PNone.NONE;
            }
            return this.factory().createTuple(cls, new ObjectSequenceStorage(dst, this.inSequence));
        }

        @Specialization
        PTuple withDict(VirtualFrame frame, Object cls, Object sequence, PDict dict, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ListNodes.FastConstructListNode fastConstructListNode, @Cached.Exclusive @Cached SequenceStorageNodes.ToArrayNode toArrayNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notASequenceProfile, @Cached.Exclusive @Cached InlinedBranchProfile wrongLenProfile, @Cached.Exclusive @Cached InlinedBranchProfile needsReallocProfile, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            Object[] src = this.sequenceToArray(frame, inliningTarget, sequence, fastConstructListNode, toArrayNode, notASequenceProfile);
            Object[] dst = this.processSequence(inliningTarget, cls, src, wrongLenProfile, needsReallocProfile);
            HashingStorage hs = dict.getDictStorage();
            for (int i = src.length; i < dst.length; ++i) {
                Object o = getItem.execute(inliningTarget, hs, this.fieldNames[i]);
                dst[i] = o == null ? PNone.NONE : o;
            }
            return this.factory().createTuple(cls, new ObjectSequenceStorage(dst, this.inSequence));
        }

        @Specialization(guards={"!isNoValue(dict)", "!isDict(dict)"})
        PTuple doDictError(VirtualFrame frame, Object cls, Object sequence, Object dict) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_A_DICT_AS_SECOND_ARG_IF_ANY, StructSequence.getTpName(cls));
        }

        private Object[] sequenceToArray(VirtualFrame frame, Node inliningTarget, Object sequence, ListNodes.FastConstructListNode fastConstructListNode, SequenceStorageNodes.ToArrayNode toArrayNode, BuiltinClassProfiles.IsBuiltinObjectProfile notASequenceProfile) {
            PSequence seq;
            try {
                seq = fastConstructListNode.execute((Frame)frame, inliningTarget, sequence);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.TypeError, notASequenceProfile);
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CONSTRUCTOR_REQUIRES_A_SEQUENCE);
            }
            return toArrayNode.execute(inliningTarget, seq.getSequenceStorage());
        }

        private Object[] processSequence(Node inliningTarget, Object cls, Object[] src, InlinedBranchProfile wrongLenProfile, InlinedBranchProfile needsReallocProfile) {
            int len = src.length;
            int minLen = this.inSequence;
            int maxLen = this.fieldNames.length;
            if (len < minLen || len > maxLen) {
                wrongLenProfile.enter(inliningTarget);
                if (minLen == maxLen) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_A_D_SEQUENCE, StructSequence.getTpName(cls), minLen, len);
                }
                if (len < minLen) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_AN_AT_LEAST_D_SEQUENCE, StructSequence.getTpName(cls), minLen, len);
                }
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.TAKES_AN_AT_MOST_D_SEQUENCE, StructSequence.getTpName(cls), maxLen, len);
            }
            if (len != maxLen) {
                needsReallocProfile.enter(inliningTarget);
                Object[] dst = new Object[maxLen];
                PythonUtils.arraycopy(src, 0, dst, 0, len);
                return dst;
            }
            return src;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    public static abstract class DisabledNewNode
    extends PythonVarargsBuiltinNode {
        @Override
        public final Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (arguments.length > 0) {
                return this.error(arguments[0], PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
        }

        @Specialization
        Object error(Object cls, Object[] arguments, PKeyword[] keywords) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, StructSequence.getTpName(cls));
        }
    }

    private static class GetStructMemberNode
    extends PRootNode {
        public static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("$self"), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        private final int fieldIdx;

        GetStructMemberNode(PythonLanguage language, int fieldIdx) {
            super(language);
            this.fieldIdx = fieldIdx;
        }

        public Object execute(VirtualFrame frame) {
            PTuple self = (PTuple)PArguments.getArgument((Frame)frame, 0);
            return self.getSequenceStorage().getItemNormalized(this.fieldIdx);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }
    }
}

