/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PUnionType;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class GenericTypeNodes {
    static void reprItem(TruffleStringBuilder sb, Object obj) {
        Object module;
        Object args;
        PyObjectLookupAttr lookup = PyObjectLookupAttr.getUncached();
        PyObjectStrAsTruffleStringNode str = PyObjectStrAsTruffleStringNode.getUncached();
        Object origin = lookup.execute(null, null, obj, SpecialAttributeNames.T___ORIGIN__);
        if (origin != PNone.NO_VALUE && (args = lookup.execute(null, null, obj, SpecialAttributeNames.T___ARGS__)) != PNone.NO_VALUE) {
            sb.appendStringUncached(PyObjectReprAsTruffleStringNode.executeUncached(obj));
            return;
        }
        Object qualname = lookup.execute(null, null, obj, SpecialAttributeNames.T___QUALNAME__);
        if (qualname != PNone.NO_VALUE && !((module = lookup.execute(null, null, obj, SpecialAttributeNames.T___MODULE__)) instanceof PNone)) {
            if (PyUnicodeCheckNode.executeUncached(module) && PyObjectRichCompareBool.EqNode.compareUncached(module, BuiltinNames.T_BUILTINS)) {
                sb.appendStringUncached(str.execute(null, null, qualname));
                return;
            }
            sb.appendStringUncached(str.execute(null, null, module));
            sb.appendCodePointUncached(46);
            sb.appendStringUncached(str.execute(null, null, qualname));
            return;
        }
        sb.appendStringUncached(PyObjectReprAsTruffleStringNode.executeUncached(obj));
    }

    @CompilerDirectives.TruffleBoundary
    static Object[] makeParameters(PTuple args) {
        PyObjectLookupAttr lookup = PyObjectLookupAttr.getUncached();
        SequenceStorage storage = args.getSequenceStorage();
        int nargs = storage.length();
        ArrayList<Object> parameters = new ArrayList<Object>(nargs);
        for (int iarg = 0; iarg < nargs; ++iarg) {
            Object subparams;
            Object t = storage.getItemNormalized(iarg);
            if (GenericTypeNodes.isTypeVar(t)) {
                GenericTypeNodes.addUnique(parameters, t);
            }
            if (!((subparams = lookup.execute(null, null, t, SpecialAttributeNames.T___PARAMETERS__)) instanceof PTuple)) continue;
            SequenceStorage storage2 = ((PTuple)subparams).getSequenceStorage();
            for (int j = 0; j < storage2.length(); ++j) {
                GenericTypeNodes.addUnique(parameters, storage2.getItemNormalized(j));
            }
        }
        return parameters.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isTypeVar(Object obj) {
        Object type = GetClassNode.executeUncached(obj);
        TruffleString typeName = TypeNodes.GetNameNode.executeUncached(type);
        if (BuiltinNames.T_TYPE_VAR.equalsUncached((AbstractTruffleString)typeName, PythonUtils.TS_ENCODING)) {
            Object module = PyObjectLookupAttr.executeUncached(type, SpecialAttributeNames.T___MODULE__);
            return PyUnicodeCheckNode.executeUncached(module) && PyObjectRichCompareBool.EqNode.compareUncached(module, BuiltinNames.T_TYPING);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    private static void addUnique(List<Object> list, Object obj) {
        if (GenericTypeNodes.indexOf(list, obj) < 0) {
            list.add(obj);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static int indexOf(List<Object> list, Object obj) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != obj) continue;
            return i;
        }
        return -1;
    }

    @CompilerDirectives.TruffleBoundary
    static Object[] subsParameters(Node node, Object self, PTuple args, PTuple parameters, Object item) {
        Object[] objectArray;
        SequenceStorage paramsStorage = parameters.getSequenceStorage();
        int nparams = paramsStorage.length();
        if (nparams == 0) {
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.THERE_ARE_NO_TYPE_VARIABLES_LEFT_IN_S, PyObjectReprAsTruffleStringNode.executeUncached(self));
        }
        if (item instanceof PTuple) {
            objectArray = ((PTuple)item).getSequenceStorage().getCopyOfInternalArray();
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = item;
        }
        Object[] argitems = objectArray;
        if (argitems.length != nparams) {
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.TOO_S_ARGUMENTS_FOR_S, argitems.length > nparams ? "many" : "few", PyObjectReprAsTruffleStringNode.executeUncached(self));
        }
        SequenceStorage argsStorage = args.getSequenceStorage();
        Object[] newargs = new Object[argsStorage.length()];
        for (int iarg = 0; iarg < argsStorage.length(); ++iarg) {
            Object arg = argsStorage.getItemNormalized(iarg);
            if (GenericTypeNodes.isTypeVar(arg)) {
                for (int iparam = 0; iparam < nparams; ++iparam) {
                    if (paramsStorage.getItemNormalized(iparam) != arg) continue;
                    arg = argitems[iparam];
                    break;
                }
            } else {
                arg = GenericTypeNodes.subsTvars(arg, paramsStorage, argitems);
            }
            newargs[iarg] = arg;
        }
        return newargs;
    }

    private static Object subsTvars(Object obj, SequenceStorage parameters, Object[] argitems) {
        Object subparams = PyObjectLookupAttr.executeUncached(obj, SpecialAttributeNames.T___PARAMETERS__);
        if (subparams instanceof PTuple) {
            SequenceStorage subparamsStorage = ((PTuple)subparams).getSequenceStorage();
            int nparams = parameters.length();
            int nsubargs = subparamsStorage.length();
            if (nsubargs > 0) {
                Object[] subargs = new Object[nsubargs];
                block0: for (int i = 0; i < nsubargs; ++i) {
                    Object arg = subparamsStorage.getItemNormalized(i);
                    for (int iparam = 0; iparam < nparams; ++iparam) {
                        if (parameters.getItemNormalized(iparam) != arg) continue;
                        subargs[i] = arg = argitems[iparam];
                        continue block0;
                    }
                }
                PTuple subargsTuple = PythonObjectFactory.getUncached().createTuple(subargs);
                obj = PyObjectGetItem.executeUncached(obj, subargsTuple);
            }
        }
        return obj;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] dedupAndFlattenArgs(Object[] args) {
        args = GenericTypeNodes.flattenArgs(args);
        PyObjectRichCompareBool.EqNode eq = PyObjectRichCompareBool.EqNode.getUncached();
        Object[] newArgs = new Object[args.length];
        int addedItems = 0;
        for (int i = 0; i < args.length; ++i) {
            boolean isDuplicate = false;
            Object iElement = args[i];
            for (int j = 0; j < addedItems; ++j) {
                Object jElement = newArgs[j];
                boolean isGA = iElement instanceof PGenericAlias && jElement instanceof PGenericAlias;
                boolean bl = isDuplicate = isGA ? eq.compare(null, null, iElement, jElement) : IsNode.getUncached().execute(iElement, jElement);
                if (isDuplicate) break;
            }
            if (isDuplicate) continue;
            newArgs[addedItems++] = iElement;
        }
        if (addedItems != args.length) {
            newArgs = Arrays.copyOf(newArgs, addedItems);
        }
        return newArgs;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] flattenArgs(Object[] args) {
        int totalArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof PUnionType) {
                totalArgs += ((PUnionType)args[i]).getArgs().getSequenceStorage().length();
                continue;
            }
            ++totalArgs;
        }
        Object[] flattenedArgs = new Object[totalArgs];
        int pos = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof PUnionType) {
                SequenceStorage storage = ((PUnionType)args[i]).getArgs().getSequenceStorage();
                for (int j = 0; j < storage.length(); ++j) {
                    flattenedArgs[pos++] = storage.getItemNormalized(j);
                }
                continue;
            }
            flattenedArgs[pos++] = args[i] == PNone.NONE ? PythonBuiltinClassType.PNone : args[i];
        }
        assert (pos == totalArgs);
        return flattenedArgs;
    }

    public static abstract class UnionTypeOrNode
    extends PNodeWithContext {
        public abstract Object execute(Object var1, Object var2);

        @Specialization(guards={"isUnionable(inliningTarget, typeCheck, self)", "isUnionable(inliningTarget, typeCheck, other)"}, limit="1")
        static Object union(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyObjectTypeCheck typeCheck, @Cached PythonObjectFactory factory) {
            Object[] args = GenericTypeNodes.dedupAndFlattenArgs(new Object[]{self, other});
            if (args.length == 1) {
                return args[0];
            }
            assert (args.length > 1);
            return factory.createUnionType(args);
        }

        @Fallback
        static Object notImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        protected static boolean isUnionable(Node inliningTarget, PyObjectTypeCheck typeCheck, Object obj) {
            return obj == PNone.NONE || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PythonClass) || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PGenericAlias) || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PUnionType);
        }
    }
}

