/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached(value=false)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyLongAsLongAndOverflowNode
extends PNodeWithContext {
    public abstract long execute(Frame var1, Node var2, Object var3) throws OverflowException;

    @Specialization
    static long doInt(int object) {
        return object;
    }

    @Specialization
    static long doLong(long object) {
        return object;
    }

    @Specialization
    static long doPInt(PInt object) throws OverflowException {
        return object.longValueExact();
    }

    @Specialization
    static long doBoolean(boolean x) {
        return x ? 1L : 0L;
    }

    @Specialization
    static long doNativePointer(PythonNativeVoidPtr object) {
        return object.getNativePointer();
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static long doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached PyNumberIndexNode indexNode, @Cached BuiltinPyLongAsLongAndOverflowNode recursive) throws OverflowException {
        Object result = indexNode.execute((Frame)frame, inliningTarget, object);
        assert (PyLongCheckExactNode.canBeBuiltinInt(result));
        return recursive.execute((Frame)frame, inliningTarget, result);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class BuiltinPyLongAsLongAndOverflowNode
    extends PNodeWithContext {
        BuiltinPyLongAsLongAndOverflowNode() {
        }

        public abstract long execute(Frame var1, Node var2, Object var3) throws OverflowException;

        @Specialization
        static long doInt(int object) {
            return object;
        }

        @Specialization
        static long doLong(long object) {
            return object;
        }

        @Specialization
        static long doPInt(PInt object) throws OverflowException {
            return object.longValueExact();
        }

        @Specialization
        static long doBoolean(boolean x) {
            return x ? 1L : 0L;
        }

        @Specialization
        static long doNativePointer(PythonNativeVoidPtr object) {
            return object.getNativePointer();
        }
    }
}

