/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.deque.PDeque;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.range.PRange;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyMappingCheckNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
@GenerateInline
@GenerateCached(value=false)
public abstract class PyMappingCheckNode
extends PNodeWithContext {
    public static boolean executeUncached(Object obj) {
        return PyMappingCheckNodeGen.getUncached().execute(null, obj);
    }

    public abstract boolean execute(Node var1, Object var2);

    @Specialization
    static boolean doDict(PDict object) {
        return true;
    }

    @Specialization
    static boolean doString(TruffleString object) {
        return true;
    }

    @Specialization
    static boolean doSequence(PSequence object) {
        return true;
    }

    @Specialization
    static boolean doArray(PArray object) {
        return true;
    }

    @Specialization
    static boolean doMemoryView(PMemoryView object) {
        return true;
    }

    @Specialization
    static boolean doMappingproxy(PMappingproxy object) {
        return true;
    }

    @Specialization
    static boolean doRange(PRange object) {
        return true;
    }

    @Specialization
    static boolean doDeque(PDeque object) {
        return false;
    }

    @Specialization
    static boolean doSet(PBaseSet object) {
        return false;
    }

    protected static boolean cannotBeMapping(Object object) {
        return object instanceof PDeque || object instanceof PBaseSet;
    }

    protected static boolean isKnownMapping(Object object) {
        return object instanceof PDict || TruffleStringMigrationHelpers.isJavaString(object) || object instanceof TruffleString || object instanceof PSequence || object instanceof PArray || object instanceof PMemoryView || object instanceof PRange || object instanceof PMappingproxy;
    }

    @Specialization(guards={"!isKnownMapping(object)", "!cannotBeMapping(object)"})
    static boolean doPythonObject(Node inliningTarget, PythonObject object, @Cached.Shared(value="getClass") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupGetItem") @Cached(parameters={"GetItem"}, inline=false) LookupCallableSlotInMRONode lookupGetItem) {
        Object type = getClassNode.execute(inliningTarget, object);
        return lookupGetItem.execute(type) != PNone.NO_VALUE;
    }

    @Specialization(guards={"!isKnownMapping(object)", "!cannotBeMapping(object)"}, replaces={"doPythonObject"})
    static boolean doGeneric(Node inliningTarget, Object object, @Cached.Shared(value="getClass") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupGetItem") @Cached(parameters={"GetItem"}, inline=false) LookupCallableSlotInMRONode lookupGetItem, @CachedLibrary(limit="3") InteropLibrary lib) {
        Object type = getClassNode.execute(inliningTarget, object);
        if (type == PythonBuiltinClassType.ForeignObject) {
            return lib.hasHashEntries(object);
        }
        return lookupGetItem.execute(type) != PNone.NO_VALUE;
    }
}

