/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectSetAttrNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectSetAttr
extends PNodeWithContext {
    public final void executeCached(Frame frame, Object receiver, Object name, Object value) {
        this.execute(frame, this, receiver, name, value);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    public final void execute(Node inliningTarget, Object receiver, Object name, Object value) {
        this.execute(null, inliningTarget, receiver, name, value);
    }

    public final void deleteCached(Frame frame, Object receiver, Object name) {
        this.execute(frame, null, receiver, name, null);
    }

    @Specialization(guards={"name == cachedName", "value != null"}, limit="1")
    static void setFixedAttr(Frame frame, Node inliningTarget, Object self, TruffleString name, Object value, @Cached(value="name") TruffleString cachedName, @Cached.Shared(value="getClass") @Cached GetClassNode getClass, @Cached.Shared(value="lookup") @Cached(parameters={"SetAttr"}, inline=false) LookupSpecialMethodSlotNode lookupSetattr, @Cached.Shared(value="lookupGet") @Cached(parameters={"GetAttribute"}, inline=false) LookupSpecialMethodSlotNode lookupGetattr, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raise, @Cached.Shared(value="call") @Cached(inline=false) CallTernaryMethodNode callSetattr) {
        Object type = getClass.execute(inliningTarget, self);
        Object setattr = lookupSetattr.execute(frame, type, self);
        if (setattr == PNone.NO_VALUE) {
            if (lookupGetattr.execute(frame, type, self) == PNone.NO_VALUE) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_HAS_NO_ATTRS_S_TO_ASSIGN, self, name);
            }
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_HAS_RO_ATTRS_S_TO_ASSIGN, self, name);
        }
        callSetattr.execute(frame, setattr, self, name, value);
    }

    @Specialization(guards={"name == cachedName", "value == null"}, limit="1")
    static void delFixedAttr(Frame frame, Node inliningTarget, Object self, TruffleString name, Object value, @Cached(value="name") TruffleString cachedName, @Cached.Shared(value="getClass") @Cached GetClassNode getClass, @Cached.Shared(value="lookupDel") @Cached(parameters={"DelAttr"}, inline=false) LookupSpecialMethodSlotNode lookupDelattr, @Cached.Shared(value="lookupGet") @Cached(parameters={"GetAttribute"}, inline=false) LookupSpecialMethodSlotNode lookupGetattr, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raise, @Cached.Shared(value="callDel") @Cached(inline=false) CallBinaryMethodNode callDelattr) {
        Object type = getClass.execute(inliningTarget, self);
        Object delattr = lookupDelattr.execute(frame, type, self);
        if (delattr == PNone.NO_VALUE) {
            if (lookupGetattr.execute(frame, type, self) == PNone.NO_VALUE) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_HAS_NO_ATTRS_S_TO_DELETE, self, name);
            }
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_HAS_RO_ATTRS_S_TO_DELETE, self, name);
        }
        callDelattr.executeObject(frame, delattr, self, name);
    }

    @Specialization(replaces={"setFixedAttr", "delFixedAttr"})
    static void doDynamicAttr(Frame frame, Node inliningTarget, Object self, TruffleString name, Object value, @Cached.Shared(value="getClass") @Cached GetClassNode getClass, @Cached.Shared(value="lookup") @Cached(parameters={"SetAttr"}, inline=false) LookupSpecialMethodSlotNode lookupSetattr, @Cached.Shared(value="lookupDel") @Cached(parameters={"DelAttr"}, inline=false) LookupSpecialMethodSlotNode lookupDelattr, @Cached.Shared(value="lookupGet") @Cached(parameters={"GetAttribute"}, inline=false) LookupSpecialMethodSlotNode lookupGetattr, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raise, @Cached.Shared(value="call") @Cached(inline=false) CallTernaryMethodNode callSetattr, @Cached.Shared(value="callDel") @Cached(inline=false) CallBinaryMethodNode callDelattr) {
        if (value == null) {
            PyObjectSetAttr.delFixedAttr(frame, inliningTarget, self, name, value, name, getClass, lookupDelattr, lookupGetattr, raise, callDelattr);
        } else {
            PyObjectSetAttr.setFixedAttr(frame, inliningTarget, self, name, value, name, getClass, lookupSetattr, lookupGetattr, raise, callSetattr);
        }
    }

    @Specialization(guards={"!isString(name)"})
    static void nameMustBeString(Node inliningTarget, Object self, Object name, Object value, @Cached.Shared(value="raise") @Cached PRaiseNode.Lazy raise) {
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, name);
    }

    @NeverDefault
    public static PyObjectSetAttr create() {
        return PyObjectSetAttrNodeGen.create();
    }

    public static PyObjectSetAttr getUncached() {
        return PyObjectSetAttrNodeGen.getUncached();
    }
}

