/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonFileDetector;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.traceback.TracebackBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyLongAsIntNodeGen;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNodeGen;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyTraceBackPrintNodeGen;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@GenerateInline(value=false)
public abstract class PyTraceBackPrintNode
extends PNodeWithContext {
    static final int TRACEBACK_LIMIT = 1000;
    static final int TB_RECURSIVE_CUTOFF = 3;

    public static boolean fileWriteObject(VirtualFrame frame, Object file, Object data, boolean printRaw) {
        Object value = printRaw ? PyTraceBackPrintNode.objectStr(frame, data) : PyTraceBackPrintNode.objectRepr(frame, data);
        if (value == null) {
            return false;
        }
        PyTraceBackPrintNode.fileWriteString(frame, file, PyTraceBackPrintNode.castToString(value));
        return true;
    }

    public static void fileWriteString(VirtualFrame frame, Object file, TruffleString data) {
        PyTraceBackPrintNode.fileWriteString(frame, null, file, data, PyObjectGetAttr.getUncached(), CallNode.getUncached());
    }

    public static void fileWriteString(VirtualFrame frame, Object file, String data) {
        PyTraceBackPrintNode.fileWriteString(frame, file, PythonUtils.toTruffleStringUncached(data));
    }

    public static void fileWriteString(VirtualFrame frame, Node inliningTarget, Object file, TruffleString data, PyObjectGetAttr getAttr, CallNode callNode) {
        Object writeMethod = getAttr.execute((Frame)frame, inliningTarget, file, IONodes.T_WRITE);
        callNode.execute((Frame)frame, writeMethod, new Object[]{data});
    }

    public static void fileFlush(VirtualFrame frame, Object file) {
        Object flushMethod = PyObjectGetAttr.getUncached().execute((Frame)frame, null, file, IONodes.T_FLUSH);
        CallNode.getUncached().execute((Frame)frame, flushMethod, new Object[0]);
    }

    public static Object objectStr(VirtualFrame frame, Object value) {
        return PyTraceBackPrintNode.objectStr(frame, null, value, PyObjectStrAsObjectNode.getUncached());
    }

    public static Object objectStr(VirtualFrame frame, Node inliningTarget, Object value, PyObjectStrAsObjectNode strAsObjectNode) {
        try {
            return strAsObjectNode.execute((Frame)frame, inliningTarget, value);
        }
        catch (PException pe) {
            return null;
        }
    }

    public static Object objectRepr(VirtualFrame frame, Object value) {
        return PyTraceBackPrintNode.objectRepr(frame, null, value, PyObjectReprAsObjectNode.getUncached());
    }

    public static Object objectRepr(VirtualFrame frame, Node inliningTarget, Object value, PyObjectReprAsObjectNode reprAsObjectNode) {
        try {
            return reprAsObjectNode.execute((Frame)frame, inliningTarget, value);
        }
        catch (PException pe) {
            return null;
        }
    }

    public static TruffleString castToString(Object value) {
        return CastToTruffleStringNode.executeUncached(value);
    }

    public static TruffleString tryCastToString(Object value) {
        try {
            return PyTraceBackPrintNode.castToString(value);
        }
        catch (CannotCastException e) {
            return null;
        }
    }

    public static Object objectLookupAttr(VirtualFrame frame, Object object, TruffleString attr) {
        return PyTraceBackPrintNode.objectLookupAttr(frame, null, object, attr, PyObjectLookupAttr.getUncached());
    }

    public static Object objectLookupAttr(VirtualFrame frame, Node inliningTarget, Object object, TruffleString attr, PyObjectLookupAttr lookupAttr) {
        return lookupAttr.execute((Frame)frame, inliningTarget, object, attr);
    }

    public static TruffleString objectLookupAttrAsString(VirtualFrame frame, Node inliningTarget, Object object, TruffleString attr, PyObjectLookupAttr lookupAttr, CastToTruffleStringNode castToStringNode) {
        Object value = PyTraceBackPrintNode.objectLookupAttr(frame, inliningTarget, object, attr, lookupAttr);
        return value != PNone.NO_VALUE ? castToStringNode.execute(inliningTarget, value) : null;
    }

    public static boolean objectHasAttr(VirtualFrame frame, Object object, TruffleString attr) {
        return PyTraceBackPrintNode.objectLookupAttr(frame, object, attr) != PNone.NO_VALUE;
    }

    public static TruffleString getTypeName(Object type) {
        return TypeNodes.GetNameNode.executeUncached(type);
    }

    public static Object getObjectClass(Object object) {
        return GetClassNode.executeUncached(object);
    }

    public static Object getExceptionTraceback(Object e) {
        return ExceptionNodes.GetTracebackNode.executeUncached(e);
    }

    public static void setExceptionTraceback(Object e, Object tb) {
        ExceptionNodes.SetTracebackNode.executeUncached(e, tb);
    }

    public static boolean checkLong(Object object) {
        return PyLongCheckNode.executeUncached(object);
    }

    public static int longAsInt(MaterializedFrame frame, Object object) {
        return PyLongAsIntNodeGen.getUncached().execute((Frame)frame, null, object);
    }

    public static long longAsLongAndOverflow(VirtualFrame frame, Object object, long overflowValue) {
        try {
            return PyLongAsLongAndOverflowNodeGen.getUncached().execute((Frame)frame, null, object);
        }
        catch (OverflowException e) {
            if (object instanceof PInt) {
                return ((PInt)object).isZeroOrNegative() ? 0L : overflowValue;
            }
            return overflowValue;
        }
    }

    public static Object objectReadAttr(Object object, TruffleString attribute) {
        return ReadAttributeFromObjectNode.getUncached().execute(object, attribute);
    }

    public static TruffleString classNameNoDot(TruffleString name) {
        int len = name.codePointLengthUncached(PythonUtils.TS_ENCODING);
        int i = name.lastIndexOfCodePointUncached(46, len, 0, PythonUtils.TS_ENCODING);
        return i > 0 ? name.substringUncached(i + 1, len - i - 1, PythonUtils.TS_ENCODING, true) : name;
    }

    public PCode getCode(VirtualFrame frame, PythonObjectFactory factory, TracebackBuiltins.GetTracebackFrameNode getTbFrameNode, PTraceback tb) {
        PFrame pFrame = getTbFrameNode.execute(frame, tb);
        return factory.createCode(pFrame.getTarget());
    }

    protected PTraceback getNextTb(Node inliningTarget, TracebackBuiltins.MaterializeTruffleStacktraceNode materializeStNode, PTraceback traceback) {
        materializeStNode.execute(inliningTarget, traceback);
        return traceback.getNext();
    }

    private static void printLineRepeated(VirtualFrame frame, Object out, int count) {
        int cnt = count;
        StringBuilder sb = PyTraceBackPrintNode.newStringBuilder("  [Previous line repeated ");
        PyTraceBackPrintNode.append(sb, cnt -= 3, cnt > 1 ? " more times]\n" : " more time]\n");
        PyTraceBackPrintNode.fileWriteString(frame, out, PyTraceBackPrintNode.sbToString(sb));
    }

    private void displayLine(VirtualFrame frame, Object out, TruffleString fileName, int lineNo, TruffleString name) {
        if (fileName == null || name == null) {
            return;
        }
        StringBuilder sb = PyTraceBackPrintNode.newStringBuilder("  File \"");
        PyTraceBackPrintNode.append(sb, fileName, "\", line ", lineNo, ", in ", name, "\n");
        PyTraceBackPrintNode.fileWriteString(frame, out, PyTraceBackPrintNode.sbToString(sb));
        this.displaySourceLine(frame, out, fileName, lineNo, 4);
    }

    protected static TruffleString getIndent(int indent) {
        return StringLiterals.T_SPACE.repeatUncached(indent, PythonUtils.TS_ENCODING);
    }

    @CompilerDirectives.TruffleBoundary
    protected CharSequence getSourceLine(TruffleString fileName, int lineNo) {
        PythonContext context = this.getContext();
        TruffleFile file = null;
        try {
            file = context.getEnv().getInternalTruffleFile(fileName.toJavaStringUncached());
        }
        catch (Exception e) {
            return null;
        }
        String line = null;
        try {
            Charset encoding;
            try {
                encoding = PythonFileDetector.findEncodingStrict(file);
            }
            catch (PythonFileDetector.InvalidEncodingException e) {
                encoding = StandardCharsets.UTF_8;
            }
            BufferedReader reader = file.newBufferedReader(encoding);
            for (int i = 1; i <= lineNo; ++i) {
                if (i == lineNo) {
                    line = reader.readLine();
                    continue;
                }
                reader.readLine();
            }
        }
        catch (IOException ioe) {
            line = null;
        }
        return line;
    }

    private void displaySourceLine(VirtualFrame frame, Object out, TruffleString fileName, int lineNo, int indent) {
        CharSequence line = this.getSourceLine(fileName, lineNo);
        if (line != null) {
            PyTraceBackPrintNode.fileWriteString(frame, out, PyTraceBackPrintNode.getIndent(indent));
            PyTraceBackPrintNode.fileWriteString(frame, out, PyTraceBackPrintNode.trimLeft(line));
            PyTraceBackPrintNode.fileWriteString(frame, out, "\n");
        }
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static StringBuilder newStringBuilder(String str) {
        return new StringBuilder(str);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String sbToString(StringBuilder sb) {
        return sb.toString();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static StringBuilder append(StringBuilder sb, Object ... args) {
        for (Object arg : args) {
            sb.append(arg);
        }
        return sb;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String trimLeft(CharSequence sequence) {
        int st;
        int len = sequence.length();
        for (st = 0; st < len && sequence.charAt(st) <= ' '; ++st) {
        }
        return (st > 0 ? sequence.subSequence(st, len) : sequence).toString();
    }

    private void printInternal(VirtualFrame frame, Node inliningTarget, PythonObjectFactory factory, TracebackBuiltins.GetTracebackFrameNode getTbFrameNode, TracebackBuiltins.MaterializeTruffleStacktraceNode materializeStNode, Object out, PTraceback traceback, long limit, TruffleString.EqualNode equalNode) {
        int depth = 0;
        TruffleString lastFile = null;
        int lastLine = -1;
        TruffleString lastName = null;
        int cnt = 0;
        PTraceback tb1 = traceback;
        PTraceback tb = traceback;
        while (tb1 != null) {
            ++depth;
            tb1 = this.getNextTb(inliningTarget, materializeStNode, tb1);
        }
        while (tb != null && (long)depth > limit) {
            --depth;
            tb = this.getNextTb(inliningTarget, materializeStNode, tb);
        }
        while (tb != null) {
            PCode code = this.getCode(frame, factory, getTbFrameNode, tb);
            if (lastFile == null || !equalNode.execute((AbstractTruffleString)code.getFilename(), lastFile, PythonUtils.TS_ENCODING) || lastLine == -1 || tb.getLineno() != lastLine || lastName == null || !equalNode.execute((AbstractTruffleString)code.getName(), (AbstractTruffleString)lastName, PythonUtils.TS_ENCODING)) {
                if (cnt > 3) {
                    PyTraceBackPrintNode.printLineRepeated(frame, out, cnt);
                }
                lastFile = code.getFilename();
                lastLine = tb.getLineno();
                lastName = code.getName();
                cnt = 0;
            }
            if (++cnt <= 3) {
                this.displayLine(frame, out, code.getFilename(), tb.getLineno(), code.getName());
            }
            tb = this.getNextTb(inliningTarget, materializeStNode, tb);
        }
        if (cnt > 3) {
            PyTraceBackPrintNode.printLineRepeated(frame, out, cnt);
        }
    }

    public abstract void execute(VirtualFrame var1, PythonModule var2, Object var3, Object var4);

    @Specialization
    public void printTraceBack(VirtualFrame frame, PythonModule sys, Object out, PTraceback tb, @Bind(value="this") Node inliningTarget, @Cached TracebackBuiltins.GetTracebackFrameNode getTbFrameNode, @Cached TracebackBuiltins.MaterializeTruffleStacktraceNode materializeStNode, @Cached PythonObjectFactory factory, @Cached TruffleString.EqualNode equalNode) {
        long limit = 1000L;
        Object limitv = PyTraceBackPrintNode.objectReadAttr(sys, BuiltinNames.T_TRACEBACKLIMIT);
        if (PyTraceBackPrintNode.checkLong(limitv) && (limit = PyTraceBackPrintNode.longAsLongAndOverflow(frame, limitv, Integer.MAX_VALUE)) <= 0L) {
            return;
        }
        PyTraceBackPrintNode.fileWriteString(frame, out, "Traceback (most recent call last):\n");
        this.printInternal(frame, inliningTarget, factory, getTbFrameNode, materializeStNode, out, tb, limit, equalNode);
    }

    @Specialization(guards={"!isPTraceback(tb)"})
    public void printTraceBack(VirtualFrame frame, PythonModule sys, Object out, Object tb, @Cached PRaiseNode raiseNode) {
        throw raiseNode.raiseBadInternalCall();
    }

    @NeverDefault
    public static PyTraceBackPrintNode create() {
        return PyTraceBackPrintNodeGen.create();
    }
}

