/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.Node;

public final class IndirectCallData
extends Node
implements IndirectCallNode {
    private static final IndirectCallData UNCACHED = new IndirectCallData();
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedExceptionState;
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedMyFrame;

    public static IndirectCallData create() {
        return new IndirectCallData();
    }

    public static IndirectCallData getUncached() {
        return UNCACHED;
    }

    @Override
    public Assumption needNotPassFrameAssumption() {
        if (this.nativeCodeDoesntNeedMyFrame == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedMyFrame;
    }

    @Override
    public Assumption needNotPassExceptionAssumption() {
        if (this.nativeCodeDoesntNeedExceptionState == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedExceptionState;
    }
}

