/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInterface;

public interface IndirectCallNode
extends NodeInterface {
    public Assumption needNotPassFrameAssumption();

    public Assumption needNotPassExceptionAssumption();

    default public boolean calleeNeedsCallerFrame() {
        return !this.needNotPassFrameAssumption().isValid();
    }

    default public boolean calleeNeedsExceptionState() {
        return !this.needNotPassExceptionAssumption().isValid();
    }

    default public void setCalleeNeedsCallerFrame() {
        this.needNotPassFrameAssumption().invalidate();
    }

    default public void setCalleeNeedsExceptionState() {
        this.needNotPassExceptionAssumption().invalidate();
    }

    public static boolean setEncapsulatingNeedsToPassCallerFrame(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null; pythonCallNode = pythonCallNode.getParent()) {
            if (!(pythonCallNode instanceof IndirectCallNode)) continue;
            IndirectCallNode indirectCallNode = (IndirectCallNode)pythonCallNode;
            indirectCallNode.setCalleeNeedsCallerFrame();
            return true;
        }
        return false;
    }

    public static void setEncapsulatingNeedsToPassExceptionState(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null; pythonCallNode = pythonCallNode.getParent()) {
            if (!(pythonCallNode instanceof IndirectCallNode)) continue;
            ((IndirectCallNode)pythonCallNode).setCalleeNeedsExceptionState();
            break;
        }
    }

    default public IndirectCallNode getThisAsIndirectCallNode() {
        return this;
    }
}

