/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptors;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.GetAttributeNodeFactory;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public final class GetAttributeNode
extends PNodeWithContext {
    @Node.Child
    private GetFixedAttributeNode getFixedAttributeNode;

    public Object executeObject(VirtualFrame frame, Object object) {
        return this.getFixedAttributeNode.executeObject(frame, object);
    }

    protected GetAttributeNode(TruffleString key) {
        this.getFixedAttributeNode = GetFixedAttributeNode.create(key);
    }

    @NeverDefault
    public static GetAttributeNode create(TruffleString key) {
        return new GetAttributeNode(key);
    }

    public static abstract class GetFixedAttributeNode
    extends GetAttributeBaseNode {
        private final TruffleString key;

        public GetFixedAttributeNode(TruffleString key) {
            this.key = key;
        }

        public final TruffleString getKey() {
            return this.key;
        }

        public final Object executeObject(VirtualFrame frame, Object object) {
            return this.execute(frame, object);
        }

        public abstract Object execute(VirtualFrame var1, Object var2);

        protected static boolean getAttributeIs(Object lazyClass, BuiltinMethodDescriptor expected) {
            Object slotValue = null;
            if (lazyClass instanceof PythonBuiltinClassType) {
                slotValue = SpecialMethodSlot.GetAttribute.getValue((PythonBuiltinClassType)((Object)lazyClass));
            } else if (lazyClass instanceof PythonManagedClass) {
                slotValue = SpecialMethodSlot.GetAttribute.getValue((PythonManagedClass)lazyClass);
            }
            return slotValue == expected;
        }

        protected static boolean isObjectGetAttribute(Object lazyClass) {
            return GetFixedAttributeNode.getAttributeIs(lazyClass, BuiltinMethodDescriptors.OBJ_GET_ATTRIBUTE);
        }

        protected static boolean isModuleGetAttribute(Object lazyClass) {
            return GetFixedAttributeNode.getAttributeIs(lazyClass, BuiltinMethodDescriptors.MODULE_GET_ATTRIBUTE);
        }

        protected static boolean isTypeGetAttribute(Object lazyClass) {
            return GetFixedAttributeNode.getAttributeIs(lazyClass, BuiltinMethodDescriptors.TYPE_GET_ATTRIBUTE);
        }

        @Specialization(guards={"isSingleContext()"})
        final Object doSingleContext(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                return this.dispatchNode.executeObject(frame, object, this.key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, this.getPythonClass(object), this.key, pe);
            }
        }

        @Specialization(guards={"!isSingleContext()", "isObjectGetAttribute(getPythonClass(object))"})
        final Object doBuiltinObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached ObjectBuiltins.GetAttributeNode getAttributeNode) {
            try {
                return getAttributeNode.execute(frame, object, this.key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, this.key, pe);
            }
        }

        @Specialization(guards={"!isSingleContext()", "isTypeGetAttribute(getPythonClass(object))"})
        final Object doBuiltinType(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached TypeBuiltins.GetattributeNode getAttributeNode) {
            try {
                return getAttributeNode.execute(frame, object, this.key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, this.key, pe);
            }
        }

        @Specialization(guards={"!isSingleContext()", "isModuleGetAttribute(getPythonClass(object))"})
        final Object doBuiltinModule(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached ModuleBuiltins.ModuleGetattritbuteNode getAttributeNode) {
            try {
                return getAttributeNode.execute(frame, object, this.key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, this.key, pe);
            }
        }

        @Specialization(guards={"!isSingleContext()"}, replaces={"doBuiltinObject", "doBuiltinType", "doBuiltinModule"})
        final Object doGeneric(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                return this.dispatchNode.executeObject(frame, object, this.key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, this.getPythonClass(object), this.key, pe);
            }
        }

        @NeverDefault
        public static GetFixedAttributeNode create(TruffleString key) {
            return GetAttributeNodeFactory.GetFixedAttributeNodeGen.create(key);
        }
    }

    public static abstract class GetAnyAttributeNode
    extends GetAttributeBaseNode {
        public abstract Object executeObject(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        Object doIt(VirtualFrame frame, Object object, Object key, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            try {
                return this.dispatchNode.executeObject(frame, object, key);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                return this.dispatchGetAttrOrRethrowObject(frame, object, key, pe);
            }
        }

        @NeverDefault
        public static GetAnyAttributeNode create() {
            return GetAttributeNodeFactory.GetAnyAttributeNodeGen.create();
        }
    }

    static abstract class GetAttributeBaseNode
    extends PNodeWithContext {
        @Node.Child
        protected LookupAndCallBinaryNode dispatchNode = LookupAndCallBinaryNode.create(SpecialMethodSlot.GetAttribute);
        @Node.Child
        private LookupSpecialMethodSlotNode lookupGetattrNode;
        @Node.Child
        private CallBinaryMethodNode callBinaryMethodNode;
        @Node.Child
        private GetClassNode getClassNode;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile hasGetattrProfile;

        GetAttributeBaseNode() {
        }

        Object dispatchGetAttrOrRethrowObject(VirtualFrame frame, Object object, Object key, PException pe) {
            return this.ensureCallGetattrNode().executeObject((Frame)frame, this.lookupGetattrOrRethrow(frame, object, pe), object, key);
        }

        Object dispatchGetAttrOrRethrowObject(VirtualFrame frame, Object object, Object objectLazyClass, Object key, PException pe) {
            return this.ensureCallGetattrNode().executeObject((Frame)frame, this.lookupGetattrOrRethrow(frame, object, objectLazyClass, pe), object, key);
        }

        private Object lookupGetattrOrRethrow(VirtualFrame frame, Object object, PException pe) {
            return this.lookupGetattrOrRethrow(frame, object, this.getPythonClass(object), pe);
        }

        private Object lookupGetattrOrRethrow(VirtualFrame frame, Object object, Object objectLazyClass, PException pe) {
            Object getattrAttribute = this.ensureLookupGetattrNode().execute((Frame)frame, objectLazyClass, object);
            if (this.ensureHasGetattrProfile().profile(getattrAttribute == PNone.NO_VALUE)) {
                throw pe;
            }
            return getattrAttribute;
        }

        private LookupSpecialMethodSlotNode ensureLookupGetattrNode() {
            if (this.lookupGetattrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupGetattrNode = (LookupSpecialMethodSlotNode)this.insert(LookupSpecialMethodSlotNode.create(SpecialMethodSlot.GetAttr));
            }
            return this.lookupGetattrNode;
        }

        private CallBinaryMethodNode ensureCallGetattrNode() {
            if (this.callBinaryMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callBinaryMethodNode = (CallBinaryMethodNode)this.insert(CallBinaryMethodNode.create());
            }
            return this.callBinaryMethodNode;
        }

        private ConditionProfile ensureHasGetattrProfile() {
            if (this.hasGetattrProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hasGetattrProfile = ConditionProfile.create();
            }
            return this.hasGetattrProfile;
        }

        protected Object getPythonClass(Object object) {
            if (this.getClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getClassNode.executeCached(object);
        }
    }
}

