/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.bytecode.BinarySubscrSeqFactory;
import com.oracle.graal.python.nodes.bytecode.QuickeningGeneralizeException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@ImportStatic(value={PGuards.class})
public abstract class BinarySubscrSeq
extends Node {
    public static final QuickeningGeneralizeException GENERALIZE_RESULT = new QuickeningGeneralizeException(0);
    public static final QuickeningGeneralizeException GENERALIZE_COLLECTION = new QuickeningGeneralizeException(0);

    @GenerateInline(value=false)
    public static abstract class DNode
    extends BinarySubscrSeq {
        public abstract double execute(Object var1, int var2);

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        double doList(PList sequence, int index, @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getItemNode) {
            try {
                return getItemNode.executeDouble(sequence.getSequenceStorage(), index);
            }
            catch (UnexpectedResultException e) {
                throw GENERALIZE_RESULT;
            }
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        double doList(PTuple sequence, int index, @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode) {
            try {
                return getItemNode.executeDouble(sequence.getSequenceStorage(), index);
            }
            catch (UnexpectedResultException e) {
                throw GENERALIZE_RESULT;
            }
        }

        @Fallback
        double doGeneralize(Object sequence, int index) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw GENERALIZE_COLLECTION;
        }

        public static DNode create() {
            return BinarySubscrSeqFactory.DNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class INode
    extends BinarySubscrSeq {
        public abstract int execute(Object var1, int var2) throws QuickeningGeneralizeException;

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        int doList(PList sequence, int index, @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getItemNode) {
            try {
                return getItemNode.executeInt(sequence.getSequenceStorage(), index);
            }
            catch (UnexpectedResultException e) {
                throw GENERALIZE_RESULT;
            }
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        int doList(PTuple sequence, int index, @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode) {
            try {
                return getItemNode.executeInt(sequence.getSequenceStorage(), index);
            }
            catch (UnexpectedResultException e) {
                throw GENERALIZE_RESULT;
            }
        }

        @Fallback
        int doGeneralize(Object sequence, int index) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw GENERALIZE_COLLECTION;
        }

        public static INode create() {
            return BinarySubscrSeqFactory.INodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class ONode
    extends BinarySubscrSeq {
        public abstract Object execute(Object var1, int var2);

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        Object doList(PList sequence, int index, @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getItemNode) {
            return getItemNode.execute(sequence.getSequenceStorage(), index);
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(sequence)"})
        Object doList(PTuple sequence, int index, @Cached(value="createForTuple()") SequenceStorageNodes.GetItemNode getItemNode) {
            return getItemNode.execute(sequence.getSequenceStorage(), index);
        }

        @Fallback
        Object doGeneralize(Object sequence, int index) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw GENERALIZE_COLLECTION;
        }

        public static ONode create() {
            return BinarySubscrSeqFactory.ONodeGen.create();
        }
    }
}

