/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@ReportPolymorphism
abstract class LookupAndCallNonReversibleBinaryNode
extends LookupAndCallBinaryNode {
    protected final SpecialMethodSlot slot;
    protected final TruffleString name;

    LookupAndCallNonReversibleBinaryNode(TruffleString name, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handlerFactory, boolean ignoreDescriptorException) {
        super(handlerFactory, ignoreDescriptorException);
        this.name = name;
        this.slot = null;
    }

    LookupAndCallNonReversibleBinaryNode(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handlerFactory, boolean ignoreDescriptorException) {
        super(handlerFactory, ignoreDescriptorException);
        assert (slot.getReverse() == null);
        this.name = slot.getName();
        this.slot = slot;
    }

    protected final PythonBinaryBuiltinNode getBinaryBuiltin(PythonBuiltinClassType clazz) {
        PBuiltinFunction builtinFunction;
        if (this.slot != null) {
            Object attribute = this.slot.getValue(clazz);
            if (attribute instanceof BuiltinMethodDescriptor.BinaryBuiltinDescriptor) {
                return ((BuiltinMethodDescriptor.BinaryBuiltinDescriptor)attribute).createNode();
            }
            return null;
        }
        Object attribute = LookupAttributeInMRONode.Dynamic.getUncached().execute((Object)clazz, this.name);
        if (attribute instanceof PBuiltinFunction && PythonBinaryBuiltinNode.class.isAssignableFrom((builtinFunction = (PBuiltinFunction)attribute).getBuiltinNodeFactory().getNodeClass())) {
            return (PythonBinaryBuiltinNode)builtinFunction.getBuiltinNodeFactory().createNode(new Object[0]);
        }
        return null;
    }

    protected static PythonBuiltinClassType getBuiltinClass(Node inliningTarget, Object receiver, GetClassNode getClassNode) {
        Object clazz = getClassNode.execute(inliningTarget, receiver);
        return clazz instanceof PythonBuiltinClassType ? (PythonBuiltinClassType)((Object)clazz) : null;
    }

    protected static boolean isClazz(Node inliningTarget, PythonBuiltinClassType clazz, Object receiver, GetClassNode getClassNode) {
        return getClassNode.execute(inliningTarget, receiver) == clazz;
    }

    @Specialization(guards={"clazz != null", "function != null", "isClazz(inliningTarget, clazz, left, getClassNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObjectBuiltin(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached(value="getBuiltinClass(this, left, getClassNode)") PythonBuiltinClassType clazz, @Cached(value="getBinaryBuiltin(clazz)") PythonBinaryBuiltinNode function) {
        return function.execute(frame, left, right);
    }

    @Specialization(guards={"left.getClass() == cachedLeftClass", "right.getClass() == cachedRightClass"}, limit="5")
    Object callObjectGeneric(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached(value="left.getClass()") Class<?> cachedLeftClass, @Cached(value="right.getClass()") Class<?> cachedRightClass, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr) {
        return this.doCallObject(frame, inliningTarget, left, right, getClassNode, getattr);
    }

    @Specialization(replaces={"callObjectGeneric"})
    @ReportPolymorphism.Megamorphic
    Object callObjectMegamorphic(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr) {
        return this.doCallObject(frame, inliningTarget, left, right, getClassNode, getattr);
    }

    private Object doCallObject(VirtualFrame frame, Node inliningTarget, Object left, Object right, GetClassNode getClassNode, LookupSpecialBaseNode getattr) {
        Object leftCallable;
        Object leftClass = getClassNode.execute(inliningTarget, left);
        try {
            leftCallable = getattr.execute((Frame)frame, leftClass, left);
        }
        catch (PException e) {
            if (this.ignoreDescriptorException) {
                leftCallable = PNone.NO_VALUE;
            }
            throw e;
        }
        if (leftCallable == PNone.NO_VALUE) {
            if (this.handlerFactory != null) {
                return this.runErrorHandler(frame, left, right);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
        return this.ensureDispatch().executeObject((Frame)frame, leftCallable, left, right);
    }

    @NeverDefault
    protected final LookupSpecialBaseNode createLookup() {
        if (this.slot != null) {
            return LookupSpecialMethodSlotNode.create(this.slot);
        }
        return LookupSpecialMethodNode.create(this.name);
    }

    @Override
    public final TruffleString getName() {
        return this.name;
    }

    @Override
    public final TruffleString getRname() {
        return null;
    }
}

