/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={SpecialMethodNames.class, PythonOptions.class})
public abstract class LookupAndCallNonReversibleTernaryNode
extends LookupAndCallTernaryNode {
    LookupAndCallNonReversibleTernaryNode(TruffleString name) {
        super(name);
    }

    LookupAndCallNonReversibleTernaryNode(SpecialMethodSlot slot) {
        super(slot);
    }

    protected static PythonBuiltinClassType getBuiltinClass(Node inliningTarget, Object receiver, GetClassNode getClassNode) {
        Object clazz = getClassNode.execute(inliningTarget, receiver);
        return clazz instanceof PythonBuiltinClassType ? (PythonBuiltinClassType)((Object)clazz) : null;
    }

    protected static boolean isClazz(Node inliningTarget, PythonBuiltinClassType clazz, Object receiver, GetClassNode getClassNode) {
        return getClassNode.execute(inliningTarget, receiver) == clazz;
    }

    protected final PythonTernaryBuiltinNode getTernaryBuiltin(PythonBuiltinClassType clazz) {
        PBuiltinFunction builtinFunction;
        if (this.slot != null) {
            Object attribute = this.slot.getValue(clazz);
            if (attribute instanceof BuiltinMethodDescriptor.TernaryBuiltinDescriptor) {
                return ((BuiltinMethodDescriptor.TernaryBuiltinDescriptor)attribute).createNode();
            }
            return null;
        }
        Object attribute = LookupAttributeInMRONode.Dynamic.getUncached().execute((Object)clazz, this.name);
        if (attribute instanceof PBuiltinFunction && PythonTernaryBuiltinNode.class.isAssignableFrom((builtinFunction = (PBuiltinFunction)attribute).getBuiltinNodeFactory().getNodeClass())) {
            return (PythonTernaryBuiltinNode)builtinFunction.getBuiltinNodeFactory().createNode(new Object[0]);
        }
        return null;
    }

    @Specialization(guards={"clazz != null", "function != null", "isClazz(inliningTarget, clazz, v, getClassNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObjectBuiltin(VirtualFrame frame, Object v, Object w, Object z, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached(value="getBuiltinClass(this, v, getClassNode)") PythonBuiltinClassType clazz, @Cached(value="getTernaryBuiltin(clazz)") PythonTernaryBuiltinNode function) {
        return function.execute(frame, v, w, z);
    }

    @Specialization(guards={"arg1.getClass() == cachedArg1Class"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObject(VirtualFrame frame, Object arg1, Object arg2, Object arg3, @Bind(value="this") Node inliningTarget, @Cached(value="arg1.getClass()") Class<?> cachedArg1Class, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Exclusive @Cached CallTernaryMethodNode dispatchNode) {
        Object klass = getClassNode.execute(inliningTarget, arg1);
        return dispatchNode.execute((Frame)frame, getattr.execute((Frame)frame, klass, arg1), arg1, arg2, arg3);
    }

    @Specialization(replaces={"callObject"})
    @ReportPolymorphism.Megamorphic
    static Object callObjectMegamorphic(VirtualFrame frame, Object arg1, Object arg2, Object arg3, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(value="createLookup()") LookupSpecialBaseNode getattr, @Cached.Exclusive @Cached CallTernaryMethodNode dispatchNode) {
        Object klass = getClassNode.execute(inliningTarget, arg1);
        return dispatchNode.execute((Frame)frame, getattr.execute((Frame)frame, klass, arg1), arg1, arg2, arg3);
    }
}

