/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmeticFactory;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public enum BinaryArithmetic {
    Add(BinaryArithmeticFactory.AddNodeGen::create),
    Sub(BinaryArithmeticFactory.SubNodeGen::create),
    Mul(BinaryArithmeticFactory.MulNodeGen::create),
    TrueDiv(BinaryArithmeticFactory.TrueDivNodeGen::create),
    FloorDiv(BinaryArithmeticFactory.FloorDivNodeGen::create),
    Mod(BinaryArithmeticFactory.ModNodeGen::create),
    LShift(BinaryArithmeticFactory.LShiftNodeGen::create),
    RShift(BinaryArithmeticFactory.RShiftNodeGen::create),
    And(BinaryArithmeticFactory.BitAndNodeGen::create),
    Or(BinaryArithmeticFactory.BitOrNodeGen::create),
    Xor(BinaryArithmeticFactory.BitXorNodeGen::create),
    MatMul(BinaryArithmeticFactory.MatMulNodeGen::create),
    Pow(BinaryArithmeticFactory.PowNodeGen::create),
    DivMod(BinaryArithmeticFactory.DivModNodeGen::create);

    private final CreateBinaryOp create;

    private BinaryArithmetic(CreateBinaryOp create) {
        this.create = create;
    }

    @NeverDefault
    public BinaryOpNode create() {
        return this.create.create();
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallBinaryArithmeticRootNode(language, this);
    }

    static interface CreateBinaryOp {
        public BinaryOpNode create();
    }

    static final class CallBinaryArithmeticRootNode
    extends CallArithmeticRootNode {
        static final Signature SIGNATURE_BINARY = new Signature(2, false, -1, false, PythonUtils.tsArray("$self", "other"), null);
        @Node.Child
        private BinaryOpNode callBinaryNode;
        private final BinaryArithmetic binaryOperator;

        CallBinaryArithmeticRootNode(PythonLanguage language, BinaryArithmetic binaryOperator) {
            super(language);
            this.binaryOperator = binaryOperator;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE_BINARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callBinaryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callBinaryNode = (BinaryOpNode)this.insert(this.binaryOperator.create());
            }
            return this.callBinaryNode.executeObject(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1));
        }
    }

    public static abstract class DivModNode
    extends BinaryArithmeticRaiseNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = DivModNode.createHandler("divmod");

        @Specialization
        final PTuple doLL(int left, int right, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            this.raiseIntDivisionByZero(right == 0);
            return factory.createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization
        final PTuple doLL(long left, long right, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            this.raiseIntDivisionByZero(right == 0L);
            return factory.createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization
        final PTuple doDL(double left, long right, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            this.raiseDivisionByZero(right == 0L);
            return factory.createTuple(new Object[]{Math.floor(left / (double)right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        final PTuple doDD(double left, double right, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            this.raiseDivisionByZero(right == 0.0);
            return factory.createTuple(new Object[]{Math.floor(left / right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        final PTuple doLD(long left, double right, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            this.raiseDivisionByZero(right == 0.0);
            return factory.createTuple(new Object[]{Math.floor((double)left / right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(DivMod, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class PowNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = PowNode.createHandler("** or pow()");

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Pow, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class MatMulNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = MatMulNode.createHandler("@");

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(MatMul, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitXorNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitXorNode.createHandler("^");

        @Specialization
        static int op(int left, int right) {
            return left ^ right;
        }

        @Specialization
        static long op(long left, long right) {
            return left ^ right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createBinaryOp(Xor, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitOrNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitOrNode.createHandler("|");

        @Specialization
        static int op(int left, int right) {
            return left | right;
        }

        @Specialization
        static long op(long left, long right) {
            return left | right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Or, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitAndNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitAndNode.createHandler("&");

        @Specialization
        static int op(int left, int right) {
            return left & right;
        }

        @Specialization
        static long op(long left, long right) {
            return left & right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createBinaryOp(And, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class RShiftNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = RShiftNode.createHandler(">>");

        @Specialization(guards={"right < 32", "right >= 0"})
        static int doIISmall(int left, int right) {
            return left >> right;
        }

        @Specialization(guards={"right < 64", "right >= 0"})
        static long doIISmall(long left, long right) {
            return left >> (int)right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(RShift, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class LShiftNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = LShiftNode.createHandler("<<");

        @Specialization(guards={"right < 32", "right >= 0"}, rewriteOn={OverflowException.class})
        static int doII(int left, int right) throws OverflowException {
            int result = left << right;
            if (left != result >> right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization(guards={"right < 64", "right >= 0"}, rewriteOn={OverflowException.class})
        static long doLL(long left, long right) throws OverflowException {
            long result = left << (int)right;
            if (left != result >> (int)right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(LShift, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class ModNode
    extends BinaryArithmeticRaiseNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = ModNode.createHandler("%");

        @Specialization
        final int doII(int left, int right) {
            this.raiseIntDivisionByZero(right == 0);
            return Math.floorMod(left, right);
        }

        @Specialization
        final long doLL(long left, long right) {
            this.raiseIntDivisionByZero(right == 0L);
            return Math.floorMod(left, right);
        }

        @Specialization
        final double doDL(double left, long right) {
            this.raiseDivisionByZero(right == 0L);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        final double doDD(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        final double doLD(long left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Mod, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class FloorDivNode
    extends BinaryArithmeticRaiseNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = FloorDivNode.createHandler("//");

        @Specialization
        final int doII(int left, int right) {
            this.raiseIntDivisionByZero(right == 0);
            return Math.floorDiv(left, right);
        }

        @Specialization(rewriteOn={OverflowException.class})
        final long doLL(long left, long right) throws OverflowException {
            if (left == Long.MIN_VALUE && right == -1L) {
                throw OverflowException.INSTANCE;
            }
            this.raiseIntDivisionByZero(right == 0L);
            return Math.floorDiv(left, right);
        }

        @Specialization
        final double doDL(double left, long right) {
            this.raiseDivisionByZero(right == 0L);
            return Math.floor(left / (double)right);
        }

        @Specialization
        final double doDD(double left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return Math.floor(left / right);
        }

        @Specialization
        final double doLD(long left, double right) {
            this.raiseDivisionByZero(right == 0.0);
            return Math.floor((double)left / right);
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(FloorDiv, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class TrueDivNode
    extends BinaryArithmeticRaiseNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = TrueDivNode.createHandler("/");

        @Specialization
        final double divII(int x, int y) {
            return this.divDD(x, y);
        }

        @Specialization
        final double doDD(long x, double y) {
            return this.divDD(x, y);
        }

        @Specialization
        final double doDL(double x, long y) {
            return this.divDD(x, y);
        }

        @Specialization
        final double divDD(double x, double y) {
            this.raiseDivisionByZero(y == 0.0);
            return x / y;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(TrueDiv, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BinaryArithmeticRaiseNode
    extends BinaryArithmeticNode {
        @Node.Child
        private PRaiseNode raiseNode;

        private final PRaiseNode ensureRaise() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            return this.raiseNode;
        }

        protected final void raiseIntDivisionByZero(boolean cond) {
            if (cond) {
                throw this.ensureRaise().raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_OR_MODULO_BY_ZERO, "integer");
            }
        }

        protected final void raiseDivisionByZero(boolean cond) {
            if (cond) {
                throw this.ensureRaise().raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
        }
    }

    public static abstract class MulNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = MulNode.createHandler("*");

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.multiplyExact(x, y);
        }

        @Specialization(replaces={"doII"})
        static long doIIL(int x, int y) {
            return (long)x * (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) {
            return Math.multiplyExact(x, y);
        }

        @Specialization
        static double doDL(double left, long right) {
            return left * (double)right;
        }

        @Specialization
        static double doLD(long left, double right) {
            return (double)left * right;
        }

        @Specialization
        static double doDD(double left, double right) {
            return left * right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createPyNumberMultiply(NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class SubNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = SubNode.createHandler("-");

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        static long doIIOvf(int x, int y) {
            return (long)x - (long)y;
        }

        @Specialization
        static double doDD(double left, double right) {
            return left - right;
        }

        @Specialization
        static double doDL(double left, long right) {
            return left - (double)right;
        }

        @Specialization
        static double doLD(long left, double right) {
            return (double)left - right;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Sub, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class AddNode
    extends BinaryArithmeticNode {
        static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = AddNode.createHandler("+");

        public abstract int executeInt(VirtualFrame var1, int var2, int var3) throws UnexpectedResultException;

        public abstract double executeDouble(VirtualFrame var1, double var2, double var4) throws UnexpectedResultException;

        @Specialization(rewriteOn={ArithmeticException.class})
        static int add(int left, int right) {
            return Math.addExact(left, right);
        }

        @Specialization
        static long doIIOvf(int x, int y) {
            return (long)x + (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long addLong(long left, long right) {
            return Math.addExact(left, right);
        }

        @Specialization
        static double doDD(double left, double right) {
            return left + right;
        }

        @Specialization
        static double doDL(double left, long right) {
            return left + (double)right;
        }

        @Specialization
        static double doLD(long left, double right) {
            return (double)left + right;
        }

        @Specialization
        static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createPyNumberAdd(NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }

        @NeverDefault
        public static AddNode create() {
            return BinaryArithmeticFactory.AddNodeGen.create();
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class BinaryArithmeticNode
    extends BinaryOpNode {
        static Supplier<LookupAndCallBinaryNode.NotImplementedHandler> createHandler(final String operator) {
            return () -> new LookupAndCallBinaryNode.NotImplementedHandler(){
                @Node.Child
                private PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(VirtualFrame frame, Object arg, Object arg2) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, this.getErrorMessage(arg), operator, arg, arg2);
                }

                @CompilerDirectives.TruffleBoundary
                private TruffleString getErrorMessage(Object arg) {
                    if (operator.equals(">>") && arg instanceof PBuiltinMethod && ((PBuiltinMethod)arg).getBuiltinFunction().getName().equalsUncached((AbstractTruffleString)BuiltinNames.T_PRINT, PythonUtils.TS_ENCODING)) {
                        return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P_PRINT;
                    }
                    return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P;
                }
            };
        }

        @NeverDefault
        static LookupAndCallBinaryNode createCallNode(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            assert (slot.getReverse() != null);
            return LookupAndCallBinaryNode.createReversible(slot, slot.getReverse(), handler);
        }

        @NeverDefault
        static LookupAndCallBinaryNode createBinaryOp(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createBinaryOp(slot, slot.getReverse(), handler);
        }

        @NeverDefault
        static LookupAndCallBinaryNode createPyNumberAdd(Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createPyNumberAdd(handler);
        }

        @NeverDefault
        static LookupAndCallBinaryNode createPyNumberMultiply(Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createPyNumberMultiply(handler);
        }
    }
}

