/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;

public enum TernaryArithmetic {
    Pow(SpecialMethodNames.T___POW__, "**", "pow");

    private final TruffleString methodName;
    private final Supplier<LookupAndCallTernaryNode.NotImplementedHandler> notImplementedHandler;

    private TernaryArithmetic(TruffleString methodName, final String operator, final String operatorFunction) {
        this.methodName = methodName;
        this.notImplementedHandler = () -> new LookupAndCallTernaryNode.NotImplementedHandler(){
            @Node.Child
            private PRaiseNode raiseNode = PRaiseNode.create();

            @Override
            public Object execute(Object arg, Object arg2, Object arg3) {
                if (arg3 instanceof PNone) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_PR_S_P_AND_P, operator, operatorFunction, arg, arg2);
                }
                throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_P_P, operatorFunction, arg, arg2, arg3);
            }
        };
    }

    public TruffleString getMethodName() {
        return this.methodName;
    }

    public LookupAndCallTernaryNode create() {
        return LookupAndCallTernaryNode.createReversible(this.methodName, this.notImplementedHandler);
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallTernaryArithmeticRootNode(language, this);
    }

    static final class CallTernaryArithmeticRootNode
    extends CallArithmeticRootNode {
        static final Signature SIGNATURE_TERNARY = new Signature(3, false, -1, false, PythonUtils.tsArray("x", "y", "z"), null);
        @Node.Child
        private LookupAndCallTernaryNode callTernaryNode;
        private final TernaryArithmetic ternaryOperator;

        private CallTernaryArithmeticRootNode(PythonLanguage language, TernaryArithmetic ternaryOperator) {
            super(language);
            this.ternaryOperator = ternaryOperator;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE_TERNARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callTernaryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callTernaryNode = (LookupAndCallTernaryNode)this.insert(this.ternaryOperator.create());
            }
            return this.callTernaryNode.execute(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1), PArguments.getArgument((Frame)frame, 2));
        }
    }
}

