/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
abstract class ReadBuiltinNode
extends PNodeWithContext {
    ReadBuiltinNode() {
    }

    public abstract Object execute(TruffleString var1);

    @Specialization(guards={"isSingleContext(this)"})
    Object returnBuiltinFromConstantModule(TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached InlinedConditionProfile isBuiltinProfile, @Cached.Shared @Cached ReadAttributeFromObjectNode readFromBuiltinsNode, @Cached(value="getBuiltins()") PythonModule builtins) {
        return this.readBuiltinFromModule(attributeId, raiseNode, inliningTarget, isBuiltinProfile, builtins, readFromBuiltinsNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private PException raiseNameNotDefined(PRaiseNode raiseNode, TruffleString attributeId) {
        throw raiseNode.raise(PythonErrorType.NameError, ErrorMessages.NAME_NOT_DEFINED, attributeId);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"returnBuiltinFromConstantModule"})
    Object returnBuiltin(TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached InlinedConditionProfile isBuiltinProfile, @Cached.Shared @Cached ReadAttributeFromObjectNode readFromBuiltinsNode, @Cached.Exclusive @Cached InlinedConditionProfile ctxInitializedProfile) {
        PythonModule builtins = this.getBuiltins(inliningTarget, ctxInitializedProfile);
        return this.returnBuiltinFromConstantModule(attributeId, inliningTarget, raiseNode, isBuiltinProfile, readFromBuiltinsNode, builtins);
    }

    private Object readBuiltinFromModule(TruffleString attributeId, PRaiseNode.Lazy raiseNode, Node inliningTarget, InlinedConditionProfile isBuiltinProfile, PythonModule builtins, ReadAttributeFromObjectNode readFromBuiltinsNode) {
        Object builtin = readFromBuiltinsNode.execute(builtins, attributeId);
        if (isBuiltinProfile.profile(inliningTarget, builtin != PNone.NO_VALUE)) {
            return builtin;
        }
        throw this.raiseNameNotDefined(raiseNode.get(inliningTarget), attributeId);
    }

    @NeverDefault
    protected PythonModule getBuiltins() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getBuiltins(null, InlinedConditionProfile.getUncached());
    }

    protected PythonModule getBuiltins(Node inliningTarget, InlinedConditionProfile ctxInitializedProfile) {
        PythonContext context = PythonContext.get(this);
        if (ctxInitializedProfile.profile(inliningTarget, context.isInitialized())) {
            return context.getBuiltins();
        }
        return context.lookupBuiltinModule(BuiltinNames.T_BUILTINS);
    }
}

