/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.CodePointConversionNodeGen;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class CodePointConversionNode
extends ArgumentCastNode.ArgumentCastNodeWithRaise {
    private final String builtinName;
    private final int defaultValue;
    protected final boolean useDefaultForNone;

    public CodePointConversionNode(String builtinName, int defaultValue, boolean useDefaultForNone) {
        this.builtinName = builtinName;
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    int doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"useDefaultForNone"})
    int doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Specialization
    int doString(TruffleString value, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (codePointLengthNode.execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING) == 1) {
            return codePointAtIndexNode.execute((AbstractTruffleString)value, 0, PythonUtils.TS_ENCODING);
        }
        throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_S_NOT_P, this.builtinName, "unicode character", value);
    }

    @Specialization(guards={"!isHandledPNone(useDefaultForNone, value)"}, replaces={"doString"})
    int doOthers(Object value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        try {
            return this.doString(castToStringNode.execute(inliningTarget, value), codePointLengthNode, codePointAtIndexNode);
        }
        catch (CannotCastException ex) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_BRACKETS_ARG_MUST_BE_S_NOT_P, this.builtinName, "unicode character", value);
        }
    }

    @ClinicConverterFactory
    @NeverDefault
    public static CodePointConversionNode create(@ClinicConverterFactory.BuiltinName String builtinName, @ClinicConverterFactory.DefaultValue int defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return CodePointConversionNodeGen.create(builtinName, defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory
    @NeverDefault
    public static CodePointConversionNode create(@ClinicConverterFactory.BuiltinName String builtinName, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return CodePointConversionNodeGen.create(builtinName, -1, false);
    }
}

