/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;

@GenerateUncached
public abstract class GetDictIfExistsNode
extends PNodeWithContext {
    public abstract PDict execute(Object var1);

    public abstract PDict execute(PythonObject var1);

    @Specialization(guards={"object.getShape() == cachedShape", "hasNoDict(cachedShape)"}, limit="1")
    static PDict getNoDictCachedShape(PythonObject object, @Cached(value="object.getShape()") Shape cachedShape) {
        assert (GetDictIfExistsNode.doPythonObject(object, DynamicObjectLibrary.getUncached()) == null);
        return null;
    }

    @Specialization(guards={"hasNoDict(object.getShape())"}, replaces={"getNoDictCachedShape"})
    static PDict getNoDict(PythonObject object) {
        assert (GetDictIfExistsNode.doPythonObject(object, DynamicObjectLibrary.getUncached()) == null);
        return null;
    }

    @Idempotent
    protected static boolean hasNoDict(Shape shape) {
        return (shape.getFlags() & 8) == 0;
    }

    @Specialization(guards={"isSingleContext()", "object == cached", "dictIsConstant(cached)", "dict != null"}, limit="1")
    static PDict getConstant(PythonObject object, @Cached(value="object", weak=true) PythonObject cached, @Cached(value="getDictUncached(object)", weak=true) PDict dict) {
        return dict;
    }

    protected boolean dictIsConstant(PythonObject object) {
        return object instanceof PythonModule || object instanceof PythonManagedClass;
    }

    protected PDict getDictUncached(PythonObject object) {
        return (PDict)DynamicObjectLibrary.getUncached().getOrDefault((DynamicObject)object, (Object)PythonObject.DICT, null);
    }

    @Specialization(replaces={"getConstant"})
    @HostCompilerDirectives.InliningCutoff
    static PDict doPythonObject(PythonObject object, @CachedLibrary(limit="4") DynamicObjectLibrary dylib) {
        return (PDict)dylib.getOrDefault((DynamicObject)object, (Object)PythonObject.DICT, null);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    PDict doNativeObject(PythonAbstractNativeObject object, @Cached CApiTransitions.PythonToNativeNode toSulong, @Cached CApiTransitions.NativeToPythonNode toJava, @Cached CExtNodes.PCallCapiFunction callGetDictNode) {
        Object javaDict = toJava.execute(callGetDictNode.call(NativeCAPISymbol.FUN_PY_OBJECT_GENERIC_GET_DICT, toSulong.execute(object)));
        if (javaDict instanceof PDict) {
            return (PDict)javaDict;
        }
        if (javaDict == PNone.NO_VALUE) {
            return null;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, javaDict);
    }

    @Fallback
    static PDict doOther(Object object) {
        return null;
    }

    public static GetDictIfExistsNode getUncached() {
        return GetDictIfExistsNodeGen.getUncached();
    }
}

