/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={PGuards.class})
public abstract class CastToTruffleStringNode
extends PNodeWithContext {
    public abstract TruffleString execute(Node var1, Object var2) throws CannotCastException;

    public final TruffleString executeCached(Object x) throws CannotCastException {
        return this.execute(this, x);
    }

    public static TruffleString executeUncached(Object x) throws CannotCastException {
        return CastToTruffleStringNodeGen.getUncached().execute(null, x);
    }

    @Specialization
    static TruffleString doTruffleString(TruffleString x) {
        return x;
    }

    @Specialization(guards={"x.isMaterialized()"})
    static TruffleString doPStringMaterialized(PString x) {
        return x.getMaterialized();
    }

    @Specialization(guards={"!x.isMaterialized()"})
    static TruffleString doPStringGeneric(Node inliningTarget, PString x, @Cached StringNodes.StringMaterializeNode materializeNode) {
        return materializeNode.execute(inliningTarget, x);
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static TruffleString doNativeObject(Node inliningTarget, PythonNativeObject x, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached(inline=false) ReadNativeStringNode read) {
        if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.PString)) {
            return read.execute(x.getPtr());
        }
        throw CannotCastException.INSTANCE;
    }

    @Specialization(guards={"!isString(x)", "!isNativeObject(x)"})
    static TruffleString doUnsupported(Object x) {
        throw CannotCastException.INSTANCE;
    }

    @NeverDefault
    public static CastToTruffleStringNode create() {
        return CastToTruffleStringNodeGen.create();
    }

    @NeverDefault
    public static CastToTruffleStringNode getUncached() {
        return CastToTruffleStringNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ReadNativeStringNode
    extends PNodeWithContext {
        public abstract TruffleString execute(Object var1);

        @Specialization
        static TruffleString read(Object pointer, @Cached CStructAccess.ReadI32Node readI32, @Cached CStructAccess.ReadI64Node readI64, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadByteNode readByte, @CachedLibrary(limit="3") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative, @Cached TruffleString.FromByteArrayNode fromBytes) {
            TruffleString.Encoding encoding;
            int state = readI32.read(pointer, CFields.PyASCIIObject__state);
            boolean ready = PythonUtils.isBitSet(state, 7);
            if (!ready) {
                throw CompilerDirectives.shouldNotReachHere((String)"not implemented - need to call _PyUnicode_Ready for native string");
            }
            int kind = state >> 2 & 7;
            Object data = readPointer.read(pointer, CFields.PyUnicodeObject__data);
            long length = readI64.read(pointer, CFields.PyASCIIObject__length);
            if (kind == 1) {
                encoding = TruffleString.Encoding.ISO_8859_1;
            } else if (kind == 2) {
                encoding = TruffleString.Encoding.UTF_16LE;
            } else {
                assert (kind == 4);
                encoding = TruffleString.Encoding.UTF_32LE;
            }
            int bytes = PythonUtils.toIntError(length * (long)kind);
            if (lib.isPointer(data) || data instanceof Long) {
                return fromNative.execute(data, 0, bytes, encoding, false);
            }
            byte[] result = readByte.readByteArray(pointer, bytes);
            return fromBytes.execute(result, encoding, false);
        }
    }
}

