/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.ImpModuleBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.PyTruffleObjectFree;
import com.oracle.graal.python.builtins.objects.cext.capi.PyTruffleObjectFreeFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.EmulatedPosixSupport;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.ImageBuildtimePosixSupport;
import com.oracle.graal.python.runtime.LoggingPosixSupport;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.runtime.NFILZMASupport;
import com.oracle.graal.python.runtime.NFIPosixSupport;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonThreadKillException;
import com.oracle.graal.python.runtime.object.IDUtils;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.Consumer;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.ShutdownHook;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import com.oracle.truffle.llvm.api.Toolchain;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.file.LinkOption;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionKey;
import sun.misc.Unsafe;

public final class PythonContext
extends Python3Core {
    public static final TruffleString T_IMPLEMENTATION = PythonUtils.tsLiteral("implementation");
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(PythonContext.class);
    public final CApiTransitions.HandleContext nativeContext = new CApiTransitions.HandleContext();
    private volatile boolean finalizing;
    public static final String J_PYTHON_JNI_LIBRARY_NAME = System.getProperty("python.jni.library", PythonContext.getSupportLibName("pythonjni"));
    private static final TruffleString T_PREFIX = StringLiterals.T_SLASH;
    private static final TruffleString T_LIB_PYTHON_3 = PythonUtils.tsLiteral("/lib/python3.10");
    private static final TruffleString T_LIB_GRAALPYTHON = PythonUtils.tsLiteral("/lib/graalpy23.1");
    private static final TruffleString T_STD_LIB_PLACEHOLDER = PythonUtils.tsLiteral("!stdLibHome!");
    private static final String J_NO_CORE_FATAL = "could not determine Graal.Python's core path - you must pass --python.CoreHome.";
    private static final String J_NO_PREFIX_WARNING = "could not determine Graal.Python's sys prefix path - you may need to pass --python.SysPrefix.";
    private static final String J_NO_CORE_WARNING = "could not determine Graal.Python's core path - you may need to pass --python.CoreHome.";
    private static final String J_NO_STDLIB = "could not determine Graal.Python's standard library path. You need to pass --python.StdLibHome if you want to use the standard library.";
    private static final String J_NO_CAPI = "could not determine Graal.Python's C API library path. You need to pass --python.CAPI if you want to use the C extension modules.";
    private static final String J_NO_JNI = "could not determine Graal.Python's JNI library. You need to pass --python.JNILibrary if you want to run, for example, binary HPy extension modules.";
    private PythonModule mainModule;
    private final List<ShutdownHook> shutdownHooks = new ArrayList<ShutdownHook>();
    private final List<AtExitHook> atExitHooks = new ArrayList<AtExitHook>();
    private final List<Runnable> capiHooks = new ArrayList<Runnable>();
    private final HashMap<PythonNativeClass, CyclicAssumption> nativeClassStableAssumptions = new HashMap();
    private final ThreadGroup threadGroup = new ThreadGroup("GRAALPYTHON_THREADS");
    private final IDUtils idUtils = new IDUtils();
    @CompilerDirectives.CompilationFinal
    private SecureRandom secureRandom;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] hashSecret = new byte[24];
    private final ConcurrentHashMap<Long, Object> ptrAdrMap = new ConcurrentHashMap();
    @CompilerDirectives.CompilationFinal
    private PosixSupport posixSupport;
    @CompilerDirectives.CompilationFinal
    private NFIZlibSupport nativeZlib;
    @CompilerDirectives.CompilationFinal
    private NFIBz2Support nativeBz2lib;
    @CompilerDirectives.CompilationFinal
    private NFILZMASupport nativeLZMA;
    private final AtomicLong pythonThreadStackSize = new AtomicLong(0L);
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private final Map<Thread, PythonThreadState> threadStateMapping = Collections.synchronizedMap(new WeakHashMap());
    private WeakReference<Thread> mainThread;
    private final ReentrantLock importLock = new ReentrantLock();
    @CompilerDirectives.CompilationFinal
    private boolean isInitialized = false;
    private OutputStream out;
    private OutputStream err;
    private InputStream in;
    @CompilerDirectives.CompilationFinal
    private CApiContext cApiContext;
    @CompilerDirectives.CompilationFinal
    private GraalHPyContext hPyContext;
    private TruffleString soABI;
    private static final Assumption singleNativeContext = Truffle.getRuntime().createAssumption("single native context assumption");
    private final GlobalInterpreterLock globalInterpreterLock = new GlobalInterpreterLock();
    private final AtomicBoolean inAsyncHandler = new AtomicBoolean(false);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonNativeWrapper[] singletonNativePtrs = new PythonNativeWrapper[PythonLanguage.getNumberOfSpecialSingletons()];
    private final AsyncHandler handler;
    private final AsyncHandler.SharedFinalizer sharedFinalizer;
    private boolean gcEnabled = true;
    private final ThreadLocal<ArrayDeque<TruffleString>> currentImport = new ThreadLocal();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Object[] optionValues;
    private final AllocationReporter allocationReporter;
    private final WeakHashMap<CallTarget, TruffleString> codeFilename = new WeakHashMap();
    private final WeakHashMap<CodeUnit, TruffleString> codeUnitFilename = new WeakHashMap();
    private final ConcurrentHashMap<TruffleString, AtomicLong> deserializationId = new ConcurrentHashMap();
    private final long perfCounterStart = ImageInfo.inImageBuildtimeCode() ? 0L : System.nanoTime();
    public static final String CHILD_CONTEXT_DATA = "childContextData";
    @CompilerDirectives.CompilationFinal
    private List<Integer> childContextFDs;
    private final ChildContextData childContextData;
    private final SharedMultiprocessingData sharedMultiprocessingData;
    private boolean codecsInitialized;
    private final List<Object> codecSearchPath = new ArrayList<Object>();
    private final Map<TruffleString, PTuple> codecSearchCache = new HashMap<TruffleString, PTuple>();
    private final Map<TruffleString, Object> codecErrorRegistry = new HashMap<TruffleString, Object>();
    private int intMaxStrDigits;
    private int minIntBitLengthOverLimit;
    private static final double LOG2_10 = Math.log(10.0) / Math.log(2.0);
    private TruffleString pyPackageContext;
    private final PythonNativePointer nativeNull = new PythonNativePointer(null);
    public RootCallTarget signatureContainer;
    private static final TruffleLanguage.ContextReference<PythonContext> REFERENCE = TruffleLanguage.ContextReference.create(PythonLanguage.class);
    private TruffleString langHome;
    private TruffleString sysPrefix;
    private TruffleString basePrefix;
    private TruffleString coreHome;
    private TruffleString capiHome;
    private TruffleString jniHome;
    private TruffleString stdLibHome;
    private TruffleFile homeResourcesFile;
    private int dlopenFlags;

    @CompilerDirectives.TruffleBoundary
    public static String getSupportLibName(PythonOS os, String libName) {
        return switch (os) {
            case PythonOS.PLATFORM_LINUX, PythonOS.PLATFORM_FREEBSD, PythonOS.PLATFORM_SUNOS -> "lib" + libName + ".so";
            case PythonOS.PLATFORM_DARWIN -> "lib" + libName + ".dylib";
            case PythonOS.PLATFORM_WIN32 -> libName + ".dll";
            default -> libName;
        };
    }

    @CompilerDirectives.TruffleBoundary
    public static String getSupportLibName(String libName) {
        return PythonContext.getSupportLibName(PythonOS.getPythonOS(), libName);
    }

    public TruffleString getPyPackageContext() {
        return this.pyPackageContext;
    }

    public void setPyPackageContext(TruffleString pyPackageContext) {
        this.pyPackageContext = pyPackageContext;
    }

    public List<Object> getCodecSearchPath() {
        return this.codecSearchPath;
    }

    public boolean isCodecsInitialized() {
        return this.codecsInitialized;
    }

    public void markCodecsInitialized() {
        this.codecsInitialized = true;
    }

    public Map<TruffleString, PTuple> getCodecSearchCache() {
        return this.codecSearchCache;
    }

    public Map<TruffleString, Object> getCodecErrorRegistry() {
        return this.codecErrorRegistry;
    }

    public int getIntMaxStrDigits() {
        return this.intMaxStrDigits;
    }

    public int getMinIntBitLengthOverLimit() {
        return this.minIntBitLengthOverLimit;
    }

    public void setIntMaxStrDigits(int intMaxStrDigits) {
        this.intMaxStrDigits = intMaxStrDigits;
        this.minIntBitLengthOverLimit = PythonContext.computeMinIntBitLengthOverLimit(intMaxStrDigits);
    }

    @CompilerDirectives.TruffleBoundary
    private static int computeMinIntBitLengthOverLimit(int limit) {
        double bitLength = Math.floor((double)limit * LOG2_10) + 1.0;
        if (MathGuards.fitInt(bitLength)) {
            return (int)bitLength;
        }
        return Integer.MAX_VALUE;
    }

    public boolean tryEnterAsyncHandler() {
        return this.inAsyncHandler.compareAndSet(false, true);
    }

    public void leaveAsyncHandler() {
        this.inAsyncHandler.set(false);
    }

    public PythonContext(PythonLanguage language, TruffleLanguage.Env env) {
        super(language, env.isNativeAccessAllowed());
        this.dlopenFlags = PosixConstants.RTLD_NOW.value;
        this.env = env;
        this.allocationReporter = (AllocationReporter)env.lookup(AllocationReporter.class);
        this.childContextData = (ChildContextData)env.getConfig().get(CHILD_CONTEXT_DATA);
        this.sharedMultiprocessingData = this.childContextData == null ? new SharedMultiprocessingData(language.namedSemaphores) : this.childContextData.parentCtx.sharedMultiprocessingData;
        this.handler = new AsyncHandler(this);
        this.sharedFinalizer = new AsyncHandler.SharedFinalizer(this);
        this.optionValues = PythonOptions.createOptionValuesStorage(env);
        this.in = env.in();
        this.out = env.out();
        this.err = env.err();
    }

    public static PythonContext get(Node node) {
        return (PythonContext)REFERENCE.get(node);
    }

    public PythonNativePointer getNativeNull() {
        return this.nativeNull;
    }

    public AllocationReporter getAllocationReporter() {
        return this.allocationReporter;
    }

    public boolean isChildContext() {
        return this.childContextData != null;
    }

    public ChildContextData getChildContextData() {
        return this.childContextData;
    }

    public SharedMultiprocessingData getSharedMultiprocessingData() {
        return this.sharedMultiprocessingData;
    }

    public long spawnTruffleContext(int fd, int sentinel, int[] fdsToKeep) {
        ChildContextData data = new ChildContextData(this.isChildContext() ? this.childContextData.parentCtx : this);
        TruffleContext.Builder builder = data.parentCtx.env.newInnerContextBuilder(new String[0]).forceSharing(this.getOption(PythonOptions.ForceSharingForInnerContexts)).inheritAllAccess(true).initializeCreatorContext(true).option("python.NativeModules", "false").config(CHILD_CONTEXT_DATA, (Object)data);
        Thread thread = data.parentCtx.env.createThread((Runnable)new ChildContextThread(fd, sentinel, data, builder));
        long tid = PThread.getThreadId(thread);
        this.getSharedMultiprocessingData().putChildContextThread(tid, thread);
        this.getSharedMultiprocessingData().putChildContextData(tid, data);
        for (int fdToKeep : fdsToKeep) {
            this.getSharedMultiprocessingData().incrementFDRefCount(fdToKeep);
        }
        PythonContext.start(thread);
        return tid;
    }

    @CompilerDirectives.TruffleBoundary
    private static void start(Thread thread) {
        thread.start();
    }

    public synchronized List<Integer> getChildContextFDs() {
        if (this.childContextFDs == null) {
            this.childContextFDs = new ArrayList<Integer>();
        }
        return this.childContextFDs;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public long getPythonThreadStackSize() {
        return this.pythonThreadStackSize.get();
    }

    public long getAndSetPythonsThreadStackSize(long value) {
        return this.pythonThreadStackSize.getAndSet(value);
    }

    public long getNextObjectId() {
        return this.idUtils.getNextObjectId();
    }

    public long getNextObjectId(Object object) {
        return this.idUtils.getNextObjectId(object);
    }

    public long getNextStringId(TruffleString string) {
        return this.idUtils.getNextStringId(string);
    }

    public <T> T getOption(OptionKey<T> key) {
        assert (!PythonOptions.isEngineOption(key)) : "Querying engine option via context.";
        if (CompilerDirectives.inInterpreter()) {
            return (T)this.getEnv().getOptions().get(key);
        }
        return PythonOptions.getOptionUnrolling(this.optionValues, PythonOptions.getOptionKeys(), key);
    }

    public ReentrantLock getImportLock() {
        return this.importLock;
    }

    public PFunction importFunc() {
        return this.getImportFunc();
    }

    public PosixSupport getPosixSupport() {
        return this.posixSupport;
    }

    public boolean isNativeAccessAllowed() {
        return this.env.isNativeAccessAllowed();
    }

    public NFIZlibSupport getNFIZlibSupport() {
        return this.nativeZlib;
    }

    public NFIBz2Support getNFIBz2Support() {
        return this.nativeBz2lib;
    }

    public NFILZMASupport getNFILZMASupport() {
        return this.nativeLZMA;
    }

    public ConcurrentHashMap<Long, Object> getCtypesAdrMap() {
        return this.ptrAdrMap;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public void setEnv(TruffleLanguage.Env newEnv) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.env = newEnv;
        this.in = this.env.in();
        this.out = this.env.out();
        this.err = this.env.err();
        this.posixSupport.setEnv(this.env);
        this.optionValues = PythonOptions.createOptionValuesStorage(newEnv);
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setErr(OutputStream err) {
        this.err = err;
    }

    public PythonModule getMainModule() {
        return this.mainModule;
    }

    public Python3Core getCore() {
        return this;
    }

    public InputStream getStandardIn() {
        return this.in;
    }

    public OutputStream getStandardErr() {
        return this.err;
    }

    public OutputStream getStandardOut() {
        return this.out;
    }

    public void setCurrentException(PythonLanguage language, PException e) {
        this.getThreadState((PythonLanguage)language).currentException = e;
    }

    public PException getCurrentException(PythonLanguage lang) {
        return this.getThreadState((PythonLanguage)lang).currentException;
    }

    public void setCaughtException(PythonLanguage lang, PException e) {
        this.getThreadState((PythonLanguage)lang).caughtException = e;
    }

    public PException getCaughtException(PythonLanguage lang) {
        return this.getThreadState((PythonLanguage)lang).caughtException;
    }

    public void setTopFrameInfo(PythonLanguage lang, PFrame.Reference topframeref) {
        this.getThreadState((PythonLanguage)lang).topframeref = topframeref;
    }

    public PFrame.Reference popTopFrameInfo(PythonLanguage lang) {
        return this.getThreadState(lang).popTopFrameInfo();
    }

    public PFrame.Reference peekTopFrameInfo(PythonLanguage lang) {
        return this.getThreadState((PythonLanguage)lang).topframeref;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean reprEnter(Object item) {
        return this.getThreadState(this.getLanguage()).reprEnter(item);
    }

    @CompilerDirectives.TruffleBoundary
    public void reprLeave(Object item) {
        this.getThreadState(this.getLanguage()).reprLeave(item);
    }

    public long getPerfCounterStart() {
        return this.perfCounterStart;
    }

    public SecureRandom getSecureRandom() {
        assert (!ImageInfo.inImageBuildtimeCode());
        if (this.secureRandom == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try {
                this.secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
            }
            catch (NoSuchAlgorithmException e) {
                if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
                    try {
                        this.secureRandom = SecureRandom.getInstanceStrong();
                    }
                    catch (NoSuchAlgorithmException e2) {
                        throw new RuntimeException("Unable to obtain entropy source for random number generation (NativePRNGNonBlocking)", e2);
                    }
                }
                throw new RuntimeException("Unable to obtain entropy source for random number generation (NativePRNGNonBlocking)", e);
            }
        }
        return this.secureRandom;
    }

    public byte[] getHashSecret() {
        assert (!ImageInfo.inImageBuildtimeCode());
        return this.hashSecret;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        try {
            this.acquireGil();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.mainThread = new WeakReference<Thread>(Thread.currentThread());
            this.initializePosixSupport();
            this.initialize(this);
            this.setupRuntimeInformation(false);
            this.postInitialize();
            if (!ImageInfo.inImageBuildtimeCode()) {
                this.importSiteIfForced();
            } else if (this.posixSupport instanceof ImageBuildtimePosixSupport) {
                ((ImageBuildtimePosixSupport)this.posixSupport).checkLeakingResources();
            }
        }
        finally {
            if (ImageInfo.inImageBuildtimeCode()) {
                this.mainThread = null;
            }
            this.releaseGil();
        }
    }

    public void patch(TruffleLanguage.Env newEnv) {
        try {
            this.acquireGil();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.mainThread = new WeakReference<Thread>(Thread.currentThread());
            this.setEnv(newEnv);
            this.setupRuntimeInformation(true);
            this.postInitialize();
            this.importSiteIfForced();
        }
        finally {
            this.releaseGil();
        }
    }

    private void importSiteIfForced() {
        if (this.getOption(PythonOptions.ForceImportSite).booleanValue()) {
            AbstractImportNode.importModule(StringLiterals.T_SITE);
        }
        if (!this.getOption(PythonOptions.WarnOptions).isEmpty()) {
            AbstractImportNode.importModule(StringLiterals.T_WARNINGS);
        }
        if (this.getOption(PythonOptions.InputFilePath).isEmpty()) {
            this.addSysPath0();
        }
        if (this.getOption(PythonOptions.SetupLLVMLibraryPaths).booleanValue()) {
            ImpModuleBuiltins.importFrozenModuleObject(this, PythonUtils.toTruffleStringUncached("graalpy.sulong_support"), false);
        }
    }

    public void addSysPath0() {
        TruffleString path0;
        if (!this.getOption(PythonOptions.IsolateFlag).booleanValue() && (path0 = this.computeSysPath0()) != null) {
            PythonModule sys = this.lookupBuiltinModule(BuiltinNames.T_SYS);
            Object path = sys.getAttribute(StringLiterals.T_PATH);
            PyObjectCallMethodObjArgs.executeUncached(path, SpecialMethodNames.T_INSERT, 0, path0);
        }
    }

    private TruffleString computeSysPath0() {
        String[] args = this.env.getApplicationArguments();
        if (args.length == 0) {
            return null;
        }
        String argv0 = args[0];
        if (argv0.isEmpty()) {
            return StringLiterals.T_EMPTY_STRING;
        }
        if (argv0.equals("-m")) {
            try {
                return PythonUtils.toTruffleStringUncached(this.env.getCurrentWorkingDirectory().getPath());
            }
            catch (SecurityException e) {
                return null;
            }
        }
        if (!argv0.equals("-c")) {
            TruffleFile parent;
            TruffleFile scriptFile = this.env.getPublicTruffleFile(argv0);
            try {
                parent = scriptFile.getCanonicalFile(new LinkOption[0]).getParent();
            }
            catch (IOException | SecurityException e) {
                parent = scriptFile.getParent();
            }
            if (parent != null) {
                return PythonUtils.toTruffleStringUncached(parent.getPath());
            }
        }
        return StringLiterals.T_EMPTY_STRING;
    }

    private void patchPackagePaths(TruffleString from, TruffleString to) {
        HashingStorage modulesStorage = this.getSysModules().getDictStorage();
        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(modulesStorage);
        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(modulesStorage, it)) {
            Object file;
            Object v = HashingStorageNodes.HashingStorageIteratorValue.executeUncached(modulesStorage, it);
            if (!(v instanceof PythonModule)) continue;
            Object path = ((PythonModule)v).getAttribute(SpecialAttributeNames.T___PATH__);
            if (path instanceof PList) {
                Object[] paths = SequenceStorageNodes.CopyInternalArrayNode.executeUncached(((PList)path).getSequenceStorage());
                for (int i = 0; i < paths.length; ++i) {
                    TruffleString strPath;
                    Object pathElement = paths[i];
                    if (pathElement instanceof PString) {
                        strPath = ((PString)pathElement).getValueUncached();
                    } else if (TruffleStringMigrationHelpers.isJavaString(pathElement)) {
                        strPath = PythonUtils.toTruffleStringUncached((String)pathElement);
                    } else {
                        if (!(pathElement instanceof TruffleString)) continue;
                        strPath = (TruffleString)pathElement;
                    }
                    if (!strPath.regionEqualsUncached(0, (AbstractTruffleString)from, 0, from.codePointLengthUncached(PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING)) continue;
                    paths[i] = StringNodes.StringReplaceNode.getUncached().execute(strPath, from, to, -1);
                }
                ((PythonModule)v).setAttribute(SpecialAttributeNames.T___PATH__, this.factory().createList(paths));
            }
            if ((file = ((PythonModule)v).getAttribute(SpecialAttributeNames.T___FILE__)) instanceof PString) {
                file = ((PString)file).getValueUncached();
            }
            if (file instanceof TruffleString) {
                TruffleString strFile = (TruffleString)file;
                ((PythonModule)v).setAttribute(SpecialAttributeNames.T___FILE__, StringNodes.StringReplaceNode.getUncached().execute(strFile, from, to, -1));
            }
            if (!TruffleStringMigrationHelpers.isJavaString(file)) continue;
            TruffleString strFile = PythonUtils.toTruffleStringUncached((String)file);
            ((PythonModule)v).setAttribute(SpecialAttributeNames.T___FILE__, StringNodes.StringReplaceNode.getUncached().execute(strFile, from, to, -1));
        }
    }

    private void setupRuntimeInformation(boolean isPatching) {
        if (!ImageInfo.inImageBuildtimeCode()) {
            this.initializeHashSecret();
        }
        this.setIntMaxStrDigits(this.getOption(PythonOptions.IntMaxStrDigits));
        if (!PythonOptions.WITHOUT_COMPRESSION_LIBRARIES) {
            this.nativeZlib = NFIZlibSupport.createNative(this, "");
            this.nativeBz2lib = NFIBz2Support.createNative(this, "");
            this.nativeLZMA = NFILZMASupport.createNative(this, "");
        }
        this.mainModule = this.factory().createPythonModule(BuiltinNames.T___MAIN__);
        this.mainModule.setAttribute(BuiltinNames.T___BUILTINS__, this.getBuiltins());
        this.mainModule.setAttribute(SpecialAttributeNames.T___ANNOTATIONS__, this.factory().createDict());
        SetDictNode.executeUncached(this.mainModule, this.factory().createDictFixedStorage(this.mainModule));
        this.getSysModules().setItem(BuiltinNames.T___MAIN__, this.mainModule);
        if (ImageInfo.inImageBuildtimeCode()) {
            this.patchPackagePaths(this.getStdlibHome(), T_STD_LIB_PLACEHOLDER);
        } else if (isPatching && ImageInfo.inImageRuntimeCode()) {
            this.patchPackagePaths(T_STD_LIB_PLACEHOLDER, this.getStdlibHome());
        }
        this.applyToAllThreadStates(ts -> {
            ts.currentException = null;
        });
        this.isInitialized = true;
    }

    private void initializeHashSecret() {
        assert (!ImageInfo.inImageBuildtimeCode());
        Optional<Integer> hashSeed = this.getOption(PythonOptions.HashSeed);
        if (hashSeed.isPresent()) {
            int hashSeedValue = hashSeed.get();
            if (hashSeedValue != 0) {
                int x = hashSeedValue;
                for (int i = 0; i < this.hashSecret.length; ++i) {
                    x *= 214013;
                    this.hashSecret[i] = (byte)((x += 2531011) >>> 16 & 0xFF);
                }
            }
        } else {
            this.getSecureRandom().nextBytes(this.hashSecret);
        }
    }

    private void initializePosixSupport() {
        PosixSupport result;
        TruffleString option = this.getLanguage().getEngineOption(PythonOptions.PosixModuleBackend);
        TruffleString.EqualNode eqNode = TruffleString.EqualNode.getUncached();
        boolean selectedJavaBackend = eqNode.execute((AbstractTruffleString)StringLiterals.T_JAVA, (AbstractTruffleString)option, PythonUtils.TS_ENCODING);
        if (PythonOptions.WITHOUT_NATIVE_POSIX || selectedJavaBackend) {
            if (!selectedJavaBackend) {
                PythonContext.writeWarning("Native Posix backend selected, but it was excluded from the runtime, switching to Java backend.");
            }
            result = new EmulatedPosixSupport(this);
        } else if (eqNode.execute((AbstractTruffleString)StringLiterals.T_NATIVE, (AbstractTruffleString)option, PythonUtils.TS_ENCODING) || eqNode.execute((AbstractTruffleString)StringLiterals.T_LLVM_LANGUAGE, (AbstractTruffleString)option, PythonUtils.TS_ENCODING)) {
            if (ImageInfo.inImageBuildtimeCode()) {
                EmulatedPosixSupport emulatedPosixSupport = new EmulatedPosixSupport(this);
                NFIPosixSupport nativePosixSupport = new NFIPosixSupport(this, option);
                result = new ImageBuildtimePosixSupport(nativePosixSupport, emulatedPosixSupport);
            } else if (ImageInfo.inImageRuntimeCode()) {
                NFIPosixSupport nativePosixSupport = new NFIPosixSupport(this, option);
                result = new ImageBuildtimePosixSupport(nativePosixSupport, null);
            } else {
                if (!this.getOption(PythonOptions.RunViaLauncher).booleanValue()) {
                    PythonContext.writeWarning("Native Posix backend is not fully supported when embedding. For example, standard I/O always uses file descriptors 0, 1 and 2 regardless of stream redirection specified in Truffle environment");
                }
                result = new NFIPosixSupport(this, option);
            }
        } else {
            throw new IllegalStateException(String.format("Wrong value for the PosixModuleBackend option: '%s'", option));
        }
        this.posixSupport = LoggingPosixSupport.isEnabled() ? new LoggingPosixSupport(result) : result;
    }

    public void initializeHomeAndPrefixPaths(TruffleLanguage.Env newEnv, String languageHome) {
        Supplier[] homeCandidates;
        TruffleFile home;
        if (ImageInfo.inImageBuildtimeCode()) {
            this.capiHome = this.jniHome = StringLiterals.T_DOT;
            this.stdLibHome = this.jniHome;
            this.coreHome = this.jniHome;
            this.langHome = this.jniHome;
            this.sysPrefix = this.jniHome;
            this.basePrefix = this.jniHome;
            return;
        }
        String pythonHome = (String)newEnv.getOptions().get(PythonOptions.PythonHome);
        if (pythonHome.isEmpty()) {
            try {
                pythonHome = System.getenv("GRAAL_PYTHONHOME");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (languageHome != null && pythonHome == null) {
            home = newEnv.getInternalTruffleFile(languageHome);
        } else if (pythonHome != null) {
            boolean envHomeIsDirectory = false;
            TruffleFile envHomeFile = null;
            try {
                envHomeFile = newEnv.getInternalTruffleFile(pythonHome);
                envHomeIsDirectory = envHomeFile.isDirectory(new LinkOption[0]);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            home = envHomeIsDirectory ? envHomeFile : null;
        } else {
            home = null;
        }
        for (Supplier homeCandidateSupplier : homeCandidates = new Supplier[]{() -> home, () -> {
            try {
                TruffleFile internalResource = newEnv.getInternalResource("python-home");
                this.homeResourcesFile = internalResource == null ? null : internalResource.getAbsoluteFile();
                return this.homeResourcesFile;
            }
            catch (IOException iOException) {
                return null;
            }
        }}) {
            boolean homeSeemsValid;
            block30: {
                TruffleFile homeCandidate;
                block29: {
                    this.sysPrefix = (TruffleString)newEnv.getOptions().get(PythonOptions.SysPrefix);
                    this.basePrefix = (TruffleString)newEnv.getOptions().get(PythonOptions.SysBasePrefix);
                    this.coreHome = (TruffleString)newEnv.getOptions().get(PythonOptions.CoreHome);
                    this.stdLibHome = (TruffleString)newEnv.getOptions().get(PythonOptions.StdLibHome);
                    this.capiHome = (TruffleString)newEnv.getOptions().get(PythonOptions.CAPI);
                    this.jniHome = (TruffleString)newEnv.getOptions().get(PythonOptions.JNIHome);
                    homeCandidate = (TruffleFile)homeCandidateSupplier.get();
                    if (homeCandidate == null) continue;
                    homeSeemsValid = !this.coreHome.isEmpty() && !this.stdLibHome.isEmpty();
                    Python3Core.writeInfo(() -> MessageFormat.format("Initial locations:\n\tLanguage home: {0}\n\tSysPrefix: {1}\n\tBaseSysPrefix: {2}\n\tCoreHome: {3}\n\tStdLibHome: {4}\n\tCAPI: {5}\n\tJNI library: {6}\n\tHome candidate: {7}", languageHome, this.sysPrefix, this.basePrefix, this.coreHome, this.stdLibHome, this.capiHome, this.jniHome, homeCandidate.toString()));
                    this.langHome = PythonUtils.toTruffleStringUncached(homeCandidate.toString());
                    if (this.sysPrefix.isEmpty()) {
                        this.sysPrefix = PythonUtils.toTruffleStringUncached(homeCandidate.getAbsoluteFile().getPath());
                    }
                    if (this.basePrefix.isEmpty()) {
                        this.basePrefix = PythonUtils.toTruffleStringUncached(homeCandidate.getAbsoluteFile().getPath());
                    }
                    if (this.coreHome.isEmpty()) {
                        try {
                            for (TruffleFile f : homeCandidate.list()) {
                                if (f.getName().equals("lib-graalpython") && f.isDirectory(new LinkOption[0])) {
                                    this.coreHome = PythonUtils.toTruffleStringUncached(f.getPath());
                                    homeSeemsValid = true;
                                    break;
                                }
                                if (!f.getName().equals("lib") || !f.isDirectory(new LinkOption[0])) continue;
                                for (TruffleFile f2 : f.list()) {
                                    if (!f2.getName().equals("graalpy23.1") || !f.isDirectory(new LinkOption[0])) continue;
                                    this.coreHome = PythonUtils.toTruffleStringUncached(f2.getPath());
                                    homeSeemsValid = true;
                                    break block29;
                                }
                            }
                        }
                        catch (IOException | SecurityException exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.stdLibHome.isEmpty()) {
                    try {
                        for (TruffleFile f : homeCandidate.list()) {
                            if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 && (f.getName().equals("Lib") || f.getName().equals("lib")) && f.isDirectory(new LinkOption[0])) {
                                this.stdLibHome = PythonUtils.toTruffleStringUncached(f.getPath());
                                continue;
                            }
                            if (f.getName().equals("lib") && f.isDirectory(new LinkOption[0])) {
                                for (TruffleFile f2 : f.list()) {
                                    if (!f2.getName().equals("python3.10") || !f.isDirectory(new LinkOption[0])) continue;
                                    this.stdLibHome = PythonUtils.toTruffleStringUncached(f2.getPath());
                                    homeSeemsValid = true;
                                    break block30;
                                }
                                continue;
                            }
                            if (!f.getName().equals("lib-python") || !f.isDirectory(new LinkOption[0])) continue;
                            for (TruffleFile f2 : f.list()) {
                                if (!f2.getName().equals("3") || !f.isDirectory(new LinkOption[0])) continue;
                                this.stdLibHome = PythonUtils.toTruffleStringUncached(f2.getPath());
                                homeSeemsValid = true;
                                break block30;
                            }
                        }
                    }
                    catch (IOException | SecurityException exception) {
                        // empty catch block
                    }
                }
            }
            if (this.capiHome.isEmpty()) {
                this.capiHome = this.coreHome;
            }
            if (this.jniHome.isEmpty()) {
                this.jniHome = this.coreHome;
            }
            if (homeSeemsValid) break;
        }
        Python3Core.writeInfo(() -> MessageFormat.format("Updated locations:\n\tLanguage home: {0}\n\tSysPrefix: {1}\n\tBaseSysPrefix: {2}\n\tCoreHome: {3}\n\tStdLibHome: {4}\n\tExecutable: {5}\n\tCAPI: {6}\n\tJNI library: {7}", this.langHome, this.sysPrefix, this.basePrefix, this.coreHome, this.stdLibHome, newEnv.getOptions().get(PythonOptions.Executable), this.capiHome, this.jniHome));
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getLanguageHome() {
        if (this.langHome == null || this.langHome.isEmpty()) {
            this.langHome = T_PREFIX;
        }
        return this.langHome;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getSysPrefix() {
        if (this.sysPrefix.isEmpty()) {
            PythonContext.writeWarning(J_NO_PREFIX_WARNING);
            this.sysPrefix = T_PREFIX;
        }
        return this.sysPrefix;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getSysBasePrefix() {
        if (this.basePrefix.isEmpty()) {
            this.basePrefix = this.getLanguageHome();
        }
        return this.basePrefix;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getCoreHome() {
        if (this.coreHome.isEmpty()) {
            PythonContext.writeWarning(J_NO_CORE_WARNING);
            this.coreHome = T_LIB_GRAALPYTHON;
        }
        return this.coreHome;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getStdlibHome() {
        if (this.stdLibHome.isEmpty()) {
            PythonContext.writeWarning(J_NO_STDLIB);
            this.stdLibHome = T_LIB_PYTHON_3;
        }
        return this.stdLibHome;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getCoreHomeOrFail() {
        if (this.coreHome.isEmpty()) {
            throw new RuntimeException(J_NO_CORE_FATAL);
        }
        return this.coreHome;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getCAPIHome() {
        if (this.capiHome.isEmpty()) {
            PythonContext.writeWarning(J_NO_CAPI);
            return this.coreHome;
        }
        return this.capiHome;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getJNIHome() {
        if (this.jniHome.isEmpty()) {
            PythonContext.writeWarning(J_NO_JNI);
            return this.jniHome;
        }
        return this.jniHome;
    }

    private static void writeWarning(String warning) {
        LOGGER.warning(warning);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerAtexitHook(ShutdownHook shutdownHook) {
        this.shutdownHooks.add(shutdownHook);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerAtexitHook(Object callable, Object[] arguments, PKeyword[] keywords, CallTarget ct) {
        this.atExitHooks.add(new AtExitHook(callable, arguments, keywords, ct));
    }

    @CompilerDirectives.TruffleBoundary
    public void unregisterAtexitHook(Object callable) {
        this.atExitHooks.removeIf(hook -> hook.callable == callable);
    }

    @CompilerDirectives.TruffleBoundary
    public void clearAtexitHooks() {
        this.atExitHooks.clear();
    }

    public void registerCApiHook(Runnable hook) {
        if (this.hasCApiContext()) {
            hook.run();
        } else {
            this.capiHooks.add(hook);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void finalizeContext() {
        boolean cancelling = this.env.getContext().isCancelling();
        try (GilNode.UncachedAcquire gil = GilNode.uncachedAcquire();){
            if (!cancelling) {
                this.shutdownThreads();
                this.runShutdownHooks();
            }
            this.handler.shutdown();
            this.finalizing = true;
            this.joinThreads();
            if (!cancelling) {
                this.cleanupCApiResources();
            }
            this.disposeThreadStates();
        }
        this.cleanupHPyResources();
        for (int fd : this.getChildContextFDs()) {
            if (this.getSharedMultiprocessingData().decrementFDRefCount(fd)) continue;
            this.getSharedMultiprocessingData().closePipe(fd);
        }
        this.mainThread = null;
    }

    @CompilerDirectives.TruffleBoundary
    public int getAtexitHookCount() {
        return this.atExitHooks.size();
    }

    @CompilerDirectives.TruffleBoundary
    public void runAtexitHooks() {
        PException lastException = null;
        for (int i = this.atExitHooks.size() - 1; i >= 0; --i) {
            AtExitHook hook = this.atExitHooks.get(i);
            try {
                hook.ct.call(new Object[]{hook.callable, hook.arguments, hook.keywords});
                continue;
            }
            catch (PException e) {
                lastException = e;
            }
        }
        this.atExitHooks.clear();
        if (lastException != null) {
            throw lastException;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void runShutdownHooks() {
        try {
            this.runAtexitHooks();
        }
        catch (PException pException) {
            // empty catch block
        }
        for (ShutdownHook h : this.shutdownHooks) {
            h.call(this);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void disposeThreadStates() {
        for (PythonThreadState ts : this.threadStateMapping.values()) {
            ts.dispose();
        }
        this.threadStateMapping.clear();
    }

    @CompilerDirectives.TruffleBoundary
    private void cleanupCApiResources() {
        PyTruffleObjectFree.ReleaseHandleNode releaseHandleNode = PyTruffleObjectFreeFactory.ReleaseHandleNodeGen.getUncached();
        for (PythonNativeWrapper singletonNativeWrapper : this.singletonNativePtrs) {
            if (singletonNativeWrapper == null) continue;
            releaseHandleNode.execute(singletonNativeWrapper);
        }
    }

    private void cleanupHPyResources() {
        if (this.hPyContext != null) {
            this.hPyContext.finalizeContext();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void shutdownThreads() {
        LOGGER.fine("shutting down threads");
        PDict importedModules = this.getSysModules();
        HashingStorage dictStorage = importedModules.getDictStorage();
        Object value = HashingStorageNodes.HashingStorageGetItem.executeUncached(dictStorage, BuiltinNames.T_THREADING);
        if (value != null) {
            Object attrShutdown = ReadAttributeFromObjectNode.getUncached().execute(value, SpecialMethodNames.T_SHUTDOWN);
            if (attrShutdown == PNone.NO_VALUE) {
                LOGGER.fine("threading module has no member " + SpecialMethodNames.T_SHUTDOWN);
                return;
            }
            try {
                CallNode.getUncached().execute(null, attrShutdown, new Object[0]);
            }
            catch (Exception | StackOverflowError e) {
                try {
                    boolean exitException;
                    boolean bl = exitException = InteropLibrary.getUncached().isException((Object)e) && InteropLibrary.getUncached().getExceptionType((Object)e) == ExceptionType.EXIT;
                    if (!exitException) {
                        ExceptionUtils.printPythonLikeStackTrace(e);
                        if (PythonOptions.isWithJavaStacktrace(this.getLanguage())) {
                            e.printStackTrace(new PrintWriter(this.getStandardErr()));
                        }
                    }
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                throw e;
            }
        }
        LOGGER.finest("threading module was not imported");
        LOGGER.fine("successfully shut down all threads");
    }

    private void joinThreads() {
        LOGGER.fine("joining threads");
        try {
            LinkedList<Thread> threads = new LinkedList<Thread>(this.threadStateMapping.keySet());
            boolean runViaLauncher = this.getOption(PythonOptions.RunViaLauncher);
            for (Thread thread : threads) {
                if (thread == Thread.currentThread()) continue;
                LOGGER.finest("joining thread " + thread);
                this.disposeThread(thread);
                boolean isOurThread = runViaLauncher || thread.getThreadGroup() == this.threadGroup;
                int tries = isOurThread ? 100 : 5;
                for (int i = 0; i < tries && thread.isAlive(); ++i) {
                    thread.join(tries - i);
                    if (!thread.isAlive()) break;
                    LOGGER.fine("Trying to join " + thread.getName() + " failed after " + (tries - i) + "ms.");
                    if (isOurThread) {
                        thread.interrupt();
                        thread.join(tries - i);
                        if (!thread.isAlive()) break;
                        LOGGER.fine("Trying to interrupt our " + thread.getName() + " failed after " + (tries - i) + "ms.");
                    }
                    this.env.submitThreadLocal(new Thread[]{thread}, new ThreadLocalAction(true, false){

                        protected void perform(ThreadLocalAction.Access access) {
                            throw new PythonThreadKillException();
                        }
                    });
                }
                if (!isOurThread || !thread.isAlive()) continue;
                LOGGER.warning("Could not stop thread " + thread.getName());
            }
        }
        catch (InterruptedException e) {
            LOGGER.finest("got interrupt while joining threads");
            Thread.currentThread().interrupt();
        }
    }

    public void initializeMainModule(TruffleString path) {
        if (path != null) {
            this.mainModule.setAttribute(SpecialAttributeNames.T___FILE__, path);
        }
    }

    public static Assumption getSingleNativeContextAssumption() {
        return singleNativeContext;
    }

    public boolean isExecutableAccessAllowed() {
        return this.getEnv().isHostLookupAllowed() || this.isNativeAccessAllowed();
    }

    public static final void triggerAsyncActions(Node node) {
        TruffleSafepoint.poll((Node)node);
    }

    public AsyncHandler getAsyncHandler() {
        return this.handler;
    }

    public void registerAsyncAction(Supplier<AsyncHandler.AsyncAction> actionSupplier) {
        this.handler.registerAction(actionSupplier);
    }

    public void pollAsyncActions() {
        this.handler.poll();
    }

    @CompilerDirectives.TruffleBoundary
    public CyclicAssumption getNativeClassStableAssumption(PythonNativeClass cls, boolean createOnDemand) {
        CyclicAssumption assumption = this.nativeClassStableAssumptions.get(cls);
        if (assumption == null && createOnDemand) {
            assumption = new CyclicAssumption("Native class " + cls + " stable");
            this.nativeClassStableAssumptions.put(cls, assumption);
        }
        return assumption;
    }

    public void setSingletonNativeWrapper(PythonAbstractObject obj, PythonNativeWrapper nativePtr) {
        assert (PythonLanguage.getSingletonNativeWrapperIdx(obj) != -1) : "invalid special singleton object";
        assert (this.singletonNativePtrs[PythonLanguage.getSingletonNativeWrapperIdx(obj)] == null);
        VarHandle.storeStoreFence();
        this.singletonNativePtrs[PythonLanguage.getSingletonNativeWrapperIdx((Object)obj)] = nativePtr;
    }

    public PythonNativeWrapper getSingletonNativeWrapper(PythonAbstractObject obj) {
        int singletonNativePtrIdx = PythonLanguage.getSingletonNativeWrapperIdx(obj);
        if (singletonNativePtrIdx != -1) {
            return this.singletonNativePtrs[singletonNativePtrIdx];
        }
        return null;
    }

    public void reacquireGilAfterStackOverflow() {
        while (!this.ownsGil()) {
            try {
                this.acquireGil();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean ownsGil() {
        return this.globalInterpreterLock.isHeldByCurrentThread();
    }

    Thread getGilOwner() {
        return this.globalInterpreterLock.getOwner();
    }

    @CompilerDirectives.TruffleBoundary
    boolean tryAcquireGil() {
        return this.globalInterpreterLock.tryLock();
    }

    @CompilerDirectives.TruffleBoundary
    void acquireGil() throws InterruptedException {
        assert (!this.ownsGil()) : PythonContext.dumpStackOnAssertionHelper("trying to acquire the GIL more than once");
        boolean wasInterrupted = Thread.interrupted();
        this.globalInterpreterLock.lockInterruptibly();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static final String dumpStackOnAssertionHelper(String msg) {
        Thread.dumpStack();
        return msg;
    }

    @CompilerDirectives.TruffleBoundary
    void releaseGil() {
        assert (this.globalInterpreterLock.getHoldCount() == 1) : PythonContext.dumpStackOnAssertionHelper("trying to release the GIL with invalid hold count " + this.globalInterpreterLock.getHoldCount());
        this.globalInterpreterLock.unlock();
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleFile getPublicTruffleFileRelaxed(TruffleString path, TruffleString ... allowedSuffixes) {
        String jlHome;
        String jlPath;
        if (this.homeResourcesFile != null && !this.env.isFileIOAllowed() && (jlPath = path.toJavaStringUncached()).startsWith(jlHome = this.langHome.toJavaStringUncached())) {
            String homeRelativePath = jlPath.substring(jlHome.length() + 1);
            return this.homeResourcesFile.resolve(homeRelativePath);
        }
        TruffleFile f = this.env.getInternalTruffleFile(path.toJavaStringUncached());
        if (ImageInfo.inImageBuildtimeCode() || this.isPyFileInLanguageHome(f) && (f.isDirectory(new LinkOption[]{LinkOption.NOFOLLOW_LINKS}) || PythonContext.hasAllowedSuffix(path, allowedSuffixes))) {
            return f;
        }
        return this.env.getPublicTruffleFile(path.toJavaStringUncached());
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static boolean hasAllowedSuffix(TruffleString path, TruffleString[] allowedSuffixes) {
        int pathLen = path.codePointLengthUncached(PythonUtils.TS_ENCODING);
        for (TruffleString suffix : allowedSuffixes) {
            int suffixLen = suffix.codePointLengthUncached(PythonUtils.TS_ENCODING);
            if (suffixLen > pathLen || !path.regionEqualsUncached(pathLen - suffixLen, (AbstractTruffleString)suffix, 0, suffixLen, PythonUtils.TS_ENCODING)) continue;
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isPyFileInLanguageHome(TruffleFile path) {
        assert (!ImageInfo.inImageBuildtimeCode()) : "language home won't be available during image build time";
        if (this.langHome != null) {
            TruffleFile coreHomePath = this.getEnv().getInternalTruffleFile(this.langHome.toJavaStringUncached()).getAbsoluteFile();
            TruffleFile absolutePath = path.getAbsoluteFile();
            return absolutePath.startsWith(coreHomePath);
        }
        LOGGER.log(Level.FINE, () -> "Cannot access file " + path + " because there is no language home.");
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getCurrentImport() {
        ArrayDeque<TruffleString> ci = this.currentImport.get();
        if (ci == null || ci.isEmpty()) {
            return StringLiterals.T_EMPTY_STRING;
        }
        return ci.peek();
    }

    @CompilerDirectives.TruffleBoundary
    public void pushCurrentImport(TruffleString object) {
        ArrayDeque<Object> ci = this.currentImport.get();
        if (ci == null) {
            ci = new ArrayDeque();
            this.currentImport.set(ci);
        }
        ci.push(object);
    }

    @CompilerDirectives.TruffleBoundary
    public void popCurrentImport() {
        assert (this.currentImport.get() != null && this.currentImport.get().peek() != null) : "invalid popCurrentImport without push";
        this.currentImport.get().pop();
    }

    public Thread[] getThreads() {
        CompilerAsserts.neverPartOfCompilation();
        return this.threadStateMapping.keySet().toArray(new Thread[0]);
    }

    public PythonThreadState getThreadState(PythonLanguage lang) {
        PythonThreadState curThreadState = (PythonThreadState)lang.getThreadStateLocal().get();
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)curThreadState.isShuttingDown())) {
            this.killThread();
        }
        return curThreadState;
    }

    private void killThread() {
        CompilerDirectives.transferToInterpreter();
        if (this.ownsGil()) {
            this.releaseGil();
        }
        throw new PythonThreadKillException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyToAllThreadStates(Consumer<PythonThreadState> action) {
        if (this.getLanguage().singleThreadedAssumption.isValid()) {
            action.accept((PythonThreadState)this.getLanguage().getThreadStateLocal().get());
        } else {
            PythonContext pythonContext = this;
            synchronized (pythonContext) {
                for (PythonThreadState ts : this.threadStateMapping.values()) {
                    action.accept(ts);
                }
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setSentinelLockWeakref(WeakReference<PLock> sentinelLock) {
        this.getThreadState((PythonLanguage)this.getLanguage()).sentinelLock = sentinelLock;
    }

    @CompilerDirectives.TruffleBoundary
    public void initializeMultiThreading() {
        this.handler.activateGIL();
    }

    public synchronized void attachThread(Thread thread, ContextThreadLocal<PythonThreadState> threadState) {
        CompilerAsserts.neverPartOfCompilation();
        this.threadStateMapping.put(thread, (PythonThreadState)threadState.get(thread));
    }

    public synchronized void disposeThread(Thread thread) {
        CompilerAsserts.neverPartOfCompilation();
        PythonThreadState ts = this.threadStateMapping.get(thread);
        if (ts == null) {
            return;
        }
        ts.shutdown();
        this.threadStateMapping.remove(thread);
        ts.dispose();
        PythonContext.releaseSentinelLock(ts.sentinelLock);
        this.getSharedMultiprocessingData().removeChildContextThread(PThread.getThreadId(thread));
    }

    private static void releaseSentinelLock(WeakReference<PLock> sentinelLockWeakref) {
        PLock sentinelLock;
        if (sentinelLockWeakref != null && (sentinelLock = (PLock)sentinelLockWeakref.get()) != null) {
            sentinelLock.release();
        }
    }

    public boolean hasCApiContext() {
        return this.cApiContext != null;
    }

    public CApiContext getCApiContext() {
        return this.cApiContext;
    }

    public void setCApiContext(CApiContext capiContext) {
        assert (this.cApiContext == null) : "tried to create new C API context but it was already created";
        this.cApiContext = capiContext;
    }

    public void runCApiHooks() {
        for (Runnable capiHook : this.capiHooks) {
            capiHook.run();
        }
        this.capiHooks.clear();
    }

    public boolean hasHPyContext() {
        return this.hPyContext != null;
    }

    public synchronized GraalHPyContext createHPyContext(Object hpyLibrary) throws Exception {
        GraalHPyContext hpyContext;
        assert (this.hPyContext == null) : "tried to create new HPy context but it was already created";
        this.hPyContext = hpyContext = new GraalHPyContext(this, hpyLibrary);
        return hpyContext;
    }

    public GraalHPyContext getHPyContext() {
        assert (this.hPyContext != null) : "tried to get HPy context but was not created yet";
        return this.hPyContext;
    }

    @CompilerDirectives.TruffleBoundary
    private Object initDebugMode() {
        if (!this.hasHPyContext()) {
            throw CompilerDirectives.shouldNotReachHere((String)"cannot initialize HPy debug context without HPy universal context");
        }
        throw CompilerDirectives.shouldNotReachHere((String)"not yet implemented");
    }

    public boolean isGcEnabled() {
        return this.gcEnabled;
    }

    public void setGcEnabled(boolean flag) {
        this.gcEnabled = flag;
    }

    public AsyncHandler.SharedFinalizer getSharedFinalizer() {
        return this.sharedFinalizer;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void setCodeFilename(CallTarget callTarget, TruffleString filename) {
        this.codeFilename.put(callTarget, filename);
    }

    public TruffleString getCodeFilename(CallTarget callTarget) {
        return this.codeFilename.get(callTarget);
    }

    public void setCodeUnitFilename(CodeUnit co, TruffleString filename) {
        this.codeUnitFilename.put(co, filename);
    }

    public TruffleString getCodeUnitFilename(CodeUnit co) {
        return this.codeUnitFilename.get(co);
    }

    public long getDeserializationId(TruffleString fileName) {
        return this.deserializationId.computeIfAbsent(fileName, f -> new AtomicLong()).incrementAndGet();
    }

    @CompilerDirectives.TruffleBoundary
    public String getLLVMSupportExt(String libName) {
        LanguageInfo llvmInfo;
        Toolchain toolchain;
        String toolchainIdentifier;
        if (!this.getOption(PythonOptions.NativeModules).booleanValue() && !"native".equals(toolchainIdentifier = (toolchain = (Toolchain)this.env.lookup(llvmInfo = (LanguageInfo)this.env.getInternalLanguages().get("llvm"), Toolchain.class)).getIdentifier())) {
            return PythonContext.getSupportLibName(PythonOS.PLATFORM_LINUX, libName + "-" + toolchainIdentifier);
        }
        return PythonContext.getSupportLibName(libName + "-native");
    }

    @CompilerDirectives.TruffleBoundary
    public TruffleString getSoAbi() {
        if (this.soABI == null) {
            PythonModule sysModule = this.lookupBuiltinModule(BuiltinNames.T_SYS);
            Object implementationObj = ReadAttributeFromObjectNode.getUncached().execute(sysModule, T_IMPLEMENTATION);
            TruffleString cacheTag = (TruffleString)PythonAbstractObject.PInteropGetAttributeNode.executeUncached(implementationObj, SysModuleBuiltins.T_CACHE_TAG);
            TruffleString multiArch = (TruffleString)PythonAbstractObject.PInteropGetAttributeNode.executeUncached(implementationObj, SysModuleBuiltins.T__MULTIARCH);
            TruffleString toolchainId = this.getPlatformId();
            TruffleString soExt = PythonOS.getPythonOS() == PythonOS.PLATFORM_DARWIN && StringLiterals.T_NATIVE.equalsUncached((AbstractTruffleString)toolchainId, PythonUtils.TS_ENCODING) ? StringLiterals.T_EXT_SO : (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 && StringLiterals.T_NATIVE.equalsUncached((AbstractTruffleString)toolchainId, PythonUtils.TS_ENCODING) ? StringLiterals.T_EXT_PYD : StringLiterals.T_EXT_SO);
            this.soABI = StringUtils.cat(StringLiterals.T_DOT, cacheTag, StringLiterals.T_DASH, toolchainId, StringLiterals.T_DASH, multiArch, soExt);
        }
        return this.soABI;
    }

    public TruffleString getPlatformId() {
        if (!this.getOption(PythonOptions.NativeModules).booleanValue()) {
            LanguageInfo llvmInfo = (LanguageInfo)this.env.getInternalLanguages().get("llvm");
            Toolchain toolchain = (Toolchain)this.env.lookup(llvmInfo, Toolchain.class);
            return PythonUtils.toTruffleStringUncached(toolchain.getIdentifier());
        }
        return StringLiterals.T_NATIVE;
    }

    public Thread getMainThread() {
        if (this.mainThread != null) {
            return (Thread)this.mainThread.get();
        }
        return null;
    }

    public int getDlopenFlags() {
        return this.dlopenFlags;
    }

    public void setDlopenFlags(int dlopenFlags) {
        this.dlopenFlags = dlopenFlags;
    }

    public Unsafe getUnsafe() {
        if (this.isNativeAccessAllowed()) {
            return UnsafeWrapper.UNSAFE;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new RuntimeException("Native access not allowed, cannot manipulate native memory");
    }

    public long allocateNativeMemory(long size) {
        return PythonContext.allocateNativeMemoryBoundary(this.getUnsafe(), size);
    }

    @CompilerDirectives.TruffleBoundary
    private static long allocateNativeMemoryBoundary(Unsafe unsafe, long size) {
        return unsafe.allocateMemory(size);
    }

    public void freeNativeMemory(long address) {
        PythonContext.freeNativeMemoryBoundary(this.getUnsafe(), address);
    }

    @CompilerDirectives.TruffleBoundary
    private static void freeNativeMemoryBoundary(Unsafe unsafe, long address) {
        unsafe.freeMemory(address);
    }

    public void copyNativeMemory(long dst, byte[] src, int srcOffset, int size) {
        PythonContext.copyNativeMemoryBoundary(this.getUnsafe(), null, dst, src, PythonContext.byteArrayOffset(srcOffset), size);
    }

    public void copyNativeMemory(byte[] dst, int dstOffset, long src, int size) {
        PythonContext.copyNativeMemoryBoundary(this.getUnsafe(), dst, PythonContext.byteArrayOffset(dstOffset), null, src, size);
    }

    private static long byteArrayOffset(int offset) {
        return (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)Unsafe.ARRAY_BYTE_INDEX_SCALE * (long)offset;
    }

    @CompilerDirectives.TruffleBoundary
    private static void copyNativeMemoryBoundary(Unsafe unsafe, Object dst, long dstOffset, Object src, long srcOffset, int size) {
        unsafe.copyMemory(src, srcOffset, dst, dstOffset, size);
    }

    public void setNativeMemory(long pointer, int size, byte value) {
        PythonContext.setNativeMemoryBoundary(this.getUnsafe(), pointer, size, value);
    }

    @CompilerDirectives.TruffleBoundary
    private static void setNativeMemoryBoundary(Unsafe unsafe, long pointer, int size, byte value) {
        unsafe.setMemory(pointer, size, value);
    }

    private static final class GlobalInterpreterLock
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;

        private GlobalInterpreterLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }

    public static final class ChildContextData {
        private int exitCode = 0;
        private boolean signaled;
        private final PythonContext parentCtx;
        private TruffleWeakReference<TruffleContext> ctx;
        private final AtomicBoolean exiting = new AtomicBoolean(false);
        private final CountDownLatch running = new CountDownLatch(1);

        public ChildContextData(PythonContext parentCtx) {
            this.parentCtx = parentCtx;
        }

        public void setExitCode(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public void setSignaled(int signaledCode) {
            this.signaled = true;
            this.exitCode = signaledCode;
        }

        public boolean wasSignaled() {
            return this.signaled;
        }

        private void setTruffleContext(TruffleContext ctx) {
            assert (this.ctx == null);
            assert (ctx != null);
            this.ctx = new TruffleWeakReference((Object)ctx);
        }

        public TruffleContext getTruffleContext() {
            return (TruffleContext)this.ctx.get();
        }

        public void awaitRunning() throws InterruptedException {
            this.running.await();
        }

        public boolean compareAndSetExiting(boolean expect, boolean update) {
            return this.exiting.compareAndSet(expect, update);
        }
    }

    public static final class SharedMultiprocessingData {
        private static final Object SENTINEL = new Object();
        private final AtomicInteger fdCounter = new AtomicInteger(0);
        private final ConcurrentSkipListMap<Integer, LinkedBlockingQueue<Object>> pipeData = new ConcurrentSkipListMap();
        private final ConcurrentHashMap<Integer, Integer> fdRefCount = new ConcurrentHashMap();
        private final ConcurrentHashMap<TruffleString, Semaphore> namedSemaphores;
        private final ConcurrentHashMap<Long, Thread> childContextThreads = new ConcurrentHashMap();
        private final ConcurrentHashMap<Long, ChildContextData> childContextData = new ConcurrentHashMap();

        public SharedMultiprocessingData(ConcurrentHashMap<TruffleString, Semaphore> namedSemaphores) {
            this.namedSemaphores = namedSemaphores;
        }

        @CompilerDirectives.TruffleBoundary
        private void incrementFDRefCount(int fd) {
            this.fdRefCount.compute(fd, (f, count) -> count == null ? 1 : count + 1);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean decrementFDRefCount(int fd) {
            Integer cnt = this.fdRefCount.computeIfPresent(fd, (f, count) -> {
                if (count == 0 || count == Integer.MIN_VALUE) {
                    return Integer.MIN_VALUE;
                }
                assert (count > 0);
                return count - 1;
            });
            return cnt != null && !this.fdRefCount.remove(fd, Integer.MIN_VALUE);
        }

        @CompilerDirectives.TruffleBoundary
        public int[] pipe() {
            LinkedBlockingQueue q = new LinkedBlockingQueue();
            int writeFD = this.fdCounter.addAndGet(-2);
            assert (SharedMultiprocessingData.isWriteFD(writeFD));
            int readFD = SharedMultiprocessingData.getPairFd(writeFD);
            this.pipeData.put(readFD, q);
            this.pipeData.put(writeFD, q);
            return new int[]{readFD, writeFD};
        }

        @CompilerDirectives.TruffleBoundary
        public void addPipeData(int fd, byte[] bytes, Runnable noFDHandler, Runnable brokenPipeHandler) {
            assert (SharedMultiprocessingData.isWriteFD(fd));
            LinkedBlockingQueue<Object> q = this.pipeData.get(fd);
            if (q == null) {
                noFDHandler.run();
                throw CompilerDirectives.shouldNotReachHere();
            }
            int fd2 = SharedMultiprocessingData.getPairFd(fd);
            if (this.isClosed(fd2)) {
                brokenPipeHandler.run();
                throw CompilerDirectives.shouldNotReachHere();
            }
            q.add(bytes);
        }

        @CompilerDirectives.TruffleBoundary
        public void closePipe(int fd) {
            LinkedBlockingQueue<Object> q = this.pipeData.remove(fd);
            if (q != null && SharedMultiprocessingData.isWriteFD(fd)) {
                q.offer(SENTINEL);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public Object takePipeData(Node node, int fd, Runnable noFDHandler) {
            LinkedBlockingQueue<Object> q = this.pipeData.get(fd);
            if (q == null) {
                noFDHandler.run();
                throw CompilerDirectives.shouldNotReachHere();
            }
            Object[] o = new Object[]{PNone.NONE};
            TruffleSafepoint.setBlockedThreadInterruptible((Node)node, lbq -> {
                o[0] = SharedMultiprocessingData.take(lbq);
            }, q);
            return o[0];
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isBlocking(int fd) {
            boolean[] result = new boolean[]{false};
            this.pipeData.compute(fd, (f, q) -> {
                int fd2;
                result[0] = q == null ? false : (this.isClosed(fd2 = SharedMultiprocessingData.getPairFd(fd)) ? false : q.isEmpty());
                return q;
            });
            return result[0];
        }

        private static int getPairFd(int fd) {
            return SharedMultiprocessingData.isWriteFD(fd) ? fd + 1 : fd - 1;
        }

        private static boolean isWriteFD(int fd) {
            return fd % 2 == 0;
        }

        private static Object take(LinkedBlockingQueue<Object> q) throws InterruptedException {
            Object v = q.take();
            if (v == SENTINEL) {
                q.offer(SENTINEL);
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            return v;
        }

        private boolean isClosed(int fd) {
            return fd >= this.fdCounter.get() && this.pipeData.get(fd) == null;
        }

        @CompilerDirectives.TruffleBoundary
        public void putNamedSemaphore(TruffleString name, Semaphore sem) {
            this.namedSemaphores.put(name, sem);
        }

        @CompilerDirectives.TruffleBoundary
        public Semaphore getNamedSemaphore(TruffleString name) {
            return this.namedSemaphores.get(name);
        }

        @CompilerDirectives.TruffleBoundary
        public Semaphore removeNamedSemaphore(TruffleString name) {
            return this.namedSemaphores.remove(name);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread getChildContextThread(long tid) {
            return this.childContextThreads.get(tid);
        }

        @CompilerDirectives.TruffleBoundary
        public void putChildContextThread(long id, Thread thread) {
            this.childContextThreads.put(id, thread);
        }

        @CompilerDirectives.TruffleBoundary
        public void removeChildContextThread(long id) {
            this.childContextThreads.remove(id);
        }

        @CompilerDirectives.TruffleBoundary
        public ChildContextData getChildContextData(long tid) {
            return this.childContextData.get(tid);
        }

        @CompilerDirectives.TruffleBoundary
        public void removeChildContextData(long tid) {
            this.childContextData.remove(tid);
        }

        @CompilerDirectives.TruffleBoundary
        public void putChildContextData(long id, ChildContextData data) {
            this.childContextData.put(id, data);
        }
    }

    private static class ChildContextThread
    implements Runnable {
        private static final TruffleLogger MULTIPROCESSING_LOGGER = PythonLanguage.getLogger(ChildContextThread.class);
        private static final Source MULTIPROCESSING_SOURCE = Source.newBuilder((String)"python", (CharSequence)"from multiprocessing.spawn import spawn_truffleprocess; spawn_truffleprocess(fd, sentinel)", (String)"<spawned-child-context>").internal(true).build();
        private final int fd;
        private final ChildContextData data;
        private final TruffleContext.Builder builder;
        private final int sentinel;

        public ChildContextThread(int fd, int sentinel, ChildContextData data, TruffleContext.Builder builder) {
            this.fd = fd;
            this.data = data;
            this.builder = builder;
            this.sentinel = sentinel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MULTIPROCESSING_LOGGER.fine("starting spawned child context");
            TruffleContext ctx = this.builder.build();
            this.data.setTruffleContext(ctx);
            Object parent = ctx.enter(null);
            CallTarget ct = PythonContext.get(null).getEnv().parsePublic(MULTIPROCESSING_SOURCE, new String[]{"fd", "sentinel"});
            try {
                this.data.running.countDown();
                Object res = ct.call(new Object[]{this.fd, this.sentinel});
                int exitCode = CastToJavaIntLossyNode.executeUncached(res);
                this.data.setExitCode(exitCode);
            }
            finally {
                ctx.leave(null, parent);
                if (this.data.compareAndSetExiting(false, true)) {
                    try {
                        ctx.close();
                        MULTIPROCESSING_LOGGER.log(Level.FINE, "closed spawned child context");
                    }
                    catch (Throwable t) {
                        MULTIPROCESSING_LOGGER.log(Level.FINE, "exception while closing spawned child context", t);
                    }
                }
                this.data.parentCtx.sharedMultiprocessingData.closePipe(this.sentinel);
            }
        }
    }

    public static final class PythonThreadState {
        private boolean shuttingDown = false;
        PFrame.Reference topframeref = PFrame.Reference.EMPTY;
        WeakReference<PLock> sentinelLock;
        PException currentException;
        PException caughtException = PException.NO_EXCEPTION;
        HashSet<Object> reprObjectSet;
        PDict dict;
        CtypesModuleBuiltins.CtypesThreadState ctypes;
        PThreadState nativeWrapper;
        Object traceFun;
        boolean tracing;
        boolean profiling;
        TraceEvent tracingWhat;
        Object profileFun;
        PContextVarsContext contextVarsContext;
        Object runningEventLoop;
        Object asyncgenFirstIter;
        public int recursionDepth;

        public PythonThreadState(PythonContext context, Thread owner) {
        }

        void shutdown() {
            this.shuttingDown = true;
        }

        public Object getRunningEventLoop() {
            return this.runningEventLoop;
        }

        public void setRunningEventLoop(Object runningEventLoop) {
            this.runningEventLoop = runningEventLoop;
        }

        public boolean isShuttingDown() {
            return this.shuttingDown;
        }

        @CompilerDirectives.TruffleBoundary
        boolean reprEnter(Object item) {
            if (this.reprObjectSet == null) {
                this.reprObjectSet = new HashSet();
            }
            return this.reprObjectSet.add(item);
        }

        @CompilerDirectives.TruffleBoundary
        void reprLeave(Object item) {
            this.reprObjectSet.remove(item);
        }

        public PException getCurrentException() {
            return this.currentException;
        }

        public void setCurrentException(PException currentException) {
            this.currentException = currentException;
        }

        public PException getCaughtException() {
            return this.caughtException;
        }

        public void setCaughtException(PException caughtException) {
            this.caughtException = caughtException;
        }

        public void setTopFrameInfo(PFrame.Reference topframeref) {
            this.topframeref = topframeref;
        }

        public PFrame.Reference popTopFrameInfo() {
            PFrame.Reference ref = this.topframeref;
            this.topframeref = null;
            return ref;
        }

        public PFrame.Reference peekTopFrameInfo() {
            return this.topframeref;
        }

        public PDict getDict() {
            return this.dict;
        }

        public void setDict(PDict dict) {
            this.dict = dict;
        }

        public CtypesModuleBuiltins.CtypesThreadState getCtypes() {
            return this.ctypes;
        }

        public void setCtypes(CtypesModuleBuiltins.CtypesThreadState ctypes) {
            this.ctypes = ctypes;
        }

        public PThreadState getNativeWrapper() {
            return this.nativeWrapper;
        }

        public void setNativeWrapper(PThreadState nativeWrapper) {
            this.nativeWrapper = nativeWrapper;
        }

        public PContextVarsContext getContextVarsContext() {
            if (this.contextVarsContext == null) {
                this.contextVarsContext = PythonObjectFactory.getUncached().createContextVarsContext();
            }
            return this.contextVarsContext;
        }

        public void setContextVarsContext(PContextVarsContext contextVarsContext) {
            assert (contextVarsContext != null);
            this.contextVarsContext = contextVarsContext;
        }

        public void dispose() {
            PyTruffleObjectFree.ReleaseHandleNode releaseHandleNode = PyTruffleObjectFreeFactory.ReleaseHandleNodeGen.getUncached();
            if (this.dict != null && this.dict.getNativeWrapper() != null) {
                releaseHandleNode.execute(this.dict.getNativeWrapper());
            }
            this.dict = null;
            if (this.nativeWrapper != null) {
                releaseHandleNode.execute(this.nativeWrapper);
                this.nativeWrapper = null;
            }
        }

        public Object getTraceFun() {
            return this.traceFun;
        }

        public void setTraceFun(Object traceFun, PythonLanguage language) {
            if (this.traceFun != traceFun) {
                language.noTracingOrProfilingAssumption.invalidate();
                this.traceFun = traceFun;
            }
        }

        public boolean isTracing() {
            return this.tracing;
        }

        public void tracingStart(TraceEvent newTracingWhat) {
            assert (!this.tracing) : "Attempt made to trace a call while inside a trace function. Did you forget to check isTracing before calling invokeTraceFunction?";
            this.tracing = true;
            this.setTracingWhat(newTracingWhat);
        }

        public void tracingStop() {
            this.tracing = false;
        }

        public TraceEvent getTracingWhat() {
            return this.tracingWhat;
        }

        public void setTracingWhat(TraceEvent tracingWhat) {
            this.tracingWhat = tracingWhat;
        }

        public void setProfileFun(Object profileFun, PythonLanguage language) {
            if (this.profileFun != profileFun) {
                language.noTracingOrProfilingAssumption.invalidate();
                this.profileFun = profileFun;
            }
        }

        public Object getProfileFun() {
            return this.profileFun;
        }

        public boolean isProfiling() {
            return this.profiling;
        }

        public void profilingStart() {
            assert (!this.profiling) : "Attempt made to trace a call while inside a profile function. Did you forget to check isProfiling before calling invokeTraceFunction?";
            this.profiling = true;
        }

        public void profilingStop() {
            this.profiling = false;
        }

        public Object getAsyncgenFirstIter() {
            return this.asyncgenFirstIter;
        }

        public void setAsyncgenFirstIter(Object asyncgenFirstIter) {
            this.asyncgenFirstIter = asyncgenFirstIter;
        }
    }

    private static final class AtExitHook {
        final Object callable;
        final Object[] arguments;
        final PKeyword[] keywords;
        final CallTarget ct;

        AtExitHook(Object callable, Object[] arguments, PKeyword[] keywords, CallTarget ct) {
            this.callable = callable;
            this.arguments = arguments;
            this.keywords = keywords;
            this.ct = ct;
        }
    }

    private static final class UnsafeWrapper {
        private static final Unsafe UNSAFE = UnsafeWrapper.initUnsafe();

        private UnsafeWrapper() {
        }

        private static Unsafe initUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafeInstance.setAccessible(true);
                    return (Unsafe)theUnsafeInstance.get(Unsafe.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
                }
            }
        }
    }

    private record ClosureInfo(Object closure, Object delegate, Object executable, long pointer) {
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetThreadStateNode
    extends Node {
        public abstract PythonThreadState execute(Node var1, PythonContext var2);

        public final PythonThreadState executeCached(PythonContext context) {
            return this.execute(this, context);
        }

        public final PythonThreadState executeCached() {
            return this.executeCached(null);
        }

        public final void setCaughtExceptionCached(PythonContext context, PException exception) {
            this.executeCached((PythonContext)context).caughtException = exception;
        }

        public final void setCaughtException(Node inliningTarget, PException exception) {
            this.execute((Node)inliningTarget, null).caughtException = exception;
        }

        public final PException getCurrentException(Node inliningTarget, PythonContext context) {
            return this.execute((Node)inliningTarget, (PythonContext)context).currentException;
        }

        public final PException getCurrentException(Node inliningTarget) {
            return this.execute((Node)inliningTarget, null).currentException;
        }

        public final void setTopFrameInfoCached(PythonContext context, PFrame.Reference topframeref) {
            this.executeCached((PythonContext)context).topframeref = topframeref;
        }

        public final void clearTopFrameInfoCached(PythonContext context) {
            this.executeCached((PythonContext)context).topframeref = null;
        }

        public final void setCurrentException(Node inliningTarget, PythonContext context, PException exception) {
            this.execute((Node)inliningTarget, (PythonContext)context).currentException = exception;
        }

        public final void setCurrentException(Node inliningTarget, PException exception) {
            this.execute((Node)inliningTarget, null).currentException = exception;
        }

        @Specialization(guards={"noContext == null", "!curThreadState.isShuttingDown()"})
        static PythonThreadState doNoShutdown(PythonContext noContext, @Bind(value="getThreadState()") PythonThreadState curThreadState) {
            return curThreadState;
        }

        @Specialization(guards={"noContext == null"}, replaces={"doNoShutdown"})
        PythonThreadState doGeneric(PythonContext noContext) {
            PythonThreadState curThreadState = (PythonThreadState)PythonLanguage.get(this).getThreadStateLocal().get();
            if (curThreadState.isShuttingDown()) {
                PythonContext.get(this).killThread();
            }
            return curThreadState;
        }

        @Specialization(guards={"!curThreadState.isShuttingDown()"})
        static PythonThreadState doNoShutdownWithContext(PythonContext context, @Bind(value="getThreadState()") PythonThreadState curThreadState) {
            return curThreadState;
        }

        @Specialization(replaces={"doNoShutdownWithContext"})
        PythonThreadState doGenericWithContext(PythonContext context) {
            PythonThreadState curThreadState = (PythonThreadState)PythonLanguage.get(this).getThreadStateLocal().get(context.env.getContext());
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)curThreadState.isShuttingDown())) {
                context.killThread();
            }
            return curThreadState;
        }

        @NonIdempotent
        PythonThreadState getThreadState() {
            return (PythonThreadState)PythonLanguage.get(this).getThreadStateLocal().get();
        }
    }

    public static enum ProfileEvent {
        CALL("call"),
        C_CALL("c_call"),
        C_EXCEPTION("c_exception"),
        C_RETURN("c_return"),
        RETURN("return");

        public final TruffleString name;

        private ProfileEvent(String name) {
            this.name = PythonUtils.tsLiteral(name);
        }
    }

    public static enum TraceEvent {
        CALL("call"),
        EXCEPTION("exception"),
        LINE("line"),
        RETURN("return"),
        DISABLED("");

        public final TruffleString pythonName;

        private TraceEvent(String pythonName) {
            this.pythonName = PythonUtils.tsLiteral(pythonName);
        }
    }
}

