/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import java.util.Arrays;

public final class BoolSequenceStorage
extends TypedSequenceStorage {
    private boolean[] values;

    public BoolSequenceStorage() {
        this.values = new boolean[0];
    }

    public BoolSequenceStorage(boolean[] elements) {
        this(elements, elements.length);
    }

    public BoolSequenceStorage(boolean[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public BoolSequenceStorage(int capacity) {
        this.values = new boolean[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    protected void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    protected void increaseCapacityExact(int newCapacity) {
        this.values = new boolean[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public SequenceStorage copy() {
        return new BoolSequenceStorage(PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newLength) {
        return new BoolSequenceStorage(newLength);
    }

    @Override
    public Object[] getInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    public boolean[] getInternalBoolArray() {
        return this.values;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.getBoolItemNormalized(idx);
    }

    public boolean getBoolItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Boolean)) {
            throw new SequenceStoreException(value);
        }
        this.setBoolItemNormalized(idx, (Boolean)value);
    }

    public void setBoolItemNormalized(int idx, boolean value) {
        this.values[idx] = value;
    }

    @Override
    public void insertItem(int idx, Object value) throws SequenceStoreException {
        if (!(value instanceof Boolean)) {
            throw new SequenceStoreException(value);
        }
        this.insertBoolItem(idx, (Boolean)value);
    }

    private void insertBoolItem(int idx, boolean value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public SequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        boolean[] newArray = new boolean[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new BoolSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new BoolSequenceStorage(newArray);
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                boolean temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public Object getIndicativeValue() {
        return false;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        if (other.length() != this.length() || !(other instanceof BoolSequenceStorage)) {
            return false;
        }
        boolean[] otherArray = ((BoolSequenceStorage)other).getInternalBoolArray();
        for (int i = 0; i < this.length(); ++i) {
            if (this.values[i] == otherArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (boolean[])arrayObject;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Boolean;
    }
}

