/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=PythonBufferAccessLibrary.class)
public final class EmptySequenceStorage
extends SequenceStorage {
    public static final EmptySequenceStorage INSTANCE = new EmptySequenceStorage();

    @Override
    public SequenceStorage generalizeFor(Object value, SequenceStorage target) {
        BasicSequenceStorage generalized = value instanceof Byte ? new ByteSequenceStorage(16) : (value instanceof Boolean ? new BoolSequenceStorage(16) : (value instanceof Integer ? (target instanceof ByteSequenceStorage ? new ByteSequenceStorage(16) : new IntSequenceStorage()) : (value instanceof Long ? (target instanceof ByteSequenceStorage ? new ByteSequenceStorage(16) : new LongSequenceStorage()) : (value instanceof Double ? new DoubleSequenceStorage() : new ObjectSequenceStorage(PythonUtils.EMPTY_OBJECT_ARRAY)))));
        return generalized;
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public void setNewLength(int length) {
        if (length != 0) {
            CompilerDirectives.transferToInterpreter();
            throw PRaiseNode.getUncached().raise(PythonErrorType.ValueError, ErrorMessages.LIST_LENGTH_OUT_OF_RANGE);
        }
    }

    @Override
    public SequenceStorage copy() {
        return this;
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return this;
    }

    @Override
    public Object[] getInternalArray() {
        return PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public Object getItemNormalized(int idx) {
        CompilerDirectives.transferToInterpreter();
        throw PRaiseNode.getUncached().raise(PythonErrorType.ValueError, ErrorMessages.LIST_INDEX_OUT_OF_RANGE);
    }

    @Override
    public void setItemNormalized(int idx, Object value) throws SequenceStoreException {
        CompilerDirectives.transferToInterpreter();
        throw PRaiseNode.getUncached().raise(PythonErrorType.ValueError, ErrorMessages.LIST_ASSIGMENT_INDEX_OUT_OF_RANGE);
    }

    @Override
    public void insertItem(int idx, Object value) throws SequenceStoreException {
        assert (idx == 0);
        throw new SequenceStoreException(value);
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
    }

    @Override
    public SequenceStorage getSliceInBound(int start, int stop, int step, int len) {
        assert (start == stop && stop == 0);
        return this;
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean equals(SequenceStorage other) {
        return other == INSTANCE;
    }

    @Override
    public void ensureCapacity(int newCapacity) {
    }

    @Override
    public Object getInternalArrayObject() {
        return null;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Empty;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength() {
        return 0;
    }

    @ExportMessage
    byte readByte(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }

    @ExportMessage
    short readShort(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }

    @ExportMessage
    int readInt(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }

    @ExportMessage
    long readLong(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }

    @ExportMessage
    float readFloat(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }

    @ExportMessage
    double readDouble(int byteOffset) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("EmptySequenceStorage is always empty!");
    }
}

