/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.FcntlModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.FcntlModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="fcntl")
public final class FcntlModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FcntlModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        for (PosixConstants.IntConstant c : PosixConstants.flockOperation) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        for (PosixConstants.IntConstant c : PosixConstants.flockType) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        super.initialize(core);
    }

    @Builtin(name="ioctl", minNumOfPositionalArgs=2, parameterNames={"fd", "request", "arg", "mutate_flag"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversionClass=PosixModuleBuiltins.FileDescriptorConversionNode.class), @ArgumentClinic(name="request", conversion=ArgumentClinic.ClinicConversion.Long), @ArgumentClinic(name="mutate_flag", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class IoctlNode
    extends PythonClinicBuiltinNode {
        private static final int IOCTL_BUFSZ = 1024;

        IoctlNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Specialization
        Object ioctl(VirtualFrame frame, int fd, long request, Object arg, boolean mutateArg, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached PyLongAsIntNode asIntNode, @Cached CastToTruffleStringNode castToString, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached GilNode gilNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached SysModuleBuiltins.AuditNode auditNode) {
            auditNode.audit(inliningTarget, "fcnt.ioctl", fd, request, arg);
            try {
                Object buffer;
                int intArg = 0;
                if (arg != PNone.NO_VALUE) {
                    buffer = null;
                    if (acquireLib.hasBuffer(arg)) {
                        boolean writable = false;
                        try {
                            buffer = acquireLib.acquireWritable(arg, frame, indirectCallData);
                            writable = true;
                        }
                        catch (PException e) {
                            try {
                                buffer = acquireLib.acquireReadonly(arg, frame, indirectCallData);
                            }
                            catch (PException pException) {
                                // empty catch block
                            }
                        }
                        if (buffer != null) {
                            try {
                                byte[] ioctlArg;
                                boolean writeBack;
                                int len;
                                block34: {
                                    len = bufferLib.getBufferLength(buffer);
                                    writeBack = false;
                                    boolean releaseGil = true;
                                    ioctlArg = null;
                                    if (writable && mutateArg) {
                                        byte[] internalArray;
                                        writeBack = true;
                                        if (bufferLib.hasInternalByteArray(buffer) && (internalArray = bufferLib.getInternalByteArray(buffer)).length > len && internalArray[len] == 0) {
                                            writeBack = false;
                                            releaseGil = false;
                                            ioctlArg = internalArray;
                                        }
                                    } else if (len > 1024) {
                                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.IOCTL_STRING_ARG_TOO_LONG);
                                    }
                                    if (ioctlArg == null) {
                                        ioctlArg = new byte[len + 1];
                                        bufferLib.readIntoByteArray(buffer, 0, ioctlArg, 0, len);
                                    }
                                    try {
                                        int ret = this.callIoctlBytes(frame, inliningTarget, fd, request, ioctlArg, releaseGil, posixLib, gilNode, constructAndRaiseNode);
                                        if (!writable || !mutateArg) break block34;
                                        Integer n = ret;
                                        if (writeBack) {
                                            bufferLib.writeFromByteArray(buffer, 0, ioctlArg, 0, len);
                                        }
                                        return n;
                                    }
                                    catch (Throwable throwable) {
                                        if (writeBack) {
                                            bufferLib.writeFromByteArray(buffer, 0, ioctlArg, 0, len);
                                        }
                                        throw throwable;
                                    }
                                }
                                PBytes pBytes = factory.createBytes(ioctlArg, len);
                                if (writeBack) {
                                    bufferLib.writeFromByteArray(buffer, 0, ioctlArg, 0, len);
                                }
                                return pBytes;
                            }
                            finally {
                                bufferLib.release(buffer, frame, indirectCallData);
                            }
                        }
                    }
                    TruffleString stringArg = null;
                    try {
                        stringArg = castToString.execute(inliningTarget, arg);
                    }
                    catch (CannotCastException len) {
                        // empty catch block
                    }
                    if (stringArg != null) {
                        TruffleString.Encoding utf8 = TruffleString.Encoding.UTF_8;
                        int len = (stringArg = switchEncodingNode.execute((AbstractTruffleString)stringArg, utf8)).byteLength(utf8);
                        if (len > 1024) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.IOCTL_STRING_ARG_TOO_LONG);
                        }
                        byte[] ioctlArg = new byte[len + 1];
                        copyToByteArrayNode.execute((AbstractTruffleString)stringArg, 0, ioctlArg, 0, len, utf8);
                        this.callIoctlBytes(frame, inliningTarget, fd, request, ioctlArg, true, posixLib, gilNode, constructAndRaiseNode);
                        return factory.createBytes(ioctlArg, len);
                    }
                    intArg = asIntNode.execute((Frame)frame, inliningTarget, arg);
                }
                try {
                    gilNode.release(true);
                    try {
                        buffer = posixLib.ioctlInt(this.getPosixSupport(), fd, request, intArg);
                        return buffer;
                    }
                    finally {
                        gilNode.acquire();
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorUnsupported(frame, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int callIoctlBytes(VirtualFrame frame, Node inliningTarget, int fd, long request, byte[] ioctlArg, boolean releaseGil, PosixSupportLibrary posixLib, GilNode gilNode, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int n;
            block7: {
                if (releaseGil) {
                    gilNode.release(true);
                }
                try {
                    n = posixLib.ioctlBytes(this.getPosixSupport(), fd, request, ioctlArg);
                    if (!releaseGil) break block7;
                    gilNode.acquire();
                }
                catch (Throwable throwable) {
                    try {
                        if (releaseGil) {
                            gilNode.acquire();
                        }
                        throw throwable;
                    }
                    catch (PosixSupportLibrary.PosixException e) {
                        throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                    }
                }
            }
            return n;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FcntlModuleBuiltinsClinicProviders.IoctlNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="lockf", minNumOfPositionalArgs=2, parameterNames={"fd", "cmd", "len", "start", "whence"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversionClass=PosixModuleBuiltins.FileDescriptorConversionNode.class), @ArgumentClinic(name="cmd", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class LockfNode
    extends PythonClinicBuiltinNode {
        LockfNode() {
        }

        @Specialization
        PNone lockf(VirtualFrame frame, int fd, int code, Object lenObj, Object startObj, int whence, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posix, @Cached PyLongAsLongNode asLongNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            int lockType;
            auditNode.audit(inliningTarget, "fcntl.lockf", fd, code, lenObj != PNone.NO_VALUE ? lenObj : PNone.NONE, startObj != PNone.NO_VALUE ? startObj : PNone.NONE, whence);
            if (code == PosixConstants.LOCK_UN.value) {
                lockType = PosixConstants.F_UNLCK.getValueIfDefined();
            } else if ((code & PosixConstants.LOCK_SH.value) != 0) {
                lockType = PosixConstants.F_RDLCK.getValueIfDefined();
            } else if ((code & PosixConstants.LOCK_EX.value) != 0) {
                lockType = PosixConstants.F_WRLCK.getValueIfDefined();
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNRECOGNIZED_LOCKF_ARGUMENT);
            }
            long start = 0L;
            if (startObj != PNone.NO_VALUE) {
                start = asLongNode.execute((Frame)frame, inliningTarget, startObj);
            }
            long len = 0L;
            if (lenObj != PNone.NO_VALUE) {
                len = asLongNode.execute((Frame)frame, inliningTarget, lenObj);
            }
            try {
                posix.fcntlLock(this.getPosixSupport(), fd, (code & PosixConstants.LOCK_NB.value) == 0, lockType, whence, start, len);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FcntlModuleBuiltinsClinicProviders.LockfNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="flock", parameterNames={"fd", "operation"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversionClass=PosixModuleBuiltins.FileDescriptorConversionNode.class), @ArgumentClinic(name="operation", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class FlockNode
    extends PythonBinaryClinicBuiltinNode {
        FlockNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FcntlModuleBuiltinsClinicProviders.FlockNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        synchronized PNone flock(VirtualFrame frame, int fd, int operation, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posix, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "fcntl.flock", fd, operation);
            try {
                posix.flock(this.getPosixSupport(), fd, operation);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }
}

