/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SocketModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.SocketModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.socket.SocketNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.TimeUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.List;

@CoreFunctions(defineModule="_socket")
public final class SocketModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SocketModuleBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    static int findProtocolByName(Node raisingNode, String protocolName) {
        String protoConstant = "IPPROTO_" + protocolName.toUpperCase();
        for (PosixConstants.IntConstant constant : PosixConstants.ipProto) {
            if (!constant.defined || !constant.name.equals(protoConstant)) continue;
            return constant.getValueIfDefined();
        }
        throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.OSError, ErrorMessages.SERVICE_PROTO_NOT_FOUND);
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant("SocketType", (Object)PythonBuiltinClassType.PSocket);
        this.addBuiltinConstant("error", (Object)PythonBuiltinClassType.OSError);
        this.addBuiltinConstant("timeout", (Object)PythonBuiltinClassType.TimeoutError);
        this.addBuiltinConstant("has_ipv6", (Object)true);
        this.addConstant(PosixConstants.SOL_SOCKET);
        this.addBuiltinConstant("SOL_IP", (Object)0);
        this.addBuiltinConstant("SOL_TCP", (Object)6);
        this.addBuiltinConstant("SOL_UDP", (Object)17);
        this.addConstant(PosixConstants.SOMAXCONN);
        this.addConstants(PosixConstants.socketType);
        this.addConstants(PosixConstants.socketFamily);
        this.addConstants(PosixConstants.socketOptions);
        this.addConstants(PosixConstants.gaiFlags);
        this.addConstants(PosixConstants.gaiErrors);
        this.addConstants(PosixConstants.niFlags);
        this.addConstants(PosixConstants.ipProto);
        this.addConstants(PosixConstants.tcpOptions);
        this.addConstants(PosixConstants.shutdownHow);
        this.addConstants(PosixConstants.ip4Address);
        this.addConstants(PosixConstants.ipv6Options);
    }

    @Override
    public void postInitialize(Python3Core core) {
        PythonModule module = core.lookupBuiltinModule(BuiltinNames.T__SOCKET);
        module.setModuleState(-1L);
        if (PosixSupportLibrary.getUncached().getBackend(core.getContext().getPosixSupport()).toJavaStringUncached().equals("java")) {
            module.setAttribute(PythonUtils.toTruffleStringUncached(PosixConstants.AF_UNIX.name), PNone.NO_VALUE);
        }
    }

    private void addConstants(PosixConstants.IntConstant[] constants) {
        for (PosixConstants.IntConstant constant : constants) {
            this.addConstant(constant);
        }
    }

    private void addConstant(PosixConstants.IntConstant constant) {
        if (constant.defined) {
            this.addBuiltinConstant(constant.name, (Object)constant.getValueIfDefined());
        }
    }

    @Builtins(value={@Builtin(name="ntohl", minNumOfPositionalArgs=1), @Builtin(name="htonl", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    static abstract class NToHLNode
    extends PythonUnaryBuiltinNode {
        NToHLNode() {
        }

        @Specialization
        static long convert(VirtualFrame frame, Object xObj, @Bind(value="this") Node inliningTarget, @Cached PyLongAsLongNode asLongNode, @Cached PRaiseNode.Lazy raiseNode) {
            long x = asLongNode.execute((Frame)frame, inliningTarget, xObj);
            if (x < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_CONVERT_NEGATIVE_VALUE_TO_UNSIGNED_INT);
            }
            if (x > 0xFFFFFFFFL) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.INT_LATGER_THAN_32_BITS);
            }
            int i = (int)x;
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                i = Integer.reverseBytes(i);
            }
            return Integer.toUnsignedLong(i);
        }
    }

    @Builtins(value={@Builtin(name="ntohs", minNumOfPositionalArgs=1), @Builtin(name="htons", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    static abstract class NToHSNode
    extends PythonUnaryBuiltinNode {
        NToHSNode() {
        }

        @Specialization
        static int convert(VirtualFrame frame, Object xObj, @Bind(value="this") Node inliningTarget, @Cached PyLongAsIntNode asIntNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode.Lazy raiseNode) {
            int x = asIntNode.execute((Frame)frame, inliningTarget, xObj);
            if (x < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.NTOHS_CANT_CONVERT_NEG_PYTHON_INT);
            }
            if (x > 65535) {
                warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.NTOH_PYTHON_STRING_TOO_LARGE_TO_CONVERT, 1);
            }
            short i = (short)x;
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                i = Short.reverseBytes(i);
            }
            return Short.toUnsignedInt(i);
        }
    }

    @Builtin(name="inet_ntop", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"family", "packed_ip"})
    @ArgumentClinic(name="family", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class InetNtoPNode
    extends PythonBinaryClinicBuiltinNode {
        InetNtoPNode() {
        }

        @Specialization(limit="3")
        static TruffleString doGeneric(VirtualFrame frame, int family, Object obj, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="obj") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(obj, frame, indirectCallData);
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                if (family == PosixConstants.AF_INET.value) {
                    if (len != 4) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ILLEGAL_LENGTH_OF_PACKED_IP_ADDRS);
                    }
                } else if (family == PosixConstants.AF_INET6.value) {
                    if (len != 16) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ILLEGAL_LENGTH_OF_PACKED_IP_ADDRS);
                    }
                } else {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_ADDR_FAMILY, family);
                }
                try {
                    PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                    Object result = posixLib.inet_ntop(posixSupport, family, bytes);
                    TruffleString truffleString = posixLib.getPathAsString(posixSupport, result);
                    return truffleString;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.InetNtoPNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="inet_pton", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"family", "addr"})
    @ArgumentsClinic(value={@ArgumentClinic(name="family", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="addr", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    static abstract class InetPtoNNode
    extends PythonBinaryClinicBuiltinNode {
        InetPtoNNode() {
        }

        @Specialization
        static PBytes doConvert(VirtualFrame frame, int family, TruffleString addr, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                byte[] bytes = posixLib.inet_pton(posixSupport, family, posixLib.createPathFromString(posixSupport, addr));
                return factory.createBytes(bytes);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            catch (PosixSupportLibrary.InvalidAddressException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.ILLEGAL_IP_ADDR_STRING_TO_INET_PTON);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.InetPtoNNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="inet_ntoa", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class InetNtoANode
    extends PythonUnaryBuiltinNode {
        InetNtoANode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        static TruffleString doGeneric(VirtualFrame frame, Object addr, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="addr") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PRaiseNode.Lazy raiseNode) {
            Object buffer = bufferAcquireLib.acquireReadonly(addr, frame, indirectCallData);
            try {
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                if (len != 4) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.PACKED_IP_WRONG_LENGTH, "inet_ntoa");
                }
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                Object result = posixLib.inet_ntoa(posixSupport, ByteArraySupport.bigEndian().getInt(bytes, 0));
                TruffleString truffleString = posixLib.getPathAsString(posixSupport, result);
                return truffleString;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }
    }

    @Builtin(name="inet_aton", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"addr"})
    @ArgumentClinic(name="addr", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class InetAtoNNode
    extends PythonUnaryClinicBuiltinNode {
        InetAtoNNode() {
        }

        @Specialization
        static PBytes doConvert(TruffleString addr, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                int converted = posixLib.inet_aton(posixSupport, posixLib.createPathFromString(posixSupport, addr));
                byte[] bytes = new byte[4];
                ByteArraySupport.bigEndian().putInt(bytes, 0, converted);
                return factory.createBytes(bytes);
            }
            catch (PosixSupportLibrary.InvalidAddressException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.ILLEGAL_IP_ADDR_STRING_TO_INET_ATON);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.InetAtoNNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="dup", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"fd"})
    @GenerateNodeFactory
    static abstract class DupNode
    extends PythonUnaryBuiltinNode {
        DupNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object close(VirtualFrame frame, Object fdObj, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @Cached PyLongAsIntNode asIntNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Integer n;
            int fd = asIntNode.execute((Frame)frame, inliningTarget, fdObj);
            gil.release(true);
            try {
                int dup = posixLib.dup(this.getPosixSupport(), fd);
                try {
                    posixLib.setInheritable(this.getPosixSupport(), dup, false);
                }
                catch (PosixSupportLibrary.PosixException e1) {
                    try {
                        posixLib.close(this.getPosixSupport(), dup);
                    }
                    catch (PosixSupportLibrary.PosixException posixException) {
                        // empty catch block
                    }
                }
                n = dup;
                gil.acquire();
            }
            catch (Throwable throwable) {
                try {
                    gil.acquire();
                    throw throwable;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return n;
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"fd"})
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object close(VirtualFrame frame, Object fdObj, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached GilNode gil, @Cached PyLongAsIntNode asIntNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            block5: {
                int fd = asIntNode.execute((Frame)frame, inliningTarget, fdObj);
                try {
                    gil.release(true);
                    try {
                        posixLib.close(this.getPosixSupport(), fd);
                    }
                    finally {
                        gil.acquire();
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    if (e.getErrorCode() == OSErrorEnum.ECONNRESET.getNumber()) break block5;
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getaddrinfo", minNumOfPositionalArgs=2, parameterNames={"host", "port", "family", "type", "proto", "flags"})
    @ArgumentsClinic(value={@ArgumentClinic(name="family", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="com.oracle.graal.python.runtime.PosixConstants.AF_UNSPEC.value"), @ArgumentClinic(name="type", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="proto", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    public static abstract class GetAddrInfoNode
    extends PythonClinicBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object getAddrInfo(VirtualFrame frame, Object hostObject, Object portObject, int family, int type, int proto, int flags, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary cursorLib, @Cached InlinedExactClassProfile profile, @Cached(value="createIdna()") SocketNodes.IdnaFromStringOrBytesConverterNode idna, @Cached PyLongAsLongNode asLongNode, @Cached CastToTruffleStringNode castToString, @Cached BytesNodes.ToBytesNode toBytes, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached SocketNodes.MakeSockAddrNode makeSockAddrNode, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached TruffleString.FromLongNode fromLongNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupportLibrary.AddrInfoCursor cursor;
            Object port;
            Object portObjectProfiled;
            Object host = null;
            PosixSupport posixSupport = PosixSupport.get(inliningTarget);
            if (hostObject != PNone.NONE) {
                host = posixLib.createPathFromBytes(posixSupport, idna.execute(frame, hostObject));
            }
            if (PGuards.canBeInteger(portObjectProfiled = profile.profile(inliningTarget, portObject))) {
                port = posixLib.createPathFromString(posixSupport, fromLongNode.execute(asLongNode.execute((Frame)frame, inliningTarget, portObjectProfiled), PythonUtils.TS_ENCODING, false));
            } else if (PGuards.isString(portObjectProfiled)) {
                port = posixLib.createPathFromString(posixSupport, castToString.execute(inliningTarget, portObjectProfiled));
            } else if (PGuards.isBytes(portObjectProfiled)) {
                port = posixLib.createPathFromBytes(posixSupport, toBytes.execute(frame, portObjectProfiled));
            } else if (portObject == PNone.NONE) {
                port = null;
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.INT_OR_STRING_EXPECTED);
            }
            auditNode.audit(inliningTarget, "socket.getaddrinfo", hostObject, portObjectProfiled, family, type, proto, flags);
            try {
                gil.release(true);
                try {
                    cursor = posixLib.getaddrinfo(posixSupport, host, port, family, type, proto, flags);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (PosixSupportLibrary.GetAddrInfoException e) {
                throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketGAIError, new Object[]{e.getErrorCode(), e.getMessageAsTruffleString()});
            }
            try {
                SequenceStorage storage = new ObjectSequenceStorage(5);
                do {
                    Object addr = makeSockAddrNode.execute(frame, inliningTarget, cursorLib.getSockAddr(cursor));
                    TruffleString canonName = StringLiterals.T_EMPTY_STRING;
                    if (cursorLib.getCanonName(cursor) != null) {
                        canonName = posixLib.getPathAsString(posixSupport, cursorLib.getCanonName(cursor));
                    }
                    PTuple tuple = factory.createTuple(new Object[]{cursorLib.getFamily(cursor), cursorLib.getSockType(cursor), cursorLib.getProtocol(cursor), canonName, addr});
                    storage = appendNode.execute(inliningTarget, storage, tuple, SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                } while (cursorLib.next(cursor));
                PList pList = factory.createList(storage);
                return pList;
            }
            finally {
                cursorLib.release(cursor);
            }
        }

        @NeverDefault
        protected static SocketNodes.IdnaFromStringOrBytesConverterNode createIdna() {
            return SocketNodes.IdnaFromStringOrBytesConverterNode.create("getaddrinfo", 1);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.GetAddrInfoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="getnameinfo", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"sockaddr", "flags"})
    @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class GetNameInfoNode
    extends PythonBinaryClinicBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object getNameInfo(VirtualFrame frame, PTuple sockaddr, int flags, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoCursorLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLibrary, @Cached GilNode gil, @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached CastToTruffleStringNode castAddress, @Cached PyLongAsIntNode asIntNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached TruffleString.FromLongNode fromLongNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString address;
            SequenceStorage addr = sockaddr.getSequenceStorage();
            int addrLen = addr.length();
            if (addrLen < 2 || addrLen > 4) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ILLEGAL_SOCKET_ADDR_ARG, "getnameinfo()");
            }
            int flowinfo = 0;
            int scopeid = 0;
            Object arg0 = getItem.execute(inliningTarget, addr, 0);
            try {
                address = castAddress.execute(inliningTarget, arg0);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, arg0);
            }
            int port = asIntNode.execute((Frame)frame, inliningTarget, getItem.execute(inliningTarget, addr, 1));
            if (addrLen > 2 && ((flowinfo = asIntNode.execute((Frame)frame, inliningTarget, getItem.execute(inliningTarget, addr, 2))) < 0 || flowinfo > 1048575)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_FLOWINFO_RANGE, "getnameinfo");
            }
            if (addrLen > 3) {
                scopeid = asIntNode.execute((Frame)frame, inliningTarget, getItem.execute(inliningTarget, addr, 3));
            }
            auditNode.audit(inliningTarget, "socket.getnameinfo", sockaddr);
            try {
                PosixSupportLibrary.UniversalSockAddr queryAddr;
                PosixSupportLibrary.UniversalSockAddr resolvedAddr;
                int family;
                gil.release(true);
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                try {
                    PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(posixSupport, posixLib.createPathFromString(posixSupport, address), posixLib.createPathFromString(posixSupport, fromLongNode.execute((long)port, PythonUtils.TS_ENCODING, false)), PosixConstants.AF_UNSPEC.value, PosixConstants.SOCK_DGRAM.value, 0, PosixConstants.AI_NUMERICHOST.value);
                    try {
                        family = addrInfoCursorLib.getFamily(cursor);
                        resolvedAddr = addrInfoCursorLib.getSockAddr(cursor);
                        if (addrInfoCursorLib.next(cursor)) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.SOCKADDR_RESOLVED_TO_MULTIPLE_ADDRESSES);
                        }
                    }
                    finally {
                        addrInfoCursorLib.release(cursor);
                    }
                }
                finally {
                    gil.acquire();
                }
                if (family == PosixConstants.AF_INET.value) {
                    if (addrLen != 2) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.IPV4_MUST_BE_2_TUPLE);
                    }
                    queryAddr = posixLib.createUniversalSockAddrInet4(posixSupport, new PosixSupportLibrary.Inet4SockAddr(port, sockAddrLibrary.asInet4SockAddr(resolvedAddr).getAddress()));
                } else if (family == PosixConstants.AF_INET6.value) {
                    queryAddr = posixLib.createUniversalSockAddrInet6(posixSupport, new PosixSupportLibrary.Inet6SockAddr(port, sockAddrLibrary.asInet6SockAddr(resolvedAddr).getAddress(), flowinfo, scopeid));
                } else {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.UNKNOWN_FAMILY);
                }
                Object[] getnameinfo = posixLib.getnameinfo(posixSupport, queryAddr, flags);
                TruffleString host = posixLib.getPathAsString(posixSupport, getnameinfo[0]);
                TruffleString service = posixLib.getPathAsString(posixSupport, getnameinfo[1]);
                return factory.createTuple(new Object[]{host, service});
            }
            catch (PosixSupportLibrary.GetAddrInfoException e) {
                throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketGAIError, new Object[]{e.getErrorCode(), e.getMessageAsTruffleString()});
            }
        }

        @Fallback
        static Object error(Object sockaddr, Object flags, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.GETNAMEINFO_ARG1_MUST_BE_TUPLE);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.GetNameInfoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="getservbyport", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"port", "protocolname"})
    @ArgumentsClinic(value={@ArgumentClinic(name="port", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="protocolname", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NO_VALUE")})
    @GenerateNodeFactory
    public static abstract class GetServByPortNode
    extends PythonBinaryClinicBuiltinNode {
        public static final TruffleString T_UDP = PythonUtils.tsLiteral("udp");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object getServByPort(int port, Object protocolNameObj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile nonProtocol, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached TruffleString.EqualNode equalNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString truffleString;
            TruffleString protocolName = nonProtocol.profile(inliningTarget, PGuards.isNoValue(protocolNameObj)) ? null : (TruffleString)protocolNameObj;
            if (port < 0 || port > 65535) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_PORT_RANGE, "getservbyport");
            }
            auditNode.audit(inliningTarget, "socket.getservbyport", port, protocolName != null ? protocolName : "");
            gil.release(true);
            try {
                PosixSupportLibrary.UniversalSockAddr addr = posixLib.createUniversalSockAddrInet4(this.getPosixSupport(), new PosixSupportLibrary.Inet4SockAddr(port, PosixConstants.INADDR_ANY.value));
                int flags = 0;
                if (protocolName != null && equalNode.execute((AbstractTruffleString)protocolName, (AbstractTruffleString)T_UDP, PythonUtils.TS_ENCODING)) {
                    flags |= PosixConstants.NI_DGRAM.value;
                }
                Object[] result = posixLib.getnameinfo(this.getPosixSupport(), addr, flags);
                TruffleString name = posixLib.getPathAsString(this.getPosixSupport(), result[1]);
                this.checkName(name);
                truffleString = name;
                gil.acquire();
            }
            catch (Throwable throwable) {
                try {
                    gil.acquire();
                    throw throwable;
                }
                catch (PosixSupportLibrary.GetAddrInfoException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.SERVICE_PROTO_NOT_FOUND);
                }
            }
            return truffleString;
        }

        @CompilerDirectives.TruffleBoundary
        private void checkName(TruffleString name) {
            if (name.toJavaStringUncached().matches("^\\d+$")) {
                throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.OSError, ErrorMessages.SERVICE_PROTO_NOT_FOUND);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.GetServByPortNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="getservbyname", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"servicename", "protocolname"})
    @ArgumentsClinic(value={@ArgumentClinic(name="servicename", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="protocolname", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="PNone.NO_VALUE")})
    @GenerateNodeFactory
    public static abstract class GetServByNameNode
    extends PythonBinaryClinicBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object getServByName(TruffleString serviceName, Object protocolNameObj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noneProtocol, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoCursorLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLibrary, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupportLibrary.AddrInfoCursor cursor;
            TruffleString protocolName = noneProtocol.profile(inliningTarget, PGuards.isNoValue(protocolNameObj)) ? null : (TruffleString)protocolNameObj;
            auditNode.audit(inliningTarget, "socket.getservbyname", serviceName, protocolName != null ? protocolName : "");
            int protocol = 0;
            if (protocolName != null) {
                protocol = SocketModuleBuiltins.findProtocolByName(inliningTarget, toJavaStringNode.execute((AbstractTruffleString)protocolName));
            }
            gil.release(true);
            try {
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                cursor = posixLib.getaddrinfo(posixSupport, null, posixLib.createPathFromString(posixSupport, serviceName), PosixConstants.AF_INET.value, 0, protocol, 0);
            }
            finally {
                gil.acquire();
            }
            try {
                PosixSupportLibrary.UniversalSockAddr addr = addrInfoCursorLib.getSockAddr(cursor);
                Integer n = sockAddrLibrary.asInet4SockAddr(addr).getPort();
                addrInfoCursorLib.release(cursor);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    addrInfoCursorLib.release(cursor);
                    throw throwable;
                }
                catch (PosixSupportLibrary.GetAddrInfoException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OSError, ErrorMessages.SERVICE_PROTO_NOT_FOUND);
                }
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SocketModuleBuiltinsClinicProviders.GetServByNameNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="gethostbyname_ex", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetHostByNameExNode
    extends PythonUnaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object get(VirtualFrame frame, Object nameObj, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoCursorLib, @Bind(value="this") Node inliningTarget, @Cached(value="createIdnaConverter()") SocketNodes.IdnaFromStringOrBytesConverterNode idnaConverter, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            byte[] name = idnaConverter.execute(frame, nameObj);
            auditNode.audit(inliningTarget, "socket.gethostbyname", factory.createTuple(new Object[]{nameObj}));
            PosixSupportLibrary.AddrInfoCursor cursor = posixLib.getaddrinfo(this.getPosixSupport(), posixLib.createPathFromBytes(this.getPosixSupport(), name), null, PosixConstants.AF_INET.value, 0, 0, PosixConstants.AI_CANONNAME.value);
            try {
                TruffleString canonName = posixLib.getPathAsString(this.getPosixSupport(), addrInfoCursorLib.getCanonName(cursor));
                PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addrInfoCursorLib.getSockAddr(cursor));
                TruffleString addr = posixLib.getPathAsString(this.getPosixSupport(), posixLib.inet_ntop(this.getPosixSupport(), PosixConstants.AF_INET.value, inet4SockAddr.getAddressAsBytes()));
                PList aliases = factory.createList();
                PList addrs = factory.createList(new Object[]{addr});
                PTuple pTuple = factory.createTuple(new Object[]{canonName, aliases, addrs});
                addrInfoCursorLib.release(cursor);
                return pTuple;
            }
            catch (Throwable throwable) {
                try {
                    addrInfoCursorLib.release(cursor);
                    throw throwable;
                }
                catch (PosixSupportLibrary.GetAddrInfoException e) {
                    throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketHError, new Object[]{e.getMessageAsTruffleString()});
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
        }

        @NeverDefault
        protected static SocketNodes.IdnaFromStringOrBytesConverterNode createIdnaConverter() {
            return SocketNodes.IdnaFromStringOrBytesConverterNode.create("gethostbyname_ex", 1);
        }
    }

    @Builtin(name="gethostbyname", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=1, parameterNames={"name"})
    @GenerateNodeFactory
    public static abstract class GetHostByNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString getHostByName(VirtualFrame frame, Object nameObj, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary addrLib, @Bind(value="this") Node inliningTarget, @Cached(value="createIdnaConverter()") SocketNodes.IdnaFromStringOrBytesConverterNode idnaConverter, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached SocketNodes.SetIpAddrNode setIpAddrNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            byte[] name = idnaConverter.execute(frame, nameObj);
            auditNode.audit(inliningTarget, "socket.gethostbyname", factory.createTuple(new Object[]{nameObj}));
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, name, PosixConstants.AF_INET.value);
            PosixSupportLibrary.Inet4SockAddr inet4SockAddr = addrLib.asInet4SockAddr(addr);
            try {
                return posixLib.getPathAsString(this.getPosixSupport(), posixLib.inet_ntop(this.getPosixSupport(), PosixConstants.AF_INET.value, inet4SockAddr.getAddressAsBytes()));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @NeverDefault
        protected static SocketNodes.IdnaFromStringOrBytesConverterNode createIdnaConverter() {
            return SocketNodes.IdnaFromStringOrBytesConverterNode.create("gethostbyname", 1);
        }
    }

    @Builtin(name="gethostbyaddr", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetHostByAddrNode
    extends PythonUnaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object doGeneric(VirtualFrame frame, Object ip, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @CachedLibrary(limit="1") PosixSupportLibrary.AddrInfoCursorLibrary addrInfoCursorLib, @CachedLibrary(limit="1") PosixSupportLibrary.UniversalSockAddrLibrary sockAddrLibrary, @Bind(value="this") Node inliningTarget, @Cached(value="createIdnaConverter()") SocketNodes.IdnaFromStringOrBytesConverterNode idnaConverter, @Cached SocketNodes.SetIpAddrNode setIpAddrNode, @Cached SequenceStorageNodes.AppendNode appendNode, @Cached SocketNodes.MakeIpAddrNode makeIpAddrNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "socket.gethostbyaddr", ip);
            PosixSupportLibrary.UniversalSockAddr addr = setIpAddrNode.execute(frame, idnaConverter.execute(frame, ip), PosixConstants.AF_UNSPEC.value);
            int family = sockAddrLibrary.getFamily(addr);
            try {
                Object[] getnameinfoResult = posixLib.getnameinfo(this.getPosixSupport(), addr, PosixConstants.NI_NAMEREQD.value);
                TruffleString hostname = posixLib.getPathAsString(this.getPosixSupport(), getnameinfoResult[0]);
                SequenceStorage storage = new ObjectSequenceStorage(5);
                try {
                    PosixSupportLibrary.AddrInfoCursor cursor;
                    gil.release(true);
                    try {
                        cursor = posixLib.getaddrinfo(this.getPosixSupport(), getnameinfoResult[0], posixLib.createPathFromString(this.getPosixSupport(), StringLiterals.T_ZERO), family, 0, 0, 0);
                    }
                    finally {
                        gil.acquire();
                    }
                    try {
                        do {
                            PosixSupportLibrary.UniversalSockAddr forwardAddr = addrInfoCursorLib.getSockAddr(cursor);
                            storage = appendNode.execute(inliningTarget, storage, makeIpAddrNode.execute(frame, inliningTarget, forwardAddr), SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
                        } while (addrInfoCursorLib.next(cursor));
                    }
                    finally {
                        addrInfoCursorLib.release(cursor);
                    }
                }
                catch (PosixSupportLibrary.GetAddrInfoException getAddrInfoException) {
                    // empty catch block
                }
                return factory.createTuple(new Object[]{hostname, factory.createList(), factory.createList(storage)});
            }
            catch (PosixSupportLibrary.GetAddrInfoException e) {
                throw constructAndRaiseNode.get(inliningTarget).executeWithArgsOnly((Frame)frame, PythonBuiltinClassType.SocketHError, new Object[]{1, e.getMessageAsTruffleString()});
            }
        }

        @NeverDefault
        protected static SocketNodes.IdnaFromStringOrBytesConverterNode createIdnaConverter() {
            return SocketNodes.IdnaFromStringOrBytesConverterNode.create("gethostbyname", 1);
        }
    }

    @Builtin(name="gethostname")
    @GenerateNodeFactory
    public static abstract class GetHostnameNode
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        TruffleString doGeneric(VirtualFrame frame, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            TruffleString truffleString;
            auditNode.audit(inliningTarget, "socket.gethostname", new Object[0]);
            gil.release(true);
            try {
                truffleString = posixLib.getPathAsString(this.getPosixSupport(), posixLib.gethostname(this.getPosixSupport()));
                gil.acquire();
            }
            catch (Throwable throwable) {
                try {
                    gil.acquire();
                    throw throwable;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return truffleString;
        }
    }

    @Builtin(name="setdefaulttimeout", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class SetDefaultTimeoutNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object set(VirtualFrame frame, PythonModule module, Object value, @Bind(value="this") Node inliningTarget, @Cached SocketNodes.ParseTimeoutNode parseTimeoutNode) {
            long timeout = parseTimeoutNode.execute(frame, inliningTarget, value);
            module.setModuleState(timeout);
            return PNone.NONE;
        }
    }

    @Builtin(name="getdefaulttimeout", minNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class GetDefaultTimeoutNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object get(PythonModule module) {
            long timeout = module.getModuleState(Long.class);
            return timeout < 0L ? PNone.NONE : Double.valueOf(TimeUtils.pyTimeAsSecondsDouble(timeout));
        }
    }

    @Builtin(name="socket", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PSocket)
    @GenerateNodeFactory
    public static abstract class SocketNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        Object socket(Object cls) {
            return this.factory().createSocket(cls);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            if (self == PNone.NO_VALUE && arguments.length > 0) {
                return this.socket(arguments[0]);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
        }
    }
}

