/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedWriterBuiltins;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperNodesFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.namespace.PSimpleNamespace;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.StructSequence;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatCheckExactNode;
import com.oracle.graal.python.lib.PyImportImport;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyTraceBackPrintNode;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyUnicodeAsEncodedString;
import com.oracle.graal.python.lib.PyUnicodeFromEncodedObject;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.formatting.IntegerFormatter;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="sys", isEager=true)
public final class SysModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_LICENSE;
    private static final String COMPILE_TIME;
    public static final PNone FRAMEWORK;
    public static final int MAXSIZE = Integer.MAX_VALUE;
    public static final long HASH_MULTIPLIER = 1000003L;
    public static final int HASH_BITS = 61;
    public static final long HASH_MODULUS = 0x1FFFFFFFFFFFFFFFL;
    public static final long HASH_INF = 314159L;
    public static final long HASH_NAN = 0L;
    public static final long HASH_IMAG = 1000003L;
    public static final int INT_DEFAULT_MAX_STR_DIGITS = 4300;
    public static final int INT_MAX_STR_DIGITS_THRESHOLD = 640;
    public static final TruffleString T_CACHE_TAG;
    public static final TruffleString T__MULTIARCH;
    private static final TruffleString[] SYS_PREFIX_ATTRIBUTES;
    private static final TruffleString[] BASE_PREFIX_ATTRIBUTES;
    static final StructSequence.BuiltinTypeDescriptor VERSION_INFO_DESC;
    static final StructSequence.BuiltinTypeDescriptor WINDOWS_VER_DESC;
    static final StructSequence.BuiltinTypeDescriptor FLAGS_DESC;
    static final StructSequence.BuiltinTypeDescriptor FLOAT_INFO_DESC;
    static final StructSequence.BuiltinTypeDescriptor INT_INFO_DESC;
    static final StructSequence.BuiltinTypeDescriptor HASH_INFO_DESC;
    static final StructSequence.BuiltinTypeDescriptor THREAD_INFO_DESC;
    public static final StructSequence.BuiltinTypeDescriptor UNRAISABLEHOOK_ARGS_DESC;
    private static final String[] STDLIB_MODULE_NAMES;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SysModuleBuiltinsFactory.getFactories();
    }

    protected static PSimpleNamespace makeImplementation(PythonObjectFactory factory, PTuple versionInfo, TruffleString gmultiarch) {
        PSimpleNamespace ns = factory.createSimpleNamespace();
        ns.setAttribute(PythonUtils.tsLiteral("name"), PythonLanguage.T_GRAALPYTHON_ID);
        ns.setAttribute(T_CACHE_TAG, PythonUtils.toTruffleStringUncached("graalpy" + PythonLanguage.GRAALVM_MAJOR + PythonLanguage.GRAALVM_MINOR + PythonLanguage.DEV_TAG + "-311"));
        ns.setAttribute(StringLiterals.T_VERSION, versionInfo);
        ns.setAttribute(T__MULTIARCH, gmultiarch);
        ns.setAttribute(PythonUtils.tsLiteral("hexversion"), 51054496);
        return ns;
    }

    @Override
    public void initialize(Python3Core core) {
        StructSequence.initType(core, VERSION_INFO_DESC);
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            StructSequence.initType(core, WINDOWS_VER_DESC);
        }
        StructSequence.initType(core, FLAGS_DESC);
        StructSequence.initType(core, FLOAT_INFO_DESC);
        StructSequence.initType(core, INT_INFO_DESC);
        StructSequence.initType(core, HASH_INFO_DESC);
        StructSequence.initType(core, THREAD_INFO_DESC);
        StructSequence.initType(core, UNRAISABLEHOOK_ARGS_DESC);
        this.addBuiltinConstant("abiflags", (Object)StringLiterals.T_EMPTY_STRING);
        this.addBuiltinConstant("byteorder", (Object)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? StringLiterals.T_LITTLE : StringLiterals.T_BIG));
        this.addBuiltinConstant("copyright", (Object)T_LICENSE);
        PythonObjectFactory factory = PythonObjectFactory.getUncached();
        this.addBuiltinConstant(BuiltinNames.T_MODULES, (Object)factory.createDict());
        this.addBuiltinConstant("path", (Object)factory.createList());
        this.addBuiltinConstant("builtin_module_names", (Object)factory.createTuple(core.builtinModuleNames()));
        this.addBuiltinConstant("maxsize", (Object)Integer.MAX_VALUE);
        PTuple versionInfo = factory.createStructSeq(VERSION_INFO_DESC, 3, 11, 7, PythonLanguage.RELEASE_LEVEL_STRING, 0);
        this.addBuiltinConstant("version_info", (Object)versionInfo);
        this.addBuiltinConstant("api_version", (Object)1013);
        this.addBuiltinConstant("version", (Object)PythonUtils.toTruffleStringUncached("3.11.7 (" + COMPILE_TIME + ")\n[Graal, " + Truffle.getRuntime().getName() + ", Java " + System.getProperty("java.version") + " (" + System.getProperty("os.arch") + ")]"));
        this.addBuiltinConstant("float_info", (Object)factory.createStructSeq(FLOAT_INFO_DESC, Double.MAX_VALUE, 1024, 308, Double.MIN_NORMAL, -1021, -307, 15, 53, Math.ulp(1.0), 2, 1));
        this.addBuiltinConstant("int_info", (Object)factory.createStructSeq(INT_INFO_DESC, 32, 4, 4300, 640));
        this.addBuiltinConstant("hash_info", (Object)factory.createStructSeq(HASH_INFO_DESC, 64, 0x1FFFFFFFFFFFFFFFL, 314159L, 0L, 1000003L, StringLiterals.T_JAVA, 64, 0, 0));
        this.addBuiltinConstant("thread_info", (Object)factory.createStructSeq(THREAD_INFO_DESC, PNone.NONE, PNone.NONE, PNone.NONE));
        this.addBuiltinConstant("maxunicode", (Object)(IntegerFormatter.LIMIT_UNICODE.intValue() - 1));
        PythonOS os = PythonOS.getPythonOS();
        this.addBuiltinConstant("platform", (Object)os.getName());
        if (os == PythonOS.PLATFORM_DARWIN) {
            this.addBuiltinConstant("_framework", (Object)FRAMEWORK);
        }
        TruffleString gmultiarch = StringUtils.cat(PythonUtils.getPythonArch(), StringLiterals.T_DASH, os.getName());
        this.addBuiltinConstant("__gmultiarch", (Object)gmultiarch);
        PFileIO stdin = factory.createFileIO((Object)PythonBuiltinClassType.PFileIO);
        FileIOBuiltins.FileIOInit.internalInit(stdin, PythonUtils.toTruffleStringUncached("<stdin>"), 0, IONodes.IOMode.R);
        this.addBuiltinConstant(BuiltinNames.T_STDIN, (Object)stdin);
        this.addBuiltinConstant(BuiltinNames.T___STDIN__, (Object)stdin);
        PFileIO stdout = factory.createFileIO((Object)PythonBuiltinClassType.PFileIO);
        FileIOBuiltins.FileIOInit.internalInit(stdout, PythonUtils.toTruffleStringUncached("<stdout>"), 1, IONodes.IOMode.W);
        this.addBuiltinConstant(BuiltinNames.T_STDOUT, (Object)stdout);
        this.addBuiltinConstant(BuiltinNames.T___STDOUT__, (Object)stdout);
        PFileIO stderr = factory.createFileIO((Object)PythonBuiltinClassType.PFileIO);
        stderr.setUTF8Write(true);
        FileIOBuiltins.FileIOInit.internalInit(stderr, PythonUtils.toTruffleStringUncached("<stderr>"), 2, IONodes.IOMode.W);
        this.addBuiltinConstant(BuiltinNames.T_STDERR, (Object)stderr);
        this.addBuiltinConstant(BuiltinNames.T___STDERR__, (Object)stderr);
        this.addBuiltinConstant("implementation", (Object)SysModuleBuiltins.makeImplementation(factory, versionInfo, gmultiarch));
        this.addBuiltinConstant("hexversion", (Object)51054496);
        if (os == PythonOS.PLATFORM_WIN32) {
            this.addBuiltinConstant("winver", (Object)PythonUtils.toTruffleStringUncached("3.11"));
        }
        this.addBuiltinConstant("float_repr_style", (Object)"short");
        this.addBuiltinConstant("meta_path", (Object)factory.createList());
        this.addBuiltinConstant("path_hooks", (Object)factory.createList());
        this.addBuiltinConstant("path_importer_cache", (Object)factory.createDict());
        this.addBuiltinConstant("ps1", (Object)">>> ");
        this.addBuiltinConstant("ps2", (Object)"... ");
        this.addBuiltinConstant("_git", (Object)factory.createTuple(new Object[]{PythonLanguage.T_GRAALPYTHON_ID, StringLiterals.T_EMPTY_STRING, StringLiterals.T_EMPTY_STRING}));
        if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            this.addBuiltinConstant("_vpath", (Object)"");
        }
        super.initialize(core);
        this.postInitialize0(core);
    }

    public void postInitialize0(Python3Core core) {
        Object[] path;
        Object[] warnoptions;
        super.postInitialize(core);
        PythonModule sys = core.lookupBuiltinModule(BuiltinNames.T_SYS);
        PythonContext context = core.getContext();
        String[] args = context.getEnv().getApplicationArguments();
        PythonObjectFactory factory = PythonObjectFactory.getUncached();
        sys.setAttribute(PythonUtils.tsLiteral("argv"), factory.createList(SysModuleBuiltins.convertToObjectArray(args)));
        sys.setAttribute(PythonUtils.tsLiteral("orig_argv"), factory.createList(SysModuleBuiltins.convertToObjectArray(PythonOptions.getOrigArgv(core.getContext()))));
        sys.setAttribute(PythonUtils.tsLiteral("stdlib_module_names"), SysModuleBuiltins.createStdLibModulesSet(factory));
        TruffleString prefix = context.getSysPrefix();
        for (TruffleString name : SYS_PREFIX_ATTRIBUTES) {
            sys.setAttribute(name, prefix);
        }
        TruffleString base_prefix = context.getSysBasePrefix();
        for (TruffleString name : BASE_PREFIX_ATTRIBUTES) {
            sys.setAttribute(name, base_prefix);
        }
        sys.setAttribute(PythonUtils.tsLiteral("platlibdir"), PythonUtils.tsLiteral("lib"));
        TruffleString coreHome = context.getCoreHome();
        TruffleString stdlibHome = context.getStdlibHome();
        TruffleString capiHome = context.getCAPIHome();
        if (!ImageInfo.inImageBuildtimeCode()) {
            TruffleString executable = context.getOption(PythonOptions.Executable);
            TruffleString baseExecutable = context.getOption(PythonOptions.BaseExecutable);
            sys.setAttribute(PythonUtils.tsLiteral("executable"), executable);
            sys.setAttribute(PythonUtils.tsLiteral("_base_executable"), baseExecutable.isEmpty() ? executable : baseExecutable);
        }
        sys.setAttribute(PythonUtils.tsLiteral("dont_write_bytecode"), context.getOption(PythonOptions.DontWriteBytecodeFlag));
        TruffleString pycachePrefix = context.getOption(PythonOptions.PyCachePrefix);
        sys.setAttribute(PythonUtils.tsLiteral("pycache_prefix"), pycachePrefix.isEmpty() ? PNone.NONE : pycachePrefix);
        sys.setAttribute(PythonUtils.tsLiteral("_stdlib_dir"), stdlibHome);
        TruffleString strWarnoption = context.getOption(PythonOptions.WarnOptions);
        if (!strWarnoption.isEmpty()) {
            TruffleString[] strWarnoptions = StringUtils.split(strWarnoption, StringLiterals.T_COMMA, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached());
            warnoptions = PythonUtils.convertToObjectArray(strWarnoptions);
        } else {
            warnoptions = PythonUtils.EMPTY_OBJECT_ARRAY;
        }
        sys.setAttribute(PythonUtils.tsLiteral("warnoptions"), factory.createList(warnoptions));
        TruffleLanguage.Env env = context.getEnv();
        TruffleString pythonPath = context.getOption(PythonOptions.PythonPath);
        boolean capiSeparate = !capiHome.equalsUncached((AbstractTruffleString)coreHome, PythonUtils.TS_ENCODING);
        int pathIdx = 0;
        int defaultPathsLen = 2;
        if (capiSeparate) {
            ++defaultPathsLen;
        }
        if (!pythonPath.isEmpty()) {
            TruffleString sep = PythonUtils.toTruffleStringUncached(context.getEnv().getPathSeparator());
            TruffleString[] split = StringUtils.split(pythonPath, sep, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached());
            path = new Object[split.length + defaultPathsLen];
            System.arraycopy(split, 0, path, 0, split.length);
            pathIdx = split.length;
        } else {
            path = new Object[defaultPathsLen];
        }
        path[pathIdx++] = stdlibHome;
        path[pathIdx++] = PythonUtils.toTruffleStringUncached(String.valueOf(coreHome) + env.getFileNameSeparator() + "modules");
        if (capiSeparate) {
            path[pathIdx++] = PythonUtils.toTruffleStringUncached(String.valueOf(capiHome) + env.getFileNameSeparator() + "modules");
        }
        PList sysPaths = factory.createList(path);
        sys.setAttribute(PythonUtils.tsLiteral("path"), sysPaths);
        sys.setAttribute(PythonUtils.tsLiteral("flags"), factory.createStructSeq(FLAGS_DESC, PInt.intValue(context.getOption(PythonOptions.PythonOptimizeFlag) == false), PInt.intValue(context.getOption(PythonOptions.InspectFlag)), PInt.intValue(context.getOption(PythonOptions.TerminalIsInteractive)), PInt.intValue(context.getOption(PythonOptions.PythonOptimizeFlag)), PInt.intValue(context.getOption(PythonOptions.DontWriteBytecodeFlag)), PInt.intValue(context.getOption(PythonOptions.NoUserSiteFlag)), PInt.intValue(context.getOption(PythonOptions.NoSiteFlag)), PInt.intValue(context.getOption(PythonOptions.IgnoreEnvironmentFlag)), PInt.intValue(context.getOption(PythonOptions.VerboseFlag)), 0, PInt.intValue(context.getOption(PythonOptions.QuietFlag)), 0, PInt.intValue(context.getOption(PythonOptions.IsolateFlag)), false, 0, PInt.intValue(context.getOption(PythonOptions.WarnDefaultEncodingFlag)), context.getOption(PythonOptions.SafePathFlag), context.getOption(PythonOptions.IntMaxStrDigits)));
        sys.setAttribute(BuiltinNames.T___EXCEPTHOOK__, sys.getAttribute(BuiltinNames.T_EXCEPTHOOK));
        sys.setAttribute(BuiltinNames.T___UNRAISABLEHOOK__, sys.getAttribute(BuiltinNames.T_UNRAISABLEHOOK));
        sys.setAttribute(BuiltinNames.T___DISPLAYHOOK__, sys.getAttribute(BuiltinNames.T_DISPLAYHOOK));
        sys.setAttribute(BuiltinNames.T___BREAKPOINTHOOK__, sys.getAttribute(BuiltinNames.T_BREAKPOINTHOOK));
    }

    private static PFrozenSet createStdLibModulesSet(PythonObjectFactory factory) {
        EconomicMapStorage storage = EconomicMapStorage.create(STDLIB_MODULE_NAMES.length);
        for (String s : STDLIB_MODULE_NAMES) {
            storage.putUncachedWithJavaEq(s, (Object)PNone.NONE);
        }
        return factory.createFrozenSet(storage);
    }

    private static Object[] convertToObjectArray(String[] src) {
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }
        Object[] result = new Object[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = PythonUtils.toTruffleStringUncached(src[i]);
        }
        return result;
    }

    private static Object[] convertToObjectArray(TruffleString[] arr) {
        if (arr.length == 0) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }
        return Arrays.copyOf(arr, arr.length, Object[].class);
    }

    @Override
    public void postInitialize(Python3Core core) {
        this.postInitialize0(core);
        this.initStd(core);
    }

    @CompilerDirectives.TruffleBoundary
    public void initStd(Python3Core core) {
        PythonObjectSlowPathFactory factory = core.factory();
        GraalPythonModuleBuiltins gp = (GraalPythonModuleBuiltins)core.lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__).getBuiltins();
        TruffleString stdioEncoding = gp.getStdIOEncoding();
        TruffleString stdioError = gp.getStdIOError();
        PosixSupport posixSupport = core.getContext().getPosixSupport();
        PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
        PythonModule sysModule = core.lookupBuiltinModule(BuiltinNames.T_SYS);
        PBuffered reader = factory.createBufferedReader((Object)PythonBuiltinClassType.PBufferedReader);
        BufferedReaderBuiltins.BufferedReaderInit.internalInit(reader, (PFileIO)this.getBuiltinConstant(BuiltinNames.T_STDIN), 8192, factory, posixSupport, posixLib);
        SysModuleBuiltins.setWrapper(BuiltinNames.T_STDIN, BuiltinNames.T___STDIN__, IONodes.T_R, stdioEncoding, stdioError, reader, sysModule, factory);
        PBuffered writer = factory.createBufferedWriter((Object)PythonBuiltinClassType.PBufferedWriter);
        BufferedWriterBuiltins.BufferedWriterInit.internalInit(writer, (PFileIO)this.getBuiltinConstant(BuiltinNames.T_STDOUT), 8192, factory, posixSupport, posixLib);
        SysModuleBuiltins.setWrapper(BuiltinNames.T_STDOUT, BuiltinNames.T___STDOUT__, IONodes.T_W, stdioEncoding, stdioError, writer, sysModule, factory);
        writer = factory.createBufferedWriter((Object)PythonBuiltinClassType.PBufferedWriter);
        BufferedWriterBuiltins.BufferedWriterInit.internalInit(writer, (PFileIO)this.getBuiltinConstant(BuiltinNames.T_STDERR), 8192, factory, posixSupport, posixLib);
        SysModuleBuiltins.setWrapper(BuiltinNames.T_STDERR, BuiltinNames.T___STDERR__, IONodes.T_W, stdioEncoding, StringLiterals.T_BACKSLASHREPLACE, writer, sysModule, factory);
    }

    private static PTextIO setWrapper(TruffleString name, TruffleString specialName, TruffleString mode, TruffleString encoding, TruffleString error, PBuffered buffered, PythonModule sysModule, PythonObjectFactory factory) {
        PTextIO textIOWrapper = factory.createTextIO((Object)PythonBuiltinClassType.PTextIOWrapper);
        TextIOWrapperNodesFactory.TextIOWrapperInitNodeGen.getUncached().execute(null, null, textIOWrapper, buffered, encoding, error, PNone.NONE, true, true);
        SysModuleBuiltins.setAttribute(textIOWrapper, IONodes.T_MODE, mode);
        SysModuleBuiltins.setAttribute(sysModule, name, textIOWrapper);
        SysModuleBuiltins.setAttribute(sysModule, specialName, textIOWrapper);
        return textIOWrapper;
    }

    private static void setAttribute(PythonObject obj, TruffleString key, Object value) {
        obj.setAttribute(key, value);
    }

    public PDict getModules() {
        return (PDict)this.getBuiltinConstant(BuiltinNames.T_MODULES);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getStdErr() {
        return this.getBuiltinConstant(BuiltinNames.T_STDERR);
    }

    @CompilerDirectives.TruffleBoundary
    public Object getStdOut() {
        return this.getBuiltinConstant(BuiltinNames.T_STDOUT);
    }

    static {
        String compile_time;
        T_LICENSE = PythonUtils.tsLiteral("Copyright (c) Oracle and/or its affiliates. Licensed under the Universal Permissive License v 1.0 as shown at http://oss.oracle.com/licenses/upl.");
        FRAMEWORK = PNone.NONE;
        T_CACHE_TAG = PythonUtils.tsLiteral("cache_tag");
        T__MULTIARCH = PythonUtils.tsLiteral("_multiarch");
        try {
            compile_time = new Date(PythonBuiltins.class.getResource("PythonBuiltins.class").openConnection().getLastModified()).toString();
        }
        catch (IOException e) {
            compile_time = "";
        }
        COMPILE_TIME = compile_time;
        SYS_PREFIX_ATTRIBUTES = PythonUtils.tsArray("prefix", "exec_prefix");
        BASE_PREFIX_ATTRIBUTES = PythonUtils.tsArray("base_prefix", "base_exec_prefix");
        VERSION_INFO_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PVersionInfo, "sys.version_info\n\nVersion information as a named tuple.", 5, new String[]{"major", "minor", "micro", "releaselevel", "serial"}, new String[]{"Major release number", "Minor release number", "Patch release number", "'alpha', 'beta', 'candidate', or 'final'", "Serial release number"}, false);
        WINDOWS_VER_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PWindowsVersion, "sys.getwindowsversion\n\nReturn info about the running version of Windows as a named tuple.", 5, new String[]{"major", "minor", "build", "platform", "service_pack", "service_pack_major", "service_pack_minor", "suite_mask", "product_type", "platform_version"}, new String[]{"Major version number", "Minor version number", "Build number", "Operating system platform", "Latest Service Pack installed on the system", "Service Pack major version number", "Service Pack minor version number", "Bit mask identifying available product suites", "System product type", "Diagnostic version number"}, false);
        FLAGS_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PFlags, "sys.flags\n\nFlags provided through command line arguments or environment vars.", 18, new String[]{"debug", "inspect", "interactive", "optimize", "dont_write_bytecode", "no_user_site", "no_site", "ignore_environment", "verbose", "bytes_warning", "quiet", "hash_randomization", "isolated", "dev_mode", "utf8_mode", "warn_default_encoding", "safe_path", "int_max_str_digits"}, new String[]{"-d", "-i", "-i", "-O or -OO", "-B", "-s", "-S", "-E", "-v", "-b", "-q", "-R", "-I", "-X dev", "-X utf8", "-X warn_default_encoding", "-P", "-X int_max_str_digits"}, false);
        FLOAT_INFO_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PFloatInfo, "sys.float_info\n\nA named tuple holding information about the float type. It contains low level\ninformation about the precision and internal representation. Please study\nyour system's :file:`float.h` for more information.", 11, new String[]{"max", "max_exp", "max_10_exp", "min", "min_exp", "min_10_exp", "dig", "mant_dig", "epsilon", "radix", "rounds"}, new String[]{"DBL_MAX -- maximum representable finite float", "DBL_MAX_EXP -- maximum int e such that radix**(e-1) is representable", "DBL_MAX_10_EXP -- maximum int e such that 10**e is representable", "DBL_MIN -- Minimum positive normalized float", "DBL_MIN_EXP -- minimum int e such that radix**(e-1) is a normalized float", "DBL_MIN_10_EXP -- minimum int e such that 10**e is a normalized", "DBL_DIG -- digits", "DBL_MANT_DIG -- mantissa digits", "DBL_EPSILON -- Difference between 1 and the next representable float", "FLT_RADIX -- radix of exponent", "FLT_ROUNDS -- rounding mode"});
        INT_INFO_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PIntInfo, "sys.int_info\n\nA named tuple that holds information about Python's\ninternal representation of integers.  The attributes are read only.", 4, new String[]{"bits_per_digit", "sizeof_digit", "default_max_str_digits", "str_digits_check_threshold"}, new String[]{"size of a digit in bits", "size in bytes of the C type used to represent a digit", "maximum string conversion digits limitation", "minimum positive value for int_max_str_digits"});
        HASH_INFO_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PHashInfo, "hash_info\n\nA named tuple providing parameters used for computing\nhashes. The attributes are read only.", 9, new String[]{"width", "modulus", "inf", "nan", "imag", "algorithm", "hash_bits", "seed_bits", "cutoff"}, new String[]{"width of the type used for hashing, in bits", "prime number giving the modulus on which the hash function is based", "value to be used for hash of a positive infinity", "value to be used for hash of a nan", "multiplier used for the imaginary part of a complex number", "name of the algorithm for hashing of str, bytes and memoryviews", "internal output size of hash algorithm", "seed size of hash algorithm", "small string optimization cutoff"});
        THREAD_INFO_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PThreadInfo, "sys.thread_info\n\nA named tuple holding information about the thread implementation.", 3, new String[]{"name", "lock", "version"}, new String[]{"name of the thread implementation", "name of the lock implementation", "name and version of the thread library"});
        UNRAISABLEHOOK_ARGS_DESC = new StructSequence.BuiltinTypeDescriptor(PythonBuiltinClassType.PUnraisableHookArgs, "UnraisableHookArgs\n\nType used to pass arguments to sys.unraisablehook.", 5, new String[]{"exc_type", "exc_value", "exc_traceback", "err_msg", "object"}, new String[]{"Exception type", "Exception value", "Exception traceback", "Error message", "Object causing the exception"});
        STDLIB_MODULE_NAMES = new String[]{"__future__", "_abc", "_aix_support", "_ast", "_asyncio", "_bisect", "_blake2", "_bootsubprocess", "_bz2", "_codecs", "_codecs_cn", "_codecs_hk", "_codecs_iso2022", "_codecs_jp", "_codecs_kr", "_codecs_tw", "_collections", "_collections_abc", "_compat_pickle", "_compression", "_contextvars", "_crypt", "_csv", "_ctypes", "_curses", "_curses_panel", "_datetime", "_dbm", "_decimal", "_elementtree", "_frozen_importlib", "_frozen_importlib_external", "_functools", "_gdbm", "_hashlib", "_heapq", "_imp", "_io", "_json", "_locale", "_lsprof", "_lzma", "_markupbase", "_md5", "_msi", "_multibytecodec", "_multiprocessing", "_opcode", "_operator", "_osx_support", "_overlapped", "_pickle", "_posixshmem", "_posixsubprocess", "_py_abc", "_pydecimal", "_pyio", "_queue", "_random", "_scproxy", "_sha1", "_sha256", "_sha3", "_sha512", "_signal", "_sitebuiltins", "_socket", "_sqlite3", "_sre", "_ssl", "_stat", "_statistics", "_string", "_strptime", "_struct", "_symtable", "_thread", "_threading_local", "_tkinter", "_tracemalloc", "_uuid", "_warnings", "_weakref", "_weakrefset", "_winapi", "_zoneinfo", "abc", "aifc", "antigravity", "argparse", "array", "ast", "asynchat", "asyncio", "asyncore", "atexit", "audioop", "base64", "bdb", "binascii", "binhex", "bisect", "builtins", "bz2", "cProfile", "calendar", "cgi", "cgitb", "chunk", "cmath", "cmd", "code", "codecs", "codeop", "collections", "colorsys", "compileall", "concurrent", "configparser", "contextlib", "contextvars", "copy", "copyreg", "crypt", "csv", "ctypes", "curses", "dataclasses", "datetime", "dbm", "decimal", "difflib", "dis", "distutils", "doctest", "email", "encodings", "ensurepip", "enum", "errno", "faulthandler", "fcntl", "filecmp", "fileinput", "fnmatch", "fractions", "ftplib", "functools", "gc", "genericpath", "getopt", "getpass", "gettext", "glob", "graphlib", "grp", "gzip", "hashlib", "heapq", "hmac", "html", "http", "idlelib", "imaplib", "imghdr", "imp", "importlib", "inspect", "io", "ipaddress", "itertools", "json", "keyword", "lib2to3", "linecache", "locale", "logging", "lzma", "mailbox", "mailcap", "marshal", "math", "mimetypes", "mmap", "modulefinder", "msilib", "msvcrt", "multiprocessing", "netrc", "nis", "nntplib", "nt", "ntpath", "nturl2path", "numbers", "opcode", "operator", "optparse", "os", "ossaudiodev", "pathlib", "pdb", "pickle", "pickletools", "pipes", "pkgutil", "platform", "plistlib", "poplib", "posix", "posixpath", "pprint", "profile", "pstats", "pty", "pwd", "py_compile", "pyclbr", "pydoc", "pydoc_data", "pyexpat", "queue", "quopri", "random", "re", "readline", "reprlib", "resource", "rlcompleter", "runpy", "sched", "secrets", "select", "selectors", "shelve", "shlex", "shutil", "signal", "site", "smtpd", "smtplib", "sndhdr", "socket", "socketserver", "spwd", "sqlite3", "sre_compile", "sre_constants", "sre_parse", "ssl", "stat", "statistics", "string", "stringprep", "struct", "subprocess", "sunau", "symtable", "sys", "sysconfig", "syslog", "tabnanny", "tarfile", "telnetlib", "tempfile", "termios", "textwrap", "this", "threading", "time", "timeit", "tkinter", "token", "tokenize", "trace", "traceback", "tracemalloc", "tty", "turtle", "turtledemo", "types", "typing", "unicodedata", "unittest", "urllib", "uu", "uuid", "venv", "warnings", "wave", "weakref", "webbrowser", "winreg", "winsound", "wsgiref", "xdrlib", "xml", "xmlrpc", "zipapp", "zipfile", "zipimport", "zlib", "zoneinfo"};
    }

    @Builtin(name="getwindowsversion", minNumOfPositionalArgs=0, os=PythonOS.PLATFORM_WIN32)
    @GenerateNodeFactory
    static abstract class Getwindowsversion
    extends PythonBuiltinNode {
        static int[] CACHED_VERSION_INFO = null;
        static int PLATFORM = 2;

        Getwindowsversion() {
        }

        @Specialization
        PTuple getVersion(@Cached PythonObjectFactory factory) {
            if (CACHED_VERSION_INFO == null) {
                Getwindowsversion.cacheVersion();
            }
            return factory.createStructSeq(WINDOWS_VER_DESC, CACHED_VERSION_INFO[0], CACHED_VERSION_INFO[1], CACHED_VERSION_INFO[2], PLATFORM, StringLiterals.T_EMPTY_STRING, 0, 0, 0, 1, factory.createTuple(CACHED_VERSION_INFO));
        }

        @CompilerDirectives.TruffleBoundary
        static void cacheVersion() {
            String[] winvers = System.getProperty("os.version", "10.0.20000").split("\\.");
            int major = 0;
            int minor = 0;
            int build = 0;
            if (winvers.length > 0) {
                try {
                    major = Integer.parseInt(winvers[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (winvers.length > 1) {
                try {
                    minor = Integer.parseInt(winvers[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (winvers.length > 2) {
                try {
                    build = Integer.parseInt(winvers[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            CACHED_VERSION_INFO = new int[]{major, minor, build};
        }
    }

    @Builtin(name="setdlopenflags", minNumOfPositionalArgs=1, parameterNames={"flags"}, numOfPositionalOnlyArgs=1)
    @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class SetDlopenFlags
    extends PythonUnaryClinicBuiltinNode {
        SetDlopenFlags() {
        }

        @Specialization
        Object set(int flags) {
            this.getContext().setDlopenFlags(flags);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SysModuleBuiltinsClinicProviders.SetDlopenFlagsClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="getdlopenflags")
    @GenerateNodeFactory
    static abstract class GetDlopenFlags
    extends PythonBuiltinNode {
        GetDlopenFlags() {
        }

        @Specialization
        Object get() {
            return this.getContext().getDlopenFlags();
        }
    }

    @Builtin(name="set_int_max_str_digits", minNumOfPositionalArgs=1, parameterNames={"maxdigits"})
    @ArgumentClinic(name="maxdigits", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class SetIntMaxStrDigits
    extends PythonUnaryClinicBuiltinNode {
        SetIntMaxStrDigits() {
        }

        @Specialization
        Object set(int value) {
            this.getContext().setIntMaxStrDigits(value);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SysModuleBuiltinsClinicProviders.SetIntMaxStrDigitsClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="get_int_max_str_digits")
    @GenerateNodeFactory
    static abstract class GetIntMaxStrDigits
    extends PythonBuiltinNode {
        GetIntMaxStrDigits() {
        }

        @Specialization
        int get() {
            return this.getContext().getIntMaxStrDigits();
        }
    }

    @Builtin(name="exit", declaresExplicitSelf=true, minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, doc="exit($module, status=None, /)\n--\n\nExit the interpreter by raising SystemExit(status).\n\nIf the status is omitted or None, it defaults to zero (i.e., success).\nIf the status is an integer, it will be used as the system exit status.\nIf it is another kind of object, it will be printed and the system\nexit status will be one (i.e., failure).")
    @GenerateNodeFactory
    static abstract class ExitNode
    extends PythonBinaryBuiltinNode {
        ExitNode() {
        }

        @Specialization
        static Object exitNoCode(PythonModule sys, PNone status, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseSystemExit(PNone.NONE);
        }

        @Specialization(guards={"!isPNone(status)"})
        static Object exit(VirtualFrame frame, PythonModule sys, Object status, @Bind(value="this") Node inliningTarget, @Cached PyTupleCheckNode tupleCheckNode, @Cached TupleBuiltins.LenNode tupleLenNode, @Cached PyTupleGetItem getItemNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            Object code = status;
            if (tupleCheckNode.execute(inliningTarget, status) && tupleLenNode.executeInt(frame, status) == 1) {
                code = getItemNode.execute(inliningTarget, status, 0);
            }
            throw raiseNode.raiseSystemExit(code);
        }
    }

    @Builtin(name="setswitchinterval", minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="setswitchinterval($module, interval, /)\n--\n\nSet the ideal thread switching delay inside the Python interpreter.\n\nThe actual frequency of switching threads can be lower if the\ninterpreter executes long sequences of uninterruptible code(this is implementation-specific and workload-dependent).\n\nThe parameter must represent the desired switching delay in seconds\nA typical value is 0.005 (5 milliseconds).")
    @GenerateNodeFactory
    static abstract class SetSwitchIntervalNode
    extends PythonBuiltinNode {
        private static final double FACTOR = 1000000.0;

        SetSwitchIntervalNode() {
        }

        @Specialization
        static Object setCheckInterval(VirtualFrame frame, PythonModule sys, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode floatAsDoubleNode, @Cached PRaiseNode.Lazy raiseNode) {
            double interval = floatAsDoubleNode.execute(frame, inliningTarget, arg);
            if (interval <= 0.0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.SWITCH_INTERVAL_MUST_BE_POSITIVE);
            }
            PythonContext.get(inliningTarget).getSysModuleState().setSwitchInterval(1000000.0 * interval);
            return PNone.NONE;
        }
    }

    @Builtin(name="getswitchinterval", minNumOfPositionalArgs=1, declaresExplicitSelf=true, doc="getswitchinterval($module, /)\n--\n\nReturn the current thread switch interval; see sys.setswitchinterval().")
    @GenerateNodeFactory
    static abstract class GetSwitchIntervalNode
    extends PythonBuiltinNode {
        private static final double FACTOR = 1.0E-6;

        GetSwitchIntervalNode() {
        }

        @Specialization
        Object getCheckInterval(PythonModule sys) {
            return 1.0E-6 * this.getContext().getSysModuleState().getSwitchInterval();
        }
    }

    @Builtin(name="setcheckinterval", minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="setcheckinterval($module, n, /)\n--\n\nSet the async event check interval to n instructions.\n\nThis tells the Python interpreter to check for asynchronous events\nevery n instructions.\n\nThis also affects how often thread switches occur.")
    @GenerateNodeFactory
    static abstract class SetCheckIntervalNode
    extends PythonBuiltinNode {
        SetCheckIntervalNode() {
        }

        @Specialization
        static Object setCheckInterval(VirtualFrame frame, PythonModule sys, Object arg, @Bind(value="this") Node inliningTarget, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PyLongAsIntNode longAsIntNode, @Cached PyFloatCheckExactNode floatCheckExactNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (floatCheckExactNode.execute(inliningTarget, arg)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_EXPECTED_GOT_P, "integer", arg);
            }
            try {
                int n = longAsIntNode.execute((Frame)frame, inliningTarget, arg);
                warnNode.warnFormat((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.WARN_DEPRECTATED_SYS_CHECKINTERVAL, new Object[0]);
                PythonContext.get(inliningTarget).getSysModuleState().setCheckInterval(n);
            }
            catch (PException pException) {
                // empty catch block
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getcheckinterval", minNumOfPositionalArgs=1, declaresExplicitSelf=true, doc="getcheckinterval($module, /)\n--\n\nReturn the current check interval; see sys.setcheckinterval().")
    @GenerateNodeFactory
    static abstract class GetCheckIntervalNode
    extends PythonBuiltinNode {
        GetCheckIntervalNode() {
        }

        @Specialization
        Object getCheckInterval(VirtualFrame frame, PythonModule sys, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            warnNode.warnFormat((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.WARN_DEPRECTATED_SYS_CHECKINTERVAL, new Object[0]);
            return this.getContext().getSysModuleState().getCheckInterval();
        }
    }

    @Builtin(name="setrecursionlimit", minNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="setrecursionlimit($module, limit, /)\n--\n\nSet the maximum depth of the Python interpreter stack to n.\n\nThis limit prevents infinite recursion from causing an overflow of the C\nstack and crashing Python.  The highest possible limit is platform-\ndependent.")
    @GenerateNodeFactory
    static abstract class SetRecursionLimitNode
    extends PythonBuiltinNode {
        SetRecursionLimitNode() {
        }

        @Specialization
        static Object setRecLim(VirtualFrame frame, PythonModule sys, Object limit, @Bind(value="this") Node inliningTarget, @Cached PyLongAsIntNode longAsIntNode, @Cached PyFloatCheckExactNode floatCheckExactNode, @Cached PRaiseNode.Lazy raiseNode) {
            int newLimit;
            if (floatCheckExactNode.execute(inliningTarget, limit)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_EXPECTED_GOT_P, "integer", limit);
            }
            try {
                newLimit = longAsIntNode.execute((Frame)frame, inliningTarget, limit);
            }
            catch (PException pe) {
                newLimit = -1;
            }
            if (newLimit < 1) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.REC_LIMIT_GREATER_THAN_1);
            }
            PythonContext.get(inliningTarget).getSysModuleState().setRecursionLimit(newLimit);
            return PNone.NONE;
        }
    }

    @Builtin(name="getrecursionlimit", minNumOfPositionalArgs=1, declaresExplicitSelf=true, doc="getrecursionlimit($module, /)\n--\n\nReturn the current value of the recursion limit.\n\nThe recursion limit is the maximum depth of the Python interpreter\nstack.  This limit prevents infinite recursion from causing an overflow\nof the C stack and crashing Python.")
    @GenerateNodeFactory
    static abstract class GetRecursionLimitNode
    extends PythonBuiltinNode {
        GetRecursionLimitNode() {
        }

        @Specialization
        Object getRecLim(PythonModule sys) {
            return this.getContext().getSysModuleState().getRecursionLimit();
        }
    }

    @Builtin(name="breakpointhook", takesVarKeywordArgs=true, takesVarArgs=true, doc="breakpointhook(*args, **kws)\n\nThis hook function is called by built-in breakpoint().\n")
    @GenerateNodeFactory
    static abstract class BreakpointHookNode
    extends PythonBuiltinNode {
        static final TruffleString T_VAL_PDB_SETTRACE = PythonUtils.tsLiteral("pdb.set_trace");
        static final TruffleString T_MOD_OS = PythonUtils.tsLiteral("os");
        static final TruffleString T_ATTR_ENVIRON = PythonUtils.tsLiteral("environ");

        BreakpointHookNode() {
        }

        private static TruffleString getEnvVar(VirtualFrame frame, Node inliningTarget, PyImportImport importNode, PyObjectGetAttr getAttr, PyObjectCallMethodObjArgs callMethodObjArgs, CastToTruffleStringNode castToStringNode) {
            Object os = importNode.execute(frame, inliningTarget, T_MOD_OS);
            Object environ = getAttr.execute((Frame)frame, inliningTarget, os, T_ATTR_ENVIRON);
            Object var = callMethodObjArgs.execute((Frame)frame, inliningTarget, environ, SpecialMethodNames.T_GET, BuiltinNames.T_PYTHONBREAKPOINT);
            try {
                return castToStringNode.execute(inliningTarget, var);
            }
            catch (CannotCastException cce) {
                return null;
            }
        }

        @Specialization
        Object doHook(VirtualFrame frame, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached PyObjectGetAttr getAttr, @Cached PyImportImport importNode, @Cached PyObjectCallMethodObjArgs callMethodObjArgs, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile, @Cached CastToTruffleStringNode castToStringNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.LastIndexOfCodePointNode lastIndexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode) {
            Object hook;
            Object module;
            TruffleString attrName;
            TruffleString modPath;
            int hookNameLen;
            TruffleString hookName = BreakpointHookNode.getEnvVar(frame, inliningTarget, importNode, getAttr, callMethodObjArgs, castToStringNode);
            if (hookName == null || hookName.isEmpty()) {
                hookName = T_VAL_PDB_SETTRACE;
            }
            if ((hookNameLen = codePointLengthNode.execute((AbstractTruffleString)hookName, PythonUtils.TS_ENCODING)) == 1 && codePointAtIndexNode.execute((AbstractTruffleString)hookName, 0, PythonUtils.TS_ENCODING) == 48) {
                return PNone.NONE;
            }
            int lastDot = lastIndexOfCodePointNode.execute((AbstractTruffleString)hookName, 46, hookNameLen, 0, PythonUtils.TS_ENCODING);
            if (lastDot < 0) {
                modPath = BuiltinNames.T_BUILTINS;
                attrName = hookName;
            } else if (lastDot != 0) {
                modPath = substringNode.execute((AbstractTruffleString)hookName, 0, lastDot, PythonUtils.TS_ENCODING, true);
                attrName = substringNode.execute((AbstractTruffleString)hookName, lastDot + 1, hookNameLen - (lastDot + 1), PythonUtils.TS_ENCODING, true);
            } else {
                warnNode.warnFormat((Frame)frame, (Object)PythonBuiltinClassType.RuntimeWarning, ErrorMessages.WARN_IGNORE_UNIMPORTABLE_BREAKPOINT_S, hookName);
                return PNone.NONE;
            }
            try {
                module = importNode.execute(frame, inliningTarget, modPath);
            }
            catch (PException pe) {
                if (isInstanceNode.executeWith(frame, pe.getUnreifiedException(), (Object)PythonBuiltinClassType.ImportError)) {
                    warnNode.warnFormat((Frame)frame, (Object)PythonBuiltinClassType.RuntimeWarning, ErrorMessages.WARN_IGNORE_UNIMPORTABLE_BREAKPOINT_S, hookName);
                }
                return PNone.NONE;
            }
            try {
                hook = getAttr.execute((Frame)frame, inliningTarget, module, attrName);
            }
            catch (PException pe) {
                if (attrErrorProfile.profileException(inliningTarget, pe, PythonBuiltinClassType.AttributeError)) {
                    warnNode.warnFormat((Frame)frame, (Object)PythonBuiltinClassType.RuntimeWarning, ErrorMessages.WARN_IGNORE_UNIMPORTABLE_BREAKPOINT_S, hookName);
                }
                return PNone.NONE;
            }
            return callNode.execute((Frame)frame, hook, args, keywords);
        }
    }

    @Builtin(name="displayhook", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="displayhook($module, object, /)\n--\n\nPrint an object to sys.stdout and also save it in builtins._")
    @GenerateNodeFactory
    static abstract class DisplayHookNode
    extends PythonBuiltinNode {
        DisplayHookNode() {
        }

        @Specialization
        static Object doHook(VirtualFrame frame, PythonModule sys, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttr setAttr, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile unicodeEncodeErrorProfile, @Cached PyObjectLookupAttr lookupAttr, @Cached PyObjectCallMethodObjArgs callMethodObjArgs, @Cached PyObjectGetAttr getAttr, @Cached CallNode callNode, @Cached PyObjectReprAsObjectNode reprAsObjectNode, @Cached PyObjectStrAsObjectNode strAsObjectNode, @Cached CastToTruffleStringNode castToStringNode, @Cached PyUnicodeAsEncodedString pyUnicodeAsEncodedString, @Cached PyUnicodeFromEncodedObject pyUnicodeFromEncodedObject, @Cached PRaiseNode.Lazy raiseNode) {
            PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
            if (builtins == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_S, "builtins module");
            }
            if (obj == PNone.NONE) {
                return PNone.NONE;
            }
            setAttr.execute((Frame)frame, inliningTarget, builtins, SpecialAttributeNames.T___, PNone.NONE);
            Object stdOut = PyTraceBackPrintNode.objectLookupAttr(frame, inliningTarget, sys, BuiltinNames.T_STDOUT, lookupAttr);
            if (PGuards.isPNone(stdOut)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_S, "sys.stdout");
            }
            Object reprVal = null;
            try {
                reprVal = PyTraceBackPrintNode.objectRepr(frame, inliningTarget, obj, reprAsObjectNode);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.UnicodeEncodeError, unicodeEncodeErrorProfile);
                TruffleString stdoutEncoding = PyTraceBackPrintNode.objectLookupAttrAsString(frame, inliningTarget, stdOut, IONodes.T_ENCODING, lookupAttr, castToStringNode);
                Object reprStr = PyTraceBackPrintNode.objectRepr(frame, inliningTarget, obj, reprAsObjectNode);
                Object encoded = pyUnicodeAsEncodedString.execute(frame, inliningTarget, reprStr, stdoutEncoding, StringLiterals.T_BACKSLASHREPLACE);
                Object buffer = PyTraceBackPrintNode.objectLookupAttr(frame, inliningTarget, stdOut, IONodes.T_BUFFER, lookupAttr);
                if (buffer != null) {
                    callMethodObjArgs.execute((Frame)frame, inliningTarget, buffer, IONodes.T_WRITE, encoded);
                }
                Object escapedStr = pyUnicodeFromEncodedObject.execute((Frame)frame, inliningTarget, encoded, stdoutEncoding, StringLiterals.T_STRICT);
                Object str = PyTraceBackPrintNode.objectStr(frame, inliningTarget, escapedStr, strAsObjectNode);
                PyTraceBackPrintNode.fileWriteString(frame, inliningTarget, stdOut, castToStringNode.execute(inliningTarget, str), getAttr, callNode);
            }
            if (reprVal != null) {
                PyTraceBackPrintNode.fileWriteString(frame, inliningTarget, stdOut, castToStringNode.execute(inliningTarget, reprVal), getAttr, callNode);
            }
            PyTraceBackPrintNode.fileWriteString(frame, inliningTarget, stdOut, StringLiterals.T_NEWLINE, getAttr, callNode);
            setAttr.execute((Frame)frame, inliningTarget, builtins, SpecialAttributeNames.T___, obj);
            return PNone.NONE;
        }
    }

    @Builtin(name="excepthook", minNumOfPositionalArgs=4, maxNumOfPositionalArgs=4, declaresExplicitSelf=true, doc="excepthook($module, exctype, value, traceback, /)\n--\n\nHandle an exception by displaying it with a traceback on sys.stderr.")
    @GenerateNodeFactory
    static abstract class ExceptHookNode
    extends PythonBuiltinNode {
        static final TruffleString T_CAUSE_MESSAGE = PythonUtils.tsLiteral("\nThe above exception was the direct cause of the following exception:\n\n");
        static final TruffleString T_CONTEXT_MESSAGE = PythonUtils.tsLiteral("\nDuring handling of the above exception, another exception occurred:\n\n");
        static final TruffleString T_ATTR_PRINT_FILE_AND_LINE = PythonUtils.tsLiteral("print_file_and_line");
        static final TruffleString T_ATTR_MSG = PythonUtils.tsLiteral("msg");
        static final TruffleString T_ATTR_FILENAME = PythonUtils.tsLiteral("filename");
        static final TruffleString T_ATTR_LINENO = PythonUtils.tsLiteral("lineno");
        static final TruffleString T_ATTR_OFFSET = PythonUtils.tsLiteral("offset");
        static final TruffleString T_ATTR_TEXT = PythonUtils.tsLiteral("text");
        @Node.Child
        private PyTraceBackPrintNode pyTraceBackPrintNode;

        ExceptHookNode() {
        }

        private void printTraceBack(VirtualFrame frame, PythonModule sys, Object out, Object tb) {
            if (this.pyTraceBackPrintNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyTraceBackPrintNode = (PyTraceBackPrintNode)this.insert(PyTraceBackPrintNode.create());
            }
            this.pyTraceBackPrintNode.execute(frame, sys, out, tb);
        }

        private static SyntaxErrData parseSyntaxError(MaterializedFrame frame, Object err) {
            int hold;
            TruffleString fileName = null;
            TruffleString text = null;
            int lineNo = 0;
            int offset = 0;
            Object msg = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, err, T_ATTR_MSG);
            if (msg == PNone.NO_VALUE) {
                return new SyntaxErrData(null, fileName, lineNo, offset, text, true);
            }
            Object v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, err, T_ATTR_FILENAME);
            if (v == PNone.NO_VALUE) {
                return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
            }
            fileName = v == PNone.NONE ? StringLiterals.T_STRING_SOURCE : PyTraceBackPrintNode.castToString(PyTraceBackPrintNode.objectStr((VirtualFrame)frame, v));
            v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, err, T_ATTR_LINENO);
            if (v == PNone.NO_VALUE) {
                return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
            }
            try {
                hold = PyTraceBackPrintNode.longAsInt(frame, v);
            }
            catch (PException pe) {
                return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
            }
            lineNo = hold;
            v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, err, T_ATTR_OFFSET);
            if (v == PNone.NO_VALUE) {
                return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
            }
            if (v == PNone.NONE) {
                offset = -1;
            } else {
                try {
                    hold = PyTraceBackPrintNode.longAsInt(frame, v);
                }
                catch (PException pe) {
                    return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
                }
                offset = hold;
            }
            v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, err, T_ATTR_TEXT);
            if (v == PNone.NO_VALUE) {
                return new SyntaxErrData(msg, fileName, lineNo, offset, text, true);
            }
            text = v == PNone.NONE ? null : PyTraceBackPrintNode.castToString(v);
            return new SyntaxErrData(msg, fileName, lineNo, offset, text, false);
        }

        private static void printErrorText(VirtualFrame frame, Object out, SyntaxErrData syntaxErrData) {
            TruffleString text = PyTraceBackPrintNode.castToString(PyTraceBackPrintNode.objectStr(frame, syntaxErrData.text));
            int textLen = text.codePointLengthUncached(PythonUtils.TS_ENCODING);
            int offset = syntaxErrData.offset;
            if (offset >= 0) {
                int nl;
                if (offset > 0 && offset == textLen && text.codePointAtIndexUncached(offset - 1, PythonUtils.TS_ENCODING) == 10) {
                    --offset;
                }
                while ((nl = text.lastIndexOfCodePointUncached(10, textLen, 0, PythonUtils.TS_ENCODING)) >= 0 && nl < offset) {
                    offset -= nl + 1;
                    text = text.substringUncached(nl + 1, textLen, PythonUtils.TS_ENCODING, true);
                    textLen = text.codePointLengthUncached(PythonUtils.TS_ENCODING);
                }
                if (!text.isEmpty()) {
                    int cp;
                    int idx = 0;
                    while ((cp = text.codePointAtIndexUncached(idx, PythonUtils.TS_ENCODING)) == 32 || cp == 9 || cp == 12) {
                        ++idx;
                        --offset;
                    }
                    text = text.substringUncached(idx, textLen - idx, PythonUtils.TS_ENCODING, true);
                }
            }
            PyTraceBackPrintNode.fileWriteString(frame, out, "    ");
            PyTraceBackPrintNode.fileWriteString(frame, out, text);
            if (text.isEmpty() || text.codePointAtIndexUncached(text.codePointLengthUncached(PythonUtils.TS_ENCODING) - 1, PythonUtils.TS_ENCODING) != 10) {
                PyTraceBackPrintNode.fileWriteString(frame, out, StringLiterals.T_NEWLINE);
            }
            if (offset == -1) {
                return;
            }
            PyTraceBackPrintNode.fileWriteString(frame, out, "    ");
            while (--offset > 0) {
                PyTraceBackPrintNode.fileWriteString(frame, out, " ");
            }
            PyTraceBackPrintNode.fileWriteString(frame, out, "^\n");
        }

        @CompilerDirectives.TruffleBoundary
        void printExceptionRecursive(MaterializedFrame frame, PythonModule sys, Object out, Object value, Set<Object> seen) {
            if (seen != null) {
                ExceptHookNode.add(seen, value);
                if (PyExceptionInstanceCheckNode.executeUncached(value)) {
                    Object cause = ExceptionNodes.GetCauseNode.executeUncached(value);
                    Object context = ExceptionNodes.GetContextNode.executeUncached(value);
                    if (cause != PNone.NONE) {
                        if (ExceptHookNode.notSeen(seen, cause)) {
                            this.printExceptionRecursive(frame, sys, out, cause, seen);
                            PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, T_CAUSE_MESSAGE);
                        }
                    } else if (context != PNone.NONE && !ExceptionNodes.GetSuppressContextNode.executeUncached(value) && ExceptHookNode.notSeen(seen, context)) {
                        this.printExceptionRecursive(frame, sys, out, context, seen);
                        PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, T_CONTEXT_MESSAGE);
                    }
                }
            }
            this.printException(frame, sys, out, value);
        }

        protected void printException(MaterializedFrame frame, PythonModule sys, Object out, Object excValue) {
            TruffleString className;
            Object value = excValue;
            Object type = PyTraceBackPrintNode.getObjectClass(value);
            if (!PGuards.isPBaseException(value)) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, "TypeError: print_exception(): Exception expected for value, ");
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, PyTraceBackPrintNode.getTypeName(type));
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, " found\n");
                return;
            }
            PBaseException exc = (PBaseException)value;
            Object tb = PyTraceBackPrintNode.getExceptionTraceback(exc);
            if (tb instanceof PTraceback) {
                this.printTraceBack((VirtualFrame)frame, sys, out, tb);
            }
            if (PyTraceBackPrintNode.objectHasAttr((VirtualFrame)frame, value, T_ATTR_PRINT_FILE_AND_LINE)) {
                SyntaxErrData syntaxErrData = ExceptHookNode.parseSyntaxError(frame, value);
                if (!syntaxErrData.err) {
                    value = syntaxErrData.message;
                    StringBuilder sb = ExceptHookNode.newStringBuilder("  File \"");
                    ExceptHookNode.append(sb, PyTraceBackPrintNode.castToString(PyTraceBackPrintNode.objectStr((VirtualFrame)frame, syntaxErrData.fileName)), "\", line ", syntaxErrData.lineNo, "\n");
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ExceptHookNode.sbToString(sb));
                    if (syntaxErrData.text != null) {
                        ExceptHookNode.printErrorText((VirtualFrame)frame, out, syntaxErrData);
                    }
                }
            }
            try {
                className = PyTraceBackPrintNode.getTypeName(type);
                className = PyTraceBackPrintNode.classNameNoDot(className);
            }
            catch (PException pe) {
                className = null;
            }
            Object v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, type, SpecialAttributeNames.T___MODULE__);
            if (v == PNone.NO_VALUE || !PGuards.isString(v)) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_VALUE_UNKNOWN);
            } else {
                TruffleString moduleName = PyTraceBackPrintNode.castToString(v);
                if (!moduleName.equalsUncached((AbstractTruffleString)BuiltinNames.T_BUILTINS, PythonUtils.TS_ENCODING)) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, moduleName);
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_DOT);
                }
            }
            if (className == null) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_VALUE_UNKNOWN);
            } else {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, className);
            }
            if (value != PNone.NONE) {
                v = PyTraceBackPrintNode.objectStr((VirtualFrame)frame, value);
                TruffleString s = PyTraceBackPrintNode.tryCastToString(v);
                if (v == null) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ": <exception str() failed>");
                } else if (!PGuards.isString(v) || s != null && !s.isEmpty()) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ": ");
                }
                if (s != null) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, s);
                }
            }
            PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_NEWLINE);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static StringBuilder newStringBuilder(String str) {
            return new StringBuilder(str);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String sbToString(StringBuilder sb) {
            return sb.toString();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static StringBuilder append(StringBuilder sb, Object ... args) {
            for (Object arg : args) {
                sb.append(arg);
            }
            return sb;
        }

        @CompilerDirectives.TruffleBoundary
        static void add(Set<Object> set, Object value) {
            set.add(value);
        }

        @CompilerDirectives.TruffleBoundary
        static boolean notSeen(Set<Object> set, Object value) {
            return !set.contains(value);
        }

        @CompilerDirectives.TruffleBoundary
        static Set<Object> createSet() {
            return new HashSet<Object>();
        }

        @Specialization
        Object doHookWithTb(VirtualFrame frame, PythonModule sys, Object excType, Object value, PTraceback traceBack) {
            PyTraceBackPrintNode.setExceptionTraceback(value, traceBack);
            MaterializedFrame materializedFrame = frame.materialize();
            Object stdErr = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)materializedFrame, sys, BuiltinNames.T_STDERR);
            this.printExceptionRecursive(materializedFrame, sys, stdErr, value, ExceptHookNode.createSet());
            PyTraceBackPrintNode.fileFlush((VirtualFrame)materializedFrame, stdErr);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPTraceback(traceBack)"})
        Object doHookWithoutTb(VirtualFrame frame, PythonModule sys, Object excType, Object value, Object traceBack) {
            MaterializedFrame materializedFrame = frame.materialize();
            Object stdErr = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)materializedFrame, sys, BuiltinNames.T_STDERR);
            this.printExceptionRecursive(materializedFrame, sys, stdErr, value, ExceptHookNode.createSet());
            PyTraceBackPrintNode.fileFlush((VirtualFrame)materializedFrame, stdErr);
            return PNone.NONE;
        }

        @CompilerDirectives.ValueType
        static final class SyntaxErrData {
            final Object message;
            final TruffleString fileName;
            final int lineNo;
            final int offset;
            final TruffleString text;
            final boolean err;

            SyntaxErrData(Object message, TruffleString fileName, int lineNo, int offset, TruffleString text, boolean err) {
                this.message = message;
                this.fileName = fileName;
                this.lineNo = lineNo;
                this.offset = offset;
                this.text = text;
                this.err = err;
            }
        }
    }

    @Builtin(name="unraisablehook", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2, declaresExplicitSelf=true, doc="unraisablehook($module, unraisable, /)\n--\n\nHandle an unraisable exception.\n\nThe unraisable argument has the following attributes:\n\n* exc_type: Exception type.\n* exc_value: Exception value, can be None.\n* exc_traceback: Exception traceback, can be None.\n* err_msg: Error message, can be None.\n* object: Object causing the exception, can be None.")
    @GenerateNodeFactory
    static abstract class UnraisableHookNode
    extends PythonBuiltinNode {
        @Node.Child
        private PyTraceBackPrintNode pyTraceBackPrintNode;

        UnraisableHookNode() {
        }

        private void printTraceBack(VirtualFrame frame, PythonModule sys, Object out, Object tb) {
            if (this.pyTraceBackPrintNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyTraceBackPrintNode = (PyTraceBackPrintNode)this.insert(PyTraceBackPrintNode.create());
            }
            this.pyTraceBackPrintNode.execute(frame, sys, out, tb);
        }

        private void writeUnraisableExc(MaterializedFrame frame, PythonModule sys, Object out, Object excType, Object excValue, Object excTb, Object errMsg, Object obj) {
            TruffleString className;
            if (obj != PNone.NONE) {
                if (errMsg != PNone.NONE) {
                    PyTraceBackPrintNode.fileWriteObject((VirtualFrame)frame, out, errMsg, true);
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ": ");
                } else {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, "Exception ignored in: ");
                }
                if (!PyTraceBackPrintNode.fileWriteObject((VirtualFrame)frame, out, obj, false)) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, "<object repr() failed>");
                }
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_NEWLINE);
            } else if (errMsg != PNone.NONE) {
                PyTraceBackPrintNode.fileWriteObject((VirtualFrame)frame, out, errMsg, true);
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ":\n");
            }
            if (excTb != PNone.NONE) {
                this.printTraceBack((VirtualFrame)frame, sys, out, excTb);
            }
            if (excType == PNone.NONE) {
                return;
            }
            try {
                className = PyTraceBackPrintNode.getTypeName(excType);
                className = PyTraceBackPrintNode.classNameNoDot(className);
            }
            catch (PException pe) {
                className = null;
            }
            Object v = PyTraceBackPrintNode.objectLookupAttr((VirtualFrame)frame, excType, SpecialAttributeNames.T___MODULE__);
            if (v == PNone.NO_VALUE || !PGuards.isString(v)) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_VALUE_UNKNOWN);
            } else {
                TruffleString moduleName = PyTraceBackPrintNode.castToString(v);
                if (!moduleName.equalsUncached((AbstractTruffleString)BuiltinNames.T_BUILTINS, PythonUtils.TS_ENCODING)) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, moduleName);
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_DOT);
                }
            }
            if (className == null) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_VALUE_UNKNOWN);
            } else {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, className);
            }
            if (excValue != PNone.NONE) {
                PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, ": ");
                if (!PyTraceBackPrintNode.fileWriteObject((VirtualFrame)frame, out, excValue, true)) {
                    PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, "<exception str() failed>");
                }
            }
            PyTraceBackPrintNode.fileWriteString((VirtualFrame)frame, out, StringLiterals.T_NEWLINE);
        }

        @Specialization
        Object doit(VirtualFrame frame, PythonModule sys, Object args, @Bind(value="this") Node inliningTarget, @Cached PyTupleGetItem getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object cls = PyTraceBackPrintNode.getObjectClass(args);
            if (cls != PythonBuiltinClassType.PUnraisableHookArgs) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_TYPE_MUST_BE, "sys.unraisablehook", "UnraisableHookArgs");
            }
            Object excType = getItemNode.execute(inliningTarget, args, 0);
            Object excValue = getItemNode.execute(inliningTarget, args, 1);
            Object excTb = getItemNode.execute(inliningTarget, args, 2);
            Object errMsg = getItemNode.execute(inliningTarget, args, 3);
            Object obj = getItemNode.execute(inliningTarget, args, 4);
            Object stdErr = PyTraceBackPrintNode.objectLookupAttr(frame, sys, BuiltinNames.T_STDERR);
            MaterializedFrame materializedFrame = frame.materialize();
            this.writeUnraisableExc(materializedFrame, sys, stdErr, excType, excValue, excTb, errMsg, obj);
            PyTraceBackPrintNode.fileFlush((VirtualFrame)materializedFrame, stdErr);
            return PNone.NONE;
        }
    }

    @Builtin(name="set_coroutine_origin_tracking_depth", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SetCoroOriginTrackingDepth
    extends PythonUnaryBuiltinNode {
        SetCoroOriginTrackingDepth() {
        }

        @Specialization
        Object setCoroDepth(Object newValue) {
            return PNone.NONE;
        }
    }

    @Builtin(name="get_coroutine_origin_tracking_depth")
    @GenerateNodeFactory
    static abstract class GetCoroOriginTrackingDepth
    extends PythonBuiltinNode {
        GetCoroOriginTrackingDepth() {
        }

        @Specialization
        Object getCoroDepth() {
            return 0;
        }
    }

    @Builtin(name="get_asyncgen_hooks")
    @GenerateNodeFactory
    static abstract class GetAsyncgenHooks
    extends PythonBuiltinNode {
        GetAsyncgenHooks() {
        }

        @Specialization
        Object setAsyncgenHooks(@Cached PythonObjectFactory factory) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            Object firstiter = threadState.getAsyncgenFirstIter();
            return factory.createTuple(new Object[]{firstiter == null ? PNone.NONE : firstiter, PNone.NONE});
        }
    }

    @Builtin(name="set_asyncgen_hooks", parameterNames={"firstiter", "finalizer"})
    @GenerateNodeFactory
    static abstract class SetAsyncgenHooks
    extends PythonBuiltinNode {
        SetAsyncgenHooks() {
        }

        @Specialization
        Object setAsyncgenHooks(Object firstIter, Object finalizer) {
            if (firstIter != PNone.NO_VALUE && firstIter != PNone.NONE) {
                this.getContext().getThreadState(this.getLanguage()).setAsyncgenFirstIter(firstIter);
            } else if (firstIter == PNone.NONE) {
                this.getContext().getThreadState(this.getLanguage()).setAsyncgenFirstIter(null);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="getprofile")
    @GenerateNodeFactory
    static abstract class GetProfile
    extends PythonBuiltinNode {
        GetProfile() {
        }

        @Specialization
        Object getProfile() {
            PythonContext ctx = this.getContext();
            PythonContext.PythonThreadState state = ctx.getThreadState(this.getLanguage());
            Object trace = state.getProfileFun();
            return trace == null ? PNone.NONE : trace;
        }
    }

    @Builtin(name="gettrace")
    @GenerateNodeFactory
    static abstract class GetTrace
    extends PythonBuiltinNode {
        GetTrace() {
        }

        @Specialization
        Object gettrace() {
            PythonContext ctx = this.getContext();
            PythonContext.PythonThreadState state = ctx.getThreadState(this.getLanguage());
            Object trace = state.getTraceFun();
            return trace == null ? PNone.NONE : trace;
        }
    }

    @Builtin(name="setprofile", minNumOfPositionalArgs=1, parameterNames={"function"}, doc="Set the profiling function.  It will be called on each function call\nand return.  See the profiler chapter in the library manual.")
    @GenerateNodeFactory
    static abstract class SetProfile
    extends PythonBuiltinNode {
        SetProfile() {
        }

        @Specialization
        Object settrace(Object function) {
            PythonContext ctx = this.getContext();
            PythonLanguage language = this.getLanguage();
            PythonContext.PythonThreadState state = ctx.getThreadState(language);
            if (function == PNone.NONE) {
                state.setProfileFun(null, language);
            } else {
                state.setProfileFun(function, language);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="settrace", minNumOfPositionalArgs=1, parameterNames={"function"}, doc="Set the global debug tracing function.  It will be called on each\nfunction call.  See the debugger chapter in the library manual.")
    @GenerateNodeFactory
    static abstract class SetTrace
    extends PythonBuiltinNode {
        SetTrace() {
        }

        @Specialization
        Object settrace(Object function) {
            PythonContext ctx = this.getContext();
            PythonLanguage language = this.getLanguage();
            PythonContext.PythonThreadState state = ctx.getThreadState(language);
            if (function == PNone.NONE) {
                state.setTraceFun(null, language);
            } else {
                state.setTraceFun(function, language);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="is_finalizing")
    @GenerateNodeFactory
    public static abstract class IsFinalizingNode
    extends PythonBuiltinNode {
        @Specialization
        boolean doGeneric() {
            return this.getContext().isFinalizing();
        }
    }

    @Builtin(name="addaudithook", minNumOfPositionalArgs=1, doc="addaudithook($module, /, hook)\n--\n\nAdds a new audit hook callback.")
    @GenerateNodeFactory
    static abstract class SysAuditHookNode
    extends PythonBuiltinNode {
        SysAuditHookNode() {
        }

        @Specialization
        Object doAudit(VirtualFrame frame, Object hook) {
            return PNone.NONE;
        }
    }

    @Builtin(name="audit", minNumOfPositionalArgs=1, takesVarArgs=true, doc="audit(event, *args)\n\nPasses the event to any audit hooks that are attached.")
    @GenerateNodeFactory
    static abstract class SysAuditNode
    extends PythonBuiltinNode {
        SysAuditNode() {
        }

        @Specialization
        Object doAudit(VirtualFrame frame, Object event, Object[] args) {
            return PNone.NONE;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class AuditNode
    extends Node {
        protected abstract void executeInternal(Node var1, Object var2, Object[] var3);

        public void audit(Node inliningTarget, String event, Object ... arguments) {
            this.executeInternal(inliningTarget, event, arguments);
        }

        public void audit(Node inliningTarget, TruffleString event, Object ... arguments) {
            this.executeInternal(inliningTarget, event, arguments);
        }

        @Specialization
        void doAudit(TruffleString event, Object[] arguments) {
        }

        @Specialization
        void doAudit(String event, Object[] arguments) {
        }
    }

    @Builtin(name="getsizeof", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetsizeofNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(dflt)"})
        static Object doGeneric(VirtualFrame frame, Object object, PNone dflt, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached(value="createWithError()") LookupAndCallUnaryNode callSizeofNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            return GetsizeofNode.checkResult(frame, inliningTarget, asSizeNode, callSizeofNode.executeObject(frame, object), raiseNode);
        }

        @Specialization(guards={"!isNoValue(dflt)"})
        static Object doGeneric(VirtualFrame frame, Object object, Object dflt, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached(value="createWithoutError()") LookupAndCallUnaryNode callSizeofNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callSizeofNode.executeObject(frame, object);
            if (result == PNone.NO_VALUE) {
                return dflt;
            }
            return GetsizeofNode.checkResult(frame, inliningTarget, asSizeNode, result, raiseNode);
        }

        private static Object checkResult(VirtualFrame frame, Node inliningTarget, PyNumberAsSizeNode asSizeNode, Object result, PRaiseNode.Lazy raiseNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, result);
            if (value < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.SHOULD_RETURN, "__sizeof__()", ">= 0");
            }
            return value;
        }

        @NeverDefault
        protected LookupAndCallUnaryNode createWithError() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___SIZEOF__, () -> new LookupAndCallUnaryNode.NoAttributeHandler(){
                @Node.Child
                private PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(Object receiver) {
                    throw this.raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_METHOD, receiver, SpecialMethodNames.T___SIZEOF__);
                }
            });
        }

        @NeverDefault
        protected static LookupAndCallUnaryNode createWithoutError() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___SIZEOF__);
        }
    }

    @Builtin(name="getrefcount", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetrefcountNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static long doGeneric(PythonAbstractObject object, @Cached CStructAccess.ReadI64Node read) {
            if (object instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject nativeKlass = (PythonAbstractNativeObject)object;
                return read.readFromObj(nativeKlass, CFields.PyObject__ob_refcnt);
            }
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper = object.getNativeWrapper();
            if (wrapper == null) {
                return -1L;
            }
            return wrapper.getRefCount();
        }

        @Fallback
        protected long doGeneric(Object object) {
            return -1L;
        }
    }

    @Builtin(name="getdefaultencoding", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetDefaultEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        protected static TruffleString getFileSystemEncoding(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(GetDefaultEncodingNode.defaultCharsetName(), PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static String defaultCharsetName() {
            return Charset.defaultCharset().name();
        }
    }

    @Builtin(name="intern", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class InternNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isPString(s) || isTruffleString(s)"})
        static Object doPString(Object s, @Bind(value="this") Node inliningTarget, @Cached StringNodes.InternStringNode internNode, @Cached PRaiseNode.Lazy raiseNode) {
            PString interned = internNode.execute(inliningTarget, s);
            if (interned == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_INTERN_P, s);
            }
            return interned;
        }

        @Fallback
        static Object doOthers(Object obj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "intern()", "str", obj);
        }
    }

    @Builtin(name="getfilesystemencodeerrors", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetFileSystemEncodeErrorsNode
    extends PythonBuiltinNode {
        @Specialization
        protected static TruffleString getFileSystemEncoding() {
            return StringLiterals.T_SURROGATEESCAPE;
        }
    }

    @Builtin(name="getfilesystemencoding", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetFileSystemEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static TruffleString getFileSystemEncoding() {
            String javaEncoding = System.getProperty("file.encoding");
            TruffleString pythonEncoding = CharsetMapping.getPythonEncodingNameFromJavaName(javaEncoding);
            return pythonEncoding != null ? pythonEncoding : PythonUtils.toTruffleStringUncached(javaEncoding);
        }
    }

    @Builtin(name="_current_frames")
    @GenerateNodeFactory
    static abstract class CurrentFrames
    extends PythonBuiltinNode {
        CurrentFrames() {
        }

        @Specialization
        Object currentFrames(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached AuditNode auditNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached ReadCallerFrameNode readCallerFrameNode, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached PythonObjectFactory factory) {
            auditNode.audit(inliningTarget, "sys._current_frames", new Object[0]);
            if (!this.getLanguage().singleThreadedAssumption.isValid()) {
                warnNode.warn((Frame)frame, (Object)PythonBuiltinClassType.RuntimeWarning, ErrorMessages.WARN_CURRENT_FRAMES_MULTITHREADED);
            }
            PFrame currentFrame = readCallerFrameNode.executeWith(frame, 0);
            PDict result = factory.createDict();
            result.setDictStorage(setHashingStorageItem.execute((Frame)frame, inliningTarget, result.getDictStorage(), PThread.getThreadId(Thread.currentThread()), currentFrame));
            return result;
        }
    }

    @Builtin(name="_getframe", parameterNames={"depth"}, minNumOfPositionalArgs=0, needsFrame=true, alwaysNeedsCallerFrame=true)
    @ArgumentClinic(name="depth", defaultValue="0", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class GetFrameNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return SysModuleBuiltinsClinicProviders.GetFrameNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PFrame counted(VirtualFrame frame, int num, @Bind(value="this") Node inliningTarget, @Cached ReadCallerFrameNode readCallerNode, @Cached InlinedConditionProfile callStackDepthProfile, @Cached PRaiseNode.Lazy raiseNode) {
            PFrame requested = GetFrameNode.escapeFrame(frame, num, readCallerNode);
            if (callStackDepthProfile.profile(inliningTarget, requested == null)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALL_STACK_NOT_DEEP_ENOUGH);
            }
            return requested;
        }

        private static PFrame escapeFrame(VirtualFrame frame, int num, ReadCallerFrameNode readCallerNode) {
            PFrame.Reference currentFrameInfo = PArguments.getCurrentFrameInfo((Frame)frame);
            currentFrameInfo.markAsEscaped();
            return readCallerNode.executeWith(currentFrameInfo, num);
        }
    }

    @Builtin(name="exc_info", needsFrame=true)
    @GenerateNodeFactory
    public static abstract class ExcInfoNode
    extends PythonBuiltinNode {
        @Override
        public abstract PTuple execute(VirtualFrame var1);

        @Specialization
        static PTuple run(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached PythonObjectFactory factory) {
            PException currentException = getCaughtExceptionNode.execute(frame);
            assert (currentException != PException.NO_EXCEPTION);
            if (currentException == null) {
                return factory.createTuple(new PNone[]{PNone.NONE, PNone.NONE, PNone.NONE});
            }
            Object exception = currentException.getEscapedException();
            Object traceback = getTracebackNode.execute(inliningTarget, exception);
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, exception), exception, traceback});
        }

        @NeverDefault
        public static ExcInfoNode create() {
            return SysModuleBuiltinsFactory.ExcInfoNodeFactory.create(null);
        }
    }
}

