/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiMemberAccessNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;

public final class PythonCextTypeBuiltins {

    static abstract class PyTruffleType_AddGetSet
    extends PythonCextBuiltins.CApi7BuiltinNode {
        PyTruffleType_AddGetSet() {
        }

        @Specialization
        static int doGeneric(Object cls, PDict dict, TruffleString name, Object getter, Object setter, Object doc, Object closure, @Bind(value="this") Node inliningTarget, @Cached CreateGetSetNode createGetSetNode, @Cached PyDictSetDefault setDefault) {
            GetSetDescriptor descr = createGetSetNode.execute(inliningTarget, name, cls, getter, setter, doc, closure);
            setDefault.execute(null, inliningTarget, dict, name, descr);
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateGetSetNode
    extends Node {
        CreateGetSetNode() {
        }

        abstract GetSetDescriptor execute(Node var1, TruffleString var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static GetSetDescriptor createGetSet(Node inliningTarget, TruffleString name, Object cls, Object getter, Object setter, Object doc, Object closure, @Cached(inline=false) PythonObjectFactory factory, @CachedLibrary(limit="2") InteropLibrary interopLibrary) {
            boolean hasSetter;
            assert (!(doc instanceof CArrayWrappers.CArrayWrapper));
            PBuiltinFunction get = null;
            if (!interopLibrary.isNull(getter)) {
                RootCallTarget getterCT = CreateGetSetNode.getterCallTarget(name, PythonLanguage.get(inliningTarget));
                getter = CExtContext.ensureExecutable(getter, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
                get = factory.createBuiltinFunction(name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(getter, closure), 0, getterCT);
            }
            PBuiltinFunction set = null;
            boolean bl = hasSetter = !interopLibrary.isNull(setter);
            if (hasSetter) {
                RootCallTarget setterCT = CreateGetSetNode.setterCallTarget(name, PythonLanguage.get(inliningTarget));
                setter = CExtContext.ensureExecutable(setter, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
                set = factory.createBuiltinFunction(name, cls, PythonUtils.EMPTY_OBJECT_ARRAY, ExternalFunctionNodes.createKwDefaults(setter, closure), 0, setterCT);
            }
            GetSetDescriptor descriptor = factory.createGetSetDescriptor(get, set, name, cls, hasSetter);
            WriteAttributeToPythonObjectNode.executeUncached(descriptor, SpecialAttributeNames.T___DOC__, doc);
            return descriptor;
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget getterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.GetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
            return lang.createCachedCallTarget(rootNodeFunction, ExternalFunctionNodes.GetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.GETTER, name, true);
        }

        @CompilerDirectives.TruffleBoundary
        private static RootCallTarget setterCallTarget(TruffleString name, PythonLanguage lang) {
            Function rootNodeFunction = l -> new ExternalFunctionNodes.SetterRoot((PythonLanguage)((Object)l), name, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
            return lang.createCachedCallTarget(rootNodeFunction, ExternalFunctionNodes.SetterRoot.class, ExternalFunctionNodes.PExternalFunctionWrapper.SETTER, name, true);
        }
    }

    public static abstract class PyTruffleType_AddMember
    extends PythonCextBuiltins.CApi7BuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static int addMember(Object clazz, PDict tpDict, TruffleString memberName, int memberType, long offset, int canSet, Object memberDoc) {
            PythonLanguage language = PythonLanguage.get(null);
            PBuiltinFunction getterObject = CApiMemberAccessNodes.ReadMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            PBuiltinFunction setterObject = null;
            if (canSet != 0) {
                setterObject = CApiMemberAccessNodes.WriteMemberNode.createBuiltinFunction(language, clazz, memberName, memberType, (int)offset);
            }
            GetSetDescriptor memberDescriptor = PythonObjectFactory.getUncached().createMemberDescriptor(getterObject, setterObject, memberName, clazz);
            WriteAttributeToPythonObjectNode.getUncached().execute(memberDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            PyDictSetDefault.executeUncached(tpDict, memberName, memberDescriptor);
            return 0;
        }
    }

    static abstract class PyTruffleType_AddSlot
    extends PythonCextBuiltins.CApi7BuiltinNode {
        PyTruffleType_AddSlot() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int addSlot(Object clazz, PDict tpDict, TruffleString memberName, Object cfunc, int flags, int wrapper, Object memberDoc) {
            if (HashingStorageNodes.HashingStorageGetItem.hasKeyUncached(tpDict.getDictStorage(), memberName)) {
                return 0;
            }
            PythonObject wrapperDescriptor = CExtNodes.CreateFunctionNode.executeUncached(memberName, cfunc, wrapper, clazz, flags);
            WriteAttributeToPythonObjectNode.getUncached().execute(wrapperDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            PyDictSetDefault.executeUncached(tpDict, memberName, wrapperDescriptor);
            return 0;
        }
    }

    static abstract class PyTruffleType_AddFunctionToType
    extends PythonCextBuiltins.CApi8BuiltinNode {
        PyTruffleType_AddFunctionToType() {
        }

        @Specialization
        static int classMethod(Object methodDefPtr, Object type, Object dict, TruffleString name, Object cfunc, int flags, int wrapper, Object doc, @Bind(value="this") Node inliningTarget, @Cached NewClassMethodNode newClassMethodNode, @Cached PyDictSetDefault setDefault) {
            Object func = newClassMethodNode.execute(inliningTarget, methodDefPtr, name, cfunc, flags, wrapper, type, doc);
            setDefault.execute(null, inliningTarget, dict, name, func);
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CExtContext.class})
    static abstract class NewClassMethodNode
    extends Node {
        NewClassMethodNode() {
        }

        abstract Object execute(Node var1, Object var2, TruffleString var3, Object var4, Object var5, Object var6, Object var7, Object var8);

        @Specialization(guards={"isClassOrStaticMethod(flags)"})
        static Object classOrStatic(Node inliningTarget, Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Cached(inline=false) PythonObjectFactory factory, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached(inline=false) WriteAttributeToPythonObjectNode writeAttrNode, @Cached.Exclusive @Cached CExtNodes.CreateFunctionNode createFunctionNode) {
            PythonObject func = createFunctionNode.execute(inliningTarget, name, methObj, wrapper, type, flags);
            writeHiddenAttrNode.execute(inliningTarget, func, HiddenAttr.METHOD_DEF_PTR, methodDefPtr);
            PDecoratedMethod function = (flags & 0x10) != 0 ? factory.createClassmethodFromCallableObj(func) : factory.createStaticmethodFromCallableObj(func);
            writeAttrNode.execute(function, SpecialAttributeNames.T___NAME__, name);
            writeAttrNode.execute(function, SpecialAttributeNames.T___DOC__, doc);
            return function;
        }

        @Specialization(guards={"!isClassOrStaticMethod(flags)"})
        static Object doNativeCallable(Node inliningTarget, Object methodDefPtr, TruffleString name, Object methObj, int flags, int wrapper, Object type, Object doc, @Cached PythonCextBuiltins.PyObjectSetAttrNode setattr, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeNode, @Cached.Exclusive @Cached CExtNodes.CreateFunctionNode createFunctionNode) {
            PythonObject func = createFunctionNode.execute(inliningTarget, name, methObj, wrapper, type, flags);
            setattr.execute(inliningTarget, func, SpecialAttributeNames.T___NAME__, name);
            setattr.execute(inliningTarget, func, SpecialAttributeNames.T___DOC__, doc);
            writeNode.execute(inliningTarget, func, HiddenAttr.METHOD_DEF_PTR, methodDefPtr);
            return func;
        }
    }

    static abstract class PyTruffle_Trace_Type
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyTruffle_Trace_Type.class);

        PyTruffle_Trace_Type() {
        }

        @Specialization(limit="3")
        int trace(Object ptr, Object classNameObj, @CachedLibrary(value="ptr") InteropLibrary ptrLib, @CachedLibrary(value="classNameObj") InteropLibrary nameLib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            TruffleString className;
            if (nameLib.isString(classNameObj)) {
                try {
                    className = switchEncodingNode.execute((AbstractTruffleString)nameLib.asTruffleString(classNameObj), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            } else {
                className = null;
            }
            PythonContext context = this.getContext();
            Object primitivePtr = CApiContext.asPointer(ptr, ptrLib);
            context.getCApiContext().traceStaticMemory(primitivePtr, null, className);
            LOGGER.fine(() -> PythonUtils.formatJString("Initializing native type %s (ptr = %s)", className, CApiContext.asHex(primitivePtr)));
            return 0;
        }
    }

    static abstract class PyTruffle_Type_Modified
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffle_Type_Modified() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNoValue(mroTuple)"})
        int doIt(PythonNativeClass clazz, TruffleString name, PNone mroTuple) {
            CyclicAssumption nativeClassStableAssumption = this.getContext().getNativeClassStableAssumption(clazz, false);
            if (nativeClassStableAssumption != null) {
                nativeClassStableAssumption.invalidate("PyType_Modified(\"" + name.toJavaStringUncached() + "\") (without MRO) called");
            }
            SpecialMethodSlot.reinitializeSpecialMethodSlots(PythonNativeClass.cast(clazz), this.getLanguage());
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        int doIt(PythonNativeClass clazz, TruffleString name, PTuple mroTuple, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile profile) {
            SequenceStorage sequenceStorage;
            CyclicAssumption nativeClassStableAssumption = this.getContext().getNativeClassStableAssumption(clazz, false);
            if (nativeClassStableAssumption != null) {
                nativeClassStableAssumption.invalidate("PyType_Modified(\"" + name.toJavaStringUncached() + "\") called");
            }
            if (!((sequenceStorage = (SequenceStorage)profile.profile(inliningTarget, (Object)mroTuple.getSequenceStorage())) instanceof MroSequenceStorage)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("invalid MRO object for native type \"" + name.toJavaStringUncached() + "\"");
            }
            ((MroSequenceStorage)sequenceStorage).lookupChanged();
            SpecialMethodSlot.reinitializeSpecialMethodSlots(PythonNativeClass.cast(clazz), this.getLanguage());
            TpSlots.updateAllSlots(clazz);
            return 0;
        }
    }

    static abstract class PyTruffle_NewTypeDict
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_NewTypeDict() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PDict doGeneric(PythonNativeClass nativeClass) {
            PythonLanguage language = PythonLanguage.get(null);
            NativeTypeDictStorage nativeTypeStore = new NativeTypeDictStorage(language.getEmptyShape());
            PDict dict = PythonObjectFactory.getUncached().createDict(new DynamicObjectStorage(nativeTypeStore));
            HiddenAttr.WriteNode.executeUncached(dict, HiddenAttr.INSTANCESHAPE, language.getShapeForClass(nativeClass));
            return dict;
        }
    }

    static final class NativeTypeDictStorage
    extends DynamicObject {
        public NativeTypeDictStorage(Shape shape) {
            super(shape);
        }
    }

    static abstract class PyTruffle_Compute_Mro
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Compute_Mro() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doIt(PythonNativeClass self, TruffleString className) {
            PythonAbstractClass[] doSlowPath = TypeNodes.ComputeMroNode.doSlowPath(self);
            return PythonObjectFactory.getUncached().createTuple(new MroSequenceStorage(className, doSlowPath));
        }
    }

    @ImportStatic(value={PythonOptions.class})
    static abstract class PyTruffleType_IsSubtype
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleType_IsSubtype() {
        }

        @Specialization
        static int doGeneric(Object a, Object b, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(a, b));
        }
    }

    static abstract class _PyType_Lookup
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyType_Lookup() {
        }

        @Specialization
        Object doGeneric(Object type, Object name, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TypeNodes.GetMroStorageNode getMroStorageNode, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteBorrowedValue, @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached GetDictIfExistsNode getDictIfExistsNode, @CachedLibrary(limit="3") DynamicObjectLibrary dylib, @Cached PyDictGetItem getItem, @Cached PyDictSetItem setItem) {
            TruffleString key = castToTruffleStringNode.castKnownString(inliningTarget, name);
            MroSequenceStorage mro = getMroStorageNode.execute(inliningTarget, type);
            for (int i = 0; i < mro.length(); ++i) {
                PDict dict;
                PythonAbstractClass cls = mro.getPythonClassItemNormalized(i);
                if (cls instanceof PythonAbstractNativeObject) {
                    PDict d;
                    PythonAbstractNativeObject nativeCls = (PythonAbstractNativeObject)cls;
                    Object dictObj = getNativeDict.readFromObj(nativeCls, CFields.PyTypeObject__tp_dict);
                    if (!(dictObj instanceof PDict)) continue;
                    dict = d = (PDict)dictObj;
                } else if (cls instanceof PythonManagedClass) {
                    PythonManagedClass managedCls = (PythonManagedClass)cls;
                    dict = getDictIfExistsNode.execute(managedCls);
                } else {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                Object value = dict == null ? dylib.getOrDefault((DynamicObject)cls, (Object)key, null) : getItem.execute(null, inliningTarget, dict, key);
                if (value == null || value == PNone.NO_VALUE) continue;
                Object promoted = promoteBorrowedValue.execute(inliningTarget, value);
                if (promoted != null) {
                    if (dict == null) {
                        dylib.put((DynamicObject)cls, (Object)key, promoted);
                    } else {
                        setItem.execute(null, inliningTarget, dict, key, promoted);
                    }
                    return promoted;
                }
                return value;
            }
            return this.getNativeNull();
        }
    }
}

