/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.ctypes.CFieldObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerReference;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CField})
public final class CFieldBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CFieldBuiltinsSlotsGen.SLOTS;
    private static final int NO_BITFIELD = 0;
    private static final int NEW_BITFIELD = 1;
    private static final int CONT_BITFIELD = 2;
    private static final int EXPAND_BITFIELD = 3;
    public static final int PFIELD_SIZE = 0;
    public static final int PBITOFS = 1;
    public static final int PSIZE = 2;
    public static final int POFFSET = 3;
    public static final int PALIGN = 4;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CFieldBuiltinsFactory.getFactories();
    }

    static short SWAP_2(short v) {
        return (short)(v >> 8 & 0xFF | v << 8 & 0xFF00);
    }

    static int SWAP_4(int v) {
        return (v & 0xFF) << 24 | (v & 0xFF00) << 8 | (v & 0xFF0000) >> 8 | v >> 24 & 0xFF;
    }

    static long SWAP_8(long v) {
        return (v & 0xFFL) << 56 | (v & 0xFF00L) << 40 | (v & 0xFF0000L) << 24 | (v & 0xFF000000L) << 8 | (v & 0xFF00000000L) >> 8 | (v & 0xFF0000000000L) >> 24 | (v & 0xFF000000000000L) >> 40 | v >> 56 & 0xFFL;
    }

    @ImportStatic(value={FFIType.FieldGet.class})
    @GenerateUncached
    protected static abstract class GetFuncNode
    extends Node {
        protected GetFuncNode() {
        }

        abstract Object execute(FFIType.FieldGet var1, Pointer var2, int var3);

        @Specialization(guards={"getfunc == vBOOL_get"})
        static Object vBOOL_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadShortNode readShortNode) {
            return readShortNode.execute(inliningTarget, ptr) != 0;
        }

        @Specialization(guards={"getfunc == bool_get"})
        static boolean bool_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadByteNode readByteNode) {
            return readByteNode.execute(inliningTarget, ptr) != 0;
        }

        @Specialization(guards={"getfunc == b_get"})
        static int b_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadByteNode readByteNode) {
            return readByteNode.execute(inliningTarget, ptr);
        }

        @Specialization(guards={"getfunc == B_get"})
        static int B_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadByteNode readByteNode) {
            return readByteNode.execute(inliningTarget, ptr) & 0xFF;
        }

        @Specialization(guards={"getfunc == h_get"})
        static int h_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadShortNode readShortNode) {
            return readShortNode.execute(inliningTarget, ptr);
        }

        @Specialization(guards={"getfunc == h_get_sw"})
        static int h_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadShortNode readShortNode) {
            return CFieldBuiltins.SWAP_2(readShortNode.execute(inliningTarget, ptr));
        }

        @Specialization(guards={"getfunc == H_get"})
        static int H_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadShortNode readShortNode) {
            return readShortNode.execute(inliningTarget, ptr) & 0xFFFF;
        }

        @Specialization(guards={"getfunc == H_get_sw"})
        static int H_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadShortNode readShortNode) {
            return CFieldBuiltins.SWAP_2(readShortNode.execute(inliningTarget, ptr)) & 0xFFFF;
        }

        @Specialization(guards={"getfunc == i_get"})
        static int i_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return readIntNode.execute(inliningTarget, ptr);
        }

        @Specialization(guards={"getfunc == i_get_sw"})
        static Object i_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return CFieldBuiltins.SWAP_4(readIntNode.execute(inliningTarget, ptr));
        }

        @Specialization(guards={"getfunc == I_get"})
        static Object I_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return (long)readIntNode.execute(inliningTarget, ptr) & 0xFFFFFFFFL;
        }

        @Specialization(guards={"getfunc == I_get_sw"})
        static Object I_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return (long)CFieldBuiltins.SWAP_4(readIntNode.execute(inliningTarget, ptr)) & 0xFFFFFFFFL;
        }

        @Specialization(guards={"getfunc == l_get"})
        static Object l_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode) {
            return readLongNode.execute(inliningTarget, ptr);
        }

        @Specialization(guards={"getfunc == l_get_sw"})
        static Object l_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode) {
            return CFieldBuiltins.SWAP_8(readLongNode.execute(inliningTarget, ptr));
        }

        @Specialization(guards={"getfunc == L_get"})
        static Object L_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            long val = readLongNode.execute(inliningTarget, ptr);
            return val < 0L ? factory.createInt(PInt.longToUnsignedBigInteger(val)) : Long.valueOf(val);
        }

        @Specialization(guards={"getfunc == L_get_sw"})
        static Object L_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            long val = CFieldBuiltins.SWAP_8(readLongNode.execute(inliningTarget, ptr));
            return val < 0L ? factory.createInt(PInt.longToUnsignedBigInteger(val)) : Long.valueOf(val);
        }

        @Specialization(guards={"getfunc == d_get"})
        static Object d_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadLongNode readLongNode) {
            return Double.longBitsToDouble(readLongNode.execute(inliningTarget, ptr));
        }

        @Specialization(guards={"getfunc == d_get_sw"})
        static double d_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode) {
            byte[] bytes = readBytesNode.execute(inliningTarget, ptr, 8);
            return PythonUtils.ARRAY_ACCESSOR_SWAPPED.getDouble(bytes, 0);
        }

        @Specialization(guards={"getfunc == f_get"})
        static double f_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadIntNode readIntNode) {
            return Float.intBitsToFloat(readIntNode.execute(inliningTarget, ptr));
        }

        @Specialization(guards={"getfunc == f_get_sw"})
        static double f_get_sw(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode) {
            byte[] bytes = readBytesNode.execute(inliningTarget, ptr, 4);
            return PythonUtils.ARRAY_ACCESSOR_SWAPPED.getFloat(bytes, 0);
        }

        @Specialization(guards={"getfunc == O_get"})
        static Object O_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PointerNodes.ReadPythonObject readPythonObject, @Cached PRaiseNode raiseNode) {
            Pointer valuePtr = readPointerNode.execute(inliningTarget, ptr);
            if (valuePtr.isNull()) {
                throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.PY_OBJ_IS_NULL);
            }
            return readPythonObject.execute(inliningTarget, valuePtr);
        }

        @Specialization(guards={"getfunc == c_get"})
        static Object c_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadByteNode readByteNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(new byte[]{readByteNode.execute(inliningTarget, ptr)});
        }

        @Specialization(guards={"getfunc == u_get"})
        static Object u_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            byte[] bytes = readBytesNode.execute(inliningTarget, ptr, CtypesNodes.WCHAR_T_SIZE);
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, CtypesNodes.WCHAR_T_ENCODING, false), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"getfunc == U_get"})
        static Object U_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.WCsLenNode wCsLenNode, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int wcslen = wCsLenNode.execute(inliningTarget, ptr, size / CtypesNodes.WCHAR_T_SIZE);
            byte[] bytes = readBytesNode.execute(inliningTarget, ptr, wcslen * CtypesNodes.WCHAR_T_SIZE);
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, CtypesNodes.WCHAR_T_ENCODING, false), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"getfunc == s_get"})
        static Object s_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.StrLenNode strLenNode, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(readBytesNode.execute(inliningTarget, ptr, strLenNode.execute(inliningTarget, ptr, size)));
        }

        @Specialization(guards={"getfunc == z_get"})
        static Object z_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PointerNodes.StrLenNode strLenNode, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode) {
            Pointer valuePtr = readPointerNode.execute(inliningTarget, ptr);
            if (valuePtr.isNull()) {
                return PNone.NONE;
            }
            byte[] bytes = readBytesNode.execute(inliningTarget, valuePtr, strLenNode.execute(inliningTarget, valuePtr));
            return factory.createBytes(bytes);
        }

        @Specialization(guards={"getfunc == Z_get"})
        static Object Z_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached.Shared @Cached PointerNodes.WCsLenNode wCsLenNode, @Cached.Shared @Cached PointerNodes.ReadBytesNode readBytesNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            Pointer valuePtr = readPointerNode.execute(inliningTarget, ptr);
            if (valuePtr.isNull()) {
                return PNone.NONE;
            }
            byte[] bytes = readBytesNode.execute(inliningTarget, valuePtr, wCsLenNode.execute(inliningTarget, valuePtr, size) * CtypesNodes.WCHAR_T_SIZE);
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, CtypesNodes.WCHAR_T_ENCODING, false), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"getfunc == P_get"})
        static Object P_get(FFIType.FieldGet getfunc, Pointer ptr, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PointerNodes.ReadPointerNode readPointerNode, @Cached PointerNodes.GetPointerValueAsObjectNode getPointerValueAsObjectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Pointer valuePtr = readPointerNode.execute(inliningTarget, ptr);
            if (valuePtr.isNull()) {
                return 0L;
            }
            Object p = getPointerValueAsObjectNode.execute(inliningTarget, valuePtr);
            if (p instanceof Long) {
                long val = (Long)p;
                return val < 0L ? factory.createInt(PInt.longToUnsignedBigInteger(val)) : Long.valueOf(val);
            }
            return factory.createNativeVoidPtr(p);
        }
    }

    @ImportStatic(value={FFIType.class, FFIType.FieldSet.class})
    @GenerateUncached
    protected static abstract class SetFuncNode
    extends Node {
        private static final short VARIANT_FALSE = 0;
        private static final short VARIANT_TRUE = -1;
        private static TruffleString CTYPES_CFIELD_CAPSULE_NAME_PYMEM = PythonUtils.tsLiteral("_ctypes/cfield.c pymem");

        protected SetFuncNode() {
        }

        abstract Object execute(VirtualFrame var1, FFIType.FieldSet var2, Pointer var3, Object var4, int var5);

        @Specialization(guards={"setfunc == b_set || setfunc == B_set"})
        static Object b_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteByteNode writeByteNode) {
            byte val = (byte)asLongNode.execute((Frame)frame, inliningTarget, value);
            writeByteNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == h_set || setfunc == H_set"})
        static Object h_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteShortNode writeShortNode) {
            short val = (short)asLongNode.execute((Frame)frame, inliningTarget, value);
            writeShortNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == h_set_sw || setfunc == H_set_sw"})
        static Object h_set_sw(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteShortNode writeShortNode) {
            short val = (short)asLongNode.execute((Frame)frame, inliningTarget, value);
            val = CFieldBuiltins.SWAP_2(val);
            writeShortNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == i_set || setfunc == I_set"})
        static Object i_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteIntNode writeIntNode) {
            int val = (int)asLongNode.execute((Frame)frame, inliningTarget, value);
            writeIntNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == i_set_sw || setfunc == I_set_sw"})
        static Object i_set_sw(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteIntNode writeIntNode) {
            int val = (int)asLongNode.execute((Frame)frame, inliningTarget, value);
            val = CFieldBuiltins.SWAP_4(val);
            writeIntNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == vBOOL_set"})
        static Object vBOOL_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode, @Cached.Shared @Cached PointerNodes.WriteShortNode writeShortNode) {
            short val = !isTrueNode.execute((Frame)frame, inliningTarget, value) ? (short)0 : -1;
            writeShortNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == bool_set"})
        static Object bool_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectIsTrueNode isTrueNode, @Cached.Shared @Cached PointerNodes.WriteByteNode writeByteNode) {
            byte val = (byte)(isTrueNode.execute((Frame)frame, inliningTarget, value) ? 1 : 0);
            writeByteNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == l_set || setfunc == L_set"})
        static Object l_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteLongNode writeLongNode) {
            long val = asLongNode.execute((Frame)frame, inliningTarget, value);
            writeLongNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == l_set_sw || setfunc == L_set_sw"})
        static Object l_set_sw(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyLongAsLongNode asLongNode, @Cached.Shared @Cached PointerNodes.WriteLongNode writeLongNode) {
            long val = asLongNode.execute((Frame)frame, inliningTarget, value);
            val = CFieldBuiltins.SWAP_8(val);
            writeLongNode.execute(inliningTarget, ptr, val);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == d_set || setfunc == g_set"})
        static Object d_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PointerNodes.WriteLongNode writeLongNode) {
            double x = asDoubleNode.execute(frame, inliningTarget, value);
            writeLongNode.execute(inliningTarget, ptr, Double.doubleToRawLongBits(x));
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == d_set_sw"})
        static Object d_set_sw(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PointerNodes.WriteLongNode writeLongNode) {
            writeLongNode.execute(inliningTarget, ptr, CFieldBuiltins.SWAP_8(Double.doubleToRawLongBits(asDoubleNode.execute(frame, inliningTarget, value))));
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == f_set"})
        static Object f_set(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PointerNodes.WriteIntNode writeIntNode) {
            float x = (float)asDoubleNode.execute(frame, inliningTarget, value);
            writeIntNode.execute(inliningTarget, ptr, Float.floatToRawIntBits(x));
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == f_set_sw"})
        static Object f_set_sw(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Exclusive @Cached PointerNodes.WriteIntNode writeIntNode) {
            writeIntNode.execute(inliningTarget, ptr, CFieldBuiltins.SWAP_4(Float.floatToRawIntBits((float)asDoubleNode.execute(frame, inliningTarget, value))));
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == O_set"})
        static Object O_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            writePointerNode.execute(inliningTarget, ptr, Pointer.pythonObject(value));
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == c_set"})
        static Object c_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached.Exclusive @Cached PointerNodes.WriteByteNode writeByteNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int val;
            PBytesLike bytes;
            if (PGuards.isBytes(value) && (bytes = (PBytesLike)value).getSequenceStorage().length() == 1) {
                byte[] b = getBytes.execute(inliningTarget, bytes.getSequenceStorage());
                writeByteNode.execute(inliningTarget, ptr, b[0]);
                return PNone.NONE;
            }
            if (PGuards.isInteger(value) && (val = ((Integer)value).intValue()) >= 0 && val < 256) {
                writeByteNode.execute(inliningTarget, ptr, (byte)val);
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ONE_CHARACTER_BYTES_BYTEARRAY_INTEGER_EXPECTED);
        }

        @Specialization(guards={"setfunc == u_set"})
        static Object u_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode toString, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached.Exclusive @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (!PGuards.isString(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNICODE_STRING_EXPECTED_INSTEAD_OF_P_INSTANCE, value);
            }
            TruffleString str = switchEncodingNode.execute((AbstractTruffleString)toString.execute(inliningTarget, value), CtypesNodes.WCHAR_T_ENCODING);
            InternalByteArray bytes = getInternalByteArrayNode.execute((AbstractTruffleString)str, CtypesNodes.WCHAR_T_ENCODING);
            if (bytes.getLength() != CtypesNodes.WCHAR_T_SIZE) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.ONE_CHARACTER_UNICODE_EXPECTED);
            }
            writeBytesNode.execute(inliningTarget, ptr, bytes.getArray(), bytes.getOffset(), bytes.getLength());
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == U_set"})
        static Object U_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode toString, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached.Exclusive @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (!PGuards.isString(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNICODE_STRING_EXPECTED_INSTEAD_OF_P_INSTANCE, value);
            }
            TruffleString str = switchEncodingNode.execute((AbstractTruffleString)toString.execute(inliningTarget, value), CtypesNodes.WCHAR_T_ENCODING);
            InternalByteArray bytes = getInternalByteArrayNode.execute((AbstractTruffleString)str, CtypesNodes.WCHAR_T_ENCODING);
            if (bytes.getLength() > size) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.STR_TOO_LONG, bytes.getLength(), size);
            }
            writeBytesNode.execute(inliningTarget, ptr, bytes.getArray(), bytes.getOffset(), bytes.getLength());
            return value;
        }

        @Specialization(guards={"setfunc == s_set"})
        static Object s_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int length, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesWithoutFrameNode getBytes, @Cached.Exclusive @Cached PointerNodes.WriteBytesNode writeBytesNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (!PGuards.isPBytes(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_BYTES_P_FOUND, value);
            }
            byte[] data = getBytes.execute(inliningTarget, value);
            int size = data.length;
            if (size < length) {
                ++size;
            } else if (size > length) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.BYTES_TOO_LONG, size, length);
            }
            writeBytesNode.execute(inliningTarget, ptr, data);
            return PNone.NONE;
        }

        @Specialization(guards={"setfunc == z_set"})
        static Object z_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (value == PNone.NONE) {
                writePointerNode.execute(inliningTarget, ptr, Pointer.NULL);
                return PNone.NONE;
            }
            if (longCheckNode.execute(inliningTarget, value)) {
                writePointerNode.execute(inliningTarget, ptr, pointerFromLongNode.execute(inliningTarget, value));
                return PNone.NONE;
            }
            if (PGuards.isPBytes(value)) {
                int len = bufferLib.getBufferLength(value);
                byte[] bytes = new byte[len + 1];
                bufferLib.readIntoByteArray(value, 0, bytes, 0, len);
                Pointer valuePtr = Pointer.bytes(bytes);
                writePointerNode.execute(inliningTarget, ptr, valuePtr);
                new PointerReference(value, valuePtr, PythonContext.get(inliningTarget).getSharedFinalizer());
                return value;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BYTES_OR_INT_ADDR_EXPECTED_INSTEAD_OF_P, value);
        }

        @Specialization(guards={"setfunc == Z_set"})
        static Object Z_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode toString, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (value == PNone.NONE) {
                writePointerNode.execute(inliningTarget, ptr, Pointer.NULL);
                return PNone.NONE;
            }
            if (longCheckNode.execute(inliningTarget, value)) {
                writePointerNode.execute(inliningTarget, ptr, pointerFromLongNode.execute(inliningTarget, value));
                return PNone.NONE;
            }
            if (!PGuards.isString(value)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.UNICODE_STR_OR_INT_ADDR_EXPECTED_INSTEAD_OF_P, value);
            }
            TruffleString str = switchEncodingNode.execute((AbstractTruffleString)toString.execute(inliningTarget, value), CtypesNodes.WCHAR_T_ENCODING);
            int byteLength = str.byteLength(CtypesNodes.WCHAR_T_ENCODING);
            byte[] bytes = new byte[byteLength + CtypesNodes.WCHAR_T_SIZE];
            copyToByteArrayNode.execute((AbstractTruffleString)str, 0, bytes, 0, byteLength, CtypesNodes.WCHAR_T_ENCODING);
            Pointer valuePtr = Pointer.bytes(bytes);
            writePointerNode.execute(inliningTarget, ptr, valuePtr);
            return SetFuncNode.createPyMemCapsule(valuePtr, factory);
        }

        @Specialization(guards={"setfunc == P_set"})
        static Object P_set(FFIType.FieldSet setfunc, Pointer ptr, Object value, int size, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyLongCheckNode longCheckNode, @Cached.Exclusive @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached.Exclusive @Cached PointerNodes.WritePointerNode writePointerNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Pointer valuePtr;
            if (value == PNone.NONE) {
                valuePtr = Pointer.NULL;
            } else if (longCheckNode.execute(inliningTarget, value)) {
                valuePtr = pointerFromLongNode.execute(inliningTarget, value);
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_BE_CONVERTED_TO_POINTER);
            }
            writePointerNode.execute(inliningTarget, ptr, valuePtr);
            return PNone.NONE;
        }

        @Fallback
        static Object error(VirtualFrame frame, FFIType.FieldSet setfunc, Pointer ptr, Object value, int size) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.getUncached().raise(PythonErrorType.NotImplementedError, PythonUtils.toTruffleStringUncached("Field setter %s is not supported yet."), setfunc.name());
        }

        private static PyCapsule createPyMemCapsule(Pointer pointer, PythonObjectFactory factory) {
            PyCapsule capsule = factory.createCapsule(pointer, CTYPES_CFIELD_CAPSULE_NAME_PYMEM);
            new PointerReference((Object)capsule, pointer, PythonContext.get(factory).getSharedFinalizer());
            return capsule;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PyCFieldFromDesc
    extends Node {
        PyCFieldFromDesc() {
        }

        abstract CFieldObject execute(Node var1, Object var2, int var3, int var4, int var5, boolean var6, int[] var7, PythonObjectFactory var8);

        @Specialization
        static CFieldObject PyCField_FromDesc(Node inliningTarget, Object desc, int index, int bitsize, int pack, boolean big_endian, int[] props, PythonObjectFactory factory, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject adict;
            int fieldtype;
            CFieldObject self = factory.createCFieldObject((Object)PythonBuiltinClassType.CField);
            StgDictObject dict = pyTypeStgDictNode.execute(inliningTarget, desc);
            if (dict == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.HAS_NO_STGINFO);
            }
            if (bitsize != 0 && props[0] != 0 && dict.size * 8 <= props[0] && props[1] + bitsize <= props[0]) {
                fieldtype = 2;
            } else if (bitsize != 0 && props[0] != 0 && dict.size * 8 >= props[0] && props[1] + bitsize <= dict.size * 8) {
                fieldtype = 3;
            } else if (bitsize != 0) {
                fieldtype = 1;
                props[1] = 0;
                props[0] = dict.size * 8;
            } else {
                fieldtype = 0;
                props[1] = 0;
                props[0] = 0;
            }
            int size = dict.size;
            FFIType.FieldSet setfunc = FFIType.FieldSet.nil;
            FFIType.FieldGet getfunc = FFIType.FieldGet.nil;
            if (pyTypeCheck.isPyCArrayTypeObject(inliningTarget, desc) && (adict = pyTypeStgDictNode.execute(inliningTarget, desc)) != null && adict.proto != null) {
                FFIType.FieldDesc fd;
                StgDictObject idict = pyTypeStgDictNode.execute(inliningTarget, adict.proto);
                if (idict == null) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.HAS_NO_STGINFO);
                }
                if (idict.getfunc == FFIType.FieldDesc.c.getfunc) {
                    fd = FFIType.FieldDesc.s;
                    getfunc = fd.getfunc;
                    setfunc = fd.setfunc;
                }
                if (idict.getfunc == FFIType.FieldDesc.u.getfunc) {
                    fd = FFIType.FieldDesc.U;
                    getfunc = fd.getfunc;
                    setfunc = fd.setfunc;
                }
            }
            self.setfunc = setfunc;
            self.getfunc = getfunc;
            self.index = index;
            self.proto = desc;
            switch (fieldtype) {
                case 1: {
                    self.size = big_endian ? (bitsize << 16) + props[0] - props[1] - bitsize : (bitsize << 16) + props[1];
                    props[1] = bitsize;
                }
                case 0: {
                    int align = pack != 0 ? Math.min(pack, dict.align) : dict.align;
                    if (align != 0 && props[3] % align != 0) {
                        int delta = align - props[3] % align;
                        props[2] = props[2] + delta;
                        props[3] = props[3] + delta;
                    }
                    if (bitsize == 0) {
                        self.size = size;
                    }
                    props[2] = props[2] + size;
                    self.offset = props[3];
                    props[3] = props[3] + size;
                    props[4] = align;
                    break;
                }
                case 3: {
                    props[3] = props[3] + (dict.size - props[0] / 8);
                    props[2] = props[2] + (dict.size - props[0] / 8);
                    props[0] = dict.size * 8;
                    self.size = big_endian ? (bitsize << 16) + props[0] - props[1] - bitsize : (bitsize << 16) + props[1];
                    self.offset = props[3] - size;
                    props[1] = props[1] + bitsize;
                    break;
                }
                case 2: {
                    self.size = big_endian ? (bitsize << 16) + props[0] - props[1] - bitsize : (bitsize << 16) + props[1];
                    self.offset = props[3] - size;
                    props[1] = props[1] + bitsize;
                }
            }
            return self;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString PyCField_repr(CFieldObject self, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            int bits = self.size >> 16;
            int size = self.size & 0xFFFF;
            TruffleString name = getNameNode.execute(inliningTarget, self.proto);
            if (bits != 0) {
                return simpleTruffleStringFormatNode.format("<Field type=%s, ofs=%d:%d, bits=%d>", name, self.offset, size, bits);
            }
            return simpleTruffleStringFormatNode.format("<Field type=%s, ofs=%d, size=%d>", name, self.offset, size);
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_get)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class GetNode
    extends TpSlotDescrGet.DescrGetBuiltinNode {
        GetNode() {
        }

        @Specialization
        static Object doit(CFieldObject self, Object inst, Object type, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile instIsNoValueProfile, @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached PRaiseNode.Lazy raiseNode) {
            if (instIsNoValueProfile.profile(inliningTarget, inst == PNone.NO_VALUE)) {
                return self;
            }
            if (!pyTypeCheck.isCDataObject(inliningTarget, inst)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NOT_A_CTYPE_INSTANCE);
            }
            CDataObject src = (CDataObject)inst;
            return pyCDataGetNode.execute(inliningTarget, self.proto, self.getfunc, src, self.index, self.size, src.b_ptr.withOffset(self.offset));
        }
    }

    @Slot(value=Slot.SlotKind.tp_descr_set, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DescrSet
    extends TpSlotDescrSet.DescrSetBuiltinNode {
        @Specialization(guards={"!isNoValue(value)"})
        static void doit(VirtualFrame frame, CFieldObject self, Object inst, Object value, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached CDataTypeBuiltins.PyCDataSetNode cDataSetNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!pyTypeCheck.isCDataObject(inliningTarget, inst)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.NOT_A_CTYPE_INSTANCE);
            }
            CDataObject dst = (CDataObject)inst;
            cDataSetNode.execute(frame, dst, self.proto, self.setfunc, value, self.index, self.size, dst.b_ptr.withOffset(self.offset));
        }

        @Specialization(guards={"!isNoValue(value)"})
        @HostCompilerDirectives.InliningCutoff
        static void doit(CFieldObject self, Object inst, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANT_DELETE_ATTRIBUTE);
        }
    }

    @Builtin(name="size", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SizeNode
    extends PythonUnaryBuiltinNode {
        SizeNode() {
        }

        @Specialization
        Object doit(CFieldObject self) {
            return self.size;
        }
    }

    @Builtin(name="offset", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class OffsetNode
    extends PythonUnaryBuiltinNode {
        OffsetNode() {
        }

        @Specialization
        Object doit(CFieldObject self) {
            return self.offset;
        }
    }
}

