/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.functools.PPartial;
import com.oracle.graal.python.builtins.modules.functools.PartialBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictCheckExactNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.DeleteDictNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PPartial})
public final class PartialBuiltins
extends PythonBuiltins {
    public static Object[] getNewPartialArgs(PPartial partial, Object[] args, Node inliningTarget, InlinedConditionProfile hasArgsProfile) {
        return PartialBuiltins.getNewPartialArgs(partial, args, inliningTarget, hasArgsProfile, 0);
    }

    public static Object[] getNewPartialArgs(PPartial partial, Object[] args, Node inliningTarget, InlinedConditionProfile hasArgsProfile, int offset) {
        Object[] newArgs;
        Object[] pArgs = partial.getArgs();
        if (hasArgsProfile.profile(inliningTarget, args.length > offset)) {
            newArgs = new Object[pArgs.length + args.length - offset];
            PythonUtils.arraycopy(pArgs, 0, newArgs, 0, pArgs.length);
            PythonUtils.arraycopy(args, offset, newArgs, pArgs.length, args.length - offset);
        } else {
            newArgs = pArgs;
        }
        return newArgs;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PartialBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class PartialReprNode
    extends PythonUnaryBuiltinNode {
        PartialReprNode() {
        }

        private static void reprArgs(VirtualFrame frame, Node inliningTarget, PPartial partial, TruffleStringBuilder sb, PyObjectReprAsTruffleStringNode reprNode, TruffleStringBuilder.AppendStringNode appendStringNode) {
            for (Object arg : partial.getArgs()) {
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, arg));
            }
        }

        private static void reprKwArgs(VirtualFrame frame, Node inliningTarget, PPartial partial, TruffleStringBuilder sb, PyObjectReprAsTruffleStringNode reprNode, PyObjectStrAsTruffleStringNode strNode, HashingStorageNodes.HashingStorageGetIterator getHashingStorageIterator, HashingStorageNodes.HashingStorageIteratorNext hashingStorageIteratorNext, HashingStorageNodes.HashingStorageIteratorKey hashingStorageIteratorKey, HashingStorageNodes.HashingStorageGetItem getItem, TruffleStringBuilder.AppendStringNode appendStringNode) {
            PDict kwDict = partial.getKw();
            if (kwDict != null) {
                HashingStorage storage = kwDict.getDictStorage();
                HashingStorageNodes.HashingStorageIterator it = getHashingStorageIterator.execute(inliningTarget, storage);
                while (hashingStorageIteratorNext.execute(inliningTarget, storage, it)) {
                    Object key = hashingStorageIteratorKey.execute(inliningTarget, storage, it);
                    Object value = getItem.execute((Frame)frame, inliningTarget, storage, key);
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    appendStringNode.execute(sb, (AbstractTruffleString)strNode.execute((Frame)frame, inliningTarget, key));
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EQ);
                    appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, value));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static TruffleString repr(VirtualFrame frame, PPartial partial, @Bind(value="this") Node inliningTarget, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached GetClassNode classNode, @Cached TypeNodes.GetNameNode nameNode, @Cached ObjectNodes.GetFullyQualifiedClassNameNode classNameNode, @Cached HashingStorageNodes.HashingStorageGetIterator getHashingStorageIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext hashingStorageIteratorNext, @Cached HashingStorageNodes.HashingStorageIteratorKey hashingStorageIteratorKey, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            Object cls = classNode.execute(inliningTarget, partial);
            TruffleString name = cls == PythonBuiltinClassType.PPartial ? classNameNode.execute((Frame)frame, inliningTarget, partial) : nameNode.execute(inliningTarget, cls);
            PythonContext ctxt = PythonContext.get(classNameNode);
            if (!ctxt.reprEnter(partial)) {
                return StringLiterals.T_ELLIPSIS;
            }
            try {
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(sb, (AbstractTruffleString)name);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
                appendStringNode.execute(sb, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, partial.getFn()));
                PartialReprNode.reprArgs(frame, inliningTarget, partial, sb, reprNode, appendStringNode);
                PartialReprNode.reprKwArgs(frame, inliningTarget, partial, sb, reprNode, strNode, getHashingStorageIterator, hashingStorageIteratorNext, hashingStorageIteratorKey, getItem, appendStringNode);
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(partial);
            }
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class PartialCallNode
    extends PythonVarargsBuiltinNode {
        protected PartialCallNode() {
        }

        private static int indexOf(PKeyword[] keywords, PKeyword kw) {
            for (int i = 0; i < keywords.length; ++i) {
                if (!keywords[i].getName().equals((Object)kw.getName())) continue;
                return i;
            }
            return -1;
        }

        protected boolean withKeywords(PKeyword[] keywords) {
            return keywords.length > 0;
        }

        @Specialization(guards={"!self.hasKw(inliningTarget, lenNode)"})
        static Object callWoDict(VirtualFrame frame, PPartial self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile hasArgsProfile, @Cached.Shared @Cached CallVarargsMethodNode callNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            Object[] callArgs = PartialBuiltins.getNewPartialArgs(self, args, inliningTarget, hasArgsProfile);
            return callNode.execute((Frame)frame, self.getFn(), callArgs, keywords);
        }

        @Specialization(guards={"self.hasKw(inliningTarget, lenNode)", "!withKeywords(keywords)"})
        static Object callWDictWoKw(VirtualFrame frame, PPartial self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExpandKeywordStarargsNode starargsNode, @Cached.Shared @Cached InlinedConditionProfile hasArgsProfile, @Cached.Shared @Cached CallVarargsMethodNode callNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            Object[] callArgs = PartialBuiltins.getNewPartialArgs(self, args, inliningTarget, hasArgsProfile);
            return callNode.execute((Frame)frame, self.getFn(), callArgs, starargsNode.execute(inliningTarget, self.getKw()));
        }

        @Specialization(guards={"self.hasKw(inliningTarget, lenNode)", "withKeywords(keywords)"})
        static Object callWDictWKw(VirtualFrame frame, PPartial self, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ExpandKeywordStarargsNode starargsNode, @Cached.Shared @Cached InlinedConditionProfile hasArgsProfile, @Cached.Shared @Cached CallVarargsMethodNode callNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            Object[] callArgs = PartialBuiltins.getNewPartialArgs(self, args, inliningTarget, hasArgsProfile);
            PKeyword[] pKeywords = starargsNode.execute(inliningTarget, self.getKw());
            PKeyword[] callKeywords = PKeyword.create(pKeywords.length + keywords.length);
            PythonUtils.arraycopy(pKeywords, 0, callKeywords, 0, pKeywords.length);
            int kwIndex = pKeywords.length;
            for (PKeyword kw : keywords) {
                int idx = PartialCallNode.indexOf(pKeywords, kw);
                if (idx == -1) {
                    callKeywords[kwIndex] = kw;
                    ++kwIndex;
                    continue;
                }
                callKeywords[idx] = kw;
            }
            callKeywords = PythonUtils.arrayCopyOfRange(callKeywords, 0, kwIndex);
            return callNode.execute((Frame)frame, self.getFn(), callArgs, callKeywords);
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class PartialSetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PPartial self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDictNode, @Cached DeleteDictNode deleteDictNode, @Cached SequenceNodes.GetSequenceStorageNode storageNode, @Cached SequenceStorageNodes.ToArrayNode arrayNode, @Cached PyCallableCheckNode callableCheckNode, @Cached PyTupleCheckExactNode tupleCheckExactNode, @Cached PyDictCheckExactNode dictCheckExactNode, @Cached PyTupleGetItem getItemNode, @Cached TupleNodes.ConstructTupleNode constructTupleNode, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageCopy copyStorageNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (state.getSequenceStorage().length() != 4) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_PARTIAL_STATE);
            }
            Object function = getItemNode.execute(inliningTarget, state, 0);
            Object fnArgs = getItemNode.execute(inliningTarget, state, 1);
            Object fnKwargs = getItemNode.execute(inliningTarget, state, 2);
            Object dict = getItemNode.execute(inliningTarget, state, 3);
            if (!callableCheckNode.execute(inliningTarget, function) || !PGuards.isPTuple(fnArgs) || fnKwargs != PNone.NONE && !PGuards.isDict(fnKwargs)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_PARTIAL_STATE);
            }
            self.setFn(function);
            PTuple fnArgsTuple = !tupleCheckExactNode.execute(inliningTarget, fnArgs) ? constructTupleNode.execute(frame, fnArgs) : (PTuple)fnArgs;
            self.setArgs(inliningTarget, fnArgsTuple, storageNode, arrayNode);
            PDict fnKwargsDict = fnKwargs == PNone.NONE ? factory.createDict() : (!dictCheckExactNode.execute(inliningTarget, fnKwargs) ? factory.createDict(copyStorageNode.execute(inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, fnKwargs))) : (PDict)fnKwargs);
            self.setKw(fnKwargsDict);
            if (dict == PNone.NONE) {
                deleteDictNode.execute(self);
            } else {
                assert (dict instanceof PDict);
                setDictNode.execute(inliningTarget, self, (PDict)dict);
            }
            return PNone.NONE;
        }

        @Fallback
        static Object fallback(Object self, Object state, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INVALID_PARTIAL_STATE);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class PartialReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PPartial self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached GetDictIfExistsNode getDictIfExistsNode, @Cached GetOrCreateDictNode getOrCreateDictNode, @Cached PythonObjectFactory factory) {
            PDict dict = self.getShape().getPropertyCount() > 0 ? getOrCreateDictNode.execute(inliningTarget, self) : getDictIfExistsNode.execute(self);
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple fnTuple = factory.createTuple(new Object[]{self.getFn()});
            PTuple argsTuple = factory.createTuple(new Object[]{self.getFn(), self.getArgsTuple(factory), self.getKw(), dict != null ? dict : PNone.NONE});
            return factory.createTuple(new Object[]{type, fnTuple, argsTuple});
        }
    }

    @Builtin(name="keywords", minNumOfPositionalArgs=1, isGetter=true, doc="dictionary of keyword arguments to future partial calls")
    @GenerateNodeFactory
    public static abstract class PartialKeywordsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGet(PPartial self, @Cached PythonObjectFactory factory) {
            return self.getOrCreateKw(factory);
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class PartialDictNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(mapping)"})
        static Object getDict(PPartial self, PNone mapping, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization
        static Object setDict(PPartial self, PDict mapping, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        static Object setDict(PPartial self, Object mapping, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }
    }

    @Builtin(name="args", minNumOfPositionalArgs=1, isGetter=true, doc="tuple of arguments to future partial calls")
    @GenerateNodeFactory
    public static abstract class PartialArgsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGet(PPartial self, @Cached PythonObjectFactory factory) {
            return self.getArgsTuple(factory);
        }
    }

    @Builtin(name="func", minNumOfPositionalArgs=1, isGetter=true, doc="function object to use in future partial calls")
    @GenerateNodeFactory
    public static abstract class PartialFuncNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGet(PPartial self) {
            return self.getFn();
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, varArgsMarker=true, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PPartial, doc="partial(func, *args, **keywords) - new function with partial application\nof the given arguments and keywords.\n")
    @GenerateNodeFactory
    public static abstract class PartialNewNode
    extends PythonBuiltinNode {
        protected boolean isPartialWithoutDict(Node inliningTarget, GetDictIfExistsNode getDict, Object[] args, HashingStorageNodes.HashingStorageLen lenNode, boolean withKwDict) {
            return this.isPartialWithoutDict(getDict, args) && withKwDict == ((PPartial)args[0]).hasKw(inliningTarget, lenNode);
        }

        protected boolean isPartialWithoutDict(GetDictIfExistsNode getDict, Object[] args) {
            return getDict.execute(args[0]) == null && args[0] instanceof PPartial;
        }

        protected boolean withKeywords(PKeyword[] keywords) {
            return keywords.length > 0;
        }

        protected boolean atLeastOneArg(Object[] args) {
            return args.length >= 1;
        }

        @Specialization(guards={"atLeastOneArg(args)", "isPartialWithoutDict(inliningTarget, getDict, args, lenNode, false)"}, limit="1")
        static Object createFromPartialWoDictWoKw(Object cls, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached InlinedConditionProfile hasArgsProfile, @Cached.Exclusive @Cached InlinedConditionProfile hasKeywordsProfile, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            assert (args[0] instanceof PPartial);
            PPartial function = (PPartial)args[0];
            Object[] funcArgs = PartialBuiltins.getNewPartialArgs(function, args, inliningTarget, hasArgsProfile, 1);
            PDict funcKwDict = hasKeywordsProfile.profile(inliningTarget, keywords.length > 0) ? factory.createDict(keywords) : factory.createDict();
            return factory.createPartial(cls, function.getFn(), funcArgs, funcKwDict);
        }

        @Specialization(guards={"atLeastOneArg(args)", "isPartialWithoutDict(inliningTarget, getDict, args, lenNode, true)", "!withKeywords(keywords)"}, limit="1")
        static Object createFromPartialWoDictWKw(Object cls, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached InlinedConditionProfile hasArgsProfile, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            assert (args[0] instanceof PPartial);
            PPartial function = (PPartial)args[0];
            Object[] funcArgs = PartialBuiltins.getNewPartialArgs(function, args, inliningTarget, hasArgsProfile, 1);
            return factory.createPartial(cls, function.getFn(), funcArgs, function.getKwCopy(inliningTarget, factory, copyNode));
        }

        @Specialization(guards={"atLeastOneArg(args)", "isPartialWithoutDict(inliningTarget, getDict, args, lenNode, true)", "withKeywords(keywords)"}, limit="1")
        static Object createFromPartialWoDictWKwKw(VirtualFrame frame, Object cls, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached InlinedConditionProfile hasArgsProfile, @Cached.Exclusive @Cached HashingStorage.InitNode initNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageCopy copyHashingStorageNode, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            assert (args[0] instanceof PPartial);
            PPartial function = (PPartial)args[0];
            Object[] funcArgs = PartialBuiltins.getNewPartialArgs(function, args, inliningTarget, hasArgsProfile, 1);
            HashingStorage storage = copyHashingStorageNode.execute(inliningTarget, function.getKw().getDictStorage());
            PDict result = factory.createDict(storage);
            addAllToOtherNode.execute((Frame)frame, inliningTarget, initNode.execute(frame, PNone.NO_VALUE, keywords), result);
            return factory.createPartial(cls, function.getFn(), funcArgs, result);
        }

        @Specialization(guards={"atLeastOneArg(args)", "!isPartialWithoutDict(getDict, args)"}, limit="1")
        static Object createGeneric(Object cls, Object[] args, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached InlinedConditionProfile hasKeywordsProfile, @Cached PyCallableCheckNode callableCheckNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object function = args[0];
            if (!callableCheckNode.execute(inliningTarget, function)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_ARG_MUST_BE_CALLABLE, "the first");
            }
            Object[] funcArgs = PythonUtils.arrayCopyOfRange(args, 1, args.length);
            PDict funcKwDict = hasKeywordsProfile.profile(inliningTarget, keywords.length > 0) ? factory.createDict(keywords) : factory.createDict();
            return factory.createPartial(cls, function, funcArgs, funcKwDict);
        }

        @Specialization(guards={"!atLeastOneArg(args)"})
        static Object noCallable(Object cls, Object[] args, PKeyword[] keywords, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_S_TAKES_AT_LEAST_ONE_ARGUMENT, "partial");
        }
    }
}

