/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTextIOBase})
public final class TextIOBaseBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TextIOBaseBuiltinsFactory.getFactories();
    }

    @Builtin(name="errors", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ErrorsNode
    extends PythonUnaryBuiltinNode {
        ErrorsNode() {
        }

        @Specialization
        static Object doit(Object self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="newlines", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NewlinesNode
    extends PythonUnaryBuiltinNode {
        NewlinesNode() {
        }

        @Specialization
        static Object doit(Object self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="encoding", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EncodingNode
    extends PythonUnaryBuiltinNode {
        EncodingNode() {
        }

        @Specialization
        static Object doit(Object self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends PythonBuiltinNode {
        WriteNode() {
        }

        @Specialization
        static Object write(Object self, Object args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, IONodes.T_WRITE);
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends PythonBuiltinNode {
        ReadlineNode() {
        }

        @Specialization
        static Object read(Object self, Object args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, IONodes.T_READLINE);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBuiltinNode {
        ReadNode() {
        }

        @Specialization
        static Object read(Object self, Object args, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, IONodes.T_READ);
        }
    }

    @Builtin(name="detach", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DetachNode
    extends PythonBuiltinNode {
        DetachNode() {
        }

        @Specialization
        static Object detach(Object self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, IONodes.T_DETACH);
        }
    }
}

