/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.pickle.ByteArrayView;
import com.oracle.graal.python.builtins.modules.pickle.PData;
import com.oracle.graal.python.builtins.modules.pickle.PickleState;
import com.oracle.graal.python.builtins.modules.pickle.PickleUtils;
import com.oracle.graal.python.builtins.modules.pickle.PicklerNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.IntNodesFactory;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltins;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyMemoryViewFromObject;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.Serializable;
import org.graalvm.collections.Pair;

public class PUnpickler
extends PythonBuiltinObject {
    private final PData stack;
    private Object[] memo = new Object[32];
    private int memoLen = 0;
    private Object persFunc = null;
    private Object persFuncSelf;
    private byte[] inputBuffer = null;
    private byte[] inputLine = null;
    private int inputLen = 0;
    private int nextReadIdx = 0;
    private int prefetchedIdx = 0;
    private Object read = null;
    private Object readinto = null;
    private Object readline = null;
    private Object peek = null;
    private Object buffers = null;
    private TruffleString encoding = null;
    private TruffleString errors = null;
    private int[] marks = null;
    private int numMarks = 0;
    private int marksSize = 0;
    private int proto = 0;
    private boolean fixImports = false;

    public PUnpickler(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
        this.stack = new PData();
    }

    public Object getRead() {
        return this.read;
    }

    public boolean isFixImports() {
        return this.fixImports;
    }

    public void setFixImports(boolean fixImports) {
        this.fixImports = fixImports;
    }

    public int getProto() {
        return this.proto;
    }

    public void setProto(int proto) {
        this.proto = proto;
    }

    public Object getPersFunc() {
        return this.persFunc;
    }

    public void setPersFunc(Object persFunc) {
        this.persFunc = persFunc;
    }

    public Object getPersFuncSelf() {
        return this.persFuncSelf;
    }

    public void setPersFuncSelf(Object persFuncSelf) {
        this.persFuncSelf = persFuncSelf;
    }

    public void initInternals(VirtualFrame frame, Node inliningTarget, PyObjectLookupAttr lookup) {
        Pair<Object, Object> pair = PickleUtils.initMethodRef(frame, inliningTarget, lookup, this, PickleUtils.T_METHOD_PERSISTENT_LOAD);
        this.persFunc = pair.getLeft();
        this.persFuncSelf = pair.getRight();
    }

    public void setInputStream(VirtualFrame frame, Node inliningTarget, PRaiseNode.Lazy raiseNode, PyObjectLookupAttr lookup, Object file) {
        this.peek = lookup.execute((Frame)frame, inliningTarget, file, PickleUtils.T_METHOD_PEEK);
        if (this.peek == PNone.NO_VALUE) {
            this.peek = null;
        }
        this.readinto = lookup.execute((Frame)frame, inliningTarget, file, PickleUtils.T_METHOD_READINTO);
        if (this.readinto == PNone.NO_VALUE) {
            this.readinto = null;
        }
        this.read = lookup.execute((Frame)frame, inliningTarget, file, PickleUtils.T_METHOD_READ);
        this.readline = lookup.execute((Frame)frame, inliningTarget, file, PickleUtils.T_METHOD_READLINE);
        if (this.readline == PNone.NO_VALUE || this.read == PNone.NO_VALUE) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.FILE_MUST_HAVE_A_AND_B_ATTRS, PickleUtils.T_METHOD_READ, PickleUtils.T_METHOD_READLINE);
        }
    }

    public void setStringInput(byte[] data, int dataLen) {
        this.inputBuffer = data;
        this.inputLen = dataLen;
        this.nextReadIdx = 0;
        this.prefetchedIdx = this.inputLen;
    }

    public void setInputEncoding(TruffleString encoding, TruffleString errors) {
        this.encoding = encoding;
        this.errors = errors;
        if (encoding == null) {
            this.encoding = StringLiterals.T_ASCII_UPPERCASE;
        }
        if (errors == null) {
            this.errors = StringLiterals.T_STRICT;
        }
    }

    public void setBuffers(VirtualFrame frame, Node inliningTarget, PyObjectGetIter getIter, Object buffers) {
        this.buffers = buffers == null || buffers == PNone.NONE || buffers == PNone.NO_VALUE ? null : getIter.execute((Frame)frame, inliningTarget, buffers);
    }

    private void resizeMemoList(int newSize) {
        assert (newSize > this.memo.length);
        Object[] memoNew = new Object[newSize];
        PythonUtils.arraycopy(this.memo, 0, memoNew, 0, this.memo.length);
        this.memo = memoNew;
    }

    public Object memoGet(int idx) {
        return idx >= this.memo.length ? null : this.memo[idx];
    }

    public void memoPut(int idx, Object value) {
        if (idx >= this.memo.length) {
            this.resizeMemoList(idx * 2);
            assert (idx < this.memo.length);
        }
        Object oldItem = this.memo[idx];
        this.memo[idx] = value;
        if (oldItem == null) {
            ++this.memoLen;
        }
    }

    public void setMemo(Object[] memo) {
        this.memo = memo;
    }

    public Object[] getMemoCopy() {
        return PythonUtils.arrayCopyOf(this.memo, this.memo.length);
    }

    public HashingStorage copyMemoToHashingStorage(Node inliningTarget, HashingStorageNodes.HashingStorageSetItem setItem) {
        HashingStorage hashingStorage = EmptyStorage.INSTANCE;
        for (int i = 0; i < this.memo.length; ++i) {
            hashingStorage = setItem.execute(null, inliningTarget, hashingStorage, i, this.memo[i]);
        }
        return hashingStorage;
    }

    public void clearMemo() {
        this.memo = new Object[this.memo.length];
    }

    public static abstract class LoadNode
    extends BasePickleReadNode {
        @Node.Child
        private PData.PDataPushNode pDataPushNode;
        @Node.Child
        private PData.PDataPopNode pDataPopNode;
        @Node.Child
        private PData.PDataPopTupleNode pDataPopTupleNode;
        @Node.Child
        private PData.PDataPopListNode pDataPopListNode;
        @Node.Child
        private HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode;
        @Node.Child
        private ListBuiltins.ListExtendNode listExtendNode;
        @Node.Child
        private PyObjectSetAttrO setAttributeNode;
        @Node.Child
        private IntNodes.PyLongFromByteArray pyLongFromByteArray;
        @Node.Child
        private PyObjectSetItem setItemNode;
        @Node.Child
        HashingStorageNodes.HashingStorageCopy hashCopy;
        @Node.Child
        HashingStorageNodes.HashingStorageAddAllToOther addAllToOther;

        public abstract Object execute(VirtualFrame var1, PUnpickler var2);

        protected HashingStorageNodes.HashingStorageCopy ensureHashingStorageCopy() {
            if (this.hashCopy == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashCopy = (HashingStorageNodes.HashingStorageCopy)this.insert(HashingStorageNodes.HashingStorageCopy.create());
            }
            return this.hashCopy;
        }

        protected HashingStorageNodes.HashingStorageAddAllToOther ensureHashingStorageAddAllToOther() {
            if (this.addAllToOther == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.addAllToOther = (HashingStorageNodes.HashingStorageAddAllToOther)this.insert(HashingStorageNodes.HashingStorageAddAllToOther.create());
            }
            return this.addAllToOther;
        }

        protected Object longFromBytes(byte[] data, boolean bigEndian) {
            if (this.pyLongFromByteArray == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyLongFromByteArray = (IntNodes.PyLongFromByteArray)this.insert(IntNodesFactory.PyLongFromByteArrayNodeGen.create());
            }
            return this.pyLongFromByteArray.executeCached(data, bigEndian);
        }

        protected void setAttribute(VirtualFrame frame, Object object, Object key, Object value) {
            if (this.setAttributeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setAttributeNode = (PyObjectSetAttrO)this.insert(PyObjectSetAttrO.create());
            }
            this.setAttributeNode.executeCached(frame, object, key, value);
        }

        protected void extendList(VirtualFrame frame, PList list, Object slice) {
            if (this.listExtendNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.listExtendNode = (ListBuiltins.ListExtendNode)this.insert(ListBuiltins.ListExtendNode.create());
            }
            this.listExtendNode.execute(frame, list, slice);
        }

        protected void pDataPush(PUnpickler self, Object obj) {
            if (this.pDataPushNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pDataPushNode = (PData.PDataPushNode)this.insert(PData.PDataPushNode.create());
            }
            this.pDataPushNode.execute(self.stack, obj);
        }

        protected Object pDataPop(PUnpickler self) {
            if (this.pDataPopNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pDataPopNode = (PData.PDataPopNode)this.insert(PData.PDataPopNode.create());
            }
            return this.pDataPopNode.execute(self.stack);
        }

        protected Object pDataPopTuple(PUnpickler self, int start) {
            if (this.pDataPopTupleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pDataPopTupleNode = (PData.PDataPopTupleNode)this.insert(PData.PDataPopTupleNode.create());
            }
            return this.pDataPopTupleNode.execute(self.stack, start);
        }

        protected Object pDataPopList(PUnpickler self, int start) {
            if (this.pDataPopListNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pDataPopListNode = (PData.PDataPopListNode)this.insert(PData.PDataPopListNode.create());
            }
            return this.pDataPopListNode.execute(self.stack, start);
        }

        protected HashingStorage getClonedHashingStorage(VirtualFrame frame, Object obj) {
            if (this.getHashingStorageNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHashingStorageNode = (HashingCollectionNodes.GetClonedHashingStorageNode)this.insert(HashingCollectionNodes.GetClonedHashingStorageNode.create());
            }
            return this.getHashingStorageNode.doNoValueCached(frame, obj);
        }

        private void setItem(VirtualFrame frame, Object object, Object key, Object value) {
            if (this.setItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setItemNode = (PyObjectSetItem)this.insert(PyObjectSetItem.create());
            }
            this.setItemNode.executeCached((Frame)frame, object, key, value);
        }

        protected int marker(PUnpickler self) {
            if (self.numMarks < 1) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.COULD_NOT_FIND_MARK);
            }
            int mark = self.marks[--self.numMarks];
            self.stack.mark = self.numMarks != 0;
            self.stack.fence = self.numMarks != 0 ? self.marks[self.numMarks - 1] : 0;
            return mark;
        }

        void loadNone(PUnpickler self) {
            this.pDataPush(self, PNone.NONE);
        }

        private static long calcBinInt(ByteArrayView s, int nBytes) {
            long x = 0L;
            for (int i = 0; i < nBytes; ++i) {
                x |= (long)s.getUnsigned(i) << 8 * i;
            }
            if (nBytes == 4) {
                x |= -(x & 0x80000000L);
            }
            return x;
        }

        private int calcBinSize(ByteArrayView s, int nbytes) {
            int i;
            int x = 0;
            int n = nbytes;
            if (n > 4) {
                for (i = 4; i < n; ++i) {
                    if (s.get(i) == 0) continue;
                    throw this.raise(PythonBuiltinClassType.OverflowError);
                }
                n = 4;
            }
            for (i = 0; i < n; ++i) {
                x |= s.getUnsigned(i) << 8 * i;
            }
            return x;
        }

        private void loadBinIntX(PUnpickler self, ByteArrayView s, int size) {
            long x = LoadNode.calcBinInt(s, size);
            this.pDataPush(self, x);
        }

        private void loadBinInt(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 4);
            this.loadBinIntX(self, s, 4);
        }

        private void loadBinInt1(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 1);
            this.loadBinIntX(self, s, 1);
        }

        private void loadBinInt2(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 2);
            this.loadBinIntX(self, s, 2);
        }

        private void loadInt(VirtualFrame frame, PUnpickler self) {
            Object value;
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            try {
                long x = PickleUtils.asciiBytesToLong(s, this.ensureTsParseLongNode(), this.ensureTsFromByteArray());
                value = s.length == 3 && (x == 0L || x == 1L) ? (Serializable)Boolean.valueOf(x != 0L) : (Serializable)(x == (long)((int)x) ? (Number)((int)x) : (Number)x);
            }
            catch (TruffleString.NumberFormatException nfe) {
                value = this.parseInt(frame, PickleUtils.getValidIntString(s));
            }
            this.pDataPush(self, value);
        }

        private void loadLong(VirtualFrame frame, PUnpickler self) {
            Object value;
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            if (s[s.length - 2] == 76) {
                s[s.length - 2] = 0;
            }
            try {
                value = PickleUtils.asciiBytesToLong(s, this.ensureTsParseLongNode(), this.ensureTsFromByteArray());
            }
            catch (TruffleString.NumberFormatException nfe) {
                value = this.parseInt(frame, s);
            }
            this.pDataPush(self, value);
        }

        private void loadCountedLong(VirtualFrame frame, PUnpickler self, int n) {
            Object value;
            assert (n == 1 || n == 4);
            int size = n;
            ByteArrayView nbytes = this.read(frame, self, size);
            if ((size = (int)LoadNode.calcBinInt(nbytes, size)) < 0) {
                throw this.raise(PythonErrorType.UnpicklingError, ErrorMessages.LONG_PICKLE_HAS_NEG_BYTE_CNT);
            }
            if (size == 0) {
                value = 0L;
            } else {
                ByteArrayView pdata = this.read(frame, self, size);
                value = this.longFromBytes(pdata.getBytes(size), false);
            }
            this.pDataPush(self, value);
        }

        private void loadFloat(VirtualFrame frame, PUnpickler self) {
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            Double value = PickleUtils.asciiBytesToDouble(s, this.getRaiseNode(), PythonBuiltinClassType.OverflowError);
            this.pDataPush(self, value);
        }

        private void loadBinFloat(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 8);
            Double value = NumericSupport.bigEndian().getDouble(s.getBytes(8), 0);
            this.pDataPush(self, value);
        }

        private void loadCountedBinBytes(VirtualFrame frame, PUnpickler self, int nbytes) {
            ByteArrayView s = this.read(frame, self, nbytes);
            int size = this.calcBinSize(s, nbytes);
            if (size < 0) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_EXCEEDS_MAX_SIZE_N_BYTES, "BINBYTES", Integer.MAX_VALUE);
            }
            byte[] buffer = new byte[size];
            this.readInto(frame, self, buffer);
            PBytes bytes = this.factory().createBytes(buffer);
            this.pDataPush(self, bytes);
        }

        private void loadCountedByteArray(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 8);
            int size = this.calcBinSize(s, 8);
            if (size < 0) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_EXCEEDS_MAX_SIZE_N_BYTES, "BYTEARRAY8", Integer.MAX_VALUE);
            }
            byte[] buffer = new byte[size];
            this.readInto(frame, self, buffer);
            PByteArray bytearray = this.factory().createByteArray(buffer);
            this.pDataPush(self, bytearray);
        }

        private void loadNextBuffer(VirtualFrame frame, PUnpickler self) {
            if (self.buffers == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.PICKLE_STREAM_NO_BUFFERS);
            }
            Object buf = this.getNextItem(frame, self.buffers);
            if (buf == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.NOT_ENOUGH_BUFFERS);
            }
            this.pDataPush(self, buf);
        }

        private void loadReadOnlyBuffer(VirtualFrame frame, PUnpickler self) {
            int len = self.stack.size;
            if (len <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object obj = self.stack.data[len - 1];
            Object view = this.createMemoryView(frame, obj);
            boolean readonly = this.getBufferAccessLibrary().isReadonly(view);
            if (!readonly) {
                self.stack.data[len - 1] = view = this.getToReadonlyNode().call(frame, view);
            }
        }

        private void loadCountedBinString(VirtualFrame frame, PUnpickler self, int nbytes) {
            ByteArrayView s = this.read(frame, self, nbytes);
            int size = this.calcBinSize(s, nbytes);
            if (size < 0) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_EXCEEDS_MAX_SIZE_N_BYTES, "BINSTRING", Integer.MAX_VALUE);
            }
            s = this.read(frame, self, size);
            PBytes bytes = this.factory().createBytes(s.getBytes(size), size);
            Object obj = this.ensureTsEqualNode().execute((AbstractTruffleString)self.encoding, (AbstractTruffleString)T_CODEC_BYTES, PythonUtils.TS_ENCODING) ? bytes : this.decode(frame, bytes, self.encoding, self.errors);
            this.pDataPush(self, obj);
        }

        private void loadString(VirtualFrame frame, PUnpickler self) {
            byte[] s = this.readLine(frame, self);
            int len = s.length;
            if (--len < 2 || s[0] != s[len - 1] || s[0] != 39 && s[0] != 34) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_OPCODE_ARG_MUST_BE_QUOTED, "STRING");
            }
            int pStart = 1;
            assert ((len -= 2) >= 0);
            Object bytes = this.escapeDecode(frame, this.factory(), s, pStart, len);
            Object obj = this.ensureTsEqualNode().execute((AbstractTruffleString)self.encoding, (AbstractTruffleString)T_CODEC_BYTES, PythonUtils.TS_ENCODING) ? bytes : this.decode(frame, bytes, self.encoding, self.errors);
            this.pDataPush(self, obj);
        }

        private void loadUnicode(VirtualFrame frame, PUnpickler self) {
            byte[] s = this.readLine(frame, self);
            if (s.length < 1) {
                throw this.badReadLine();
            }
            Object str = this.unicodeRawDecodeEscape(frame, s, s.length - 1);
            this.pDataPush(self, str);
        }

        private void loadBinCountedUnicode(VirtualFrame frame, PUnpickler self, int nbytes) {
            ByteArrayView s = this.read(frame, self, nbytes);
            int size = this.calcBinSize(s, nbytes);
            if (size < 0) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_EXCEEDS_MAX_SIZE_N_BYTES, "BINUNICODE", Integer.MAX_VALUE);
            }
            s = this.read(frame, self, size);
            Object str = this.decodeUTF8(frame, s, size, T_ERRORS_SURROGATEPASS);
            this.pDataPush(self, str);
        }

        private void loadCountedTuple(PUnpickler self, int len) {
            if (self.stack.size < len) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object tuple = this.pDataPopTuple(self, self.stack.size - len);
            this.pDataPush(self, tuple);
        }

        private void loadTuple(PUnpickler self) {
            int i = this.marker(self);
            this.loadCountedTuple(self, self.stack.size - i);
        }

        private void loadEmptyList(PUnpickler self) {
            this.pDataPush(self, this.factory().createList());
        }

        private void loadList(PUnpickler self) {
            int i = this.marker(self);
            Object list = this.pDataPopList(self, i);
            this.pDataPush(self, list);
        }

        private void loadEmptyDict(PUnpickler self) {
            this.pDataPush(self, this.factory().createDict());
        }

        private void loadDict(VirtualFrame frame, PUnpickler self) {
            int j = self.stack.size;
            int i = this.marker(self);
            if ((j - i) % 2 != 0) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.ODD_NR_ITEMS_FOR_S, "DICT");
            }
            HashingStorage storage = EmptyStorage.INSTANCE;
            for (int k = i + 1; k < j; k += 2) {
                Object key = self.stack.data[k - 1];
                Object value = self.stack.data[k];
                storage = this.setHashingStorageItem(frame, storage, key, value);
            }
            self.stack.clear(i);
            this.pDataPush(self, this.factory().createDict(storage));
        }

        private void loadEmptySet(PUnpickler self) {
            this.pDataPush(self, this.factory().createSet());
        }

        private void loadAddItems(VirtualFrame frame, PUnpickler self) {
            int len;
            int mark = this.marker(self);
            if (mark > (len = self.stack.size) || mark <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            if (len == mark) {
                return;
            }
            Object set = self.stack.data[mark - 1];
            if (set instanceof PSet) {
                Object items = this.pDataPopTuple(self, mark);
                HashingStorage union = ((PSet)set).getDictStorage().unionCached(this.getHashingStorage(frame, items), this.ensureHashingStorageCopy(), this.ensureHashingStorageAddAllToOther());
                ((PSet)set).setDictStorage(union);
            } else {
                Object add_func = this.lookupAttributeStrict((Frame)frame, set, BuiltinNames.T_ADD);
                for (int i = mark; i < len; ++i) {
                    Object item = self.stack.data[i];
                    try {
                        this.call(frame, add_func, item);
                        continue;
                    }
                    catch (PException pe) {
                        self.stack.clear(i + 1);
                        self.stack.size = mark;
                        throw pe;
                    }
                }
                self.stack.size = mark;
            }
        }

        private void loadFrozenSet(VirtualFrame frame, PUnpickler self) {
            int i = this.marker(self);
            Object items = this.pDataPopTuple(self, i);
            PFrozenSet frozenset = this.factory().createFrozenSet(this.getClonedHashingStorage(frame, items));
            this.pDataPush(self, frozenset);
        }

        private Object instantiate(VirtualFrame frame, Object cls, Object args) {
            Object func;
            assert (args instanceof PTuple);
            if (this.length(frame, args) == 0 && PGuards.isPythonClass(cls) && (func = this.getLookupAttrNode().executeCached((Frame)frame, cls, SpecialMethodNames.T___GETINITARGS__)) == PNone.NO_VALUE) {
                Object newMethod = this.lookupAttributeStrict((Frame)frame, cls, SpecialMethodNames.T___NEW__);
                return this.callNew(frame, newMethod, cls);
            }
            return this.callStarArgs(frame, cls, args);
        }

        private void loadObj(VirtualFrame frame, PUnpickler self) {
            Object obj = null;
            int i = this.marker(self);
            if (self.stack.size - i < 1) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object args = this.pDataPopTuple(self, i + 1);
            Object cls = this.pDataPop(self);
            if (cls != null) {
                obj = this.instantiate(frame, cls, args);
            }
            assert (obj != null);
            this.pDataPush(self, obj);
        }

        private void loadInst(VirtualFrame frame, PythonContext ctx, PUnpickler self) {
            Object cls = null;
            Object obj = null;
            int i = this.marker(self);
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            Object moduleName = this.decodeASCII(frame, s, s.length - 1, T_ERRORS_STRICT);
            s = this.readLine(frame, self);
            if (s != null) {
                if (s.length < 2) {
                    throw this.badReadLine();
                }
                try {
                    Object className = this.decodeASCII(frame, s, s.length - 1, T_ERRORS_STRICT);
                    cls = this.findClass(frame, ctx.getCore(), self, moduleName, className);
                }
                catch (PException className) {
                    // empty catch block
                }
            }
            assert (cls != null);
            Object args = this.pDataPopTuple(self, i);
            if (args != null) {
                obj = this.instantiate(frame, cls, args);
            }
            assert (obj != null);
            this.pDataPush(self, obj);
        }

        private void loadNewObj(VirtualFrame frame, PUnpickler self) {
            Object args = this.pDataPop(self);
            if (!(args instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_EXPECTED_AN_ARG_S, "NEWOBJ", "tuple.");
            }
            Object cls = this.pDataPop(self);
            if (!PGuards.isPythonClass(cls)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_CLASS_ARG_S, "NEWOBJ", "isn't a type object");
            }
            Object tpNew = this.getLookupAttrNode().executeCached((Frame)frame, cls, SpecialMethodNames.T___NEW__);
            if (tpNew == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_CLASS_ARG_S, "NEWOBJ", "has NULL tp_new");
            }
            Object obj = this.callNew(frame, tpNew, cls, args);
            this.pDataPush(self, obj);
        }

        private void loadNewObjEx(VirtualFrame frame, PUnpickler self) {
            Object kwargs = this.pDataPop(self);
            Object args = this.pDataPop(self);
            Object cls = this.pDataPop(self);
            if (!PGuards.isPythonClass(cls)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_CLASS_ARG_MUST_BE_TYPE_NOT_P, "NEWOBJ_EX", cls);
            }
            Object tpNew = this.getLookupAttrNode().executeCached((Frame)frame, cls, SpecialMethodNames.T___NEW__);
            if (tpNew == PNone.NO_VALUE) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_CLASS_ARG_DOES_NOT_HAVE_S, "NEWOBJ_EX", SpecialMethodNames.T___NEW__);
            }
            if (!(args instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "NEWOBJ_EX args", "tuple", args);
            }
            if (!(kwargs instanceof PDict)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_ARG_MUST_BE_S_NOT_P, "NEWOBJ_EX kwargs", "dict", kwargs);
            }
            Object obj = this.callNew(frame, tpNew, cls, args, kwargs);
            this.pDataPush(self, obj);
        }

        private void doAppend(VirtualFrame frame, PUnpickler self, int x) {
            int len = self.stack.size;
            if (x > len || x <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            if (len == x) {
                return;
            }
            Object list = self.stack.data[x - 1];
            if (list instanceof PList) {
                Object slice = this.pDataPopList(self, x);
                this.extendList(frame, (PList)list, slice);
            } else {
                Object extendFunc = this.getLookupAttrNode().executeCached((Frame)frame, list, BuiltinNames.T_EXTEND);
                if (extendFunc != PNone.NO_VALUE) {
                    Object slice = this.pDataPopList(self, x);
                    this.call(frame, extendFunc, slice);
                } else {
                    Object appendFunc = this.lookupAttributeStrict((Frame)frame, list, BuiltinNames.T_APPEND);
                    for (int i = x; i < len; ++i) {
                        Object value = self.stack.data[i];
                        try {
                            this.call(frame, appendFunc, value);
                            continue;
                        }
                        catch (PException pe) {
                            self.stack.clear(i + 1);
                            self.stack.size = x;
                            return;
                        }
                    }
                    self.stack.size = x;
                }
            }
        }

        private void loadGlobal(VirtualFrame frame, PythonContext ctx, PUnpickler self) {
            Object global = null;
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            TruffleString moduleName = PickleUtils.decodeUTF8Strict(s, s.length - 1, this.ensureTsFromByteArray(), this.ensureTsSwitchEncodingNode());
            s = this.readLine(frame, self);
            if (s != null) {
                if (s.length < 2) {
                    throw this.badReadLine();
                }
                TruffleString globalName = PickleUtils.decodeUTF8Strict(s, s.length - 1, this.ensureTsFromByteArray(), this.ensureTsSwitchEncodingNode());
                if (globalName != null) {
                    global = this.findClass(frame, ctx.getCore(), self, moduleName, globalName);
                }
            }
            this.pDataPush(self, global);
        }

        private void loadStackGlobal(VirtualFrame frame, PythonContext ctx, PUnpickler self) {
            Object globalName = null;
            Object moduleName = null;
            try {
                globalName = this.pDataPop(self);
                moduleName = this.pDataPop(self);
            }
            catch (PException pe) {
                pe.expectCached(PythonBuiltinClassType.UnpicklingError, this.ensureErrProfile());
            }
            if (!PGuards.isString(moduleName) || !PGuards.isString(globalName)) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_REQ_STR, "STACK_GLOBAL");
            }
            Object global = this.findClass(frame, ctx.getCore(), self, moduleName, globalName);
            this.pDataPush(self, global);
        }

        private void loadAppend(VirtualFrame frame, PUnpickler self) {
            if (self.stack.size - 1 <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            this.doAppend(frame, self, self.stack.size - 1);
        }

        private void loadAppends(VirtualFrame frame, PUnpickler self) {
            int i = this.marker(self);
            this.doAppend(frame, self, i);
        }

        private void loadBuild(VirtualFrame frame, PUnpickler self) {
            Object slotstate;
            if (self.stack.size - 2 < self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object state = this.pDataPop(self);
            Object inst = self.stack.data[self.stack.size - 1];
            Object setstate = this.getLookupAttrNode().executeCached((Frame)frame, inst, SpecialMethodNames.T___SETSTATE__);
            if (setstate != PNone.NO_VALUE) {
                this.call(frame, setstate, state);
                return;
            }
            if (state instanceof PTuple && this.length(frame, state) == 2) {
                Object tmp = state;
                state = this.getItem(frame, tmp, (Object)0);
                slotstate = this.getItem(frame, tmp, (Object)1);
            } else {
                slotstate = null;
            }
            if (state != PNone.NONE) {
                if (!(state instanceof PDict)) {
                    throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_STATE_NOT_DICT, "");
                }
                Object dict = this.lookupAttributeStrict((Frame)frame, inst, SpecialAttributeNames.T___DICT__);
                HashingStorage storage = this.getHashingStorage(frame, state);
                HashingStorage dictStorage = this.getHashingStorage(frame, dict);
                this.ensureHashingStorageAddAllToOther().executeCached((Frame)frame, storage, dictStorage);
                HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
                HashingStorageNodes.HashingStorageIteratorNext nextNode = this.ensureHashingStorageIteratorNext();
                HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
                HashingStorageNodes.HashingStorageIteratorValue getValueNode = this.ensureHashingStorageIteratorValue();
                while (nextNode.executeCached(storage, it)) {
                    this.setHashingStorageItem(frame, dictStorage, getKeyNode.executeCached(storage, it), getValueNode.executeCached(storage, it));
                }
            }
            if (slotstate != null) {
                if (!(slotstate instanceof PDict)) {
                    throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.S_STATE_NOT_DICT, "slot");
                }
                HashingStorage storage = this.getHashingStorage(frame, slotstate);
                HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
                HashingStorageNodes.HashingStorageIteratorNext nextNode = this.ensureHashingStorageIteratorNext();
                HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
                HashingStorageNodes.HashingStorageIteratorValue getValueNode = this.ensureHashingStorageIteratorValue();
                while (nextNode.executeCached(storage, it)) {
                    this.setAttribute(frame, inst, getKeyNode.executeCached(storage, it), getValueNode.executeCached(storage, it));
                }
            }
        }

        private void loadDup(PUnpickler self) {
            int len = self.stack.size;
            if (len <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object last = self.stack.data[len - 1];
            this.pDataPush(self, last);
        }

        private void loadBinGet(VirtualFrame frame, PUnpickler self) {
            byte s = this.read(frame, self);
            int idx = s & 0xFF;
            Object value = self.memoGet(idx);
            if (value == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.MEMO_VALUE_NOT_FOUND_AT_INDEX_D, idx);
            }
            this.pDataPush(self, value);
        }

        private void loadLongBinGet(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 4);
            int idx = this.calcBinSize(s, 4);
            Object value = self.memoGet(idx);
            if (value == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.MEMO_VALUE_NOT_FOUND_AT_INDEX_D, idx);
            }
            this.pDataPush(self, value);
        }

        private void loadGet(VirtualFrame frame, PUnpickler self) {
            int idx;
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            try {
                idx = PickleUtils.asciiBytesToInt(s, this.ensureTsParseIntNode(), this.ensureTsFromByteArray());
            }
            catch (TruffleString.NumberFormatException nfe) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            Object value = self.memoGet(idx);
            if (value == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.MEMO_VALUE_NOT_FOUND_AT_INDEX_D, idx);
            }
            this.pDataPush(self, value);
        }

        private static void loadMark(PUnpickler self) {
            if (self.numMarks >= self.marksSize) {
                int alloc = (self.numMarks << 1) + 20;
                int[] marksNew = new int[alloc];
                if (self.marks != null) {
                    PythonUtils.arraycopy(self.marks, 0, marksNew, 0, Math.min(alloc, self.marks.length));
                }
                self.marks = marksNew;
                self.marksSize = alloc;
            }
            self.stack.mark = true;
            self.marks[self.numMarks++] = self.stack.fence = self.stack.size;
        }

        private void loadBinPut(VirtualFrame frame, PUnpickler self) {
            byte s = this.read(frame, self);
            if (self.stack.size <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object value = self.stack.data[self.stack.size - 1];
            int idx = s & 0xFF;
            self.memoPut(idx, value);
        }

        private void loadLongBinPut(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 4);
            if (self.stack.size <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object value = self.stack.data[self.stack.size - 1];
            int idx = this.calcBinSize(s, 4);
            if (idx < 0) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.NEG_S_ARG, "LONG_BINPUT");
            }
            self.memoPut(idx, value);
        }

        private void loadPut(VirtualFrame frame, PUnpickler self) {
            int idx;
            byte[] s = this.readLine(frame, self);
            if (s.length < 2) {
                throw this.badReadLine();
            }
            if (self.stack.size <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object value = self.stack.data[self.stack.size - 1];
            try {
                idx = PickleUtils.asciiBytesToInt(s, this.ensureTsParseIntNode(), this.ensureTsFromByteArray());
            }
            catch (TruffleString.NumberFormatException nfe) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (idx < 0) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.NEG_S_ARG, "PUT");
            }
            self.memoPut(idx, value);
        }

        private void loadMemoize(PUnpickler self) {
            if (self.stack.size <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            Object value = self.stack.data[self.stack.size - 1];
            self.memoPut(self.memoLen, value);
        }

        private void loadPop(PUnpickler self) {
            int len = self.stack.size;
            if (self.numMarks > 0 && self.marks[self.numMarks - 1] == len) {
                --self.numMarks;
                self.stack.mark = self.numMarks != 0;
                self.stack.fence = self.numMarks != 0 ? self.marks[self.numMarks - 1] : 0;
            } else {
                if (len <= self.stack.fence) {
                    throw this.pDataStackRaiseUnderflow(self);
                }
                self.stack.size = --len;
            }
        }

        private void loadPopMark(PUnpickler self) {
            int i = this.marker(self);
            self.stack.clear(i);
        }

        private void doSetItems(VirtualFrame frame, PUnpickler self, int x) {
            PDict pDict;
            int len = self.stack.size;
            if (x > len || x <= self.stack.fence) {
                throw this.pDataStackRaiseUnderflow(self);
            }
            if (len == x) {
                return;
            }
            if ((len - x) % 2 != 0) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.ODD_NR_ITEMS_FOR_S, "SETITEMS");
            }
            Object dict = self.stack.data[x - 1];
            boolean isBuiltinDict = dict instanceof PDict && PGuards.isBuiltinDict(pDict = (PDict)dict);
            for (int i = x + 1; i < len; i += 2) {
                Object key = self.stack.data[i - 1];
                Object value = self.stack.data[i];
                if (isBuiltinDict) {
                    this.setDictItem(frame, (PDict)dict, key, value);
                    continue;
                }
                this.setItem(frame, dict, key, value);
            }
            self.stack.clear(x);
        }

        private void loadSetItem(VirtualFrame frame, PUnpickler self) {
            this.doSetItems(frame, self, self.stack.size - 2);
        }

        private void loadSetItems(VirtualFrame frame, PUnpickler self) {
            int i = this.marker(self);
            this.doSetItems(frame, self, i);
        }

        private void loadPersId(VirtualFrame frame, PUnpickler self) {
            Object pid;
            if (self.persFunc == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.PID_NO_FUNC);
            }
            byte[] s = this.readLine(frame, self);
            if (s.length < 1) {
                throw this.badReadLine();
            }
            try {
                pid = this.decodeASCII(frame, s, s.length - 1, T_ERRORS_STRICT);
            }
            catch (PException pe) {
                pe.expectCached(PythonBuiltinClassType.UnicodeDecodeError, this.ensureErrProfile());
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.PID_PROTO_0);
            }
            this.pDataPush(self, this.callPersistentLoad(frame, self, pid));
        }

        private Object callPersistentLoad(VirtualFrame frame, PUnpickler self, Object pid) {
            if (self.persFuncSelf == null) {
                return this.call(frame, self.persFunc, pid);
            }
            return this.call(frame, self.persFunc, self.persFuncSelf, pid);
        }

        private void loadBinPersId(VirtualFrame frame, PUnpickler self) {
            if (self.persFunc == null) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.PID_NO_FUNC);
            }
            Object pid = this.pDataPop(self);
            this.pDataPush(self, this.callPersistentLoad(frame, self, pid));
        }

        private void loadReduce(VirtualFrame frame, PUnpickler self) {
            Object obj = null;
            Object argtup = this.pDataPop(self);
            Object callable = this.pDataPop(self);
            if (callable != null) {
                obj = this.callStarArgs(frame, callable, argtup);
            }
            assert (obj != null);
            this.pDataPush(self, obj);
        }

        private void loadProto(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 1);
            int i = s.getUnsigned(0);
            if (i <= 5) {
                self.proto = i;
                return;
            }
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNSUPPORTED_PICKLE_PROTO, i);
        }

        private void loadFrame(VirtualFrame frame, PUnpickler self) {
            ByteArrayView s = this.read(frame, self, 8);
            int frameLen = this.calcBinSize(s, 8);
            if (frameLen < 0) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.S_EXCEEDS_MAX_SIZE_N_BYTES, "FRAME", Integer.MAX_VALUE);
            }
            s = this.read(frame, self, frameLen);
            self.nextReadIdx -= frameLen;
        }

        private void loadExtension(VirtualFrame frame, PythonContext ctx, PUnpickler self, int nbytes) {
            Object pair;
            assert (nbytes == 1 || nbytes == 2 || nbytes == 4);
            ByteArrayView codebytes = this.read(frame, self, nbytes);
            long code = LoadNode.calcBinInt(codebytes, nbytes);
            if (code <= 0L) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.EXT_CODE_LE_0);
            }
            PickleState st = this.getGlobalState(ctx.getCore());
            Object obj = this.getDictItem(frame, st.extensionCache, code);
            if (obj != null) {
                this.pDataPush(self, obj);
            }
            if ((pair = this.getDictItem(frame, st.invertedRegistry, code)) == null) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.EXT_UNREGISTERED, code);
            }
            if (!(pair instanceof PTuple) || this.length(frame, pair) != 2) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INV_REG_NOT_2TUPLE, code);
            }
            Object moduleName = this.getItem(frame, pair, (Object)0);
            if (!PGuards.isString(moduleName)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INV_REG_NOT_2TUPLE, code);
            }
            Object className = this.getItem(frame, pair, (Object)1);
            if (!PGuards.isString(className)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INV_REG_NOT_2TUPLE, code);
            }
            obj = this.findClass(frame, ctx.getCore(), self, moduleName, className);
            assert (st.extensionCache instanceof PDict);
            this.setDictItem(frame, (PDict)st.extensionCache, code, obj);
            this.pDataPush(self, obj);
        }

        private void loadBool(PUnpickler self, boolean bool) {
            this.pDataPush(self, bool);
        }

        @Specialization
        public Object load(VirtualFrame frame, PUnpickler self) {
            self.numMarks = 0;
            self.stack.mark = false;
            self.stack.fence = 0;
            self.proto = 0;
            if (self.stack.getSize() > 0) {
                self.stack.clear(0);
            }
            PythonContext ctx = PythonContext.get(this);
            block72: while (true) {
                byte s;
                try {
                    s = this.read(frame, self);
                }
                catch (PException pe) {
                    pe.expectCached(PythonBuiltinClassType.UnpicklingError, this.ensureErrProfile());
                    throw this.raise(PythonBuiltinClassType.EOFError, ErrorMessages.RAN_OUT_OF_INPUT);
                }
                switch (s) {
                    case 78: {
                        this.loadNone(self);
                        continue block72;
                    }
                    case 74: {
                        this.loadBinInt(frame, self);
                        continue block72;
                    }
                    case 75: {
                        this.loadBinInt1(frame, self);
                        continue block72;
                    }
                    case 77: {
                        this.loadBinInt2(frame, self);
                        continue block72;
                    }
                    case 73: {
                        this.loadInt(frame, self);
                        continue block72;
                    }
                    case 76: {
                        this.loadLong(frame, self);
                        continue block72;
                    }
                    case -118: {
                        this.loadCountedLong(frame, self, 1);
                        continue block72;
                    }
                    case -117: {
                        this.loadCountedLong(frame, self, 4);
                        continue block72;
                    }
                    case 70: {
                        this.loadFloat(frame, self);
                        continue block72;
                    }
                    case 71: {
                        this.loadBinFloat(frame, self);
                        continue block72;
                    }
                    case 67: {
                        this.loadCountedBinBytes(frame, self, 1);
                        continue block72;
                    }
                    case 66: {
                        this.loadCountedBinBytes(frame, self, 4);
                        continue block72;
                    }
                    case -114: {
                        this.loadCountedBinBytes(frame, self, 8);
                        continue block72;
                    }
                    case -106: {
                        this.loadCountedByteArray(frame, self);
                        continue block72;
                    }
                    case -105: {
                        this.loadNextBuffer(frame, self);
                        continue block72;
                    }
                    case -104: {
                        this.loadReadOnlyBuffer(frame, self);
                        continue block72;
                    }
                    case 85: {
                        this.loadCountedBinString(frame, self, 1);
                        continue block72;
                    }
                    case 84: {
                        this.loadCountedBinString(frame, self, 4);
                        continue block72;
                    }
                    case 83: {
                        this.loadString(frame, self);
                        continue block72;
                    }
                    case 86: {
                        this.loadUnicode(frame, self);
                        continue block72;
                    }
                    case -116: {
                        this.loadBinCountedUnicode(frame, self, 1);
                        continue block72;
                    }
                    case 88: {
                        this.loadBinCountedUnicode(frame, self, 4);
                        continue block72;
                    }
                    case -115: {
                        this.loadBinCountedUnicode(frame, self, 8);
                        continue block72;
                    }
                    case 41: {
                        this.loadCountedTuple(self, 0);
                        continue block72;
                    }
                    case -123: {
                        this.loadCountedTuple(self, 1);
                        continue block72;
                    }
                    case -122: {
                        this.loadCountedTuple(self, 2);
                        continue block72;
                    }
                    case -121: {
                        this.loadCountedTuple(self, 3);
                        continue block72;
                    }
                    case 116: {
                        this.loadTuple(self);
                        continue block72;
                    }
                    case 93: {
                        this.loadEmptyList(self);
                        continue block72;
                    }
                    case 108: {
                        this.loadList(self);
                        continue block72;
                    }
                    case 125: {
                        this.loadEmptyDict(self);
                        continue block72;
                    }
                    case 100: {
                        this.loadDict(frame, self);
                        continue block72;
                    }
                    case -113: {
                        this.loadEmptySet(self);
                        continue block72;
                    }
                    case -112: {
                        this.loadAddItems(frame, self);
                        continue block72;
                    }
                    case -111: {
                        this.loadFrozenSet(frame, self);
                        continue block72;
                    }
                    case 111: {
                        this.loadObj(frame, self);
                        continue block72;
                    }
                    case 105: {
                        this.loadInst(frame, ctx, self);
                        continue block72;
                    }
                    case -127: {
                        this.loadNewObj(frame, self);
                        continue block72;
                    }
                    case -110: {
                        this.loadNewObjEx(frame, self);
                        continue block72;
                    }
                    case 99: {
                        this.loadGlobal(frame, ctx, self);
                        continue block72;
                    }
                    case -109: {
                        this.loadStackGlobal(frame, ctx, self);
                        continue block72;
                    }
                    case 97: {
                        this.loadAppend(frame, self);
                        continue block72;
                    }
                    case 101: {
                        this.loadAppends(frame, self);
                        continue block72;
                    }
                    case 98: {
                        this.loadBuild(frame, self);
                        continue block72;
                    }
                    case 50: {
                        this.loadDup(self);
                        continue block72;
                    }
                    case 104: {
                        this.loadBinGet(frame, self);
                        continue block72;
                    }
                    case 106: {
                        this.loadLongBinGet(frame, self);
                        continue block72;
                    }
                    case 103: {
                        this.loadGet(frame, self);
                        continue block72;
                    }
                    case 40: {
                        LoadNode.loadMark(self);
                        continue block72;
                    }
                    case 113: {
                        this.loadBinPut(frame, self);
                        continue block72;
                    }
                    case 114: {
                        this.loadLongBinPut(frame, self);
                        continue block72;
                    }
                    case 112: {
                        this.loadPut(frame, self);
                        continue block72;
                    }
                    case -108: {
                        this.loadMemoize(self);
                        continue block72;
                    }
                    case 48: {
                        this.loadPop(self);
                        continue block72;
                    }
                    case 49: {
                        this.loadPopMark(self);
                        continue block72;
                    }
                    case 115: {
                        this.loadSetItem(frame, self);
                        continue block72;
                    }
                    case 117: {
                        this.loadSetItems(frame, self);
                        continue block72;
                    }
                    case 80: {
                        this.loadPersId(frame, self);
                        continue block72;
                    }
                    case 81: {
                        this.loadBinPersId(frame, self);
                        continue block72;
                    }
                    case 82: {
                        this.loadReduce(frame, self);
                        continue block72;
                    }
                    case -128: {
                        this.loadProto(frame, self);
                        continue block72;
                    }
                    case -107: {
                        this.loadFrame(frame, self);
                        continue block72;
                    }
                    case -126: {
                        this.loadExtension(frame, ctx, self, 1);
                        continue block72;
                    }
                    case -125: {
                        this.loadExtension(frame, ctx, self, 2);
                        continue block72;
                    }
                    case -124: {
                        this.loadExtension(frame, ctx, self, 4);
                        continue block72;
                    }
                    case -120: {
                        this.loadBool(self, true);
                        continue block72;
                    }
                    case -119: {
                        this.loadBool(self, false);
                        continue block72;
                    }
                    case 46: {
                        break block72;
                    }
                    default: {
                        if (32 <= s && s <= 126 && s != 39 && s != 92) {
                            throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.INVALID_LOAD_KEY_CHR, s);
                        }
                        throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.INVALID_LOAD_KEY_HEX, s);
                    }
                }
                break;
            }
            this.skipConsumed(frame, self);
            return this.pDataPop(self);
        }
    }

    public static abstract class FindClassNode
    extends BasePickleReadNode {
        public abstract Object execute(VirtualFrame var1, PUnpickler var2, TruffleString var3, TruffleString var4);

        @Specialization
        Object find(VirtualFrame frame, PUnpickler unpickler, TruffleString module, TruffleString name) {
            return this.findClass(frame, PythonContext.get(this).getCore(), unpickler, module, name);
        }
    }

    public static abstract class BasePickleReadNode
    extends PicklerNodes.BasePickleNode {
        @Node.Child
        private PyMemoryViewFromObject memoryViewNode;
        @Node.Child
        private MemoryViewBuiltins.ToReadonlyNode toReadonlyNode;
        @Node.Child
        private PythonBufferAcquireLibrary bufferAcquireLibrary;
        @Node.Child
        private PythonBufferAccessLibrary bufferAccessLibrary;
        @Node.Child
        private TruffleString.ParseLongNode tsParseLongNode;
        @Node.Child
        private TruffleString.ParseIntNode tsParseIntNode;
        private final IndirectCallData indirectCallData = IndirectCallData.createFor(this);

        protected TruffleString.ParseLongNode ensureTsParseLongNode() {
            if (this.tsParseLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsParseLongNode = (TruffleString.ParseLongNode)this.insert((Node)TruffleString.ParseLongNode.create());
            }
            return this.tsParseLongNode;
        }

        protected TruffleString.ParseIntNode ensureTsParseIntNode() {
            if (this.tsParseIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsParseIntNode = (TruffleString.ParseIntNode)this.insert((Node)TruffleString.ParseIntNode.create());
            }
            return this.tsParseIntNode;
        }

        protected PyMemoryViewFromObject ensureMemoryViewNode() {
            if (this.memoryViewNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.memoryViewNode = (PyMemoryViewFromObject)this.insert(PyMemoryViewFromObject.create());
            }
            return this.memoryViewNode;
        }

        protected MemoryViewBuiltins.ToReadonlyNode getToReadonlyNode() {
            if (this.toReadonlyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toReadonlyNode = (MemoryViewBuiltins.ToReadonlyNode)this.insert(MemoryViewBuiltinsFactory.ToReadonlyNodeFactory.create());
            }
            return this.toReadonlyNode;
        }

        protected PythonBufferAcquireLibrary getBufferAcquireLibrary() {
            if (this.bufferAcquireLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferAcquireLibrary = (PythonBufferAcquireLibrary)this.insert((Node)((PythonBufferAcquireLibrary)PythonBufferAcquireLibrary.getFactory().createDispatched(3)));
            }
            return this.bufferAcquireLibrary;
        }

        protected PythonBufferAccessLibrary getBufferAccessLibrary() {
            if (this.bufferAccessLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferAccessLibrary = (PythonBufferAccessLibrary)this.insert((Node)((PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().createDispatched(3)));
            }
            return this.bufferAccessLibrary;
        }

        public Object createMemoryViewFromBytes(VirtualFrame frame, byte[] bytes, int n) {
            return this.ensureMemoryViewNode().execute(frame, this.factory().createByteArray(bytes, n));
        }

        public Object createMemoryView(VirtualFrame frame, Object obj) {
            return this.ensureMemoryViewNode().execute(frame, obj);
        }

        protected PException badReadLine() {
            return this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.PICKLE_DATA_WAS_TRUNCATED);
        }

        protected PException pDataStackRaiseUnderflow(PUnpickler self) {
            return this.raise(PythonBuiltinClassType.UnpicklingError, self.stack.mark ? ErrorMessages.PDATA_UNEXPECTED_MARK_FOUND : ErrorMessages.PDATA_UNPICKLING_STACK_UNDERFLOW);
        }

        protected void skipConsumed(VirtualFrame frame, PUnpickler self) {
            int consumed = self.nextReadIdx - self.prefetchedIdx;
            if (consumed <= 0) {
                return;
            }
            assert (self.peek != null);
            this.call(frame, self.read, consumed);
            self.prefetchedIdx = self.nextReadIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int setStringInput(PUnpickler self, VirtualFrame frame, Object input) {
            Object buffer = this.getBufferAcquireLibrary().acquire(input, 8, frame, this.indirectCallData);
            try {
                self.inputBuffer = this.getBufferAccessLibrary().getCopiedByteArray(buffer);
                self.inputLen = this.getBufferAccessLibrary().getBufferLength(buffer);
                self.nextReadIdx = 0;
                self.prefetchedIdx = self.inputLen;
                int n = self.inputLen;
                return n;
            }
            finally {
                this.getBufferAccessLibrary().release(input, frame, this.indirectCallData);
            }
        }

        protected int readFromFile(VirtualFrame frame, PUnpickler self, int n) {
            int readSize;
            Object data;
            assert (self.read != null);
            this.skipConsumed(frame, self);
            if (n == -1) {
                data = this.call(frame, self.readline, new Object[0]);
            } else {
                int len;
                if (self.peek != null && n < 131072) {
                    len = 131072;
                    try {
                        data = this.call(frame, self.peek, len);
                        readSize = this.setStringInput(self, frame, data);
                        self.prefetchedIdx = 0;
                        if (n <= readSize) {
                            return n;
                        }
                    }
                    catch (PException pe) {
                        pe.expectCached(PythonBuiltinClassType.NotImplementedError, this.ensureErrProfile());
                    }
                }
                len = n;
                data = this.call(frame, self.read, len);
            }
            assert (data != null);
            readSize = this.setStringInput(self, frame, data);
            return readSize;
        }

        protected byte read(VirtualFrame frame, PUnpickler self) {
            return this.read(frame, self, 1).get(0);
        }

        protected ByteArrayView read(VirtualFrame frame, PUnpickler self, int n) {
            if (n <= self.inputLen - self.nextReadIdx) {
                ByteArrayView bytesView = new ByteArrayView(self.inputBuffer, self.nextReadIdx);
                self.nextReadIdx += n;
                return bytesView;
            }
            return this.readImpl(frame, self, n);
        }

        private ByteArrayView readImpl(VirtualFrame frame, PUnpickler self, int n) {
            if (self.nextReadIdx > 0x7FFFFFFE) {
                throw this.raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.READ_OVERFLOW);
            }
            assert (self.nextReadIdx + n > self.inputLen);
            if (self.read == null) {
                throw this.badReadLine();
            }
            int numRead = this.readFromFile(frame, self, n);
            if (numRead < n) {
                throw this.badReadLine();
            }
            self.nextReadIdx = n;
            return new ByteArrayView(self.inputBuffer);
        }

        protected int readInto(VirtualFrame frame, PUnpickler self, byte[] buffer) {
            return this.readInto(frame, self, buffer, buffer.length);
        }

        protected int readInto(VirtualFrame frame, PUnpickler self, byte[] buffer, int numBytes) {
            int readSize;
            int n = numBytes;
            assert (n != -1);
            int inBuffer = self.inputLen - self.nextReadIdx;
            int bufOffset = 0;
            if (inBuffer > 0) {
                int toRead = Math.min(inBuffer, n);
                PythonUtils.arraycopy(self.inputBuffer, self.nextReadIdx, buffer, bufOffset, toRead);
                self.nextReadIdx += toRead;
                bufOffset += toRead;
                if ((n -= toRead) == 0) {
                    return n;
                }
            }
            if (self.read == null) {
                throw this.badReadLine();
            }
            this.skipConsumed(frame, self);
            if (self.readinto == null) {
                Object data = this.call(frame, self.read, n);
                if (!(data instanceof PBytes)) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_RETURNED_NON_BYTES_P, "read()", data);
                }
                int readSize2 = this.getBufferAccessLibrary().getBufferLength(data);
                if (readSize2 < n) {
                    throw this.badReadLine();
                }
                this.getBufferAccessLibrary().readIntoByteArray(data, 0, buffer, bufOffset, n);
                return n;
            }
            if (bufOffset == 0) {
                Object bufObj = this.createMemoryViewFromBytes(frame, buffer, n);
                Object readSizeObj = this.call(frame, self.readinto, bufObj);
                readSize = this.asSizeExact(frame, readSizeObj);
                if (readSize < 0) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_RETURNED_NEG_SIZE, "readinto()");
                }
            } else {
                byte[] temp = new byte[n];
                Object bufObj = this.createMemoryViewFromBytes(frame, temp, n);
                Object readSizeObj = this.call(frame, self.readinto, bufObj);
                readSize = this.asSizeExact(frame, readSizeObj);
                if (readSize < 0) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_RETURNED_NEG_SIZE, "readinto()");
                }
                PythonUtils.arraycopy(temp, 0, buffer, bufOffset, readSize);
            }
            if (readSize < n) {
                throw this.badReadLine();
            }
            return n;
        }

        protected byte[] copyLine(PUnpickler self, byte[] line, int len) {
            return this.copyLine(self, line, 0, len);
        }

        protected byte[] copyLine(PUnpickler self, byte[] line, int lineStart, int len) {
            self.inputLine = new byte[len];
            PythonUtils.arraycopy(line, lineStart, self.inputLine, 0, len);
            return self.inputLine;
        }

        protected byte[] readLine(VirtualFrame frame, PUnpickler self) {
            for (int i = self.nextReadIdx; i < self.inputLen; ++i) {
                if (self.inputBuffer[i] != 10) continue;
                int numRead = i - self.nextReadIdx + 1;
                byte[] line = this.copyLine(self, self.inputBuffer, self.nextReadIdx, numRead);
                self.nextReadIdx = i + 1;
                return line;
            }
            if (self.read == null) {
                throw this.badReadLine();
            }
            int numRead = this.readFromFile(frame, self, -1);
            if (numRead == 0 || self.inputBuffer[numRead - 1] != 10) {
                throw this.badReadLine();
            }
            self.nextReadIdx = numRead;
            return this.copyLine(self, self.inputBuffer, numRead);
        }
    }
}

