/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.buffer;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.lang.invoke.MethodHandles;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PythonBufferAccessLibrary.class)
final class PythonBufferAccessLibraryGen
extends LibraryFactory<PythonBufferAccessLibrary> {
    private static final Class<PythonBufferAccessLibrary> LIBRARY_CLASS = PythonBufferAccessLibraryGen.lazyLibraryClass();
    private static final Message IS_BUFFER = new MessageImpl("isBuffer", 0, false, Boolean.TYPE, Object.class);
    private static final Message RELEASE = new MessageImpl("release", 1, false, Void.TYPE, Object.class);
    private static final Message GET_BUFFER_LENGTH = new MessageImpl("getBufferLength", 2, false, Integer.TYPE, Object.class);
    private static final Message IS_READONLY = new MessageImpl("isReadonly", 3, false, Boolean.TYPE, Object.class);
    private static final Message HAS_INTERNAL_BYTE_ARRAY = new MessageImpl("hasInternalByteArray", 4, false, Boolean.TYPE, Object.class);
    private static final Message GET_INTERNAL_BYTE_ARRAY = new MessageImpl("getInternalByteArray", 5, false, byte[].class, Object.class);
    private static final Message READ_INTO_BYTE_ARRAY = new MessageImpl("readIntoByteArray", 6, false, Void.TYPE, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
    private static final Message WRITE_FROM_BYTE_ARRAY = new MessageImpl("writeFromByteArray", 7, false, Void.TYPE, Object.class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
    private static final Message READ_INTO_BUFFER = new MessageImpl("readIntoBuffer", 8, false, Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, PythonBufferAccessLibrary.class);
    private static final Message READ_BYTE = new MessageImpl("readByte", 9, false, Byte.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_SHORT = new MessageImpl("readShort", 10, false, Short.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_SHORT_BYTE_ORDER = new MessageImpl("readShortByteOrder", 11, false, Short.TYPE, Object.class, Integer.TYPE, ByteOrder.class);
    private static final Message READ_INT = new MessageImpl("readInt", 12, false, Integer.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_INT_BYTE_ORDER = new MessageImpl("readIntByteOrder", 13, false, Integer.TYPE, Object.class, Integer.TYPE, ByteOrder.class);
    private static final Message READ_LONG = new MessageImpl("readLong", 14, false, Long.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_LONG_BYTE_ORDER = new MessageImpl("readLongByteOrder", 15, false, Long.TYPE, Object.class, Integer.TYPE, ByteOrder.class);
    private static final Message READ_FLOAT = new MessageImpl("readFloat", 16, false, Float.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_FLOAT_BYTE_ORDER = new MessageImpl("readFloatByteOrder", 17, false, Float.TYPE, Object.class, Integer.TYPE, ByteOrder.class);
    private static final Message READ_DOUBLE = new MessageImpl("readDouble", 18, false, Double.TYPE, Object.class, Integer.TYPE);
    private static final Message READ_DOUBLE_BYTE_ORDER = new MessageImpl("readDoubleByteOrder", 19, false, Double.TYPE, Object.class, Integer.TYPE, ByteOrder.class);
    private static final Message WRITE_BYTE = new MessageImpl("writeByte", 20, false, Void.TYPE, Object.class, Integer.TYPE, Byte.TYPE);
    private static final Message WRITE_SHORT = new MessageImpl("writeShort", 21, false, Void.TYPE, Object.class, Integer.TYPE, Short.TYPE);
    private static final Message WRITE_SHORT_BYTE_ORDER = new MessageImpl("writeShortByteOrder", 22, false, Void.TYPE, Object.class, Integer.TYPE, Short.TYPE, ByteOrder.class);
    private static final Message WRITE_INT = new MessageImpl("writeInt", 23, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
    private static final Message WRITE_INT_BYTE_ORDER = new MessageImpl("writeIntByteOrder", 24, false, Void.TYPE, Object.class, Integer.TYPE, Integer.TYPE, ByteOrder.class);
    private static final Message WRITE_LONG = new MessageImpl("writeLong", 25, false, Void.TYPE, Object.class, Integer.TYPE, Long.TYPE);
    private static final Message WRITE_LONG_BYTE_ORDER = new MessageImpl("writeLongByteOrder", 26, false, Void.TYPE, Object.class, Integer.TYPE, Long.TYPE, ByteOrder.class);
    private static final Message WRITE_FLOAT = new MessageImpl("writeFloat", 27, false, Void.TYPE, Object.class, Integer.TYPE, Float.TYPE);
    private static final Message WRITE_FLOAT_BYTE_ORDER = new MessageImpl("writeFloatByteOrder", 28, false, Void.TYPE, Object.class, Integer.TYPE, Float.TYPE, ByteOrder.class);
    private static final Message WRITE_DOUBLE = new MessageImpl("writeDouble", 29, false, Void.TYPE, Object.class, Integer.TYPE, Double.TYPE);
    private static final Message WRITE_DOUBLE_BYTE_ORDER = new MessageImpl("writeDoubleByteOrder", 30, false, Void.TYPE, Object.class, Integer.TYPE, Double.TYPE, ByteOrder.class);
    private static final Message GET_OWNER = new MessageImpl("getOwner", 31, false, Object.class, Object.class);
    private static final Message GET_ITEM_SIZE = new MessageImpl("getItemSize", 32, false, Integer.TYPE, Object.class);
    private static final Message GET_FORMAT_STRING = new MessageImpl("getFormatString", 33, false, TruffleString.class, Object.class);
    private static final Message IS_NATIVE = new MessageImpl("isNative", 34, false, Boolean.TYPE, Object.class);
    private static final Message GET_NATIVE_POINTER = new MessageImpl("getNativePointer", 35, false, Object.class, Object.class);
    private static final PythonBufferAccessLibraryGen INSTANCE = new PythonBufferAccessLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private PythonBufferAccessLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_BUFFER, RELEASE, GET_BUFFER_LENGTH, IS_READONLY, HAS_INTERNAL_BYTE_ARRAY, GET_INTERNAL_BYTE_ARRAY, READ_INTO_BYTE_ARRAY, WRITE_FROM_BYTE_ARRAY, READ_INTO_BUFFER, READ_BYTE, READ_SHORT, READ_SHORT_BYTE_ORDER, READ_INT, READ_INT_BYTE_ORDER, READ_LONG, READ_LONG_BYTE_ORDER, READ_FLOAT, READ_FLOAT_BYTE_ORDER, READ_DOUBLE, READ_DOUBLE_BYTE_ORDER, WRITE_BYTE, WRITE_SHORT, WRITE_SHORT_BYTE_ORDER, WRITE_INT, WRITE_INT_BYTE_ORDER, WRITE_LONG, WRITE_LONG_BYTE_ORDER, WRITE_FLOAT, WRITE_FLOAT_BYTE_ORDER, WRITE_DOUBLE, WRITE_DOUBLE_BYTE_ORDER, GET_OWNER, GET_ITEM_SIZE, GET_FORMAT_STRING, IS_NATIVE, GET_NATIVE_POINTER));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return PythonBufferAccessLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected PythonBufferAccessLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected PythonBufferAccessLibrary createDelegate(PythonBufferAccessLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PythonBufferAccessLibrary lib = (PythonBufferAccessLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isBuffer(receiver);
            }
            case 1: {
                lib.release(receiver);
                return null;
            }
            case 2: {
                return lib.getBufferLength(receiver);
            }
            case 3: {
                return lib.isReadonly(receiver);
            }
            case 4: {
                return lib.hasInternalByteArray(receiver);
            }
            case 5: {
                return lib.getInternalByteArray(receiver);
            }
            case 6: {
                lib.readIntoByteArray(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
                return null;
            }
            case 7: {
                lib.writeFromByteArray(receiver, (Integer)args[offset], (byte[])args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3]);
                return null;
            }
            case 8: {
                lib.readIntoBuffer(receiver, (Integer)args[offset], args[offset + 1], (Integer)args[offset + 2], (Integer)args[offset + 3], (PythonBufferAccessLibrary)((Object)args[offset + 4]));
                return null;
            }
            case 9: {
                return lib.readByte(receiver, (Integer)args[offset]);
            }
            case 10: {
                return lib.readShort(receiver, (Integer)args[offset]);
            }
            case 11: {
                return lib.readShortByteOrder(receiver, (Integer)args[offset], (ByteOrder)args[offset + 1]);
            }
            case 12: {
                return lib.readInt(receiver, (Integer)args[offset]);
            }
            case 13: {
                return lib.readIntByteOrder(receiver, (Integer)args[offset], (ByteOrder)args[offset + 1]);
            }
            case 14: {
                return lib.readLong(receiver, (Integer)args[offset]);
            }
            case 15: {
                return lib.readLongByteOrder(receiver, (Integer)args[offset], (ByteOrder)args[offset + 1]);
            }
            case 16: {
                return Float.valueOf(lib.readFloat(receiver, (Integer)args[offset]));
            }
            case 17: {
                return Float.valueOf(lib.readFloatByteOrder(receiver, (Integer)args[offset], (ByteOrder)args[offset + 1]));
            }
            case 18: {
                return lib.readDouble(receiver, (Integer)args[offset]);
            }
            case 19: {
                return lib.readDoubleByteOrder(receiver, (Integer)args[offset], (ByteOrder)args[offset + 1]);
            }
            case 20: {
                lib.writeByte(receiver, (Integer)args[offset], (Byte)args[offset + 1]);
                return null;
            }
            case 21: {
                lib.writeShort(receiver, (Integer)args[offset], (Short)args[offset + 1]);
                return null;
            }
            case 22: {
                lib.writeShortByteOrder(receiver, (Integer)args[offset], (Short)args[offset + 1], (ByteOrder)args[offset + 2]);
                return null;
            }
            case 23: {
                lib.writeInt(receiver, (Integer)args[offset], (Integer)args[offset + 1]);
                return null;
            }
            case 24: {
                lib.writeIntByteOrder(receiver, (Integer)args[offset], (Integer)args[offset + 1], (ByteOrder)args[offset + 2]);
                return null;
            }
            case 25: {
                lib.writeLong(receiver, (Integer)args[offset], (Long)args[offset + 1]);
                return null;
            }
            case 26: {
                lib.writeLongByteOrder(receiver, (Integer)args[offset], (Long)args[offset + 1], (ByteOrder)args[offset + 2]);
                return null;
            }
            case 27: {
                lib.writeFloat(receiver, (Integer)args[offset], ((Float)args[offset + 1]).floatValue());
                return null;
            }
            case 28: {
                lib.writeFloatByteOrder(receiver, (Integer)args[offset], ((Float)args[offset + 1]).floatValue(), (ByteOrder)args[offset + 2]);
                return null;
            }
            case 29: {
                lib.writeDouble(receiver, (Integer)args[offset], (Double)args[offset + 1]);
                return null;
            }
            case 30: {
                lib.writeDoubleByteOrder(receiver, (Integer)args[offset], (Double)args[offset + 1], (ByteOrder)args[offset + 2]);
                return null;
            }
            case 31: {
                return lib.getOwner(receiver);
            }
            case 32: {
                return lib.getItemSize(receiver);
            }
            case 33: {
                return lib.getFormatString(receiver);
            }
            case 34: {
                return lib.isNative(receiver);
            }
            case 35: {
                return lib.getNativePointer(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected PythonBufferAccessLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected PythonBufferAccessLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<PythonBufferAccessLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary", false, PythonBufferAccessLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class Proxy
    extends PythonBufferAccessLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isBuffer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_BUFFER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void release(Object receiver_) {
            try {
                this.lib.send(receiver_, RELEASE, new Object[0]);
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int getBufferLength(Object receiver_) {
            try {
                return (Integer)this.lib.send(receiver_, GET_BUFFER_LENGTH, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isReadonly(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_READONLY, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, HAS_INTERNAL_BYTE_ARRAY, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            try {
                return (byte[])this.lib.send(receiver_, GET_INTERNAL_BYTE_ARRAY, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            try {
                this.lib.send(receiver_, READ_INTO_BYTE_ARRAY, new Object[]{srcOffset, dest, destOffset, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            try {
                this.lib.send(receiver_, WRITE_FROM_BYTE_ARRAY, new Object[]{destOffset, src, srcOffset, length});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            try {
                this.lib.send(receiver_, READ_INTO_BUFFER, new Object[]{srcOffset, dest, destOffset, length, otherLib});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            try {
                return (Byte)this.lib.send(receiver_, READ_BYTE, new Object[]{byteOffset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public short readShort(Object receiver_, int byteOffset) {
            try {
                return (Short)this.lib.send(receiver_, READ_SHORT, new Object[]{byteOffset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (Short)this.lib.send(receiver_, READ_SHORT_BYTE_ORDER, new Object[]{byteOffset, byteOrder});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int readInt(Object receiver_, int byteOffset) {
            try {
                return (Integer)this.lib.send(receiver_, READ_INT, new Object[]{byteOffset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (Integer)this.lib.send(receiver_, READ_INT_BYTE_ORDER, new Object[]{byteOffset, byteOrder});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long readLong(Object receiver_, int byteOffset) {
            try {
                return (Long)this.lib.send(receiver_, READ_LONG, new Object[]{byteOffset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (Long)this.lib.send(receiver_, READ_LONG_BYTE_ORDER, new Object[]{byteOffset, byteOrder});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            try {
                return ((Float)this.lib.send(receiver_, READ_FLOAT, new Object[]{byteOffset})).floatValue();
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return ((Float)this.lib.send(receiver_, READ_FLOAT_BYTE_ORDER, new Object[]{byteOffset, byteOrder})).floatValue();
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            try {
                return (Double)this.lib.send(receiver_, READ_DOUBLE, new Object[]{byteOffset});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            try {
                return (Double)this.lib.send(receiver_, READ_DOUBLE_BYTE_ORDER, new Object[]{byteOffset, byteOrder});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            try {
                this.lib.send(receiver_, WRITE_BYTE, new Object[]{byteOffset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            try {
                this.lib.send(receiver_, WRITE_SHORT, new Object[]{byteOffset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            try {
                this.lib.send(receiver_, WRITE_SHORT_BYTE_ORDER, new Object[]{byteOffset, value, byteOrder});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            try {
                this.lib.send(receiver_, WRITE_INT, new Object[]{byteOffset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            try {
                this.lib.send(receiver_, WRITE_INT_BYTE_ORDER, new Object[]{byteOffset, value, byteOrder});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            try {
                this.lib.send(receiver_, WRITE_LONG, new Object[]{byteOffset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            try {
                this.lib.send(receiver_, WRITE_LONG_BYTE_ORDER, new Object[]{byteOffset, value, byteOrder});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            try {
                this.lib.send(receiver_, WRITE_FLOAT, new Object[]{byteOffset, Float.valueOf(value)});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            try {
                this.lib.send(receiver_, WRITE_FLOAT_BYTE_ORDER, new Object[]{byteOffset, Float.valueOf(value), byteOrder});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            try {
                this.lib.send(receiver_, WRITE_DOUBLE, new Object[]{byteOffset, value});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            try {
                this.lib.send(receiver_, WRITE_DOUBLE_BYTE_ORDER, new Object[]{byteOffset, value, byteOrder});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getOwner(Object receiver_) {
            try {
                return this.lib.send(receiver_, GET_OWNER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public int getItemSize(Object receiver_) {
            try {
                return (Integer)this.lib.send(receiver_, GET_ITEM_SIZE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public TruffleString getFormatString(Object receiver_) {
            try {
                return (TruffleString)this.lib.send(receiver_, GET_FORMAT_STRING, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public boolean isNative(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_NATIVE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object getNativePointer(Object receiver_) {
            try {
                return this.lib.send(receiver_, GET_NATIVE_POINTER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class Delegate
    extends PythonBufferAccessLibrary {
        @Node.Child
        private PythonBufferAccessLibrary delegateLibrary;

        Delegate(PythonBufferAccessLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isBuffer(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isBuffer(delegate);
            }
            return this.delegateLibrary.isBuffer(receiver_);
        }

        @Override
        public void release(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).release(delegate);
                return;
            }
            this.delegateLibrary.release(receiver_);
        }

        @Override
        public int getBufferLength(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getBufferLength(delegate);
            }
            return this.delegateLibrary.getBufferLength(receiver_);
        }

        @Override
        public boolean isReadonly(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isReadonly(delegate);
            }
            return this.delegateLibrary.isReadonly(receiver_);
        }

        @Override
        public boolean hasInternalByteArray(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)4)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).hasInternalByteArray(delegate);
            }
            return this.delegateLibrary.hasInternalByteArray(receiver_);
        }

        @Override
        public byte[] getInternalByteArray(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)5)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getInternalByteArray(delegate);
            }
            return this.delegateLibrary.getInternalByteArray(receiver_);
        }

        @Override
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)6)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readIntoByteArray(delegate, srcOffset, dest, destOffset, length);
                return;
            }
            this.delegateLibrary.readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
        }

        @Override
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)7)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeFromByteArray(delegate, destOffset, src, srcOffset, length);
                return;
            }
            this.delegateLibrary.writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
        }

        @Override
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)8)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readIntoBuffer(delegate, srcOffset, dest, destOffset, length, otherLib);
                return;
            }
            this.delegateLibrary.readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
        }

        @Override
        public byte readByte(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)9)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readByte(delegate, byteOffset);
            }
            return this.delegateLibrary.readByte(receiver_, byteOffset);
        }

        @Override
        public short readShort(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)10)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readShort(delegate, byteOffset);
            }
            return this.delegateLibrary.readShort(receiver_, byteOffset);
        }

        @Override
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)11)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readShortByteOrder(delegate, byteOffset, byteOrder);
            }
            return this.delegateLibrary.readShortByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        public int readInt(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)12)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readInt(delegate, byteOffset);
            }
            return this.delegateLibrary.readInt(receiver_, byteOffset);
        }

        @Override
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)13)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readIntByteOrder(delegate, byteOffset, byteOrder);
            }
            return this.delegateLibrary.readIntByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        public long readLong(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)14)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readLong(delegate, byteOffset);
            }
            return this.delegateLibrary.readLong(receiver_, byteOffset);
        }

        @Override
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)15)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readLongByteOrder(delegate, byteOffset, byteOrder);
            }
            return this.delegateLibrary.readLongByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        public float readFloat(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)16)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readFloat(delegate, byteOffset);
            }
            return this.delegateLibrary.readFloat(receiver_, byteOffset);
        }

        @Override
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)17)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readFloatByteOrder(delegate, byteOffset, byteOrder);
            }
            return this.delegateLibrary.readFloatByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        public double readDouble(Object receiver_, int byteOffset) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)18)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readDouble(delegate, byteOffset);
            }
            return this.delegateLibrary.readDouble(receiver_, byteOffset);
        }

        @Override
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)19)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).readDoubleByteOrder(delegate, byteOffset, byteOrder);
            }
            return this.delegateLibrary.readDoubleByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)20)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeByte(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeByte(receiver_, byteOffset, value);
        }

        @Override
        public void writeShort(Object receiver_, int byteOffset, short value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)21)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeShort(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeShort(receiver_, byteOffset, value);
        }

        @Override
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)22)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeShortByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            }
            this.delegateLibrary.writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        public void writeInt(Object receiver_, int byteOffset, int value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)23)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeInt(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeInt(receiver_, byteOffset, value);
        }

        @Override
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)24)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeIntByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            }
            this.delegateLibrary.writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        public void writeLong(Object receiver_, int byteOffset, long value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)25)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeLong(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeLong(receiver_, byteOffset, value);
        }

        @Override
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)26)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeLongByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            }
            this.delegateLibrary.writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)27)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeFloat(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeFloat(receiver_, byteOffset, value);
        }

        @Override
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)28)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeFloatByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            }
            this.delegateLibrary.writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)29)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeDouble(delegate, byteOffset, value);
                return;
            }
            this.delegateLibrary.writeDouble(receiver_, byteOffset, value);
        }

        @Override
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)30)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).writeDoubleByteOrder(delegate, byteOffset, value, byteOrder);
                return;
            }
            this.delegateLibrary.writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        public Object getOwner(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)31)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getOwner(delegate);
            }
            return this.delegateLibrary.getOwner(receiver_);
        }

        @Override
        public int getItemSize(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)32)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getItemSize(delegate);
            }
            return this.delegateLibrary.getItemSize(receiver_);
        }

        @Override
        public TruffleString getFormatString(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)33)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getFormatString(delegate);
            }
            return this.delegateLibrary.getFormatString(receiver_);
        }

        @Override
        public boolean isNative(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)34)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isNative(delegate);
            }
            return this.delegateLibrary.isNative(receiver_);
        }

        @Override
        public Object getNativePointer(Object receiver_) {
            if (PythonBufferAccessLibraryGen.isDelegated((Library)this.delegateLibrary, (int)35)) {
                Object delegate = PythonBufferAccessLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PythonBufferAccessLibrary)PythonBufferAccessLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getNativePointer(delegate);
            }
            return this.delegateLibrary.getNativePointer(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(PythonBufferAccessLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static abstract class CachedDispatch
    extends PythonBufferAccessLibrary {
        @Node.Child
        PythonBufferAccessLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(PythonBufferAccessLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isBuffer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isBuffer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void release(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.release(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int getBufferLength(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getBufferLength(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isReadonly(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isReadonly(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean hasInternalByteArray(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.hasInternalByteArray(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public byte[] getInternalByteArray(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getInternalByteArray(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public byte readByte(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readByte(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public short readShort(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readShort(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readShortByteOrder(receiver_, byteOffset, byteOrder);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int readInt(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readInt(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readIntByteOrder(receiver_, byteOffset, byteOrder);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long readLong(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readLong(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readLongByteOrder(receiver_, byteOffset, byteOrder);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public float readFloat(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readFloat(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readFloatByteOrder(receiver_, byteOffset, byteOrder);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public double readDouble(Object receiver_, int byteOffset) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readDouble(receiver_, byteOffset);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.readDoubleByteOrder(receiver_, byteOffset, byteOrder);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeByte(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeShort(Object receiver_, int byteOffset, short value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeShort(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeInt(Object receiver_, int byteOffset, int value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeInt(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeLong(Object receiver_, int byteOffset, long value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeLong(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeFloat(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeDouble(receiver_, byteOffset, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getOwner(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getOwner(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public int getItemSize(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getItemSize(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public TruffleString getFormatString(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getFormatString(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public boolean isNative(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isNative(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object getNativePointer(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PythonBufferAccessLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getNativePointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PythonBufferAccessLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (PythonBufferAccessLibrary)this.insert((Node)((PythonBufferAccessLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        PythonBufferAccessLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (PythonBufferAccessLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((PythonBufferAccessLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends PythonBufferAccessLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isBuffer(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isBuffer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void release(Object receiver_) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).release(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getBufferLength(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getBufferLength(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadonly(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isReadonly(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasInternalByteArray(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).hasInternalByteArray(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte[] getInternalByteArray(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getInternalByteArray(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readByte(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readByte(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public short readShort(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readShort(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readShortByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int readInt(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readInt(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long readLong(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readLong(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readLongByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readFloatByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, int byteOffset) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, byteOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readDoubleByteOrder(receiver_, byteOffset, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeByte(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeShort(Object receiver_, int byteOffset, short value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeShort(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeInt(Object receiver_, int byteOffset, int value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeInt(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeLong(Object receiver_, int byteOffset, long value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeLong(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFloat(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeDouble(receiver_, byteOffset, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getOwner(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getOwner(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getItemSize(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getItemSize(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getFormatString(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getFormatString(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isNative(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isNative(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativePointer(Object receiver_) {
            return ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getNativePointer(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class Default
    extends LibraryExport<PythonBufferAccessLibrary> {
        private Default() {
            super(PythonBufferAccessLibrary.class, Object.class, false, false, 0);
        }

        protected PythonBufferAccessLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected PythonBufferAccessLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=PythonBufferAccessLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends PythonBufferAccessLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBuffer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void release(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.release(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getBufferLength(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getBufferLength(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isReadonly(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isReadonly(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasInternalByteArray(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasInternalByteArray(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte[] getInternalByteArray(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getInternalByteArray(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void readIntoByteArray(Object receiver, int srcOffset, byte[] dest, int destOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoByteArray(receiver, srcOffset, dest, destOffset, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFromByteArray(Object receiver, int destOffset, byte[] src, int srcOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFromByteArray(receiver, destOffset, src, srcOffset, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void readIntoBuffer(Object receiver, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoBuffer(receiver, srcOffset, dest, destOffset, length, otherLib);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte readByte(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readByte(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readShort(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShort(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShortByteOrder(receiver, byteOffset, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readInt(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readInt(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readIntByteOrder(receiver, byteOffset, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readLong(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLong(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLongByteOrder(receiver, byteOffset, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloat(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloat(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloatByteOrder(receiver, byteOffset, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDouble(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDouble(receiver, byteOffset);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDoubleByteOrder(receiver, byteOffset, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeByte(Object receiver, int byteOffset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeByte(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeShort(Object receiver, int byteOffset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShort(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShortByteOrder(receiver, byteOffset, value, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeInt(Object receiver, int byteOffset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeInt(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeIntByteOrder(receiver, byteOffset, value, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeLong(Object receiver, int byteOffset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLong(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLongByteOrder(receiver, byteOffset, value, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloat(Object receiver, int byteOffset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloat(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloatByteOrder(receiver, byteOffset, value, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDouble(Object receiver, int byteOffset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDouble(receiver, byteOffset, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDoubleByteOrder(receiver, byteOffset, value, byteOrder);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getOwner(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getOwner(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getItemSize(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getItemSize(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getFormatString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getFormatString(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativePointer(receiver);
            }
        }

        @GeneratedBy(value=PythonBufferAccessLibrary.class)
        private static final class Cached
        extends PythonBufferAccessLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isBuffer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isBuffer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public void release(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.release(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public int getBufferLength(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getBufferLength(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isReadonly(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isReadonly(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean hasInternalByteArray(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.hasInternalByteArray(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public byte[] getInternalByteArray(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getInternalByteArray(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public void readIntoByteArray(Object receiver, int srcOffset, byte[] dest, int destOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoByteArray(this.dynamicDispatch_.cast(receiver), srcOffset, dest, destOffset, length);
            }

            @Override
            public void writeFromByteArray(Object receiver, int destOffset, byte[] src, int srcOffset, int length) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFromByteArray(this.dynamicDispatch_.cast(receiver), destOffset, src, srcOffset, length);
            }

            @Override
            public void readIntoBuffer(Object receiver, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.readIntoBuffer(this.dynamicDispatch_.cast(receiver), srcOffset, dest, destOffset, length, otherLib);
            }

            @Override
            public byte readByte(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readByte(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public short readShort(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShort(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public short readShortByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readShortByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, byteOrder);
            }

            @Override
            public int readInt(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readInt(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public int readIntByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readIntByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, byteOrder);
            }

            @Override
            public long readLong(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLong(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public long readLongByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readLongByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, byteOrder);
            }

            @Override
            public float readFloat(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloat(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public float readFloatByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readFloatByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, byteOrder);
            }

            @Override
            public double readDouble(Object receiver, int byteOffset) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDouble(this.dynamicDispatch_.cast(receiver), byteOffset);
            }

            @Override
            public double readDoubleByteOrder(Object receiver, int byteOffset, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.readDoubleByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, byteOrder);
            }

            @Override
            public void writeByte(Object receiver, int byteOffset, byte value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeByte(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeShort(Object receiver, int byteOffset, short value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShort(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeShortByteOrder(Object receiver, int byteOffset, short value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeShortByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, value, byteOrder);
            }

            @Override
            public void writeInt(Object receiver, int byteOffset, int value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeInt(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeIntByteOrder(Object receiver, int byteOffset, int value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeIntByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, value, byteOrder);
            }

            @Override
            public void writeLong(Object receiver, int byteOffset, long value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLong(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeLongByteOrder(Object receiver, int byteOffset, long value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeLongByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, value, byteOrder);
            }

            @Override
            public void writeFloat(Object receiver, int byteOffset, float value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloat(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeFloatByteOrder(Object receiver, int byteOffset, float value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeFloatByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, value, byteOrder);
            }

            @Override
            public void writeDouble(Object receiver, int byteOffset, double value) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDouble(this.dynamicDispatch_.cast(receiver), byteOffset, value);
            }

            @Override
            public void writeDoubleByteOrder(Object receiver, int byteOffset, double value, ByteOrder byteOrder) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.writeDoubleByteOrder(this.dynamicDispatch_.cast(receiver), byteOffset, value, byteOrder);
            }

            @Override
            public Object getOwner(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getOwner(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public int getItemSize(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getItemSize(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public TruffleString getFormatString(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getFormatString(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public boolean isNative(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isNative(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public Object getNativePointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getNativePointer(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(PythonBufferAccessLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=PythonBufferAccessLibrary.class)
    private static final class CachedToUncachedDispatch
    extends PythonBufferAccessLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isBuffer(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isBuffer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void release(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).release(receiver_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int getBufferLength(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getBufferLength(receiver_);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isReadonly(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isReadonly(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasInternalByteArray(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).hasInternalByteArray(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte[] getInternalByteArray(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                byte[] byArray = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getInternalByteArray(receiver_);
                return byArray;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void readIntoByteArray(Object receiver_, int srcOffset, byte[] dest, int destOffset, int length) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntoByteArray(receiver_, srcOffset, dest, destOffset, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFromByteArray(Object receiver_, int destOffset, byte[] src, int srcOffset, int length) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFromByteArray(receiver_, destOffset, src, srcOffset, length);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void readIntoBuffer(Object receiver_, int srcOffset, Object dest, int destOffset, int length, PythonBufferAccessLibrary otherLib) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntoBuffer(receiver_, srcOffset, dest, destOffset, length, otherLib);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public byte readByte(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                byte by = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readByte(receiver_, byteOffset);
                return by;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public short readShort(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                short s = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readShort(receiver_, byteOffset);
                return s;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public short readShortByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                short s = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readShortByteOrder(receiver_, byteOffset, byteOrder);
                return s;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int readInt(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readInt(receiver_, byteOffset);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int readIntByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readIntByteOrder(receiver_, byteOffset, byteOrder);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long readLong(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readLong(receiver_, byteOffset);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long readLongByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readLongByteOrder(receiver_, byteOffset, byteOrder);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloat(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                float f = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readFloat(receiver_, byteOffset);
                return f;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public float readFloatByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                float f = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readFloatByteOrder(receiver_, byteOffset, byteOrder);
                return f;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDouble(Object receiver_, int byteOffset) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                double d = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readDouble(receiver_, byteOffset);
                return d;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public double readDoubleByteOrder(Object receiver_, int byteOffset, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                double d = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).readDoubleByteOrder(receiver_, byteOffset, byteOrder);
                return d;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeByte(Object receiver_, int byteOffset, byte value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeByte(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeShort(Object receiver_, int byteOffset, short value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeShort(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeShortByteOrder(Object receiver_, int byteOffset, short value, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeShortByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeInt(Object receiver_, int byteOffset, int value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeInt(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeIntByteOrder(Object receiver_, int byteOffset, int value, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeIntByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeLong(Object receiver_, int byteOffset, long value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeLong(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeLongByteOrder(Object receiver_, int byteOffset, long value, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeLongByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloat(Object receiver_, int byteOffset, float value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFloat(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeFloatByteOrder(Object receiver_, int byteOffset, float value, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeFloatByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDouble(Object receiver_, int byteOffset, double value) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeDouble(receiver_, byteOffset, value);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void writeDoubleByteOrder(Object receiver_, int byteOffset, double value, ByteOrder byteOrder) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).writeDoubleByteOrder(receiver_, byteOffset, value, byteOrder);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getOwner(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getOwner(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public int getItemSize(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                int n = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getItemSize(receiver_);
                return n;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public TruffleString getFormatString(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                TruffleString truffleString = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getFormatString(receiver_);
                return truffleString;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isNative(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).isNative(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getNativePointer(Object receiver_) {
            assert (PythonBufferAccessLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((PythonBufferAccessLibrary)INSTANCE.getUncached(receiver_)).getNativePointer(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

