/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class PyErrStackItem
extends PythonNativeWrapper.PythonStructNativeWrapper {
    public static final String J_EXC_TYPE = "exc_type";
    public static final String J_EXC_VALUE = "exc_value";
    public static final String J_EXC_TRACEBACK = "exc_traceback";
    public static final String J_PREVIOUS_ITEM = "previous_item";
    private final Object exception;

    public PyErrStackItem(Object exception) {
        this.exception = exception;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new Object[]{J_EXC_TYPE, J_EXC_VALUE, J_EXC_TRACEBACK, J_PREVIOUS_ITEM});
    }

    @ExportMessage
    boolean isMemberReadable(String key) {
        return J_EXC_TYPE.equals(key) || J_EXC_VALUE.equals(key) || J_EXC_TRACEBACK.equals(key) || J_PREVIOUS_ITEM.equals(key);
    }

    @ExportMessage
    Object readMember(String key, @Bind(value="$node") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached CApiTransitions.PythonToNativeNode toSulongNode) {
        Object result = null;
        if (this.exception != null) {
            switch (key) {
                case "exc_type": {
                    result = getClassNode.execute(inliningTarget, this.exception);
                    break;
                }
                case "exc_value": {
                    result = this.exception;
                    break;
                }
                case "exc_traceback": {
                    result = getTracebackNode.execute(inliningTarget, this.exception);
                    if (result != PNone.NONE) break;
                    result = null;
                }
            }
        }
        if (result == null) {
            result = PythonContext.get(toSulongNode).getNativeNull();
        }
        return toSulongNode.execute(result);
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    public long asPointer() throws UnsupportedMessageException {
        if (this.isNative()) {
            return this.getNativePointer();
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    void toNative(@Bind(value="$node") Node inliningTarget, @Cached InlinedConditionProfile isNativeProfile) {
        if (!this.isNative(inliningTarget, isNativeProfile)) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

