/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyLegacyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyMemberAccessNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyObjectBuiltins;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyTypeExtra;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIFunctionPointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonImageBuildOptions;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;

public abstract class GraalHPyNodes {
    protected static Object callBuiltinFunction(GraalHPyContext graalHPyContext, TruffleString func, Object[] pythonArguments, ReadAttributeFromObjectNode readAttr, CallNode callNode) {
        Object builtinFunction = readAttr.execute(graalHPyContext.getContext().getBuiltins(), func);
        return callNode.executeWithoutFrame(builtinFunction, pythonArguments, PKeyword.EMPTY_KEYWORDS);
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyReadCallFunctionNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, GraalHPyContext var2, Object var3);

        @Specialization
        static Object doIt(GraalHPyContext context, Object def, @Cached(parameters={"context"}, inline=false) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}, inline=false) GraalHPyCAccess.IsNullNode isNullNode, @Cached(inline=false) HPyAttachFunctionTypeNode attachFunctionTypeNode) {
            Object methodFunctionPointer = readPointerNode.read(context, def, GraalHPyCField.HPyCallFunction__impl);
            if (isNullNode.execute(context, methodFunctionPointer)) {
                return null;
            }
            GraalHPyDef.HPySlotWrapper slotWrapper = GraalHPyDef.HPySlot.HPY_TP_CALL.getSignatures()[0];
            return attachFunctionTypeNode.execute(context, methodFunctionPointer, slotWrapper.getLLVMFunctionType());
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyFieldStoreNode
    extends Node {
        public abstract int execute(Node var1, PythonObject var2, Object var3, Object var4);

        @Specialization
        static int doHandle(Node inliningTarget, PythonObject owner, GraalHPyHandle hpyFieldObject, Object referent, @Cached.Shared @Cached InlinedConditionProfile nullHandleProfile) {
            int idx = hpyFieldObject.getFieldId();
            if (nullHandleProfile.profile(inliningTarget, referent == GraalHPyHandle.NULL_HANDLE_DELEGATE && idx == 0)) {
                return 0;
            }
            return GraalHPyData.setHPyField(owner, referent, idx);
        }

        @Specialization(replaces={"doHandle"})
        static int doGeneric(Node inliningTarget, PythonObject owner, Object hpyFieldObject, Object referent, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached InlinedConditionProfile nullHandleProfile) {
            int idx;
            if (lib.isNull(hpyFieldObject)) {
                idx = 0;
            } else if (hpyFieldObject instanceof GraalHPyHandle) {
                idx = ((GraalHPyHandle)hpyFieldObject).getFieldId();
            } else {
                if (hpyFieldObject instanceof Long) {
                    try {
                        idx = PInt.intValueExact((Long)hpyFieldObject);
                    }
                    catch (OverflowException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                try {
                    idx = PInt.intValueExact(lib.asPointer(hpyFieldObject));
                }
                catch (OverflowException | InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (!nullHandleProfile.profile(inliningTarget, referent == GraalHPyHandle.NULL_HANDLE_DELEGATE && idx == 0)) {
                idx = GraalHPyData.setHPyField(owner, referent, idx);
            }
            return idx;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyFieldLoadNode
    extends Node {
        public abstract Object execute(Node var1, PythonObject var2, Object var3);

        @Specialization
        static Object doHandle(PythonObject owner, GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(replaces={"doHandle"})
        static Object doGeneric(Node inliningTarget, PythonObject owner, Object hpyFieldPtr, @CachedLibrary(limit="3") InteropLibrary lib, @Cached InlinedExactClassProfile fieldTypeProfile) {
            Object referent;
            Object hpyFieldObject = fieldTypeProfile.profile(inliningTarget, hpyFieldPtr);
            if (hpyFieldObject instanceof GraalHPyHandle) {
                referent = ((GraalHPyHandle)hpyFieldObject).getDelegate();
            } else {
                int idx;
                if (hpyFieldObject instanceof Long) {
                    try {
                        idx = PInt.intValueExact((Long)hpyFieldObject);
                    }
                    catch (OverflowException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                }
                try {
                    idx = PInt.intValueExact(lib.asPointer(hpyFieldObject));
                }
                catch (OverflowException | InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (idx == 0) {
                    return GraalHPyHandle.NULL_HANDLE_DELEGATE;
                }
                referent = GraalHPyData.getHPyField(owner, idx);
            }
            return referent;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyPackKeywordArgsNode
    extends Node {
        public abstract PKeyword[] execute(Node var1, Object[] var2, PTuple var3, int var4);

        @Specialization
        static PKeyword[] doPTuple(Node inliningTarget, Object[] kwvalues, PTuple kwnames, int nkw, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached InlinedLoopConditionProfile loopProfile) {
            loopProfile.profileCounted(inliningTarget, (long)nkw);
            if (nkw == 0) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            PKeyword[] result = new PKeyword[nkw];
            SequenceStorage storage = kwnames.getSequenceStorage();
            int i = 0;
            while (loopProfile.inject(inliningTarget, i < nkw)) {
                TruffleString name = (TruffleString)getItemNode.execute(inliningTarget, storage, i);
                result[i] = new PKeyword(name, kwvalues[i]);
                ++i;
            }
            return result;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class RecursiveExceptionMatches
    extends Node {
        abstract int execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        static int tuple(GraalHPyContext context, Object err, PTuple exc, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RecursiveExceptionMatches recExcMatch, @Cached.Exclusive @Cached PyObjectGetItem getItemNode, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile) {
            int len = exc.getSequenceStorage().length();
            int i = 0;
            while (loopProfile.profile(inliningTarget, i < len)) {
                Object e = getItemNode.execute(null, inliningTarget, exc, i);
                if (recExcMatch.execute(context, err, e) != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Specialization(guards={"!isPTuple(exc)", "isTupleSubtype(inliningTarget, exc, getClassNode, isSubtypeNode)"}, limit="1")
        static int subtuple(GraalHPyContext context, Object err, Object exc, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RecursiveExceptionMatches recExcMatch, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached ReadAttributeFromObjectNode readAttr, @Cached.Shared @Cached CallNode callNode, @Cached CastToJavaIntExactNode cast, @Cached.Exclusive @Cached PyObjectGetItem getItemNode, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile) {
            int len = cast.execute(inliningTarget, GraalHPyNodes.callBuiltinFunction(context, BuiltinNames.T_LEN, new Object[]{exc}, readAttr, callNode));
            int i = 0;
            while (loopProfile.profile(inliningTarget, i < len)) {
                Object e = getItemNode.execute(null, inliningTarget, exc, i);
                if (recExcMatch.execute(context, err, e) != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }

        @Specialization(guards={"!isPTuple(exc)", "!isTupleSubtype(inliningTarget, exc, getClassNode, isSubtypeNode)"}, limit="1")
        static int others(GraalHPyContext context, Object err, Object exc, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached ReadAttributeFromObjectNode readAttr, @Cached.Shared @Cached CallNode callNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached IsNode isNode, @Cached InlinedBranchProfile isBaseExceptionProfile, @Cached InlinedConditionProfile isExceptionProfile) {
            Object isInstance = GraalHPyNodes.callBuiltinFunction(context, BuiltinNames.T_ISINSTANCE, new Object[]{err, PythonBuiltinClassType.PBaseException}, readAttr, callNode);
            Object e = err;
            if (isTrueNode.execute(null, inliningTarget, isInstance)) {
                isBaseExceptionProfile.enter(inliningTarget);
                e = getClassNode.execute(inliningTarget, err);
            }
            if (isExceptionProfile.profile(inliningTarget, RecursiveExceptionMatches.isExceptionClass(context, inliningTarget, e, isTypeNode, readAttr, callNode, isTrueNode) && RecursiveExceptionMatches.isExceptionClass(context, inliningTarget, exc, isTypeNode, readAttr, callNode, isTrueNode))) {
                return RecursiveExceptionMatches.isSubClass(context, inliningTarget, e, exc, readAttr, callNode, isTrueNode) ? 1 : 0;
            }
            return isNode.execute(exc, e) ? 1 : 0;
        }

        protected boolean isTupleSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PTuple);
        }

        static boolean isSubClass(GraalHPyContext graalHPyContext, Node inliningTarget, Object derived, Object cls, ReadAttributeFromObjectNode readAttr, CallNode callNode, PyObjectIsTrueNode isTrueNode) {
            return isTrueNode.execute(null, inliningTarget, GraalHPyNodes.callBuiltinFunction(graalHPyContext, BuiltinNames.T_ISSUBCLASS, new Object[]{derived, cls}, readAttr, callNode));
        }

        private static boolean isExceptionClass(GraalHPyContext nativeContext, Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, ReadAttributeFromObjectNode readAttr, CallNode callNode, PyObjectIsTrueNode isTrueNode) {
            return isTypeNode.execute(inliningTarget, obj) && RecursiveExceptionMatches.isSubClass(nativeContext, inliningTarget, obj, (Object)PythonBuiltinClassType.PBaseException, readAttr, callNode, isTrueNode);
        }
    }

    public static final class HPyLLVMAttachFunctionTypeNode
    extends HPyAttachFunctionTypeNode {
        private static final HPyLLVMAttachFunctionTypeNode UNCACHED = new HPyLLVMAttachFunctionTypeNode();

        @Override
        public Object execute(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType) {
            assert (InteropLibrary.getUncached().isExecutable(pointerObject));
            return pointerObject;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAttachJNIFunctionTypeNode
    extends HPyAttachFunctionTypeNode {
        @Specialization
        static GraalHPyJNIFunctionPointer doLong(GraalHPyContext hpyContext, long pointer, GraalHPyContext.LLVMType llvmFunctionType) {
            return new GraalHPyJNIFunctionPointer(pointer, llvmFunctionType, hpyContext.getCurrentMode());
        }

        @Specialization
        static GraalHPyJNIFunctionPointer doGeneric(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            long pointer;
            if (pointerObject instanceof Long) {
                Long pointerLong = (Long)pointerObject;
                pointer = pointerLong;
            } else {
                if (!interopLibrary.isPointer(pointerObject)) {
                    interopLibrary.toNative(pointerObject);
                }
                try {
                    pointer = interopLibrary.asPointer(pointerObject);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return new GraalHPyJNIFunctionPointer(pointer, llvmFunctionType, hpyContext.getCurrentMode());
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAttachNFIFunctionTypeNode
    extends HPyAttachFunctionTypeNode {
        private static final String J_NFI_LANGUAGE = "nfi";

        @Specialization(guards={"isSingleContext()", "llvmFunctionType == cachedType"}, limit="3")
        static Object doCachedSingleContext(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @Cached(value="llvmFunctionType") GraalHPyContext.LLVMType cachedType, @Cached(value="getNFISignature(hpyContext, llvmFunctionType)") Object nfiSignature, @CachedLibrary(value="nfiSignature") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(nfiSignature, pointerObject);
        }

        @Specialization(guards={"llvmFunctionType == cachedType"}, limit="3", replaces={"doCachedSingleContext"})
        static Object doCached(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @Cached(value="llvmFunctionType") GraalHPyContext.LLVMType cachedType, @Cached(value="getNFISignatureCallTarget(hpyContext, llvmFunctionType)") CallTarget nfiSignatureCt, @Cached.Shared @CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(nfiSignatureCt.call(new Object[0]), pointerObject);
        }

        @Specialization(replaces={"doCachedSingleContext", "doCached"})
        static Object doGeneric(GraalHPyContext hpyContext, Object pointerObject, GraalHPyContext.LLVMType llvmFunctionType, @Cached.Shared @CachedLibrary(limit="1") SignatureLibrary signatureLibrary) {
            return signatureLibrary.bind(HPyAttachNFIFunctionTypeNode.getNFISignature(hpyContext, llvmFunctionType), pointerObject);
        }

        @CompilerDirectives.TruffleBoundary
        static Object getNFISignature(GraalHPyContext hpyContext, GraalHPyContext.LLVMType llvmFunctionType) {
            return hpyContext.getContext().getEnv().parseInternal(HPyAttachNFIFunctionTypeNode.getNFISignatureSource(llvmFunctionType), new String[0]).call(new Object[0]);
        }

        @CompilerDirectives.TruffleBoundary
        static CallTarget getNFISignatureCallTarget(GraalHPyContext hpyContext, GraalHPyContext.LLVMType llvmFunctionType) {
            return hpyContext.getContext().getEnv().parseInternal(HPyAttachNFIFunctionTypeNode.getNFISignatureSource(llvmFunctionType), new String[0]);
        }

        @CompilerDirectives.TruffleBoundary
        static Source getNFISignatureSource(GraalHPyContext.LLVMType llvmFunctionType) {
            return Source.newBuilder((String)J_NFI_LANGUAGE, (CharSequence)HPyAttachNFIFunctionTypeNode.getNFISignatureSourceString(llvmFunctionType), (String)llvmFunctionType.name()).build();
        }

        private static String getNFISignatureSourceString(GraalHPyContext.LLVMType llvmFunctionType) {
            switch (llvmFunctionType) {
                case HPyModule_init: {
                    return "(POINTER): POINTER";
                }
                case HPyFunc_noargs: 
                case HPyFunc_unaryfunc: 
                case HPyFunc_getiterfunc: 
                case HPyFunc_iternextfunc: 
                case HPyFunc_reprfunc: {
                    return "(POINTER, POINTER): POINTER";
                }
                case HPyFunc_binaryfunc: 
                case HPyFunc_o: 
                case HPyFunc_getter: 
                case HPyFunc_getattrfunc: 
                case HPyFunc_getattrofunc: {
                    return "(POINTER, POINTER, POINTER): POINTER";
                }
                case HPyFunc_varargs: {
                    return "(POINTER, POINTER, POINTER, SINT64): POINTER";
                }
                case HPyFunc_keywords: {
                    return "(POINTER, POINTER, POINTER, SINT64, POINTER): POINTER";
                }
                case HPyFunc_ternaryfunc: 
                case HPyFunc_descrgetfunc: {
                    return "(POINTER, POINTER, POINTER, POINTER): POINTER";
                }
                case HPyFunc_inquiry: {
                    return "(POINTER, POINTER): SINT32";
                }
                case HPyFunc_lenfunc: 
                case HPyFunc_hashfunc: {
                    return "(POINTER, POINTER): SINT64";
                }
                case HPyFunc_ssizeargfunc: {
                    return "(POINTER, POINTER, SINT64): POINTER";
                }
                case HPyFunc_ssizessizeargfunc: {
                    return "(POINTER, POINTER, SINT64, SINT64): POINTER";
                }
                case HPyFunc_ssizeobjargproc: {
                    return "(POINTER, POINTER, SINT64, POINTER): SINT32";
                }
                case HPyFunc_initproc: {
                    return "(POINTER, POINTER, POINTER, SINT64, POINTER): SINT32";
                }
                case HPyFunc_ssizessizeobjargproc: {
                    return "(POINTER, POINTER, SINT64, SINT64, POINTER): SINT32";
                }
                case HPyFunc_objobjargproc: 
                case HPyFunc_setter: 
                case HPyFunc_descrsetfunc: 
                case HPyFunc_setattrfunc: 
                case HPyFunc_setattrofunc: {
                    return "(POINTER, POINTER, POINTER, POINTER): SINT32";
                }
                case HPyFunc_freefunc: {
                    return "(POINTER, POINTER): VOID";
                }
                case HPyFunc_richcmpfunc: {
                    return "(POINTER, POINTER, POINTER, SINT32): POINTER";
                }
                case HPyFunc_objobjproc: {
                    return "(POINTER, POINTER, POINTER): SINT32";
                }
                case HPyFunc_getbufferproc: {
                    return "(POINTER, POINTER, POINTER, SINT32): SINT32";
                }
                case HPyFunc_releasebufferproc: {
                    return "(POINTER, POINTER, POINTER): VOID";
                }
                case HPyFunc_traverseproc: {
                    return "(POINTER, POINTER, POINTER): SINT32";
                }
                case HPyFunc_destroyfunc: {
                    return "(POINTER): VOID";
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public static abstract class HPyAttachFunctionTypeNode
    extends PNodeWithContext {
        public abstract Object execute(GraalHPyContext var1, Object var2, GraalHPyContext.LLVMType var3);

        @NeverDefault
        public static HPyAttachFunctionTypeNode create() {
            PythonLanguage language = PythonLanguage.get(null);
            switch (language.getEngineOption(PythonOptions.HPyBackend)) {
                case JNI: {
                    if (!PythonImageBuildOptions.WITHOUT_JNI) {
                        return GraalHPyNodesFactory.HPyAttachJNIFunctionTypeNodeGen.create();
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case LLVM: {
                    return HPyLLVMAttachFunctionTypeNode.UNCACHED;
                }
                case NFI: {
                    return GraalHPyNodesFactory.HPyAttachNFIFunctionTypeNodeGen.create();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        public static HPyAttachFunctionTypeNode getUncached() {
            PythonLanguage language = PythonLanguage.get(null);
            switch (language.getEngineOption(PythonOptions.HPyBackend)) {
                case JNI: {
                    if (!PythonImageBuildOptions.WITHOUT_JNI) {
                        return GraalHPyNodesFactory.HPyAttachJNIFunctionTypeNodeGen.getUncached();
                    }
                    throw CompilerDirectives.shouldNotReachHere();
                }
                case LLVM: {
                    return HPyLLVMAttachFunctionTypeNode.UNCACHED;
                }
                case NFI: {
                    return GraalHPyNodesFactory.HPyAttachNFIFunctionTypeNodeGen.getUncached();
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyGetNativeSpacePointerNode
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        public final Object executeCached(Object object) {
            return this.execute(this, object);
        }

        public static Object executeUncached(Object object) {
            return GraalHPyNodesFactory.HPyGetNativeSpacePointerNodeGen.getUncached().execute(null, object);
        }

        @Specialization
        static Object doPythonObject(PythonObject object) {
            return GraalHPyData.getHPyNativeSpace(object);
        }

        @Fallback
        static Object doOther(Node inliningTarget, Object object) {
            return PythonContext.get(inliningTarget).getNativeNull();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyTypeGetNameNode
    extends Node {
        public static Object executeUncached(GraalHPyContext ctx, Object object) {
            return GraalHPyNodesFactory.HPyTypeGetNameNodeGen.getUncached().execute(null, ctx, object);
        }

        public abstract Object execute(Node var1, GraalHPyContext var2, Object var3);

        @Specialization(guards={"tpName != null"})
        static Object doTpName(GraalHPyContext ctx, PythonClass clazz, @Bind(value="clazz.getTpName()") Object tpName) {
            return tpName;
        }

        @Specialization(replaces={"doTpName"})
        static Object doGeneric(Node inliningTarget, GraalHPyContext ctx, Object type, @Cached TypeNodes.GetNameNode getName, @Cached(parameters={"ctx"}, inline=false) HPyAsCharPointerNode asCharPointerNode) {
            PythonClass pythonClass;
            if (type instanceof PythonClass && (pythonClass = (PythonClass)type).getTpName() != null) {
                return pythonClass.getTpName();
            }
            TruffleString baseName = getName.execute(inliningTarget, type);
            return asCharPointerNode.execute(ctx, baseName, TruffleString.Encoding.UTF_8);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyTypeSplitNameNode
    extends Node {
        HPyTypeSplitNameNode() {
        }

        public abstract TruffleString[] execute(Node var1, TruffleString var2);

        @Specialization
        static TruffleString[] doGeneric(TruffleString specNameUtf8, @Cached(inline=false) TruffleString.SwitchEncodingNode switchEncodingNode, @Cached(inline=false) TruffleString.LastIndexOfCodePointNode indexOfCodepointNode, @Cached(inline=false) TruffleString.SubstringNode substringNode, @Cached(inline=false) TruffleString.CodePointLengthNode lengthNode) {
            int length;
            TruffleString specName = switchEncodingNode.execute((AbstractTruffleString)specNameUtf8, PythonUtils.TS_ENCODING);
            int firstDotIdx = indexOfCodepointNode.execute((AbstractTruffleString)specName, 46, length = lengthNode.execute((AbstractTruffleString)specName, PythonUtils.TS_ENCODING), 0, PythonUtils.TS_ENCODING);
            if (firstDotIdx > -1) {
                TruffleString left = substringNode.execute((AbstractTruffleString)specName, 0, firstDotIdx, PythonUtils.TS_ENCODING, false);
                TruffleString right = substringNode.execute((AbstractTruffleString)specName, firstDotIdx + 1, length - firstDotIdx - 1, PythonUtils.TS_ENCODING, false);
                return new TruffleString[]{left, right};
            }
            return new TruffleString[]{null, specName};
        }
    }

    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyCreateTypeFromSpecNode
    extends Node {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(HPyCreateTypeFromSpecNode.class);
        static final TruffleString T_PYTRUFFLE_CREATETYPE = PythonUtils.tsLiteral("PyTruffle_CreateType");

        HPyCreateTypeFromSpecNode() {
        }

        abstract Object execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        static Object doGeneric(GraalHPyContext context, Object typeSpec, Object typeSpecParamArray, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") DynamicObjectLibrary dylib, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.AllocateNode allocateNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadI32Node readI32Node, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"context"}) HPyAsCharPointerNode asCharPointerNode, @Cached HPyTypeSplitNameNode splitName, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PythonObjectFactory factory, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached TypeNodes.HasSameConstructorNode hasSameConstructorNode, @Cached CStructAccess.ReadI64Node getMetaSizeNode, @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached ReadPropertyNode readPropertyNode, @Cached WritePropertyNode writePropertyNode, @Cached PyObjectCallMethodObjArgs callCreateTypeNode, @Cached HPyCreateFunctionNode addFunctionNode, @Cached HPyAddMemberNode addMemberNode, @Cached HPyCreateSlotNode addSlotNode, @Cached HPyCreateLegacySlotNode createLegacySlotNode, @Cached HPyCreateGetSetDescriptorNode createGetSetDescriptorNode, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached(parameters={"New"}) LookupCallableSlotInMRONode lookupNewNode, @Cached PRaiseNode raiseNode) {
            try {
                long baseFlags;
                TruffleString value;
                PDict namespace;
                TruffleString specName = fromCharPointerNode.execute(readPointerNode.read(context, typeSpec, GraalHPyCField.HPyType_Spec__name), false);
                TruffleString[] names = splitName.execute(inliningTarget, specName);
                assert (names.length == 2);
                Object tpName = asCharPointerNode.execute(context, names[1], TruffleString.Encoding.UTF_8);
                Object doc = readPointerNode.read(context, typeSpec, GraalHPyCField.HPyType_Spec__doc);
                if (!isNullNode.execute(context, doc)) {
                    TruffleString docString = fromCharPointerNode.execute(doc);
                    namespace = factory.createDict(new PKeyword[]{new PKeyword(SpecialAttributeNames.T___DOC__, docString)});
                } else {
                    namespace = factory.createDict();
                }
                HPyTypeSpecParam[] typeSpecParams = HPyCreateTypeFromSpecNode.extractTypeSpecParams(context, typeSpecParamArray);
                PTuple bases = HPyCreateTypeFromSpecNode.extractBases(typeSpecParams, factory);
                Object metatype = HPyCreateTypeFromSpecNode.getMetatype(typeSpecParams, raiseNode);
                if (metatype != null) {
                    if (!isTypeNode.execute(inliningTarget, metatype)) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_IS_NOT_A_TYPE, metatype);
                    }
                    if (!hasSameConstructorNode.execute(inliningTarget, metatype, (Object)PythonBuiltinClassType.PythonClass)) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_WITH_CUSTOM_CONS_NOT_SUPPORTED);
                    }
                }
                PythonModule pythonCextModule = PythonContext.get(inliningTarget).lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__);
                PythonClass newType = (PythonClass)callCreateTypeNode.execute(null, inliningTarget, pythonCextModule, T_PYTRUFFLE_CREATETYPE, names[1], bases, namespace, metatype != null ? metatype : PythonBuiltinClassType.PythonClass);
                long metaBasicSize = 0L;
                Object destroyFunc = null;
                if (metatype instanceof PythonClass) {
                    PythonClass metaclass = (PythonClass)metatype;
                    metaBasicSize = metaclass.getBasicSize();
                    destroyFunc = metaclass.getHPyDestroyFunc();
                } else if (metatype instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)metatype;
                    metaBasicSize = getMetaSizeNode.readFromObj(nativeObject, CFields.PyTypeObject__tp_basicsize);
                }
                if (metaBasicSize > 0L) {
                    Object dataPtr = allocateNode.calloc(context, 1L, metaBasicSize);
                    GraalHPyData.setHPyNativeSpace(newType, dataPtr);
                    if (destroyFunc != null) {
                        context.createHandleReference(newType, dataPtr, destroyFunc != PNone.NO_VALUE ? destroyFunc : null);
                    }
                }
                if ((value = names[0]) != null) {
                    writeAttributeToObjectNode.execute(newType, SpecialAttributeNames.T___MODULE__, value);
                }
                long flags = readI32Node.readUnsigned(context, typeSpec, GraalHPyCField.HPyType_Spec__flags);
                int builtinShape = readI32Node.read(context, typeSpec, GraalHPyCField.HPyType_Spec__builtin_shape);
                if (!GraalHPyDef.isValidBuiltinShape(builtinShape)) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HPY_INVALID_BUILTIN_SHAPE, builtinShape);
                }
                long basicSize = readI32Node.read(context, typeSpec, GraalHPyCField.HPyType_Spec__basicsize);
                long itemSize = readI32Node.read(context, typeSpec, GraalHPyCField.HPyType_Spec__itemsize);
                newType.setHPyTypeExtra(new HPyTypeExtra(flags, basicSize, itemSize, tpName, builtinShape));
                newType.makeStaticBase(dylib);
                boolean seenNew = false;
                boolean needsTpTraverse = (flags & 0x4000L) != 0L;
                TpSlots.Builder tpSlotsBuilder = TpSlots.newBuilder();
                Object defines = readPointerNode.read(context, typeSpec, GraalHPyCField.HPyType_Spec__defines);
                if (!isNullNode.execute(context, defines)) {
                    Object def;
                    long i = 0L;
                    while (!isNullNode.execute(context, def = readPointerNode.readArrayElement(context, defines, i))) {
                        HPyProperty property = null;
                        int kind = readI32Node.read(context, def, GraalHPyCField.HPyDef__kind);
                        switch (kind) {
                            case 2: {
                                PBuiltinFunction fun = addFunctionNode.execute(context, newType, def);
                                property = new HPyProperty(fun.getName(), fun);
                                break;
                            }
                            case 1: {
                                Object addSlotResult = addSlotNode.execute(context, newType, tpSlotsBuilder, def);
                                if (GraalHPyDef.HPySlot.HPY_TP_TRAVERSE.equals(addSlotResult)) {
                                    needsTpTraverse = false;
                                } else if (addSlotResult instanceof HPyProperty) {
                                    property = (HPyProperty)addSlotResult;
                                }
                                if (property == null || !SpecialMethodNames.T___NEW__.equals(property.key)) break;
                                seenNew = true;
                                break;
                            }
                            case 3: {
                                property = addMemberNode.execute(context, newType, def);
                                break;
                            }
                            case 4: {
                                GetSetDescriptor getSetDescriptor = createGetSetDescriptorNode.execute(context, newType, def);
                                property = new HPyProperty(getSetDescriptor.getName(), getSetDescriptor);
                                break;
                            }
                            default: {
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.severe(PythonUtils.formatJString("unknown definition kind: %d", kind));
                                }
                                assert (false);
                                break;
                            }
                        }
                        if (property != null) {
                            property.write(inliningTarget, writePropertyNode, readPropertyNode, newType);
                        }
                        ++i;
                    }
                }
                if (newType.getHPyVectorcallOffset() != Long.MIN_VALUE && newType.getHPyDefaultCallFunc() != null) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_HAVE_CALL_AND_VECTORCALLOFFSET);
                }
                if (needsTpTraverse) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TRAVERSE_FUNCTION_NEEDED);
                }
                Object legacySlotsArrPtr = readPointerNode.read(context, typeSpec, GraalHPyCField.HPyType_Spec__legacy_slots);
                if (!isNullNode.execute(context, legacySlotsArrPtr)) {
                    if (builtinShape != -1) {
                        throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_SPECIFY_LEG_SLOTS_WO_SETTING_LEG);
                    }
                    int i = 0;
                    while (createLegacySlotNode.execute(context, newType, tpSlotsBuilder, legacySlotsArrPtr, i)) {
                        ++i;
                    }
                }
                TpSlots newSlots = tpSlotsBuilder.build();
                newType.setTpSlots(newType.getTpSlots().copy().override(newSlots).build());
                newSlots.addOperators(newType);
                TpSlots.fixupSlotDispatchers(newType);
                Object baseClass = getBaseClassNode.execute(inliningTarget, newType);
                if (!(seenNew || basicSize <= 0L && newType.getHPyDefaultCallFunc() == null)) {
                    Object inheritedConstructor = lookupNewNode.execute(baseClass);
                    PBuiltinFunction constructorDecorator = GraalHPyObjectBuiltins.HPyObjectNewNode.createBuiltinFunction(PythonLanguage.get(raiseNode), inheritedConstructor, builtinShape);
                    writeAttributeToObjectNode.execute(newType, SpecialMethodNames.T___NEW__, constructorDecorator);
                }
                if (baseClass instanceof PythonClass) {
                    PythonClass pythonBaseClass = (PythonClass)baseClass;
                    baseFlags = pythonBaseClass.getFlags();
                } else {
                    baseFlags = 0L;
                }
                int baseBuiltinShape = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(baseClass);
                HPyCreateTypeFromSpecNode.checkInheritanceConstraints(flags, baseFlags, builtinShape, baseBuiltinShape > -1, raiseNode);
                return newType;
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.COULD_NOT_CREATE_TYPE_FROM_SPEC_BECAUSE, new Object[]{e});
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static HPyTypeSpecParam[] extractTypeSpecParams(GraalHPyContext context, Object typeSpecParamArray) {
            long specParamKindOffset;
            int specParamKind;
            if (GraalHPyCAccess.IsNullNode.executeUncached(context, typeSpecParamArray)) {
                return null;
            }
            GraalHPyCAccess.ReadI32Node readI32Node = GraalHPyCAccess.ReadI32Node.getUncached(context);
            GraalHPyCAccess.ReadHPyNode readHPyNode = GraalHPyCAccess.ReadHPyNode.getUncached(context);
            long specParamSize = context.getCTypeSize(HPyContextSignatureType.HPyType_SpecParam);
            LinkedList<HPyTypeSpecParam> specParams = new LinkedList<HPyTypeSpecParam>();
            int i = 0;
            while ((specParamKind = readI32Node.readOffset(context, typeSpecParamArray, specParamKindOffset = GraalHPyCAccess.ReadHPyNode.getElementPtr(context, (long)i, specParamSize, GraalHPyCField.HPyType_SpecParam__kind))) != 0) {
                long specParamObjectOffset = GraalHPyCAccess.ReadHPyNode.getElementPtr(context, (long)i, specParamSize, GraalHPyCField.HPyType_SpecParam__object);
                Object specParamObject = readHPyNode.read(context, typeSpecParamArray, specParamObjectOffset);
                specParams.add(new HPyTypeSpecParam(specParamKind, specParamObject));
                ++i;
            }
            return specParams.toArray(new HPyTypeSpecParam[0]);
        }

        @CompilerDirectives.TruffleBoundary
        private static PTuple extractBases(HPyTypeSpecParam[] typeSpecParams, PythonObjectFactory factory) {
            if (typeSpecParams == null) {
                return factory.createEmptyTuple();
            }
            ArrayList<Object> basesList = new ArrayList<Object>();
            block5: for (HPyTypeSpecParam typeSpecParam : typeSpecParams) {
                switch (typeSpecParam.kind()) {
                    case 1: {
                        assert (PGuards.isClassUncached(typeSpecParam.object())) : "base object is not a Python class";
                        basesList.add(typeSpecParam.object());
                        continue block5;
                    }
                    case 2: {
                        assert (PGuards.isPTuple(typeSpecParam.object())) : "type spec param claims to be a tuple but isn't";
                        return (PTuple)typeSpecParam.object();
                    }
                    case 3: {
                        continue block5;
                    }
                    default: {
                        assert (false) : "unknown type spec param kind";
                        continue block5;
                    }
                }
            }
            return factory.createTuple(basesList.toArray());
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getMetatype(HPyTypeSpecParam[] typeSpecParams, PRaiseNode raiseNode) {
            Object result = null;
            if (typeSpecParams != null) {
                for (HPyTypeSpecParam typeSpecParam : typeSpecParams) {
                    if (typeSpecParam.kind() != 3) continue;
                    if (result != null) {
                        throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HPY_METACLASS_SPECIFIED_MULTIPLE_TIMES);
                    }
                    result = typeSpecParam.object();
                    if (TypeNodes.IsTypeNode.executeUncached(result)) continue;
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_METACLASS_IS_NOT_A_TYPE, result);
                }
            }
            return result;
        }

        private static void checkInheritanceConstraints(long flags, long baseFlags, int builtinShape, boolean baseIsPure, PRaiseNode raiseNode) {
            assert (GraalHPyDef.isValidBuiltinShape(builtinShape));
            if (builtinShape == -1 && baseIsPure) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.LEG_TYPE_SHOULDNT_INHERIT_MEM_LAYOUT_FROM_PURE_TYPE);
            }
        }
    }

    @CompilerDirectives.ValueType
    record HPyTypeSpecParam(int kind, Object object) {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyLongFromLong
    extends Node {
        HPyLongFromLong() {
        }

        public abstract Object execute(Node var1, int var2, boolean var3);

        public abstract Object execute(Node var1, long var2, boolean var4);

        public abstract Object execute(Node var1, Object var2, boolean var3);

        @Specialization(guards={"signed"})
        static int doSignedInt(int n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed"})
        static long doUnsignedInt(int n, boolean signed) {
            if (n < 0) {
                return (long)n & 0xFFFFFFFFL;
            }
            return n;
        }

        @Specialization(guards={"signed"})
        static long doSignedLong(long n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed", "n >= 0"})
        static long doUnsignedLongPositive(long n, boolean signed) {
            return n;
        }

        @Specialization(guards={"!signed", "n < 0"})
        static Object doUnsignedLongNegative(long n, boolean signed, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createInt(HPyLongFromLong.convertToBigInteger(n));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger convertToBigInteger(long n) {
            return BigInteger.valueOf(n).add(BigInteger.ONE.shiftLeft(64));
        }

        @Specialization
        static Object doPointer(PythonNativeObject n, boolean signed, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createNativeVoidPtr(n.getPtr());
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyReleaseBufferProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConversion(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyGetBufferProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConversion(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.AsNativePrimitiveNode asIntNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = asIntNode.execute(args[argsOffset + 2], 1, 4, true);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyRichcmptFuncArgsCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(inliningTarget, dest[destOffset]);
            closeSecondHandleNode.execute(inliningTarget, dest[destOffset + 1]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyRichcmpFuncArgsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asHandleNode.execute(args[argsOffset + 1]);
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyRichcmptFuncArgsCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPySSizeObjArgProcCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(inliningTarget, dest[destOffset]);
            closeSecondHandleNode.execute(inliningTarget, dest[destOffset + 2]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPySSizeObjArgProcToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyAsHandleNode asHandleNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(inliningTarget, args[argsOffset + 1], 1, 8);
            dest[destOffset + 2] = asHandleNode.execute(args[argsOffset + 2]);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySSizeObjArgProcCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPySSizeArgFuncToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization(guards={"isArity(args.length, argsOffset, 2)"})
        static void doHandleSsizeT(Object[] args, int argsOffset, Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HPyAsHandleNode asHandleNode, @Cached.Shared @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(inliningTarget, args[argsOffset + 1], 1, 8);
        }

        @Specialization(guards={"isArity(args.length, argsOffset, 3)"})
        static void doHandleSsizeTSsizeT(Object[] args, int argsOffset, Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HPyAsHandleNode asHandleNode, @Cached.Shared @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            CompilerAsserts.partialEvaluationConstant((int)argsOffset);
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asSsizeTNode.execute(inliningTarget, args[argsOffset + 1], 1, 8);
            dest[destOffset + 2] = asSsizeTNode.execute(inliningTarget, args[argsOffset + 2], 1, 8);
        }

        @Specialization(replaces={"doHandleSsizeT", "doHandleSsizeTSsizeT"})
        static void doGeneric(Object[] args, int argsOffset, Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HPyAsHandleNode asHandleNode, @Cached.Shared @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode) {
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            for (int i = 1; i < args.length - argsOffset; ++i) {
                dest[destOffset + i] = asSsizeTNode.execute(inliningTarget, args[argsOffset + i], 1, 8);
            }
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }

        static boolean isArity(int len, int off, int expected) {
            return len - off == expected;
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyGetSetSetterHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(inliningTarget, dest[destOffset]);
            closeSecondHandleNode.execute(inliningTarget, dest[destOffset + 1]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyGetSetSetterToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode asHandleNode) {
            dest[destOffset] = asHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = asHandleNode.execute(args[argsOffset + 1]);
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyGetSetSetterHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyGetSetGetterToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPySelfHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyAllHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization(guards={"dest.length == destOffset"})
        static void cached0(Object[] dest, int destOffset) {
        }

        @Specialization(guards={"dest.length == cachedLength", "isLeArgsOffsetPlus(cachedLength, destOffset, 8)"}, limit="1", replaces={"cached0"})
        @ExplodeLoop
        static void cachedLoop(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached(value="dest.length") int cachedLength, @Cached.Shared @Cached HPyCloseHandleNode closeHandleNode) {
            CompilerAsserts.partialEvaluationConstant((int)destOffset);
            for (int i = 0; i < cachedLength - destOffset; ++i) {
                closeHandleNode.execute(inliningTarget, dest[destOffset + i]);
            }
        }

        @Specialization(replaces={"cached0", "cachedLoop"})
        static void uncached(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HPyCloseHandleNode closeHandleNode) {
            int len = dest.length;
            for (int i = 0; i < len - destOffset; ++i) {
                closeHandleNode.execute(inliningTarget, dest[destOffset + i]);
            }
        }

        static boolean isLeArgsOffsetPlus(int len, int off, int plus) {
            return len < plus + off;
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyAllAsHandleNode
    extends HPyConvertArgsToSulongNode {
        static boolean isArgsOffsetPlus(int len, int off, int plus) {
            return len == off + plus;
        }

        static boolean isLeArgsOffsetPlus(int len, int off, int plus) {
            return len < plus + off;
        }

        @Specialization(guards={"args.length == argsOffset"})
        static void cached0(Object[] args, int argsOffset, Object[] dest, int destOffset) {
        }

        @Specialization(guards={"args.length == cachedLength", "isLeArgsOffsetPlus(cachedLength, argsOffset, 8)"}, limit="1", replaces={"cached0"})
        @ExplodeLoop
        static void cachedLoop(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached(value="args.length") int cachedLength, @Cached.Shared @Cached HPyAsHandleNode toSulongNode) {
            CompilerAsserts.partialEvaluationConstant((int)destOffset);
            for (int i = 0; i < cachedLength - argsOffset; ++i) {
                dest[destOffset + i] = toSulongNode.execute(args[argsOffset + i]);
            }
        }

        @Specialization(replaces={"cached0", "cachedLoop"})
        static void uncached(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached.Shared @Cached HPyAsHandleNode toSulongNode) {
            int len = args.length;
            for (int i = 0; i < len - argsOffset; ++i) {
                dest[destOffset + i] = toSulongNode.execute(args[argsOffset + i]);
            }
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyAllHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyKeywordsHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeFirstHandleNode, @Cached HPyCloseHandleNode closeSecondHandleNode) {
            closeFirstHandleNode.execute(inliningTarget, dest[destOffset]);
            closeSecondHandleNode.execute(inliningTarget, dest[destOffset + 3]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyKeywordsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode, @Cached HPyAsHandleNode kwAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = args[argsOffset + 2];
            dest[destOffset + 3] = kwAsHandleNode.execute(args[argsOffset + 3]);
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyKeywordsHandleCloseNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPySelfHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeHandleNode) {
            closeHandleNode.execute(inliningTarget, dest[destOffset]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyVarargsHandleCloseNode
    extends HPyCloseArgHandlesNode {
        @Specialization
        static void doConvert(Object[] dest, int destOffset, @Bind(value="this") Node inliningTarget, @Cached HPyCloseHandleNode closeHandleNode) {
            closeHandleNode.execute(inliningTarget, dest[destOffset]);
        }
    }

    @GenerateInline(value=false)
    public static abstract class HPyVarargsToSulongNode
    extends HPyConvertArgsToSulongNode {
        @Specialization
        static void doConvert(Object[] args, int argsOffset, Object[] dest, int destOffset, @Cached HPyAsHandleNode selfAsHandleNode) {
            dest[destOffset] = selfAsHandleNode.execute(args[argsOffset]);
            dest[destOffset + 1] = args[argsOffset + 1];
            dest[destOffset + 2] = args[argsOffset + 2];
        }

        @Override
        HPyCloseArgHandlesNode createCloseHandleNode() {
            return GraalHPyNodesFactory.HPyVarargsHandleCloseNodeGen.create();
        }
    }

    public static abstract class HPyCloseArgHandlesNode
    extends PNodeWithContext {
        public abstract void executeInto(VirtualFrame var1, Object[] var2, int var3);
    }

    public static abstract class HPyConvertArgsToSulongNode
    extends PNodeWithContext {
        public abstract void executeInto(VirtualFrame var1, Object[] var2, int var3, Object[] var4, int var5);

        abstract HPyCloseArgHandlesNode createCloseHandleNode();
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAsNativeInt64Node
    extends CExtToNativeNode {
        @Specialization
        static Object doGeneric(Object value, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(inliningTarget, value, 1, 8);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class HPyAsHandleNode
    extends CExtToNativeNode {
        protected static final byte HANDLE = 0;
        protected static final byte GLOBAL = 1;
        protected static final byte FIELD = 2;

        @Override
        public final GraalHPyHandle execute(Object object) {
            return this.execute(object, 0, 0);
        }

        public final GraalHPyHandle executeGlobal(Object object, int id) {
            return this.execute(object, id, 1);
        }

        public final GraalHPyHandle executeField(Object object, int id) {
            return this.execute(object, id, 2);
        }

        protected abstract GraalHPyHandle execute(Object var1, int var2, int var3);

        @Specialization(guards={"isNoValue(object)"})
        static GraalHPyHandle doNoValue(PNone object, int id, int type) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"!isNoValue(object)", "type == HANDLE"})
        GraalHPyHandle doObject(Object object, int id, int type) {
            return this.getContext().getHPyContext().createHandle(object);
        }

        @Specialization(guards={"!isNoValue(object)", "type == GLOBAL"})
        static GraalHPyHandle doGlobal(Object object, int id, int type) {
            return GraalHPyHandle.createGlobal(object, id);
        }

        @Specialization(guards={"!isNoValue(object)", "type == FIELD"})
        GraalHPyHandle doField(Object object, int id, int type) {
            return this.getContext().getHPyContext().createField(object, id);
        }
    }

    public static final class HPyDummyToJavaNode
    extends CExtToJavaNode {
        private static final HPyDummyToJavaNode UNCACHED = new HPyDummyToJavaNode();

        public static HPyDummyToJavaNode create() {
            return new HPyDummyToJavaNode();
        }

        public static HPyDummyToJavaNode getUncached() {
            return UNCACHED;
        }

        @Override
        public Object execute(Object object) {
            return object;
        }

        public boolean isAdoptable() {
            return this != UNCACHED;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyAsPythonObjectNode
    extends CExtToJavaNode {
        public abstract Object execute(long var1);

        @Specialization
        static Object doHandle(GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static Object doNullLong(long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doLong(long bits) {
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }

        @Specialization(guards={"isBoxedDouble(bits)"})
        static double doLongDouble(long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"isBoxedInt(bits)"})
        static int doLongInt(long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static Object doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        Object doOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedDouble(bits)"})
        static double doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits)"})
        static int doOtherInt(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        @Specialization(replaces={"doHandle", "doNullLong", "doLong", "doLongDouble", "doLongInt", "doNullOther", "doOther", "doOtherDouble", "doOtherInt"})
        Object doGeneric(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib) {
            long bits;
            if (value instanceof GraalHPyHandle) {
                return ((GraalHPyHandle)value).getDelegate();
            }
            if (value instanceof Long) {
                bits = (Long)value;
            } else {
                lib.toNative(value);
                try {
                    bits = lib.asPointer(value);
                }
                catch (UnsupportedMessageException ex) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
                }
            }
            if (GraalHPyBoxing.isBoxedNullHandle(bits)) {
                return GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            if (GraalHPyBoxing.isBoxedInt(bits)) {
                return GraalHPyBoxing.unboxInt(bits);
            }
            if (GraalHPyBoxing.isBoxedDouble(bits)) {
                return GraalHPyBoxing.unboxDouble(bits);
            }
            assert (GraalHPyBoxing.isBoxedHandle(bits));
            return this.getContext().getHPyContext().getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class HPyCloseAndGetHandleNode
    extends HPyWithContextNode {
        public abstract Object execute(Node var1, Object var2);

        public abstract Object execute(Node var1, long var2);

        @Specialization(guards={"!handle.isAllocated()"})
        static Object doHandle(GraalHPyHandle handle) {
            return handle.getDelegate();
        }

        @Specialization(guards={"handle.isAllocated()"})
        static Object doHandleAllocated(Node inliningTarget, GraalHPyHandle handle) {
            handle.closeAndInvalidate(PythonContext.get(inliningTarget).getHPyContext());
            return handle.getDelegate();
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static Object doNullLong(long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        static Object doLong(Node inliningTarget, long bits) {
            int id = GraalHPyBoxing.unboxHandle(bits);
            assert (GraalHPyHandle.isAllocated(id));
            GraalHPyContext context = PythonContext.get(inliningTarget).getHPyContext();
            Object delegate = context.getObjectForHPyHandle(id);
            context.releaseHPyHandleForObject(id);
            return delegate;
        }

        @Specialization(guards={"isBoxedDouble(bits)"})
        static double doLongDouble(long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"isBoxedInt(bits)"})
        static int doLongInt(long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }

        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static Object doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        static Object doOther(Node inliningTarget, Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return HPyCloseAndGetHandleNode.doLong(inliningTarget, bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedDouble(bits)"})
        static double doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxDouble(bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits)"})
        static int doOtherInt(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyBoxing.unboxInt(bits);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyCloseHandleNode
    extends HPyWithContextNode {
        public abstract void execute(Node var1, Object var2);

        public static void executeUncached(Object object) {
            GraalHPyNodesFactory.HPyCloseHandleNodeGen.getUncached().execute(null, object);
        }

        @Specialization(guards={"!handle.isAllocated()"})
        static void doHandle(GraalHPyHandle handle) {
        }

        @Specialization(guards={"handle.isAllocated()"})
        static void doHandleAllocated(Node inliningTarget, GraalHPyHandle handle) {
            handle.closeAndInvalidate(PythonContext.get(inliningTarget).getHPyContext());
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static void doNullLong(long bits) {
        }

        @Specialization(guards={"!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        static void doLong(Node inliningTarget, long bits) {
            int id = GraalHPyBoxing.unboxHandle(bits);
            assert (GraalHPyHandle.isAllocated(id));
            PythonContext.get(inliningTarget).getHPyContext().releaseHPyHandleForObject(id);
        }

        @Specialization(guards={"!isBoxedHandle(bits)"})
        static void doLongDouble(long bits) {
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static void doNullOther(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        static void doOther(Node inliningTarget, Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            HPyCloseHandleNode.doLong(inliningTarget, bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedHandle(bits)"})
        static void doOtherDouble(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyEnsureHandleNode
    extends HPyWithContextNode {
        public abstract GraalHPyHandle execute(Node var1, Object var2);

        @Specialization
        static GraalHPyHandle doHandle(GraalHPyHandle handle) {
            return handle;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "!isBoxedNullHandle(bits)", "isBoxedHandle(bits)"})
        static GraalHPyHandle doOtherBoxedHandle(Node inliningTarget, Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return HPyEnsureHandleNode.doLong(inliningTarget, bits);
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedNullHandle(bits)"})
        static GraalHPyHandle doOtherNull(Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"!isLong(value)", "!isHPyHandle(value)", "isBoxedInt(bits) || isBoxedDouble(bits)"})
        static GraalHPyHandle doOtherBoxedPrimitive(Node inliningTarget, Object value, @Cached.Shared(value="lib") @CachedLibrary(limit="2") InteropLibrary lib, @Bind(value="asPointer(value, lib)") long bits) {
            return HPyEnsureHandleNode.doBoxedPrimitive(inliningTarget, bits);
        }

        @Specialization(guards={"isBoxedNullHandle(bits)"})
        static GraalHPyHandle doLongNull(long bits) {
            return GraalHPyHandle.NULL_HANDLE;
        }

        @Specialization(guards={"isBoxedHandle(bits)"}, replaces={"doLongNull"})
        static GraalHPyHandle doLong(Node inliningTarget, long bits) {
            GraalHPyContext context = PythonContext.get(inliningTarget).getHPyContext();
            return context.createHandle(context.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits)));
        }

        @Specialization(guards={"isBoxedInt(bits) || isBoxedDouble(bits)"})
        static GraalHPyHandle doBoxedPrimitive(Node inliningTarget, long bits) {
            Number delegate;
            if (GraalHPyBoxing.isBoxedInt(bits)) {
                delegate = GraalHPyBoxing.unboxInt(bits);
            } else if (GraalHPyBoxing.isBoxedDouble(bits)) {
                delegate = GraalHPyBoxing.unboxDouble(bits);
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return PythonContext.get(inliningTarget).getHPyContext().createHandle(delegate);
        }
    }

    @ImportStatic(value={GraalHPyBoxing.class})
    public static abstract class HPyWithContextNode
    extends PNodeWithContext {
        static long asPointer(Object handle, InteropLibrary lib) {
            try {
                return lib.asPointer(handle);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAsContextNode
    extends CExtToJavaNode {
        @Specialization
        static GraalHPyContext doHandle(GraalHPyNativeContext hpyContext) {
            return hpyContext.context;
        }

        @Specialization
        GraalHPyContext doInt(int handle) {
            return this.getContext().getHPyContext();
        }

        @Specialization
        GraalHPyContext doLong(long handle) {
            return this.getContext().getHPyContext();
        }

        @Specialization(guards={"interopLibrary.isPointer(handle)"}, limit="2")
        static GraalHPyContext doPointer(Object handle, @CachedLibrary(value="handle") InteropLibrary interopLibrary) {
            return PythonContext.get((Node)interopLibrary).getHPyContext();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyCreateLegacySlotNode
    extends PNodeWithContext {
        public abstract boolean execute(GraalHPyContext var1, Object var2, TpSlots.Builder var3, Object var4, int var5);

        @Specialization
        static boolean doIt(GraalHPyContext context, Object enclosingType, TpSlots.Builder tpSlotsBuilder, Object slotDefArrPtr, int i, @Bind(value="this") Node inliningTarget, @Cached(parameters={"context"}) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached CExtNodes.CreateMethodNode legacyMethodNode, @Cached HPyCreateLegacyMemberNode createLegacyMemberNode, @Cached HPyAddLegacyGetSetDefNode legacyGetSetNode, @Cached WriteAttributeToObjectNode writeAttributeToObjectNode, @Cached ReadAttributeFromObjectNode readAttributeToObjectNode, @Cached ReadPropertyNode readPropertyNode, @Cached WritePropertyNode writePropertyNode, @CachedLibrary(limit="1") InteropLibrary lib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            long slotIdOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, context.getCTypeSize(HPyContextSignatureType.PyType_Slot), GraalHPyCField.PyType_Slot__slot);
            int slotId = readGenericNode.executeInt(context, slotDefArrPtr, slotIdOffset, HPyContextSignatureType.Int);
            if (slotId == 0) {
                return false;
            }
            GraalHPyLegacyDef.HPyLegacySlot slot = GraalHPyLegacyDef.HPyLegacySlot.fromValue(slotId);
            if (slot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_SLOT_VALUE, slotId);
            }
            long pfuncOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, context.getCTypeSize(HPyContextSignatureType.PyType_Slot), GraalHPyCField.PyType_Slot__pfunc);
            Object pfuncPtr = readPointerNode.execute(context, slotDefArrPtr, pfuncOffset);
            TpSlots.TpSlotMeta tpSlot = slot.getTpSlot();
            if (tpSlot != null) {
                Object boundExecutable = CExtContext.ensureExecutable(pfuncPtr, tpSlot.getNativeSignature());
                tpSlotsBuilder.set(tpSlot, TpSlot.TpSlotNative.createCExtSlot(boundExecutable));
                return true;
            }
            switch (slot) {
                case Py_tp_members: {
                    HPyProperty property;
                    int j = 0;
                    while ((property = createLegacyMemberNode.execute(context, enclosingType, pfuncPtr, j)) != null) {
                        property.write(inliningTarget, writePropertyNode, readPropertyNode, enclosingType);
                        ++j;
                    }
                    break;
                }
                case Py_tp_methods: {
                    PBuiltinFunction method;
                    int j = 0;
                    while ((method = legacyMethodNode.execute(inliningTarget, pfuncPtr, j)) != null) {
                        writeAttributeToObjectNode.execute(enclosingType, method.getName(), method);
                        ++j;
                    }
                    break;
                }
                case Py_tp_getset: {
                    GetSetDescriptor getSetDescriptor;
                    int j = 0;
                    while ((getSetDescriptor = legacyGetSetNode.execute(context, enclosingType, pfuncPtr, j)) != null) {
                        writeAttributeToObjectNode.execute(enclosingType, getSetDescriptor.getName(), getSetDescriptor);
                        ++j;
                    }
                    break;
                }
                default: {
                    TruffleString attributeKey = slot.getAttributeKey();
                    if (attributeKey == null) break;
                    if (!HPyProperty.keyExists(readAttributeToObjectNode, enclosingType, attributeKey)) {
                        PBuiltinFunction method;
                        Object interopPFuncPtr = context.nativeToInteropPointer(pfuncPtr);
                        Object resolved = CExtNodes.CreateFunctionNode.resolveClosurePointerToBuiltinFun(context.getContext(), interopPFuncPtr, lib, enclosingType, attributeKey, slot.getSignature());
                        if (resolved instanceof PBuiltinFunction) {
                            PBuiltinFunction builtinFunction;
                            method = builtinFunction = (PBuiltinFunction)resolved;
                        } else {
                            Object callable;
                            if (resolved instanceof RootCallTarget || resolved instanceof BuiltinMethodDescriptor) {
                                callable = resolved;
                            } else {
                                assert (resolved == null);
                                callable = interopPFuncPtr;
                            }
                            PythonLanguage lang = PythonLanguage.get(raiseNode);
                            method = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(attributeKey, callable, enclosingType, 0, slot.getSignature(), lang, factory, true);
                        }
                        writeAttributeToObjectNode.execute(enclosingType, attributeKey, method);
                        break;
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)PythonUtils.formatJString("support for legacy slot %s not yet implemented", slot.name()));
                }
            }
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyCreateSlotNode
    extends PNodeWithContext {
        public abstract Object execute(GraalHPyContext var1, PythonClass var2, TpSlots.Builder var3, Object var4);

        @Specialization
        static Object doIt(GraalHPyContext context, PythonClass enclosingType, TpSlots.Builder tpSlotsBuilder, Object slotDef, @Bind(value="this") Node inliningTarget, @Cached HPyReadSlotNode readSlotNode, @Cached PythonObjectFactory factory, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode raiseNode) {
            assert (enclosingType.isHPyType());
            HPySlotData slotData = readSlotNode.execute(inliningTarget, context, slotDef);
            GraalHPyDef.HPySlot slot = slotData.slot;
            TpSlots.TpSlotMeta tpSlot = slot.getTpSlot();
            if (tpSlot != null) {
                Object boundExecutable = CExtContext.ensureExecutable(slotData.impl(), tpSlot.getNativeSignature());
                tpSlotsBuilder.set(tpSlot, TpSlot.TpSlotNative.createHPySlot(boundExecutable));
                return null;
            }
            HPyProperty property = null;
            Object[] methodNames = slot.getAttributeKeys();
            GraalHPyDef.HPySlotWrapper[] slotWrappers = slot.getSignatures();
            if (GraalHPyDef.HPySlot.HPY_TP_DESTROY.equals((Object)slot)) {
                enclosingType.setHPyDestroyFunc(slotData.impl());
            } else {
                if (GraalHPyDef.HPySlot.HPY_TP_TRAVERSE.equals((Object)slot)) {
                    assert (methodNames.length == 0);
                    return GraalHPyDef.HPySlot.HPY_TP_TRAVERSE;
                }
                for (int i = 0; i < methodNames.length; ++i) {
                    Object methodName;
                    TruffleString methodNameStr;
                    Object object = methodNames[i];
                    if (object instanceof HiddenAttr) {
                        HiddenAttr ha = (HiddenAttr)object;
                        methodNameStr = fromJavaStringNode.execute(ha.getName(), PythonUtils.TS_ENCODING);
                        methodName = methodNames[i];
                    } else {
                        methodName = methodNameStr = (TruffleString)methodNames[i];
                    }
                    GraalHPyDef.HPySlotWrapper slotWrapper = slotWrappers[i];
                    PythonClass enclosingTypeForFun = GraalHPyDef.HPySlot.HPY_TP_NEW.equals((Object)slot) ? null : enclosingType;
                    PythonLanguage language = PythonLanguage.get(raiseNode);
                    PBuiltinFunction function = HPyExternalFunctionNodes.createWrapperFunction(language, context, slotWrapper, null, null, methodNameStr, slotData.impl(), enclosingTypeForFun, factory);
                    property = new HPyProperty(methodName, function, property);
                }
            }
            if (GraalHPyDef.HPySlot.HPY_TP_CALL.equals((Object)slot)) {
                if (enclosingType.getItemSize() > 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_USE_CALL_WITH_VAR_OBJECTS);
                }
                if (enclosingType.getBuiltinShape() == -1 && enclosingType.getBasicSize() == 0L) {
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CANNOT_USE_CALL_WITH_LEGACY);
                }
                enclosingType.setHPyDefaultCallFunc(slotData.impl());
            }
            return property;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyReadSlotNode
    extends PNodeWithContext {
        public abstract HPySlotData execute(Node var1, GraalHPyContext var2, Object var3);

        @Specialization
        static HPySlotData doIt(Node inliningTarget, GraalHPyContext context, Object slotDef, @Cached(parameters={"context"}, inline=false) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached(parameters={"context"}, inline=false) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(inline=false) HPyAttachFunctionTypeNode attachFunctionTypeNode) {
            int slotNr = readGenericNode.readInt(context, slotDef, GraalHPyCField.HPyDef__slot__slot);
            GraalHPyDef.HPySlot slot = GraalHPyDef.HPySlot.fromValue(slotNr);
            if (slot == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_SLOT_VALUE, slotNr);
            }
            Object methodFunctionPointer = readPointerNode.read(context, slotDef, GraalHPyCField.HPyDef__slot__impl);
            methodFunctionPointer = attachFunctionTypeNode.execute(context, methodFunctionPointer, slot.getSignatures()[0].getLLVMFunctionType());
            return new HPySlotData(slot, methodFunctionPointer);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyCreateGetSetDescriptorNode
    extends PNodeWithContext {
        public abstract GetSetDescriptor execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        static GetSetDescriptor doIt(GraalHPyContext context, Object type, Object memberDef, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToPythonObjectNode writeDocNode) {
            Object setterFunctionPtr;
            boolean hasSetter;
            boolean hasGetter;
            TruffleString name = fromCharPointerNode.execute(readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__getset__name));
            PNone memberDoc = PNone.NONE;
            Object docCharPtr = readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__getset__doc);
            if (!isNullNode.execute(context, docCharPtr)) {
                memberDoc = fromCharPointerNode.execute(docCharPtr, false);
            }
            Object closurePtr = readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__getset__closure);
            Object getterFunctionPtr = readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__getset__getter_impl);
            boolean bl = hasGetter = !isNullNode.execute(context, getterFunctionPtr);
            if (hasGetter) {
                getterFunctionPtr = attachFunctionTypeNode.execute(context, getterFunctionPtr, GraalHPyContext.LLVMType.HPyFunc_getter);
            }
            boolean bl2 = hasSetter = !isNullNode.execute(context, setterFunctionPtr = readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__getset__setter_impl));
            if (hasSetter) {
                setterFunctionPtr = attachFunctionTypeNode.execute(context, setterFunctionPtr, GraalHPyContext.LLVMType.HPyFunc_setter);
            }
            PBuiltinFunction getterObject = hasGetter ? HPyExternalFunctionNodes.HPyGetSetDescriptorGetterRootNode.createFunction(context, type, name, getterFunctionPtr, closurePtr) : null;
            PBuiltinFunction setterObject = hasSetter ? HPyExternalFunctionNodes.HPyGetSetDescriptorSetterRootNode.createFunction(context, type, name, setterFunctionPtr, closurePtr) : null;
            GetSetDescriptor getSetDescriptor = factory.createGetSetDescriptor(getterObject, setterObject, name, type, !hasSetter);
            writeDocNode.execute(getSetDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            return getSetDescriptor;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAddMemberNode
    extends PNodeWithContext {
        public abstract HPyProperty execute(GraalHPyContext var1, PythonClass var2, Object var3);

        @Specialization
        static HPyProperty doIt(GraalHPyContext context, PythonClass enclosingType, Object memberDef, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached TruffleString.EqualNode equalNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToPythonObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            TruffleString name = fromCharPointerNode.execute(readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__member__name));
            PNone memberDoc = PNone.NONE;
            Object doc = readPointerNode.read(context, memberDef, GraalHPyCField.HPyDef__member__doc);
            if (!isNullNode.execute(context, doc)) {
                memberDoc = fromCharPointerNode.execute(doc, false);
            }
            int type = readGenericNode.readInt(context, memberDef, GraalHPyCField.HPyDef__member__type);
            boolean readOnly = readGenericNode.readInt(context, memberDef, GraalHPyCField.HPyDef__member__readonly) != 0;
            int offset = readGenericNode.readInt(context, memberDef, GraalHPyCField.HPyDef__member__offset);
            if (equalNode.execute((AbstractTruffleString)SpecialAttributeNames.T___VECTORCALLOFFSET__, (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) {
                enclosingType.setHPyVectorcallOffset(offset);
            }
            PythonLanguage language = PythonLanguage.get(raiseNode);
            PBuiltinFunction getterObject = GraalHPyMemberAccessNodes.HPyReadMemberNode.createBuiltinFunction(language, name, type, offset);
            PBuiltinFunction setterObject = null;
            if (!readOnly) {
                setterObject = GraalHPyMemberAccessNodes.HPyWriteMemberNode.createBuiltinFunction(language, name, type, offset);
            }
            GetSetDescriptor memberDescriptor = factory.createMemberDescriptor(getterObject, setterObject, name, enclosingType);
            writeDocNode.execute(memberDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            return new HPyProperty(name, memberDescriptor);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyCreateLegacyMemberNode
    extends PNodeWithContext {
        public abstract HPyProperty execute(GraalHPyContext var1, Object var2, Object var3, int var4);

        @Specialization
        static HPyProperty doIt(GraalHPyContext context, Object enclosingType, Object memberDefArrPtr, int i, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToPythonObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            int pyMemberDefSize = context.getCTypeSize(HPyContextSignatureType.PyMemberDef);
            long nameOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, pyMemberDefSize, GraalHPyCField.PyMemberDef__name);
            long typeOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, pyMemberDefSize, GraalHPyCField.PyMemberDef__type);
            long offsetOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, pyMemberDefSize, GraalHPyCField.PyMemberDef__offset);
            long flagsOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, pyMemberDefSize, GraalHPyCField.PyMemberDef__flags);
            long docOffset = GraalHPyCAccess.ReadGenericNode.getElementPtr(context, (long)i, pyMemberDefSize, GraalHPyCField.PyMemberDef__doc);
            Object namePtr = readPointerNode.execute(context, memberDefArrPtr, nameOffset);
            if (isNullNode.execute(context, namePtr)) {
                return null;
            }
            TruffleString name = fromCharPointerNode.execute(namePtr);
            PNone memberDoc = PNone.NONE;
            Object doc = readPointerNode.execute(context, memberDefArrPtr, docOffset);
            if (!isNullNode.execute(context, doc)) {
                memberDoc = fromCharPointerNode.execute(doc, false);
            }
            int flags = readGenericNode.executeInt(context, memberDefArrPtr, flagsOffset, HPyContextSignatureType.Int);
            int type = readGenericNode.executeInt(context, memberDefArrPtr, typeOffset, HPyContextSignatureType.Int);
            int offset = readGenericNode.executeInt(context, memberDefArrPtr, offsetOffset, HPyContextSignatureType.Int);
            PythonLanguage language = PythonLanguage.get(raiseNode);
            PBuiltinFunction getterObject = GraalHPyMemberAccessNodes.HPyReadMemberNode.createBuiltinFunction(language, name, type, offset);
            PBuiltinFunction setterObject = null;
            if ((flags & 1) == 0) {
                setterObject = GraalHPyMemberAccessNodes.HPyWriteMemberNode.createBuiltinFunction(language, name, type, offset);
            }
            GetSetDescriptor memberDescriptor = factory.createMemberDescriptor(getterObject, setterObject, name, enclosingType);
            writeDocNode.execute(memberDescriptor, SpecialAttributeNames.T___DOC__, memberDoc);
            return new HPyProperty(name, memberDescriptor);
        }
    }

    @CompilerDirectives.ValueType
    record HPySlotData(GraalHPyDef.HPySlot slot, Object impl) {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class WritePropertyNode
    extends Node {
        WritePropertyNode() {
        }

        abstract void execute(Node var1, Object var2, Object var3, Object var4);

        @Specialization
        static void doHiddenAttr(Node inliningTarget, PythonAbstractObject receiver, HiddenAttr key, Object value, @Cached HiddenAttr.WriteNode writeNode) {
            writeNode.execute(inliningTarget, receiver, key, value);
        }

        @Specialization
        static void doString(Object receiver, TruffleString key, Object value, @Cached(inline=false) WriteAttributeToObjectNode writeAttributeToObjectNode) {
            writeAttributeToObjectNode.execute(receiver, key, value);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class ReadPropertyNode
    extends Node {
        ReadPropertyNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        static Object doHiddenAttr(Node inliningTarget, PythonAbstractObject receiver, HiddenAttr key, @Cached HiddenAttr.ReadNode readNode) {
            return readNode.execute(inliningTarget, receiver, key, PNone.NO_VALUE);
        }

        @Specialization
        static Object doOther(Object receiver, TruffleString key, @Cached(inline=false) ReadAttributeFromObjectNode readAttributeFromObjectNode) {
            return readAttributeFromObjectNode.execute(receiver, key);
        }
    }

    @CompilerDirectives.ValueType
    static final class HPyProperty {
        final Object key;
        final Object value;
        final HPyProperty next;

        HPyProperty(Object key, Object value, HPyProperty next) {
            assert (key instanceof TruffleString || key instanceof HiddenAttr);
            this.key = key;
            this.value = value;
            this.next = next;
        }

        HPyProperty(TruffleString key, Object value) {
            this(key, value, null);
        }

        void write(Node inliningTarget, WritePropertyNode writePropertyNode, ReadPropertyNode readPropertyNode, Object enclosingType) {
            HPyProperty prop = this;
            while (prop != null) {
                if (!HPyProperty.keyExists(inliningTarget, readPropertyNode, enclosingType, prop.key)) {
                    writePropertyNode.execute(inliningTarget, enclosingType, prop.key, prop.value);
                }
                prop = prop.next;
            }
        }

        static boolean keyExists(Node inliningTarget, ReadPropertyNode readPropertyNode, Object enclosingType, Object key) {
            return readPropertyNode.execute(inliningTarget, enclosingType, key) != PNone.NO_VALUE;
        }

        static boolean keyExists(ReadAttributeFromObjectNode readAttributeFromObjectNode, Object enclosingType, TruffleString key) {
            return readAttributeFromObjectNode.execute(enclosingType, key) != PNone.NO_VALUE;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyAddLegacyGetSetDefNode
    extends PNodeWithContext {
        public abstract GetSetDescriptor execute(GraalHPyContext var1, Object var2, Object var3, int var4);

        @Specialization
        static GetSetDescriptor doGeneric(GraalHPyContext context, Object owner, Object legacyGetSetDef, int i, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToPythonObjectNode writeDocNode, @Cached PRaiseNode raiseNode) {
            boolean hasSetter;
            long nameOffset = GraalHPyCAccess.ReadPointerNode.getElementPtr(context, (long)i, HPyContextSignatureType.PyGetSetDef, GraalHPyCField.PyGetSetDef__name);
            Object namePtr = readPointerNode.execute(context, legacyGetSetDef, nameOffset);
            if (isNullNode.execute(context, namePtr)) {
                return null;
            }
            TruffleString getSetDescrName = fromCharPointerNode.execute(namePtr);
            long docOffset = GraalHPyCAccess.ReadPointerNode.getElementPtr(context, (long)i, HPyContextSignatureType.PyGetSetDef, GraalHPyCField.PyGetSetDef__doc);
            long getOffset = GraalHPyCAccess.ReadPointerNode.getElementPtr(context, (long)i, HPyContextSignatureType.PyGetSetDef, GraalHPyCField.PyGetSetDef__get);
            long setOffset = GraalHPyCAccess.ReadPointerNode.getElementPtr(context, (long)i, HPyContextSignatureType.PyGetSetDef, GraalHPyCField.PyGetSetDef__set);
            long closureOffset = GraalHPyCAccess.ReadPointerNode.getElementPtr(context, (long)i, HPyContextSignatureType.PyGetSetDef, GraalHPyCField.PyGetSetDef__closure);
            PNone getSetDescrDoc = PNone.NONE;
            Object docPtr = readPointerNode.execute(context, legacyGetSetDef, docOffset);
            if (!isNullNode.execute(context, docPtr)) {
                getSetDescrDoc = fromCharPointerNode.execute(docPtr);
            }
            Object getterFunPtr = readPointerNode.execute(context, legacyGetSetDef, getOffset);
            Object setterFunPtr = readPointerNode.execute(context, legacyGetSetDef, setOffset);
            Object closurePtr = context.nativeToInteropPointer(readPointerNode.execute(context, legacyGetSetDef, closureOffset));
            PythonLanguage lang = PythonLanguage.get(raiseNode);
            PBuiltinFunction getterObject = null;
            if (!isNullNode.execute(context, getterFunPtr)) {
                Object getterFunInteropPtr = CExtContext.ensureExecutable(context.nativeToInteropPointer(getterFunPtr), ExternalFunctionNodes.PExternalFunctionWrapper.GETTER);
                getterObject = HPyExternalFunctionNodes.HPyLegacyGetSetDescriptorGetterRoot.createLegacyFunction(context, lang, owner, getSetDescrName, getterFunInteropPtr, closurePtr);
            }
            PBuiltinFunction setterObject = null;
            boolean bl = hasSetter = !isNullNode.execute(context, setterFunPtr);
            if (hasSetter) {
                Object setterFunInteropPtr = CExtContext.ensureExecutable(context.nativeToInteropPointer(setterFunPtr), ExternalFunctionNodes.PExternalFunctionWrapper.SETTER);
                setterObject = HPyExternalFunctionNodes.HPyLegacyGetSetDescriptorSetterRoot.createLegacyFunction(context, lang, owner, getSetDescrName, setterFunInteropPtr, closurePtr);
            }
            GetSetDescriptor getSetDescriptor = factory.createGetSetDescriptor(getterObject, setterObject, getSetDescrName, owner, hasSetter);
            writeDocNode.execute(getSetDescriptor, SpecialAttributeNames.T___DOC__, getSetDescrDoc);
            return getSetDescriptor;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyCreateFunctionNode
    extends PNodeWithContext {
        public abstract PBuiltinFunction execute(GraalHPyContext var1, Object var2, Object var3);

        @Specialization
        static PBuiltinFunction doIt(GraalHPyContext context, Object enclosingType, Object methodDef, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached HPyAttachFunctionTypeNode attachFunctionTypeNode, @Cached PythonObjectFactory factory, @Cached WriteAttributeToPythonObjectNode writeAttributeToPythonObjectNode, @Cached PRaiseNode raiseNode) {
            GraalHPyDef.HPyFuncSignature signature;
            TruffleString methodName = fromCharPointerNode.execute(readPointerNode.read(context, methodDef, GraalHPyCField.HPyDef__meth__name));
            PNone methodDoc = PNone.NONE;
            Object doc = readPointerNode.read(context, methodDef, GraalHPyCField.HPyDef__meth__doc);
            if (!isNullNode.execute(context, doc)) {
                methodDoc = fromCharPointerNode.execute(doc, false);
            }
            if ((signature = GraalHPyDef.HPyFuncSignature.fromValue(readGenericNode.readInt(context, methodDef, GraalHPyCField.HPyDef__meth__signature))) == null) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNSUPPORTED_HYPMETH_SIG);
            }
            Object methodFunctionPointer = readPointerNode.read(context, methodDef, GraalHPyCField.HPyDef__meth__impl);
            methodFunctionPointer = attachFunctionTypeNode.execute(context, methodFunctionPointer, signature.getLLVMFunctionType());
            PBuiltinFunction function = HPyExternalFunctionNodes.createWrapperFunction(PythonLanguage.get(raiseNode), context, signature, methodName, methodFunctionPointer, enclosingType, factory);
            writeAttributeToPythonObjectNode.execute(function, SpecialAttributeNames.T___DOC__, methodDoc);
            return function;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GraalHPyModuleExecNode
    extends Node {
        public abstract void execute(Node var1, GraalHPyContext var2, PythonModule var3);

        @Specialization
        static void doGeneric(Node node, GraalHPyContext hpyContext, PythonModule module, @Cached(inline=false) HPyExternalFunctionNodes.HPyCheckPrimitiveResultNode checkFunctionResultNode, @Cached(inline=false) HPyAsHandleNode asHandleNode, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object execSlotsObj = module.getNativeModuleDef();
            if (execSlotsObj instanceof LinkedList) {
                LinkedList execSlots = (LinkedList)execSlotsObj;
                for (Object execSlot : execSlots) {
                    GraalHPyModuleExecNode.callExec(node, hpyContext, execSlot, module, checkFunctionResultNode, asHandleNode, lib);
                }
            }
        }

        static void callExec(Node node, GraalHPyContext hPyContext, Object callable, PythonModule module, HPyExternalFunctionNodes.HPyCheckPrimitiveResultNode checkFunctionResultNode, HPyAsHandleNode asHandleNode, InteropLibrary lib) {
            PythonLanguage language = PythonLanguage.get(node);
            PythonContext ctx = hPyContext.getContext();
            PythonContext.PythonThreadState pythonThreadState = ctx.getThreadState(language);
            GraalHPyHandle hModule = asHandleNode.execute(module);
            try {
                checkFunctionResultNode.execute(pythonThreadState, StringLiterals.T_EXEC, lib.execute(callable, new Object[]{hPyContext.getBackend(), hModule}));
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, StringLiterals.T_EXEC, e);
            }
            catch (ArityException e) {
                throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, StringLiterals.T_EXEC, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                if (hModule.isAllocated()) {
                    hModule.closeAndInvalidate(hPyContext);
                }
            }
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline(value=false)
    public static abstract class GraalHPyModuleCreate
    extends Node {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyModuleCreate.class);
        private static final TruffleString CREATE = PythonUtils.tsLiteral("create");

        public abstract Object execute(GraalHPyContext var1, TruffleString var2, Object var3, Object var4);

        @Specialization
        static Object doGeneric(GraalHPyContext context, TruffleString mName, Object spec, Object moduleDefPtr, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached(parameters={"context"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"context"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"context"}) GraalHPyCAccess.ReadGenericNode readGenericNode, @Cached(parameters={"context"}) GraalHPyCAccess.WriteSizeTNode writeSizeTNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached WriteAttributeToPythonObjectNode writeAttrToMethodNode, @Cached HPyCreateFunctionNode addFunctionNode, @Cached CExtNodes.CreateMethodNode addLegacyMethodNode, @Cached HPyReadSlotNode readSlotNode, @Cached HPyExternalFunctionNodes.HPyCheckHandleResultNode checkFunctionResultNode, @Cached HPyAsHandleNode asHandleNode, @CachedLibrary(limit="1") InteropLibrary createLib, @Cached PRaiseNode raiseNode) {
            Object module;
            Object legacyMethods;
            Object docPtr = readPointerNode.read(context, moduleDefPtr, GraalHPyCField.HPyModuleDef__doc);
            TruffleString mDoc = !isNullNode.execute(context, docPtr) ? fromCharPointerNode.execute(docPtr) : null;
            long size = readGenericNode.readLong(context, moduleDefPtr, GraalHPyCField.HPyModuleDef__size);
            if (size < 0L) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, PythonUtils.tsLiteral("HPy does not permit HPyModuleDef.size < 0"));
            }
            if (size > 0L) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, PythonUtils.tsLiteral("Module state is not supported yet in HPy, set HPyModuleDef.size = 0 if module state is not needed"));
            }
            Object moduleDefinesPtr = readPointerNode.read(context, moduleDefPtr, GraalHPyCField.HPyModuleDef__defines);
            LinkedList<Object> executeSlots = new LinkedList<Object>();
            LinkedList<Object> methodDefs = new LinkedList<Object>();
            Object createFunction = null;
            if (!isNullNode.execute(context, moduleDefinesPtr)) {
                Object def;
                int i = 0;
                while (!isNullNode.execute(context, def = readPointerNode.readArrayElement(context, moduleDefinesPtr, i))) {
                    int kind = readGenericNode.readInt(context, def, GraalHPyCField.HPyDef__kind);
                    block0 : switch (kind) {
                        case 2: {
                            methodDefs.add(def);
                            break;
                        }
                        case 1: {
                            HPySlotData slotData = readSlotNode.execute(inliningTarget, context, def);
                            switch (slotData.slot) {
                                case HPY_MOD_CREATE: {
                                    if (createFunction != null) {
                                        throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_HAS_MULTIPLE_CREATE_SLOTS, mName);
                                    }
                                    createFunction = slotData.impl;
                                    break block0;
                                }
                                case HPY_MOD_EXEC: {
                                    if (createFunction != null) {
                                        throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.HPY_DEFINES_CREATE_AND_OTHER_SLOTS, mName);
                                    }
                                    executeSlots.add(slotData.impl);
                                    break block0;
                                }
                            }
                            throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_USES_UNKNOW_SLOT_ID, new Object[]{mName, slotData.slot});
                        }
                        case 3: 
                        case 4: {
                            LOGGER.warning("get/set definitions are not supported for modules");
                            break;
                        }
                        default: {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.severe(PythonUtils.formatJString("unknown definition kind: %d", kind));
                            }
                            assert (false);
                            break;
                        }
                    }
                    ++i;
                }
            }
            boolean hasLegacyMethods = !isNullNode.execute(context, legacyMethods = readPointerNode.read(context, moduleDefPtr, GraalHPyCField.HPyModuleDef__legacy_methods));
            int globalStartIdx = context.getEndIndexOfGlobalTable();
            int nModuleGlobals = GraalHPyModuleCreate.initModuleGlobals(context, moduleDefPtr, globalStartIdx, isNullNode, readPointerNode, writeSizeTNode);
            context.initBatchGlobals(globalStartIdx, nModuleGlobals);
            if (createFunction != null) {
                if (hasLegacyMethods || mDoc != null || nModuleGlobals != 0) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.HPY_DEFINES_CREATE_AND_NON_DEFAULT);
                }
                module = GraalHPyModuleCreate.callCreate(inliningTarget, createFunction, context, spec, checkFunctionResultNode, asHandleNode, createLib);
                if (module instanceof PythonModule) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.HPY_MOD_CREATE_RETURNED_BUILTIN_MOD);
                }
            } else {
                PythonModule pmodule = factory.createPythonModule(mName);
                pmodule.setNativeModuleDef(executeSlots);
                module = pmodule;
            }
            for (Object e : methodDefs) {
                PBuiltinFunction fun = addFunctionNode.execute(context, null, e);
                PBuiltinMethod method = factory.createBuiltinMethod(module, fun);
                writeAttrToMethodNode.execute(method, SpecialAttributeNames.T___MODULE__, mName);
                writeAttrNode.execute(module, fun.getName(), method);
            }
            if (hasLegacyMethods) {
                PBuiltinFunction pBuiltinFunction;
                int i = 0;
                while ((pBuiltinFunction = addLegacyMethodNode.execute(inliningTarget, legacyMethods, i)) != null) {
                    PBuiltinMethod method = factory.createBuiltinMethod(module, pBuiltinFunction);
                    writeAttrToMethodNode.execute(method, SpecialAttributeNames.T___MODULE__, mName);
                    writeAttrNode.execute(module, pBuiltinFunction.getName(), method);
                    ++i;
                }
            }
            if (mDoc != null) {
                writeAttrNode.execute(module, SpecialAttributeNames.T___DOC__, mDoc);
            }
            return module;
        }

        private static int initModuleGlobals(GraalHPyContext hpyContext, Object moduleDefPtr, int startID, GraalHPyCAccess.IsNullNode isNullNode, GraalHPyCAccess.ReadPointerNode readPointerNode, GraalHPyCAccess.WriteSizeTNode writeSizeTNode) {
            Object globalsPtrArr = readPointerNode.read(hpyContext, moduleDefPtr, GraalHPyCField.HPyModuleDef__globals);
            if (!isNullNode.execute(hpyContext, globalsPtrArr)) {
                int i = 0;
                while (true) {
                    Object globalPtr;
                    if (isNullNode.execute(hpyContext, globalPtr = readPointerNode.readArrayElement(hpyContext, globalsPtrArr, i))) {
                        return i;
                    }
                    writeSizeTNode.execute(hpyContext, globalPtr, 0L, startID + i);
                    ++i;
                }
            }
            return 0;
        }

        static Object callCreate(Node inliningTarget, Object callable, GraalHPyContext hPyContext, Object spec, HPyExternalFunctionNodes.HPyCheckFunctionResultNode checkFunctionResultNode, HPyAsHandleNode asHandleNode, InteropLibrary lib) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext ctx = hPyContext.getContext();
            PythonContext.PythonThreadState pythonThreadState = ctx.getThreadState(language);
            GraalHPyHandle hSpec = asHandleNode.execute(spec);
            try {
                Object object = checkFunctionResultNode.execute(pythonThreadState, CREATE, lib.execute(callable, new Object[]{hPyContext.getBackend(), hSpec}));
                return object;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, CREATE, e);
            }
            catch (ArityException e) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, CREATE, e.getExpectedMinArity(), e.getActualArity());
            }
            finally {
                if (hSpec.isAllocated()) {
                    hSpec.closeAndInvalidate(hPyContext);
                }
            }
        }
    }

    public static abstract class HPyAsCharPointerNode
    extends Node {
        public abstract Object execute(GraalHPyContext var1, TruffleString var2, TruffleString.Encoding var3);

        @NeverDefault
        public static HPyAsCharPointerNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createAsCharPointerNode();
        }

        public static HPyAsCharPointerNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedAsCharPointerNode();
        }
    }

    public static abstract class HPyFromCharPointerNode
    extends Node {
        public final TruffleString execute(GraalHPyContext hpyContext, Object charPtr, boolean copy) {
            return this.execute(hpyContext, charPtr, -1, TruffleString.Encoding.UTF_8, copy);
        }

        public final TruffleString execute(GraalHPyContext hpyContext, Object charPtr, TruffleString.Encoding encoding) {
            return this.execute(hpyContext, charPtr, -1, encoding, true);
        }

        public abstract TruffleString execute(GraalHPyContext var1, Object var2, int var3, TruffleString.Encoding var4, boolean var5);

        public abstract TruffleString execute(GraalHPyContext var1, long var2, int var4, TruffleString.Encoding var5, boolean var6);

        @NeverDefault
        public static HPyFromCharPointerNode create(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().createFromCharPointerNode();
        }

        public static HPyFromCharPointerNode getUncached(GraalHPyContext hpyContext) {
            return hpyContext.getBackend().getUncachedFromCharPointerNode();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class HPyRaiseNode
    extends Node {
        public final int raiseInt(Frame frame, GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(frame, nativeContext, errorValue, errType, format, arguments);
        }

        public final Object raise(Frame frame, GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.execute(frame, nativeContext, errorValue, errType, format, arguments);
        }

        public final int raiseIntWithoutFrame(GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(null, nativeContext, errorValue, errType, format, arguments);
        }

        public final Object raiseWithoutFrame(GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.execute(null, nativeContext, errorValue, errType, format, arguments);
        }

        public static int raiseIntUncached(GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return GraalHPyNodesFactory.HPyRaiseNodeGen.getUncached().raiseIntWithoutFrame(nativeContext, errorValue, errType, format, arguments);
        }

        public abstract Object execute(Frame var1, GraalHPyContext var2, Object var3, PythonBuiltinClassType var4, TruffleString var5, Object[] var6);

        public abstract int executeInt(Frame var1, GraalHPyContext var2, int var3, PythonBuiltinClassType var4, TruffleString var5, Object[] var6);

        @Specialization
        static int doInt(Frame frame, GraalHPyContext nativeContext, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached HPyTransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.execute(raiseNode, errType, PNone.NO_VALUE, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, inliningTarget, nativeContext, p);
                return errorValue;
            }
        }

        @Specialization
        static Object doObject(Frame frame, GraalHPyContext nativeContext, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached HPyTransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.execute(raiseNode, errType, PNone.NO_VALUE, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, inliningTarget, nativeContext, p);
                return errorValue;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class HPyTransformExceptionToNativeNode
    extends Node {
        public abstract void execute(Frame var1, Node var2, GraalHPyContext var3, PException var4);

        public final void execute(Node inliningTarget, GraalHPyContext nativeContext, PException e) {
            this.execute(null, inliningTarget, nativeContext, e);
        }

        public final void execute(Node inliningTarget, PException e) {
            this.execute(null, inliningTarget, PythonContext.get(this).getHPyContext(), e);
        }

        public static void executeUncached(GraalHPyContext nativeContext, PException e) {
            GraalHPyNodesFactory.HPyTransformExceptionToNativeNodeGen.getUncached().execute(null, nativeContext, e);
        }

        public static void executeUncached(PException e) {
            GraalHPyNodesFactory.HPyTransformExceptionToNativeNodeGen.getUncached().execute(null, null, e);
        }

        @Specialization
        static void setCurrentException(Frame frame, Node inliningTarget, GraalHPyContext nativeContext, PException e, @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            transformExceptionToNativeNode.execute(frame, inliningTarget, e);
        }
    }

    public static abstract class HPyCallHelperFunctionNode
    extends Node {
        public final Object call(GraalHPyContext context, GraalHPyNativeSymbol name, Object ... args) {
            return this.execute(context, name, args);
        }

        protected abstract Object execute(GraalHPyContext var1, GraalHPyNativeSymbol var2, Object[] var3);

        @NeverDefault
        public static HPyCallHelperFunctionNode create(GraalHPyContext context) {
            return context.getBackend().createCallHelperFunctionNode();
        }

        public static HPyCallHelperFunctionNode getUncached(GraalHPyContext context) {
            return context.getBackend().getUncachedCallHelperFunctionNode();
        }
    }
}

