/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMCallHelperFunctionNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.HPyArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.NativeSpaceArrayWrapper;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import sun.misc.Unsafe;

abstract class GraalHPyLLVMNodes {
    private GraalHPyLLVMNodes() {
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyLLVMCallHelperFunctionNode
    extends PNodeWithContext {
        public static Object callUncached(GraalHPyContext context, GraalHPyNativeSymbol name, Object ... args) {
            return GraalHPyLLVMNodesFactory.HPyLLVMCallHelperFunctionNodeGen.getUncached().execute(null, context, name, args);
        }

        public final Object call(Node inliningTarget, GraalHPyContext context, GraalHPyNativeSymbol name, Object ... args) {
            return this.execute(inliningTarget, context, name, args);
        }

        public abstract Object execute(Node var1, GraalHPyContext var2, GraalHPyNativeSymbol var3, Object[] var4);

        @Specialization
        static Object doIt(Node inliningTarget, GraalHPyContext context, GraalHPyNativeSymbol name, Object[] args, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached HPyLLVMImportSymbolNode importCExtSymbolNode, @Cached CExtCommonNodes.EnsureTruffleStringNode ensureTruffleStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                Object llvmFunction = importCExtSymbolNode.execute(inliningTarget, context, name);
                return ensureTruffleStringNode.execute(inliningTarget, interopLibrary.execute(llvmFunction, args));
            }
            catch (ArityException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, (Exception)e);
            }
            catch (UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CAPI_SYM_NOT_CALLABLE, new Object[]{name});
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class HPyLLVMImportSymbolNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, GraalHPyContext var2, GraalHPyNativeSymbol var3);

        @Specialization(guards={"isSingleContext()", "cachedSymbol == symbol"}, limit="1")
        static Object doSymbolCached(GraalHPyContext nativeContext, GraalHPyNativeSymbol symbol, @Cached(value="symbol") GraalHPyNativeSymbol cachedSymbol, @Cached(value="getLLVMSymbol(nativeContext, symbol)") Object llvmSymbol) {
            return llvmSymbol;
        }

        @Specialization(replaces={"doSymbolCached"})
        static Object doGeneric(Node inliningTarget, GraalHPyContext hpyContext, GraalHPyNativeSymbol symbol, @Cached InlinedExactClassProfile exactClassProfile) {
            return HPyLLVMImportSymbolNode.getLLVMSymbol((GraalHPyContext)exactClassProfile.profile(inliningTarget, (Object)hpyContext), symbol);
        }

        static Object getLLVMSymbol(GraalHPyContext hpyContext, GraalHPyNativeSymbol symbol) {
            GraalHPyNativeContext graalHPyNativeContext = hpyContext.getBackend();
            if (graalHPyNativeContext instanceof GraalHPyLLVMContext) {
                GraalHPyLLVMContext hpyLLVMContext = (GraalHPyLLVMContext)graalHPyNativeContext;
                return hpyLLVMContext.getNativeSymbolCache()[symbol.ordinal()];
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMAsCharPointerNode
    extends GraalHPyNodes.HPyAsCharPointerNode {
        HPyLLVMAsCharPointerNode() {
        }

        @Specialization(guards={"isNativeAccessAllowed(hpyContext)"})
        static Object doNative(GraalHPyContext hpyContext, TruffleString string, TruffleString.Encoding encoding, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached.Exclusive @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Exclusive @Cached TruffleString.AsNativeNode asNativeNode, @Cached.Exclusive @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            TruffleString tsEncoded = switchEncodingNode.execute((AbstractTruffleString)string, encoding);
            TruffleString tsNative = asNativeNode.execute(tsEncoded, byteSize -> callHelperNode.call(inliningTarget, hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_CALLOC, byteSize, 1L), encoding, false, true);
            return getInternalNativePointerNode.execute((AbstractTruffleString)tsNative, encoding);
        }

        @Specialization(replaces={"doNative"})
        static Object doGeneric(GraalHPyContext hpyContext, TruffleString string, TruffleString.Encoding encoding, @Cached.Exclusive @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Exclusive @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            TruffleString tsEncoded = switchEncodingNode.execute((AbstractTruffleString)string, encoding);
            InternalByteArray internalByteArray = getInternalByteArrayNode.execute((AbstractTruffleString)tsEncoded, encoding);
            return new CArrayWrappers.CByteArrayWrapper(internalByteArray.getArray());
        }

        static boolean isNativeAccessAllowed(GraalHPyContext hpyContext) {
            return hpyContext.getContext().isNativeAccessAllowed();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMFromCharPointerNode
    extends GraalHPyNodes.HPyFromCharPointerNode {
        HPyLLVMFromCharPointerNode() {
        }

        @Specialization
        static TruffleString doCStringWrapper(GraalHPyContext hpyContext, CArrayWrappers.CStringWrapper cStringWrapper, int n, TruffleString.Encoding encoding, boolean copy) {
            return cStringWrapper.getString();
        }

        @Specialization
        static TruffleString doCByteArrayWrapper(GraalHPyContext hpyContext, CArrayWrappers.CByteArrayWrapper cByteArrayWrapper, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            byte[] byteArray = cByteArrayWrapper.getByteArray();
            int length = n < 0 ? byteArray.length : n;
            return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(byteArray, 0, length, encoding, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)", "isPointer(lib, charPtr)"})
        static TruffleString doPointer(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length;
            long pointer;
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            try {
                pointer = lib.asPointer(charPtr);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (n < 0) {
                length = 0;
                Unsafe unsafe = hpyContext.getContext().getUnsafe();
                while (unsafe.getByte(pointer + (long)length) != 0) {
                    ++length;
                }
            } else {
                length = n;
            }
            return switchEncodingNode.execute((AbstractTruffleString)fromNative.execute(charPtr, 0, length, encoding, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)", "!isPointer(lib, charPtr)"})
        static TruffleString doForeignArray(GraalHPyContext hpyContext, Object charPtr, int n, TruffleString.Encoding encoding, boolean copy, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @CachedLibrary(limit="1") InteropLibrary elementLib, @Bind(value="this") Node inliningTarget, @Cached GraalHPyLLVMCallHelperFunctionNode callHelperFunctionNode, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            try {
                int length;
                Object typedCharPtr;
                if (!lib.hasArrayElements(charPtr)) {
                    int size = n < 0 ? Integer.MAX_VALUE : n;
                    typedCharPtr = callHelperFunctionNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_FROM_I8_ARRAY, charPtr, size);
                    if (n < 0) {
                        length = 0;
                        while (elementLib.asByte(lib.readArrayElement(typedCharPtr, (long)length)) != 0) {
                            ++length;
                        }
                    } else {
                        length = n;
                    }
                } else {
                    typedCharPtr = charPtr;
                    int n2 = length = n < 0 ? PInt.intValueExact(lib.getArraySize(charPtr)) : n;
                }
                assert (lib.hasArrayElements(typedCharPtr));
                assert (length >= 0);
                byte[] bytes = getByteArrayNode.execute(inliningTarget, typedCharPtr, length);
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, 0, bytes.length, encoding, false), PythonUtils.TS_ENCODING);
            }
            catch (OverflowException | InteropException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        static boolean isCArrayWrapper(Object object) {
            return object instanceof CArrayWrappers.CArrayWrapper || object instanceof PySequenceArrayWrapper;
        }

        static boolean isPointer(InteropLibrary lib, Object object) {
            return lib.isPointer(object);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWritePointerNode
    extends GraalHPyCAccess.WritePointerNode {
        HPyLLVMWritePointerNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, Object valuePointer, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callWriteDataNode) {
            callWriteDataNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_PTR, basePointer, offset, valuePointer);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteHPyFieldNode
    extends GraalHPyCAccess.WriteHPyFieldNode {
        HPyLLVMWriteHPyFieldNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, PythonObject owner, Object pointer, long offset, Object referent, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyFieldStoreNode fieldStoreNode, @Cached GraalHPyNodes.HPyAsHandleNode asHandleNode, @Cached HPyLLVMCallHelperFunctionNode callGetElementPtr, @Cached HPyLLVMCallHelperFunctionNode callHelperFunctionNode) {
            Object hpyFieldPtr = HPyLLVMGetElementPtrNode.doGeneric(ctx, pointer, offset, inliningTarget, callGetElementPtr);
            Object hpyFieldObject = callHelperFunctionNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_GET_FIELD_I, hpyFieldPtr);
            int idx = fieldStoreNode.execute(inliningTarget, owner, hpyFieldObject, referent);
            GraalHPyHandle newHandle = asHandleNode.executeField(referent, idx);
            callHelperFunctionNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_SET_FIELD_I, hpyFieldPtr, newHandle);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteHPyNode
    extends GraalHPyCAccess.WriteHPyNode {
        HPyLLVMWriteHPyNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, Object object, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyAsHandleNode asHandleNode, @Cached HPyLLVMCallHelperFunctionNode callWriteDataNode) {
            callWriteDataNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_HPY, basePointer, offset, asHandleNode.execute(object));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteGenericNode
    extends GraalHPyCAccess.WriteGenericNode {
        HPyLLVMWriteGenericNode() {
        }

        @Specialization(guards={"type == cachedType"}, limit="1")
        static void doCached(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="type") HPyContextSignatureType cachedType, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, HPyLLVMWriteGenericNode.getWriteAccessor(ctx, cachedType), pointer, offset, value);
        }

        @Specialization(replaces={"doCached"})
        static void doGeneric(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType type, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, HPyLLVMWriteGenericNode.getWriteAccessor(ctx, type), pointer, offset, value);
        }

        static GraalHPyNativeSymbol getWriteAccessor(GraalHPyContext ctx, HPyContextSignatureType type) {
            switch (type) {
                case Int8_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I8;
                }
                case Uint8_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI8;
                }
                case Int16_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I16;
                }
                case Uint16_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI16;
                }
                case Int32_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I32;
                }
                case Uint32_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI32;
                }
                case Int64_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I64;
                }
                case Uint64_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI64;
                }
                case Int: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I;
                }
                case Long: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_L;
                }
                case CFloat: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_F;
                }
                case CDouble: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_D;
                }
                case HPyContextPtr: 
                case VoidPtr: 
                case VoidPtrPtr: 
                case HPyPtr: 
                case ConstHPyPtr: 
                case Wchar_tPtr: 
                case ConstWchar_tPtr: 
                case CharPtr: 
                case ConstCharPtr: 
                case DataPtr: 
                case DataPtrPtr: 
                case Cpy_PyObjectPtr: 
                case HPyModuleDefPtr: 
                case HPyType_SpecPtr: 
                case HPyType_SpecParamPtr: 
                case HPyDefPtr: 
                case HPyFieldPtr: 
                case HPyGlobalPtr: 
                case HPyCapsule_DestructorPtr: 
                case PyType_SlotPtr: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_PTR;
                }
                case Bool: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_BOOL;
                }
                case UnsignedInt: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UI;
                }
                case UnsignedLong: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_UL;
                }
                case HPy_ssize_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_HPY_SSIZE_T;
                }
            }
            int size = ctx.getCTypeSize(type);
            switch (size) {
                case 1: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I8;
                }
                case 2: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I16;
                }
                case 4: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I32;
                }
                case 8: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I64;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteDoubleNode
    extends GraalHPyCAccess.WriteDoubleNode {
        HPyLLVMWriteDoubleNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, double value, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_D, basePointer, offset, value);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteSizeTNode
    extends GraalHPyCAccess.WriteSizeTNode {
        HPyLLVMWriteSizeTNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, long value, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_HPY_SSIZE_T, basePointer, offset, value);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteI64Node
    extends GraalHPyCAccess.WriteI64Node {
        HPyLLVMWriteI64Node() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, long value, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I64, basePointer, offset, value);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMWriteI32Node
    extends GraalHPyCAccess.WriteI32Node {
        HPyLLVMWriteI32Node() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object basePointer, long offset, int value, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_WRITE_I32, basePointer, offset, value);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadGenericNode
    extends GraalHPyCAccess.ReadGenericNode {
        HPyLLVMReadGenericNode() {
        }

        @Override
        protected final int executeInt(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType size) {
            Object object = this.execute(ctx, pointer, offset, size);
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                return i;
            }
            if (object instanceof Long) {
                Long l = (Long)object;
                return (int)l.longValue();
            }
            return this.numberAsInt((Number)object);
        }

        @Override
        protected final long executeLong(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType size) {
            Object object = this.execute(ctx, pointer, offset, size);
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                return i.intValue();
            }
            if (object instanceof Long) {
                Long l = (Long)object;
                return l;
            }
            return this.numberAsLong((Number)object);
        }

        @Specialization
        static Object doGeneric(GraalHPyContext ctx, Object pointer, long offset, HPyContextSignatureType ctype, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            return callHelperFunction.call(inliningTarget, ctx, HPyLLVMReadGenericNode.getReadAccessorName(ctx, ctype), pointer, offset);
        }

        static GraalHPyNativeSymbol getReadAccessorName(GraalHPyContext ctx, HPyContextSignatureType type) {
            switch (type) {
                case Int8_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I8;
                }
                case Uint8_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI8;
                }
                case Int16_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I16;
                }
                case Uint16_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI16;
                }
                case Int32_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I32;
                }
                case Uint32_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI32;
                }
                case Int64_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I64;
                }
                case Uint64_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI64;
                }
                case Int: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I;
                }
                case Long: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_L;
                }
                case CFloat: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_F;
                }
                case CDouble: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_D;
                }
                case HPyContextPtr: 
                case VoidPtr: 
                case VoidPtrPtr: 
                case HPyPtr: 
                case ConstHPyPtr: 
                case Wchar_tPtr: 
                case ConstWchar_tPtr: 
                case CharPtr: 
                case ConstCharPtr: 
                case DataPtr: 
                case DataPtrPtr: 
                case Cpy_PyObjectPtr: 
                case HPyModuleDefPtr: 
                case HPyType_SpecPtr: 
                case HPyType_SpecParamPtr: 
                case HPyDefPtr: 
                case HPyFieldPtr: 
                case HPyGlobalPtr: 
                case HPyCapsule_DestructorPtr: 
                case PyType_SlotPtr: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_PTR;
                }
                case Bool: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_BOOL;
                }
                case UnsignedInt: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UI;
                }
                case UnsignedLong: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_UL;
                }
                case HPy_ssize_t: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_HPY_SSIZE_T;
                }
            }
            int size = ctx.getCTypeSize(type);
            switch (size) {
                case 1: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I8;
                }
                case 2: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I16;
                }
                case 4: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I32;
                }
                case 8: {
                    return GraalHPyNativeSymbol.GRAAL_HPY_READ_I64;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid member type");
        }

        @CompilerDirectives.TruffleBoundary
        private int numberAsInt(Number number) {
            return number.intValue();
        }

        @CompilerDirectives.TruffleBoundary
        private long numberAsLong(Number number) {
            return number.longValue();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadPointerNode
    extends GraalHPyCAccess.ReadPointerNode {
        HPyLLVMReadPointerNode() {
        }

        @Specialization
        static Object doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction) {
            return callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_PTR, pointer, offset);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadDoubleNode
    extends GraalHPyCAccess.ReadDoubleNode {
        HPyLLVMReadDoubleNode() {
        }

        @Specialization
        static double doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object nativeValue = callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_D, pointer, offset);
            if (nativeValue instanceof Double) {
                Double d = (Double)nativeValue;
                return d;
            }
            if (lib.fitsInDouble(nativeValue)) {
                try {
                    return lib.asDouble(nativeValue);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadFloatNode
    extends GraalHPyCAccess.ReadFloatNode {
        HPyLLVMReadFloatNode() {
        }

        @Specialization
        static double doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object nativeValue = callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_F, pointer, offset);
            if (nativeValue instanceof Double) {
                Double d = (Double)nativeValue;
                return d;
            }
            if (lib.fitsInDouble(nativeValue)) {
                try {
                    return lib.asDouble(nativeValue);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadI64Node
    extends GraalHPyCAccess.ReadI64Node {
        HPyLLVMReadI64Node() {
        }

        @Specialization
        static long doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object nativeValue = callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_I64, pointer, offset);
            if (nativeValue instanceof Long) {
                return (Long)nativeValue;
            }
            if (lib.fitsInLong(nativeValue)) {
                try {
                    return lib.asLong(nativeValue);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadI32Node
    extends GraalHPyCAccess.ReadI32Node {
        HPyLLVMReadI32Node() {
        }

        @Specialization
        static int doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperFunction, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object nativeValue = callHelperFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_I32, pointer, offset);
            if (nativeValue instanceof Integer) {
                return (Integer)nativeValue;
            }
            if (lib.fitsInInt(nativeValue)) {
                try {
                    return lib.asInt(nativeValue);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadHPyArrayNode
    extends GraalHPyCAccess.ReadHPyArrayNode {
        HPyLLVMReadHPyArrayNode() {
        }

        @Specialization
        static Object[] doHPyArrayWrapper(GraalHPyContext ctx, HPyArrayWrappers.HPyArrayWrapper pointer, long loffset, long ln, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile) {
            int n = HPyLLVMReadHPyArrayNode.ensureIntRange(ln);
            int offset = HPyLLVMReadHPyArrayNode.ensureIntRange(loffset);
            Object[] delegate = pointer.getDelegate();
            if (profile.profile(inliningTarget, offset == 0 && delegate.length == n)) {
                return delegate;
            }
            return PythonUtils.arrayCopyOfRange(delegate, offset, offset + n);
        }

        @Specialization
        static Object[] doPointer(GraalHPyContext ctx, Object pointer, long offset, long ln, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary arrayLib, @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode) {
            int n = HPyLLVMReadHPyArrayNode.ensureIntRange(ln);
            Object typedArrayPtr = callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_FROM_HPY_ARRAY, pointer, offset + ln);
            if (!arrayLib.hasArrayElements(typedArrayPtr)) {
                throw CompilerDirectives.shouldNotReachHere((String)"returned pointer object must have array type");
            }
            Object[] elements = new Object[n];
            try {
                for (int i = 0; i < elements.length; ++i) {
                    Object element = arrayLib.readArrayElement(typedArrayPtr, offset + (long)i);
                    elements[i] = asPythonObjectNode.execute(element);
                }
                return elements;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (InvalidArrayIndexException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached((Node)arrayLib, PythonBuiltinClassType.SystemError, ErrorMessages.CANNOT_ACCESS_IDX, e.getInvalidIndex(), n);
            }
        }

        private static int ensureIntRange(long n) {
            if (PInt.isIntRange(n)) {
                return (int)n;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"cannot fit long into int");
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadHPyFieldNode
    extends GraalHPyCAccess.ReadHPyFieldNode {
        HPyLLVMReadHPyFieldNode() {
        }

        @Specialization
        static Object doGeneric(GraalHPyContext ctx, PythonObject owner, Object pointer, long offset, boolean close, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached GraalHPyNodes.HPyFieldLoadNode hpyFieldLoadNode) {
            Object nativeValue = callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_HPYFIELD, pointer, offset);
            return hpyFieldLoadNode.execute(inliningTarget, owner, nativeValue);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMReadHPyNode
    extends GraalHPyCAccess.ReadHPyNode {
        HPyLLVMReadHPyNode() {
        }

        @Specialization(guards={"!close"})
        static Object doGet(GraalHPyContext ctx, Object pointer, long offset, boolean close, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached.Exclusive @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode) {
            Object nativeValue = callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_HPY, pointer, offset);
            return asPythonObjectNode.execute(nativeValue);
        }

        @Specialization(guards={"close"})
        static Object doClose(GraalHPyContext ctx, Object pointer, long offset, boolean close, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached.Exclusive @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode) {
            Object nativeValue = callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_HPY, pointer, offset);
            return closeAndGetHandleNode.execute(inliningTarget, nativeValue);
        }

        @Specialization(replaces={"doGet", "doClose"})
        static Object doGeneric(GraalHPyContext ctx, Object pointer, long offset, boolean close, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached HPyLLVMCallHelperFunctionNode callHelperNode, @Cached.Exclusive @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode, @Cached.Exclusive @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode) {
            Object nativeValue = callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_READ_HPY, pointer, offset);
            if (close) {
                return closeAndGetHandleNode.execute(inliningTarget, nativeValue);
            }
            return asPythonObjectNode.execute(nativeValue);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class LLVMReadI8ArrayNode
    extends GraalHPyCAccess.ReadI8ArrayNode {
        LLVMReadI8ArrayNode() {
        }

        @Specialization(limit="1")
        static byte[] doGeneric(GraalHPyContext ctx, Object pointer, long offset, long n, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="pointer") InteropLibrary interopLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached HPyLLVMCallHelperFunctionNode callHPyFunction) {
            if (!PInt.isIntRange(n)) {
                throw CompilerDirectives.shouldNotReachHere((String)"cannot fit long into int");
            }
            Object typedPointer = !interopLib.hasArrayElements(pointer) ? callHPyFunction.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_FROM_I8_ARRAY, pointer, n) : pointer;
            try {
                return getByteArrayNode.execute(inliningTarget, typedPointer, n);
            }
            catch (OverflowException | InteropException ex) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMGetElementPtrNode
    extends GraalHPyCAccess.GetElementPtrNode {
        HPyLLVMGetElementPtrNode() {
        }

        @Specialization
        static Object doGeneric(GraalHPyContext ctx, Object pointer, long offset, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperNode) {
            return callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_GET_ELEMENT_PTR, pointer, offset);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMBulkFreeHandleReferencesNode
    extends GraalHPyCAccess.BulkFreeHandleReferencesNode {
        HPyLLVMBulkFreeHandleReferencesNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, GraalHPyContext.GraalHPyHandleReference[] references, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperNode) {
            NativeSpaceArrayWrapper nativeSpaceArrayWrapper = new NativeSpaceArrayWrapper(references);
            callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_BULK_FREE, nativeSpaceArrayWrapper);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMFreeNode
    extends GraalHPyCAccess.FreeNode {
        HPyLLVMFreeNode() {
        }

        @Specialization
        static void doGeneric(GraalHPyContext ctx, Object pointer, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperNode) {
            callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_FREE, pointer);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class LLVMAllocateNode
    extends GraalHPyCAccess.AllocateNode {
        LLVMAllocateNode() {
        }

        @Specialization
        static Object doGeneric(GraalHPyContext ctx, long size, boolean zero, @Bind(value="this") Node inliningTarget, @Cached HPyLLVMCallHelperFunctionNode callHelperNode) {
            return callHelperNode.call(inliningTarget, ctx, GraalHPyNativeSymbol.GRAAL_HPY_CALLOC, size, 1L);
        }

        static LLVMAllocateNode create() {
            return GraalHPyLLVMNodesFactory.LLVMAllocateNodeGen.create();
        }

        static LLVMAllocateNode getUncached() {
            return GraalHPyLLVMNodesFactory.LLVMAllocateNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class HPyLLVMIsNullNode
    extends GraalHPyCAccess.IsNullNode {
        HPyLLVMIsNullNode() {
        }

        @Specialization(limit="2")
        static boolean doGeneric(GraalHPyContext hpyContext, Object pointer, @CachedLibrary(value="pointer") InteropLibrary lib) {
            return lib.isNull(pointer);
        }
    }
}

