/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

public final class PForeignArrayIterator
extends PythonBuiltinObject {
    private final Object foreignArray;
    private int cursor;

    public PForeignArrayIterator(Object cls, Shape instanceShape, Object foreignArray) {
        super(cls, instanceShape);
        this.foreignArray = foreignArray;
    }

    public Object getForeignArray() {
        return this.foreignArray;
    }

    public int getSize(InteropLibrary lib, Node inliningTarget, PyNumberAsSizeNode asSizeNode) {
        try {
            long size = lib.getArraySize(this.foreignArray);
            return asSizeNode.executeExact(null, inliningTarget, size);
        }
        catch (UnsupportedMessageException ex) {
            return 0;
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public int advance() {
        return this.cursor++;
    }
}

