/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.GroupByBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PGroupBy;
import com.oracle.graal.python.builtins.objects.itertools.PGrouper;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGroupBy})
public final class GroupByBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GroupByBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PGroupBy self, Object state, @Bind(value="this") Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!(state instanceof PTuple) || (Integer)lenNode.execute(frame, state) != 3) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "3-tuple");
            }
            Object currValue = getItemNode.execute(frame, state, 0);
            self.setCurrValue(currValue);
            Object tgtKey = getItemNode.execute(frame, state, 1);
            self.setTgtKey(tgtKey);
            Object currKey = getItemNode.execute(frame, state, 2);
            self.setCurrKey(currKey);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduceMarkerNotSet(PGroupBy self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile noKeyFuncProfile, @Cached InlinedConditionProfile noValuesProfile, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            Object keyFunc = self.getKeyFunc();
            if (noKeyFuncProfile.profile(inliningTarget, keyFunc == null)) {
                keyFunc = PNone.NONE;
            }
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple1 = factory.createTuple(new Object[]{self.getIt(), keyFunc});
            if (noValuesProfile.profile(inliningTarget, !ReduceNode.valuesSet(self))) {
                return factory.createTuple(new Object[]{type, tuple1});
            }
            PTuple tuple2 = factory.createTuple(new Object[]{self.getCurrValue(), self.getTgtKey(), self.getCurrKey()});
            return factory.createTuple(new Object[]{type, tuple1, tuple2});
        }

        private static boolean valuesSet(PGroupBy self) {
            return self.getTgtKey() != null && self.getCurrKey() != null && self.getCurrValue() != null;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PGroupBy self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached CallNode callNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached InlinedBranchProfile eqProfile, @Cached InlinedConditionProfile hasFuncProfile, @Cached InlinedLoopConditionProfile loopConditionProfile, @Cached PythonObjectFactory factory) {
            self.setCurrGrouper(null);
            while (loopConditionProfile.profile(inliningTarget, NextNode.doGroupByStep(frame, inliningTarget, self, eqProfile, eqNode))) {
                self.groupByStep(frame, inliningTarget, nextNode, callNode, hasFuncProfile);
            }
            self.setTgtKey(self.getCurrKey());
            PGrouper grouper = factory.createGrouper(self, self.getTgtKey());
            return factory.createTuple(new Object[]{self.getCurrKey(), grouper});
        }

        private static boolean doGroupByStep(VirtualFrame frame, Node inliningTarget, PGroupBy self, InlinedBranchProfile eqProfile, PyObjectRichCompareBool.EqNode eqNode) {
            if (self.getCurrKey() == null) {
                return true;
            }
            if (self.getTgtKey() == null) {
                return false;
            }
            eqProfile.enter(inliningTarget);
            return eqNode.compare((Frame)frame, inliningTarget, self.getTgtKey(), self.getCurrKey());
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PGroupBy self) {
            return self;
        }
    }
}

