/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public class BuiltinDispatchers {
    static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, int callTargetIndex, Object[] arguments, ExecutionContext.CallContext callContext, InlinedConditionProfile isNullFrameProfile, IndirectCallNode indirectCallNode) {
        PythonLanguage language = PythonLanguage.get(inliningTarget);
        RootCallTarget callTarget = language.getBuiltinSlotCallTarget(callTargetIndex);
        if (isNullFrameProfile.profile(inliningTarget, frame != null)) {
            callContext.prepareIndirectCall(frame, arguments, inliningTarget);
            return indirectCallNode.call((CallTarget)callTarget, arguments);
        }
        return BuiltinDispatchers.callWithNullFrame(inliningTarget, indirectCallNode, language, arguments, (CallTarget)callTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callWithNullFrame(Node inliningTarget, IndirectCallNode indirectCallNode, PythonLanguage language, Object[] arguments, CallTarget callTarget) {
        PythonContext context = PythonContext.get(inliningTarget);
        PythonContext.PythonThreadState threadState = context.getThreadState(language);
        Object state = ExecutionContext.IndirectCalleeContext.enterIndirect(threadState, arguments);
        try {
            Object object = indirectCallNode.call(callTarget, arguments);
            return object;
        }
        finally {
            ExecutionContext.IndirectCalleeContext.exit(threadState, state);
        }
    }
}

