/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyLongCheckNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={SpecialMethodNames.class})
@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyLongCheckNode
extends PNodeWithContext {
    public static boolean executeUncached(Object o) {
        return PyLongCheckNodeGen.getUncached().execute(null, o);
    }

    public abstract boolean execute(Node var1, Object var2);

    @Specialization
    static boolean doBool(Boolean object) {
        return true;
    }

    @Specialization
    static boolean doInt(Integer object) {
        return true;
    }

    @Specialization
    static boolean doLong(Long object) {
        return true;
    }

    @Specialization
    static boolean doPInt(PInt object) {
        return true;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static boolean doGeneric(Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode, @CachedLibrary(limit="3") InteropLibrary interopLibrary) {
        Object type = getClassNode.execute(inliningTarget, object);
        if (isSubtypeNode.execute(type, (Object)PythonBuiltinClassType.PInt)) {
            return true;
        }
        if (type == PythonBuiltinClassType.ForeignObject) {
            return interopLibrary.fitsInLong(object);
        }
        return false;
    }

    public static PyLongCheckNode getUncached() {
        return PyLongCheckNodeGen.getUncached();
    }
}

