/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class PyObjectGetItem
extends PNodeWithContext {
    public static Object executeUncached(Object receiver, Object key) {
        return PyObjectGetItemNodeGen.getUncached().execute(null, null, receiver, key);
    }

    public final Object executeCached(Frame frame, Object object, Object key) {
        return this.execute(frame, this, object, key);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

    @Specialization(guards={"isBuiltinList(object)"})
    static Object doList(VirtualFrame frame, PList object, Object key, @Cached ListBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @Specialization(guards={"isBuiltinTuple(object)"})
    static Object doTuple(VirtualFrame frame, PTuple object, Object key, @Cached TupleBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isBuiltinDict(object)"})
    static Object doDict(VirtualFrame frame, PDict object, Object key, @Cached DictBuiltins.GetItemNode getItemNode) {
        return getItemNode.execute(frame, object, key);
    }

    @Specialization(replaces={"doList", "doTuple", "doDict"})
    static Object doGeneric(VirtualFrame frame, Node inliningTarget, Object object, Object key, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached PyObjectGetItemGeneric genericNode) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, object);
        return genericNode.execute((Frame)frame, inliningTarget, object, slots, key);
    }

    @NeverDefault
    public static PyObjectGetItem create() {
        return PyObjectGetItemNodeGen.create();
    }

    public static PyObjectGetItem getUncached() {
        return PyObjectGetItemNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PyObjectGetItemGeneric
    extends PNodeWithContext {
        PyObjectGetItemGeneric() {
        }

        public abstract Object execute(Frame var1, Node var2, Object var3, TpSlots var4, Object var5);

        @Specialization(guards={"slots.mp_subscript() != null"})
        static Object doMapping(Frame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callNode) {
            return callNode.execute((VirtualFrame)frame, inliningTarget, slots.mp_subscript(), object, key);
        }

        @Specialization(guards={"slots.sq_item() != null", "slots.mp_subscript() == null"})
        @HostCompilerDirectives.InliningCutoff
        static Object doSequence(Frame frame, Node inliningTarget, Object object, TpSlots slots, Object key, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile negativeIndexProfile, @Cached TpSlotLen.CallSlotLenNode callLenSlot, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSqItem) {
            if (!indexCheckNode.execute(inliningTarget, key)) {
                PyObjectGetItemGeneric.raiseSeqIndexMustBeInt(inliningTarget, key, raiseNode);
            }
            int intKey = asSizeNode.executeExact(frame, inliningTarget, key, PythonBuiltinClassType.IndexError);
            return PySequenceGetItemNode.getItem((VirtualFrame)frame, inliningTarget, object, slots, intKey, negativeIndexProfile, callLenSlot, callSqItem, raiseNode);
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseSeqIndexMustBeInt(Node inliningTarget, Object key, PRaiseNode.Lazy raiseNode) {
            raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.SEQUENCE_INDEX_MUST_BE_INT_NOT_P, key);
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static Object tryType(VirtualFrame frame, Node inliningTarget, Object maybeType, TpSlots slots, Object key, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PyObjectLookupAttr lookupClassGetItem, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile isBuiltinClassProfile, @Cached(inline=false) PythonObjectFactory factory, @Cached(inline=false) CallNode callClassGetItem, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (isTypeNode.execute(inliningTarget, maybeType)) {
                Object classGetitem = lookupClassGetItem.execute((Frame)frame, inliningTarget, maybeType, SpecialMethodNames.T___CLASS_GETITEM__);
                if (!(classGetitem instanceof PNone)) {
                    return callClassGetItem.execute((Frame)frame, classGetitem, key);
                }
                if (isBuiltinClassProfile.profileClass(inliningTarget, maybeType, PythonBuiltinClassType.PythonClass)) {
                    return factory.createGenericAlias(maybeType, key);
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_NOT_SUBSCRIPTABLE, maybeType);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_SUBSCRIPTABLE, maybeType);
        }
    }
}

