/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmeticFactory;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public enum BinaryArithmetic {
    Add(BinaryArithmeticFactory.AddNodeGen::create),
    Sub(BinaryArithmeticFactory.SubNodeGen::create),
    Mul(BinaryArithmeticFactory.MulNodeGen::create),
    TrueDiv(BinaryArithmeticFactory.TrueDivNodeGen::create),
    FloorDiv(BinaryArithmeticFactory.FloorDivNodeGen::create),
    Mod(BinaryArithmeticFactory.ModNodeGen::create),
    LShift(BinaryArithmeticFactory.LShiftNodeGen::create),
    RShift(BinaryArithmeticFactory.RShiftNodeGen::create),
    And(BinaryArithmeticFactory.BitAndNodeGen::create),
    Or(BinaryArithmeticFactory.BitOrNodeGen::create),
    Xor(BinaryArithmeticFactory.BitXorNodeGen::create),
    MatMul(BinaryArithmeticFactory.MatMulNodeGen::create),
    Pow(BinaryArithmeticFactory.PowNodeGen::create),
    DivMod(BinaryArithmeticFactory.DivModNodeGen::create);

    private final CreateBinaryOp create;

    private BinaryArithmetic(CreateBinaryOp create) {
        this.create = create;
    }

    @NeverDefault
    public BinaryOpNode create() {
        return this.create.create();
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallBinaryArithmeticRootNode(language, this);
    }

    static interface CreateBinaryOp {
        public BinaryOpNode create();
    }

    static final class CallBinaryArithmeticRootNode
    extends CallArithmeticRootNode {
        static final Signature SIGNATURE_BINARY = new Signature(2, false, -1, false, PythonUtils.tsArray("$self", "other"), null);
        @Node.Child
        private BinaryOpNode callBinaryNode;
        private final BinaryArithmetic binaryOperator;

        CallBinaryArithmeticRootNode(PythonLanguage language, BinaryArithmetic binaryOperator) {
            super(language);
            this.binaryOperator = binaryOperator;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE_BINARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callBinaryNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callBinaryNode = (BinaryOpNode)this.insert(this.binaryOperator.create());
            }
            return this.callBinaryNode.executeObject(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1));
        }
    }

    public static abstract class DivModNode
    extends BinaryArithmeticRaiseNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = DivModNode.createHandler("divmod");

        @Specialization
        public static PTuple doLL(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            DivModNode.raiseIntDivisionByZero(right == 0, inliningTarget, raiseNode);
            return factory.createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization
        public static PTuple doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            DivModNode.raiseIntDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return factory.createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization
        public static PTuple doDL(double left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            DivModNode.raiseDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return factory.createTuple(new Object[]{Math.floor(left / (double)right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        public static PTuple doDD(double left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            DivModNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return factory.createTuple(new Object[]{Math.floor(left / right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        public static PTuple doLD(long left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            DivModNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return factory.createTuple(new Object[]{Math.floor((double)left / right), FloatBuiltins.ModNode.mod(left, right)});
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(DivMod, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class PowNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = PowNode.createHandler("** or pow()");

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Pow, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class MatMulNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = MatMulNode.createHandler("@");

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(MatMul, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitXorNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitXorNode.createHandler("^");

        @Specialization
        public static int op(int left, int right) {
            return left ^ right;
        }

        @Specialization
        public static long op(long left, long right) {
            return left ^ right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createBinaryOp(Xor, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitOrNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitOrNode.createHandler("|");

        @Specialization
        public static int op(int left, int right) {
            return left | right;
        }

        @Specialization
        public static long op(long left, long right) {
            return left | right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Or, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BitAndNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = BitAndNode.createHandler("&");

        @Specialization
        public static int op(int left, int right) {
            return left & right;
        }

        @Specialization
        public static long op(long left, long right) {
            return left & right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createBinaryOp(And, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class RShiftNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = RShiftNode.createHandler(">>");

        @Specialization(guards={"right < 32", "right >= 0"})
        public static int doIISmall(int left, int right) {
            return left >> right;
        }

        @Specialization(guards={"right < 64", "right >= 0"})
        public static long doIISmall(long left, long right) {
            return left >> (int)right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(RShift, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class LShiftNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = LShiftNode.createHandler("<<");

        @Specialization(guards={"right < 32", "right >= 0"}, rewriteOn={OverflowException.class})
        public static int doII(int left, int right) throws OverflowException {
            int result = left << right;
            if (left != result >> right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization(guards={"right < 64", "right >= 0"}, rewriteOn={OverflowException.class})
        public static long doLL(long left, long right) throws OverflowException {
            long result = left << (int)right;
            if (left != result >> (int)right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(LShift, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class ModNode
    extends BinaryArithmeticRaiseNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = ModNode.createHandler("%");

        @Specialization
        public static int doII(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            ModNode.raiseIntDivisionByZero(right == 0, inliningTarget, raiseNode);
            return Math.floorMod(left, right);
        }

        @Specialization
        public static long doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            ModNode.raiseIntDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return Math.floorMod(left, right);
        }

        @Specialization
        public static double doDL(double left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            ModNode.raiseDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        public static double doDD(double left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            ModNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        public static double doLD(long left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            ModNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return FloatBuiltins.ModNode.mod(left, right);
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Mod, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class FloorDivNode
    extends BinaryArithmeticRaiseNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = FloorDivNode.createHandler("//");

        @Specialization
        public static int doII(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            FloorDivNode.raiseIntDivisionByZero(right == 0, inliningTarget, raiseNode);
            return Math.floorDiv(left, right);
        }

        @Specialization(rewriteOn={OverflowException.class})
        public static long doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) throws OverflowException {
            if (left == Long.MIN_VALUE && right == -1L) {
                throw OverflowException.INSTANCE;
            }
            FloorDivNode.raiseIntDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return Math.floorDiv(left, right);
        }

        @Specialization
        public static double doDL(double left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            FloorDivNode.raiseDivisionByZero(right == 0L, inliningTarget, raiseNode);
            return Math.floor(left / (double)right);
        }

        @Specialization
        public static double doDD(double left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            FloorDivNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return Math.floor(left / right);
        }

        @Specialization
        public static double doLD(long left, double right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            FloorDivNode.raiseDivisionByZero(right == 0.0, inliningTarget, raiseNode);
            return Math.floor((double)left / right);
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(FloorDiv, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class TrueDivNode
    extends BinaryArithmeticRaiseNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = TrueDivNode.createHandler("/");

        @Specialization
        public static double doII(int x, int y, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            return TrueDivNode.doDD(x, y, inliningTarget, raiseNode);
        }

        @Specialization
        public static double doLD(long x, double y, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            return TrueDivNode.doDD(x, y, inliningTarget, raiseNode);
        }

        @Specialization
        public static double doDL(double x, long y, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            return TrueDivNode.doDD(x, y, inliningTarget, raiseNode);
        }

        @Specialization
        public static double doDD(double x, double y, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            TrueDivNode.raiseDivisionByZero(y == 0.0, inliningTarget, raiseNode);
            return x / y;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(TrueDiv, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class BinaryArithmeticRaiseNode
    extends BinaryArithmeticNode {
        protected static void raiseIntDivisionByZero(boolean cond, Node inliningTarget, PRaiseNode.Lazy raiseNode) {
            if (cond) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_OR_MODULO_BY_ZERO, "integer");
            }
        }

        protected static void raiseDivisionByZero(boolean cond, Node inliningTarget, PRaiseNode.Lazy raiseNode) {
            if (cond) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
        }
    }

    public static abstract class MulNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = MulNode.createHandler("*");

        @Specialization(rewriteOn={ArithmeticException.class})
        public static int doII(int x, int y) throws ArithmeticException {
            return Math.multiplyExact(x, y);
        }

        @Specialization(replaces={"doII"})
        public static long doIIL(int x, int y) {
            return (long)x * (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public static long doLL(long x, long y) {
            return Math.multiplyExact(x, y);
        }

        @Specialization
        public static double doDL(double left, long right) {
            return left * (double)right;
        }

        @Specialization
        public static double doLD(long left, double right) {
            return (double)left * right;
        }

        @Specialization
        public static double doDD(double left, double right) {
            return left * right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createPyNumberMultiply(NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class SubNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = SubNode.createHandler("-");

        @Specialization(rewriteOn={ArithmeticException.class})
        public static int doII(int x, int y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        public static long doIIOvf(int x, int y) {
            return (long)x - (long)y;
        }

        @Specialization
        public static double doDD(double left, double right) {
            return left - right;
        }

        @Specialization
        public static double doDL(double left, long right) {
            return left - (double)right;
        }

        @Specialization
        public static double doLD(long left, double right) {
            return (double)left - right;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public static long doLL(long x, long y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode(Sub, NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }
    }

    public static abstract class AddNode
    extends BinaryArithmeticNode {
        public static final Supplier<LookupAndCallBinaryNode.NotImplementedHandler> NOT_IMPLEMENTED = AddNode.createHandler("+");

        public abstract int executeInt(VirtualFrame var1, int var2, int var3) throws UnexpectedResultException;

        public abstract double executeDouble(VirtualFrame var1, double var2, double var4) throws UnexpectedResultException;

        @Specialization(rewriteOn={ArithmeticException.class})
        public static int add(int left, int right) {
            return Math.addExact(left, right);
        }

        @Specialization
        public static long doIIOvf(int x, int y) {
            return (long)x + (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public static long addLong(long left, long right) {
            return Math.addExact(left, right);
        }

        @Specialization
        public static double doDD(double left, double right) {
            return left + right;
        }

        @Specialization
        public static double doDL(double left, long right) {
            return left + (double)right;
        }

        @Specialization
        public static double doLD(long left, double right) {
            return (double)left + right;
        }

        @Specialization
        public static Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createPyNumberAdd(NOT_IMPLEMENTED)") LookupAndCallBinaryNode callNode) {
            return callNode.executeObject(frame, left, right);
        }

        @NeverDefault
        public static AddNode create() {
            return BinaryArithmeticFactory.AddNodeGen.create();
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class BinaryArithmeticNode
    extends BinaryOpNode {
        static Supplier<LookupAndCallBinaryNode.NotImplementedHandler> createHandler(final String operator) {
            return () -> new LookupAndCallBinaryNode.NotImplementedHandler(){
                @Node.Child
                private PRaiseNode raiseNode = PRaiseNode.create();

                @Override
                public Object execute(VirtualFrame frame, Object arg, Object arg2) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, this.getErrorMessage(arg), operator, arg, arg2);
                }

                @CompilerDirectives.TruffleBoundary
                private TruffleString getErrorMessage(Object arg) {
                    if (operator.equals(">>") && arg instanceof PBuiltinMethod && ((PBuiltinMethod)arg).getBuiltinFunction().getName().equalsUncached((AbstractTruffleString)BuiltinNames.T_PRINT, PythonUtils.TS_ENCODING)) {
                        return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P_PRINT;
                    }
                    return ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P;
                }
            };
        }

        @NeverDefault
        public static LookupAndCallBinaryNode createCallNode(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            assert (slot.getReverse() != null);
            return LookupAndCallBinaryNode.createReversible(slot, slot.getReverse(), handler);
        }

        @NeverDefault
        public static LookupAndCallBinaryNode createBinaryOp(SpecialMethodSlot slot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createBinaryOp(slot, slot.getReverse(), handler);
        }

        @NeverDefault
        static LookupAndCallBinaryNode createPyNumberAdd(Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createPyNumberAdd(handler);
        }

        @NeverDefault
        static LookupAndCallBinaryNode createPyNumberMultiply(Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handler) {
            return LookupAndCallBinaryNode.createPyNumberMultiply(handler);
        }
    }
}

