/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.DeleteAttributeNode;
import com.oracle.graal.python.nodes.frame.DeleteGlobalNodeGen;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
public abstract class DeleteGlobalNode
extends PNodeWithContext {
    public static DeleteGlobalNode create() {
        return DeleteGlobalNodeGen.create();
    }

    public final void executeWithGlobals(VirtualFrame frame, Object globals, TruffleString attributeId) {
        CompilerAsserts.partialEvaluationConstant((Object)attributeId);
        this.executeWithGlobalsImpl(frame, globals, attributeId);
    }

    public abstract void executeWithGlobalsImpl(VirtualFrame var1, Object var2, TruffleString var3);

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals"}, limit="1")
    static void deleteDictCached(VirtualFrame frame, PDict globals, TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached(value="globals", weak=true) PDict cachedGlobals, @Cached.Shared(value="delItem") @Cached PyObjectDelItem deleteNode) {
        deleteNode.execute((Frame)frame, inliningTarget, cachedGlobals, attributeId);
    }

    @Specialization(replaces={"deleteDictCached"})
    static void deleteDict(VirtualFrame frame, PDict globals, TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="delItem") @Cached PyObjectDelItem deleteNode) {
        deleteNode.execute((Frame)frame, inliningTarget, globals, attributeId);
    }

    @Specialization(guards={"isSingleContext()", "globals == cachedGlobals"}, limit="1")
    static void deleteModuleCached(VirtualFrame frame, PythonModule globals, TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached(value="globals", weak=true) PythonModule cachedGlobals, @Cached.Shared @Cached DeleteAttributeNode storeNode) {
        storeNode.execute(frame, inliningTarget, cachedGlobals, attributeId);
    }

    @Specialization(replaces={"deleteModuleCached"})
    static void deleteModule(VirtualFrame frame, PythonModule globals, TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DeleteAttributeNode storeNode) {
        storeNode.execute(frame, inliningTarget, globals, attributeId);
    }
}

