/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.CopyWithContextVisitor;
import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.FExprParser;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.NodeFactory;
import com.oracle.graal.python.pegparser.Parser;
import com.oracle.graal.python.pegparser.PythonStringFactory;
import com.oracle.graal.python.pegparser.RuleResultCache;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.pegparser.tokenizer.Tokenizer;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Supplier;

public abstract class AbstractParser {
    static final ExprTy[] EMPTY_EXPR_ARRAY = new ExprTy[0];
    static final KeywordTy[] EMPTY_KEYWORD_ARRAY = new KeywordTy[0];
    static final ArgTy[] EMPTY_ARG_ARRAY = new ArgTy[0];
    private static final String BARRY_AS_BDFL = "with Barry as BDFL, use '<>' instead of '!='";
    private int currentPos = 0;
    private final ArrayList<Token> tokens;
    private final Tokenizer tokenizer;
    private final ErrorCallback errorCb;
    protected final NodeFactory factory;
    private final PythonStringFactory<?> stringFactory;
    private final InputType startRule;
    private final EnumSet<Flags> flags;
    private final int featureVersion;
    protected int level = 0;
    protected boolean callInvalidRules = false;
    private boolean parsingStarted;
    protected boolean errorIndicator = false;
    private ExprTy.Name cachedDummyName;
    protected final RuleResultCache<Object> cache = new RuleResultCache(this);
    protected final ArrayList<TypeIgnoreTy> comments = new ArrayList();
    private final Object[][][] reservedKeywords;
    private final String[] softKeywords;

    protected abstract Object[][][] getReservedKeywords();

    protected abstract String[] getSoftKeywords();

    protected abstract SSTNode runParser(InputType var1);

    AbstractParser(String source, SourceRange sourceRange, PythonStringFactory<?> stringFactory, ErrorCallback errorCb, InputType startRule, EnumSet<Flags> flags, int featureVersion) {
        this.tokens = new ArrayList();
        this.tokenizer = Tokenizer.fromString(errorCb, source, AbstractParser.getTokenizerFlags(startRule, flags), sourceRange);
        this.factory = new NodeFactory();
        this.errorCb = errorCb;
        this.stringFactory = stringFactory;
        this.reservedKeywords = this.getReservedKeywords();
        this.softKeywords = this.getSoftKeywords();
        this.startRule = startRule;
        this.flags = flags;
        this.featureVersion = featureVersion;
    }

    private static EnumSet<Tokenizer.Flag> getTokenizerFlags(InputType type, EnumSet<Flags> parserFlags) {
        EnumSet<Tokenizer.Flag> flags = EnumSet.noneOf(Tokenizer.Flag.class);
        if (type == InputType.FILE) {
            flags.add(Tokenizer.Flag.EXEC_INPUT);
        } else if (type == InputType.SINGLE && parserFlags.contains((Object)Flags.INTERACTIVE_TERMINAL)) {
            flags.add(Tokenizer.Flag.INTERACTIVE);
        }
        if (parserFlags.contains((Object)Flags.TYPE_COMMENTS)) {
            flags.add(Tokenizer.Flag.TYPE_COMMENT);
        }
        if (parserFlags.contains((Object)Flags.ASYNC_HACKS)) {
            flags.add(Tokenizer.Flag.ASYNC_HACKS);
        }
        return flags;
    }

    public SSTNode parse() {
        SSTNode res = this.runParser(this.startRule);
        if (res == null) {
            this.resetParserState();
            this.runParser(this.startRule);
            if (this.errorIndicator) {
                return null;
            }
            int fill = this.getFill();
            if (fill == 0) {
                this.raiseSyntaxError("error at start before reading any input", new Object[0]);
            } else if (this.peekToken((int)(fill - 1)).type == 60 && this.tokenizer.getDone() == Tokenizer.StatusCode.EOF) {
                if (this.tokenizer.getParensNestingLevel() > 0) {
                    this.raiseUnclosedParenthesesError();
                } else {
                    this.raiseSyntaxError("unexpected EOF while parsing", new Object[0]);
                }
            } else if (this.peekToken((int)(fill - 1)).type == 5) {
                this.raiseIndentationError("unexpected indent", new Object[0]);
            } else if (this.peekToken((int)(fill - 1)).type == 6) {
                this.raiseIndentationError("unexpected unindent", new Object[0]);
            } else {
                this.raiseSyntaxErrorKnownLocation(this.peekToken(fill - 1), "invalid syntax", new Object[0]);
            }
        }
        if (this.startRule == InputType.SINGLE && this.tokenizer.isBadSingleStatement()) {
            return this.raiseSyntaxError("multiple statements found while compiling a single statement", new Object[0]);
        }
        return res;
    }

    private void resetParserState() {
        this.errorIndicator = false;
        this.callInvalidRules = true;
        this.level = 0;
        this.cache.clear();
        this.currentPos = 0;
        this.tokenizer.reportIncompleteSourceIfInteractive = false;
    }

    public int mark() {
        return this.currentPos;
    }

    public void reset(int position) {
        this.currentPos = position;
    }

    public Token expect(int tokenKind) {
        Token token = this.getAndInitializeToken();
        if (token.type == tokenKind) {
            ++this.currentPos;
            return token;
        }
        return null;
    }

    public Token expect(String text) {
        Token token = this.getAndInitializeToken();
        if (text.equals(this.getText(token))) {
            ++this.currentPos;
            return token;
        }
        return null;
    }

    protected boolean lookahead(boolean match, int kind) {
        int pos = this.mark();
        Token token = this.expect(kind);
        this.reset(pos);
        return token != null == match;
    }

    protected boolean lookahead(boolean match, String text) {
        int pos = this.mark();
        Token token = this.expect(text);
        this.reset(pos);
        return token != null == match;
    }

    public String getText(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenizer.getTokenString(token);
    }

    public Token getAndInitializeToken() {
        if (this.currentPos < this.getFill()) {
            return this.peekToken(this.currentPos);
        }
        Token token = this.tokenizer.next();
        while (token.type == 57) {
            String tag = this.getText(token);
            this.comments.add(this.factory.createTypeIgnore(token.sourceRange.startLine, tag, token.sourceRange));
            token = this.tokenizer.next();
        }
        if (this.startRule == InputType.SINGLE && token.type == 0 && this.parsingStarted) {
            token.type = 4;
            this.parsingStarted = false;
            if (this.tokenizer.getCurrentIndentIndex() > 0) {
                this.tokenizer.setPendingIndents(-this.tokenizer.getCurrentIndentIndex());
                this.tokenizer.setCurrentIndentIndex(0);
            }
        } else {
            this.parsingStarted = true;
        }
        this.tokens.add(token);
        return this.initializeToken(token);
    }

    public Token getLastNonWhitespaceToken() {
        Token t = null;
        for (int i = this.mark() - 1; i >= 0; --i) {
            t = this.peekToken(i);
            if (t.type != 0 && (t.type < 4 || t.type > 6)) break;
        }
        return t;
    }

    public ExprTy.Name name_token() {
        Token t = this.expect(1);
        if (t != null) {
            return this.factory.createVariable(this.getText(t), t.sourceRange);
        }
        return null;
    }

    public int countDots(Token[] tokenArray) {
        int cnt = 0;
        for (Token t : tokenArray) {
            if (t.type == 52) {
                cnt += 3;
                continue;
            }
            assert (t.type == 23);
            ++cnt;
        }
        return cnt;
    }

    protected ExprTy.Name expect_SOFT_KEYWORD(String keyword) {
        Token t = this.getAndInitializeToken();
        if (t.type == 1 && this.getText(t).equals(keyword)) {
            ++this.currentPos;
            return this.factory.createVariable(this.getText(t), t.sourceRange);
        }
        return null;
    }

    public Token string_token() {
        return this.expect(3);
    }

    public ExprTy number_token() {
        Token t = this.expect(2);
        if (t == null) {
            return null;
        }
        String number = this.getText(t);
        if (number.contains("_")) {
            if (this.featureVersion < 6) {
                this.raiseSyntaxError("Underscores in numeric literals are only supported in Python 3.6 and greater", new Object[0]);
            }
            number = number.replace("_", "");
        }
        int base = 10;
        int start = 0;
        boolean isFloat = false;
        boolean isComplex = false;
        if (number.startsWith("0")) {
            if (number.startsWith("0x") || number.startsWith("0X")) {
                base = 16;
                start = 2;
            } else if (number.startsWith("0o") || number.startsWith("0O")) {
                base = 8;
                start = 2;
            } else if (number.startsWith("0b") || number.startsWith("0B")) {
                base = 2;
                start = 2;
            }
        }
        if (base == 10) {
            boolean bl = isComplex = number.endsWith("j") || number.endsWith("J");
            if (!isComplex) {
                boolean bl2 = isFloat = number.contains(".") || number.contains("e") || number.contains("E");
            }
        }
        if (isComplex) {
            double imag = Double.parseDouble(number.substring(0, number.length() - 1));
            return this.factory.createConstant(ConstantValue.ofComplex(0.0, imag), t.sourceRange);
        }
        if (isFloat) {
            return this.factory.createConstant(ConstantValue.ofDouble(Double.parseDouble(number)), t.sourceRange);
        }
        long max = Long.MAX_VALUE;
        long moltmax = Long.MAX_VALUE / (long)base;
        long result = 0L;
        boolean overunder = false;
        for (int i = start; i < number.length(); ++i) {
            int lastD = AbstractParser.digitValue(number.charAt(i));
            long next = result;
            if (next > moltmax) {
                overunder = true;
            } else if ((next *= (long)base) > Long.MAX_VALUE - (long)lastD) {
                overunder = true;
            } else {
                next += (long)lastD;
            }
            if (overunder) {
                BigInteger bigResult = BigInteger.valueOf(result);
                BigInteger bigBase = BigInteger.valueOf(base);
                while (i < number.length()) {
                    bigResult = bigResult.multiply(bigBase).add(BigInteger.valueOf(AbstractParser.digitValue(number.charAt(i))));
                    ++i;
                }
                return this.factory.createConstant(ConstantValue.ofBigInteger(bigResult), t.sourceRange);
            }
            result = next;
        }
        return this.factory.createConstant(ConstantValue.ofLong(result), t.sourceRange);
    }

    private static int digitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        assert (ch >= 'A' && ch <= 'f');
        return ch - 65 + 10;
    }

    public Token expect_forced_token(int kind, String expected) {
        Token t = this.getAndInitializeToken();
        if (t.type != kind) {
            this.raiseSyntaxErrorKnownLocation(t, "expected '%s'", expected);
            return null;
        }
        ++this.currentPos;
        return t;
    }

    public ExprTy.Name name_from_token(Token t) {
        if (t == null) {
            return null;
        }
        String id = this.getText(t);
        return this.factory.createVariable(id, t.sourceRange);
    }

    public ExprTy.Name soft_keyword_token() {
        Token t = this.expect(1);
        if (t == null) {
            return null;
        }
        String txt = this.getText(t);
        for (String s : this.softKeywords) {
            if (!s.equals(txt)) continue;
            return this.name_from_token(t);
        }
        return null;
    }

    public ExprTy.Name dummyName(Object ... args) {
        if (this.cachedDummyName != null) {
            return this.cachedDummyName;
        }
        this.cachedDummyName = this.factory.createVariable("", SourceRange.ARTIFICIAL_RANGE);
        return this.cachedDummyName;
    }

    public SSTNode joinNamesWithDot(ExprTy a, ExprTy b) {
        String id = ((ExprTy.Name)a).id + "." + ((ExprTy.Name)b).id;
        return this.factory.createVariable(id, a.getSourceRange().withEnd(b.getSourceRange()));
    }

    public <T> T[] insertInFront(T element, T[] seq, Class<T> clazz) {
        Object[] result;
        if (seq == null) {
            result = (Object[])Array.newInstance(clazz, 1);
        } else {
            result = Arrays.copyOf(seq, seq.length + 1);
            System.arraycopy(seq, 0, result, 1, seq.length);
        }
        result[0] = element;
        return result;
    }

    public ExprTy[] insertInFront(ExprTy element, ExprTy[] seq) {
        return this.insertInFront(element, seq, ExprTy.class);
    }

    public PatternTy[] insertInFront(PatternTy element, PatternTy[] seq) {
        return this.insertInFront(element, seq, PatternTy.class);
    }

    public <T> T[] appendToEnd(T[] seq, T element, Class<T> clazz) {
        Object[] result;
        if (seq == null) {
            result = (Object[])Array.newInstance(clazz, 1);
            result[0] = element;
        } else {
            result = Arrays.copyOf(seq, seq.length + 1);
            result[seq.length] = element;
        }
        return result;
    }

    public ExprTy[] appendToEnd(ExprTy[] seq, ExprTy element) {
        return this.appendToEnd(seq, element, ExprTy.class);
    }

    public SSTNode concatenateStrings(Token[] tokenArray) {
        int n = tokenArray.length;
        String[] values = new String[n];
        SourceRange[] sourceRanges = new SourceRange[n];
        for (int i = 0; i < n; ++i) {
            Token t = tokenArray[i];
            values[i] = this.getText(t);
            sourceRanges[i] = t.sourceRange;
        }
        FExprParser fexprParser = (code, sourceRange) -> (ExprTy)new Parser(code, sourceRange, this.stringFactory, new ErrorCallback(){

            @Override
            public void reportIncompleteSource(int line) {
                AbstractParser.this.errorCb.reportIncompleteSource(line);
            }

            @Override
            public void onError(ErrorCallback.ErrorType errorType, SourceRange srcRange, String message) {
                AbstractParser.this.errorCb.onError(errorType, srcRange, "f-string: " + message);
            }

            @Override
            public void onWarning(ErrorCallback.WarningType warningType, SourceRange srcRange, String message) {
                AbstractParser.this.errorCb.onWarning(warningType, srcRange, message);
            }
        }, InputType.FSTRING, this.flags, this.featureVersion).parse();
        return this.factory.createString(values, sourceRanges, fexprParser, this.errorCb, this.stringFactory, this.featureVersion);
    }

    public boolean checkBarryAsFlufl(Token token) {
        if (this.flags.contains((Object)Flags.BARRY_AS_BDFL) && !this.getText(token).equals("<>")) {
            this.errorCb.onError(token.sourceRange, BARRY_AS_BDFL, new Object[0]);
            return true;
        }
        return !this.flags.contains((Object)Flags.BARRY_AS_BDFL) && !this.getText(token).equals("!=");
    }

    public boolean checkLegacyStmt(ExprTy name) {
        String[] candidates;
        if (!(name instanceof ExprTy.Name)) {
            return false;
        }
        for (String candidate : candidates = new String[]{"print", "exec"}) {
            if (!candidate.equals(((ExprTy.Name)name).id)) continue;
            return true;
        }
        return false;
    }

    public String getExprName(ExprTy e) {
        if (e instanceof ExprTy.Attribute || e instanceof ExprTy.Subscript || e instanceof ExprTy.Starred || e instanceof ExprTy.Name || e instanceof ExprTy.Tuple || e instanceof ExprTy.List || e instanceof ExprTy.Lambda) {
            return e.getClass().getSimpleName().toLowerCase();
        }
        if (e instanceof ExprTy.Call) {
            return "function call";
        }
        if (e instanceof ExprTy.BoolOp || e instanceof ExprTy.BinOp || e instanceof ExprTy.UnaryOp) {
            return "expression";
        }
        if (e instanceof ExprTy.GeneratorExp) {
            return "generator expression";
        }
        if (e instanceof ExprTy.Yield || e instanceof ExprTy.YieldFrom) {
            return "yield expression";
        }
        if (e instanceof ExprTy.Await) {
            return "await expression";
        }
        if (e instanceof ExprTy.ListComp) {
            return "list comprehension";
        }
        if (e instanceof ExprTy.SetComp) {
            return "set comprehension";
        }
        if (e instanceof ExprTy.DictComp) {
            return "dict comprehension";
        }
        if (e instanceof ExprTy.Dict) {
            return "dict literal";
        }
        if (e instanceof ExprTy.Set) {
            return "set display";
        }
        if (e instanceof ExprTy.JoinedStr || e instanceof ExprTy.FormattedValue) {
            return "f-string expression";
        }
        if (e instanceof ExprTy.Constant) {
            ExprTy.Constant constant = (ExprTy.Constant)e;
            switch (constant.value.kind) {
                case NONE: {
                    return "None";
                }
                case BOOLEAN: {
                    return constant.value.getBoolean() ? "True" : "False";
                }
                case ELLIPSIS: {
                    return "ellipsis";
                }
            }
            return "literal";
        }
        if (e instanceof ExprTy.Compare) {
            return "comparision";
        }
        if (e instanceof ExprTy.IfExp) {
            return "conditional expression";
        }
        if (e instanceof ExprTy.NamedExpr) {
            return "named expression";
        }
        assert (false) : "unexpected expression " + String.valueOf(e.getClass()) + " in assignment";
        return null;
    }

    private Token initializeToken(Token token) {
        Object[][] kwlist;
        String txt;
        int l;
        if (token.type == 1 && (l = (txt = this.getText(token)).length()) < this.reservedKeywords.length && (kwlist = this.reservedKeywords[l]) != null) {
            for (Object[] kwAssoc : kwlist) {
                if (!txt.equals(kwAssoc[0])) continue;
                token.type = (Integer)kwAssoc[1];
                break;
            }
        }
        if (token.type == 60) {
            this.tokenizerError(token);
        }
        return token;
    }

    protected String newTypeComment(Object token) {
        return this.getText((Token)token);
    }

    protected <T> T[] join(T[] a, T[] b) {
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        if (a != null) {
            T[] result = Arrays.copyOf(a, a.length + b.length);
            System.arraycopy(b, 0, result, a.length, b.length);
            return result;
        }
        return null;
    }

    protected ExprTy setExprContext(ExprTy node, ExprContextTy context) {
        return node.accept(new CopyWithContextVisitor(context));
    }

    private void indent(StringBuffer sb) {
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
    }

    void debugMessageln(String text, Object ... args) {
        StringBuffer sb = new StringBuffer();
        this.indent(sb);
        sb.append(String.format(text, args));
        System.out.println(sb);
    }

    static ExprTy[] extractKeys(KeyValuePair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] keys = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = l[i].key;
        }
        return keys;
    }

    static ExprTy[] extractValues(KeyValuePair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] values = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            values[i] = l[i].value;
        }
        return values;
    }

    static ExprTy[] extractKeys(KeyPatternPair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] keys = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = l[i].key;
        }
        return keys;
    }

    static PatternTy[] extractPatterns(KeyPatternPair[] l) {
        int len = l == null ? 0 : l.length;
        PatternTy[] values = new PatternTy[len];
        for (int i = 0; i < len; ++i) {
            values[i] = l[i].pattern;
        }
        return values;
    }

    static ExprTy[] extractStarredExpressions(KeywordOrStarred[] kwds) {
        ArrayList<ExprTy> list = new ArrayList<ExprTy>();
        for (KeywordOrStarred n : kwds) {
            if (n.isKeyword) continue;
            ExprTy element = (ExprTy)n.element;
            list.add(element);
        }
        return list.toArray(new ExprTy[0]);
    }

    static KeywordTy[] deleteStarredExpressions(KeywordOrStarred[] kwds) {
        ArrayList<KeywordTy> list = new ArrayList<KeywordTy>();
        for (KeywordOrStarred n : kwds) {
            if (!n.isKeyword) continue;
            KeywordTy element = (KeywordTy)n.element;
            list.add(element);
        }
        return list.toArray(new KeywordTy[0]);
    }

    static String[] extractNames(ExprTy[] seq) {
        ArrayList<String> list = new ArrayList<String>();
        for (ExprTy e : seq) {
            String id = ((ExprTy.Name)e).id;
            list.add(id);
        }
        return list.toArray(new String[0]);
    }

    final ExprTy collectCallSequences(ExprTy[] a, KeywordOrStarred[] b, SourceRange sourceRange) {
        ExprTy[] args;
        if (b == null) {
            return this.factory.createCall(this.dummyName(new Object[0]), a, EMPTY_KEYWORD_ARRAY, sourceRange);
        }
        ExprTy[] starred = AbstractParser.extractStarredExpressions(b);
        if (starred.length > 0) {
            args = Arrays.copyOf(a, a.length + starred.length);
            System.arraycopy(starred, 0, args, a.length, starred.length);
        } else {
            args = a;
        }
        return this.factory.createCall(this.dummyName(new Object[0]), args, AbstractParser.deleteStarredExpressions(b), sourceRange);
    }

    private ExprTy visitContainer(ExprTy[] elements, TargetsType type) {
        if (elements == null) {
            return null;
        }
        for (ExprTy expr : elements) {
            ExprTy child = this.getInvalidTarget(expr, type);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private ExprTy getInvalidTarget(ExprTy expr, TargetsType type) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof ExprTy.List) {
            return this.visitContainer(((ExprTy.List)expr).elements, type);
        }
        if (expr instanceof ExprTy.Tuple) {
            return this.visitContainer(((ExprTy.Tuple)expr).elements, type);
        }
        if (expr instanceof ExprTy.Starred) {
            if (type == TargetsType.DEL_TARGETS) {
                return expr;
            }
            return this.getInvalidTarget(((ExprTy.Starred)expr).value, type);
        }
        if (expr instanceof ExprTy.Compare) {
            if (type == TargetsType.FOR_TARGETS) {
                ExprTy.Compare compare = (ExprTy.Compare)expr;
                if (compare.ops[0] == CmpOpTy.In) {
                    return this.getInvalidTarget(compare.left, type);
                }
                return null;
            }
            return expr;
        }
        if (expr instanceof ExprTy.Name || expr instanceof ExprTy.Subscript || expr instanceof ExprTy.Attribute) {
            return null;
        }
        return expr;
    }

    SSTNode nonparenGenexpInCall(ExprTy args, ComprehensionTy[] comprehensions) {
        assert (args instanceof ExprTy.Call);
        ExprTy.Call call = (ExprTy.Call)args;
        int len = call.args.length;
        if (len <= 1) {
            return null;
        }
        ComprehensionTy lastComprehension = comprehensions[comprehensions.length - 1];
        return this.raiseSyntaxErrorKnownRange((SSTNode)call.args[len - 1], this.getLastComprehensionItem(lastComprehension), "Generator expression must be parenthesized", new Object[0]);
    }

    SSTNode raiseSyntaxErrorInvalidTarget(TargetsType type, ExprTy expr) {
        ExprTy invalidTarget = this.getInvalidTarget(expr, type);
        if (invalidTarget != null) {
            String message = type == TargetsType.STAR_TARGETS || type == TargetsType.FOR_TARGETS ? "cannot assign to %s" : "cannot delete %s";
            this.raiseSyntaxErrorKnownLocation(invalidTarget, message, this.getExprName(invalidTarget));
        }
        return this.raiseSyntaxError("invalid syntax", new Object[0]);
    }

    SSTNode raiseSyntaxError(String msg, Object ... arguments) {
        Token errorToken = this.peekToken();
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, errorToken.sourceRange, msg, arguments);
    }

    SSTNode raiseSyntaxErrorKnownLocation(Token errorToken, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, errorToken.sourceRange, msg, arguments);
    }

    SSTNode raiseErrorKnownLocation(ErrorCallback.ErrorType typeError, SourceRange where, String msgIn, Object ... argument) {
        Object msg = msgIn;
        if (this.startRule == InputType.FSTRING) {
            msg = "f-string: " + msgIn;
        }
        this.errorIndicator = true;
        this.errorCb.onError(typeError, where, (String)msg, argument);
        return null;
    }

    SSTNode raiseSyntaxErrorKnownLocation(SSTNode where, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, where.getSourceRange(), msg, arguments);
    }

    SSTNode raiseErrorKnownLocation(ErrorCallback.ErrorType errorType, SSTNode where, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(errorType, where.getSourceRange(), msg, arguments);
    }

    SSTNode raiseSyntaxErrorKnownRange(Token startToken, Token endToken, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, startToken.sourceRange.withEnd(endToken.sourceRange), msg, arguments);
    }

    SSTNode raiseSyntaxErrorKnownRange(SSTNode startNode, SSTNode endNode, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, startNode.getSourceRange().withEnd(endNode.getSourceRange()), msg, arguments);
    }

    SSTNode raiseSyntaxErrorKnownRange(SSTNode startNode, Token endToken, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, startNode.getSourceRange().withEnd(endToken.sourceRange), msg, arguments);
    }

    SSTNode raiseSyntaxErrorStartingFrom(Token where, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, this.tokenizer.extendRangeToCurrentPosition(where.sourceRange), msg, arguments);
    }

    SSTNode raiseSyntaxErrorStartingFrom(SSTNode where, String msg, Object ... arguments) {
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, this.tokenizer.extendRangeToCurrentPosition(where.getSourceRange()), msg, arguments);
    }

    SSTNode raiseArgumentsParsingError(ExprTy e) {
        for (KeywordTy keyword : ((ExprTy.Call)e).keywords) {
            if (keyword.arg != null) continue;
            return this.raiseSyntaxError("positional argument follows keyword argument unpacking", new Object[0]);
        }
        return this.raiseSyntaxError("positional argument follows keyword argument", new Object[0]);
    }

    SSTNode raiseIndentationError(String msg, Object ... arguments) {
        Token errorToken = this.peekToken();
        return this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Indentation, errorToken.sourceRange, msg, arguments);
    }

    void raiseUnclosedParenthesesError() {
        int nestingLevel = this.tokenizer.getParensNestingLevel();
        assert (nestingLevel > 0);
        int errorLineno = this.tokenizer.getParensLineNumberStack()[nestingLevel - 1];
        int errorCol = this.tokenizer.getParensColumnsStack()[nestingLevel - 1];
        this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, new SourceRange(errorLineno, errorCol, errorLineno, -1), "'%c' was never closed", this.tokenizer.getParensStack()[nestingLevel - 1]);
    }

    void tokenizerError(Token token) {
        String msg;
        if (token.type == 60 && this.tokenizer.getDone() == Tokenizer.StatusCode.SYNTAX_ERROR) {
            this.raiseErrorKnownLocation(ErrorCallback.ErrorType.Syntax, token.getSourceRange(), (String)token.extraData, new Object[0]);
        }
        ErrorCallback.ErrorType errorType = ErrorCallback.ErrorType.Syntax;
        int colOffset = -1;
        switch (this.tokenizer.getDone()) {
            case BAD_TOKEN: {
                msg = "invalid token";
                break;
            }
            case EOF: {
                if (this.tokenizer.getParensNestingLevel() > 0) {
                    this.raiseUnclosedParenthesesError();
                } else {
                    this.raiseSyntaxError("unexpected EOF while parsing", new Object[0]);
                }
                return;
            }
            case DEDENT_INVALID: {
                this.raiseIndentationError("unindent does not match any outer indentation level", new Object[0]);
                return;
            }
            case TABS_SPACES_INCONSISTENT: {
                errorType = ErrorCallback.ErrorType.Tab;
                msg = "inconsistent use of tabs and spaces in indentation";
                break;
            }
            case TOO_DEEP_INDENTATION: {
                errorType = ErrorCallback.ErrorType.Indentation;
                msg = "too many levels of indentation";
                break;
            }
            case LINE_CONTINUATION_ERROR: {
                msg = "unexpected character after line continuation character";
                colOffset = this.tokenizer.getNextCharIndex() - this.tokenizer.getLineStartIndex();
                break;
            }
            default: {
                msg = "unknown parsing error";
            }
        }
        this.raiseErrorKnownLocation(errorType, new SourceRange(this.tokenizer.getCurrentLineNumber(), colOffset >= 0 ? colOffset : 0, this.tokenizer.getCurrentLineNumber(), -1), msg, new Object[0]);
    }

    SSTNode interactiveExit() {
        return null;
    }

    <T> T lastItem(T[] seq) {
        return seq[seq.length - 1];
    }

    ExprTy getLastComprehensionItem(ComprehensionTy comprehension) {
        if (comprehension.ifs == null || comprehension.ifs.length == 0) {
            return comprehension.iter;
        }
        return this.lastItem(comprehension.ifs);
    }

    ExprTy ensureReal(ExprTy e) {
        if (!(e instanceof ExprTy.Constant) || ((ExprTy.Constant)e).value.kind == ConstantValue.Kind.COMPLEX) {
            this.raiseSyntaxErrorKnownLocation(e, "real number required in complex literal", new Object[0]);
        }
        return e;
    }

    ExprTy ensureImaginary(ExprTy e) {
        if (!(e instanceof ExprTy.Constant) || ((ExprTy.Constant)e).value.kind != ConstantValue.Kind.COMPLEX) {
            this.raiseSyntaxErrorKnownLocation(e, "imaginary number required in complex literal", new Object[0]);
        }
        return e;
    }

    ModTy makeModule(StmtTy[] statements, SourceRange sourceRange) {
        return this.factory.createModule(statements, (TypeIgnoreTy[])this.comments.toArray(TypeIgnoreTy[]::new), sourceRange);
    }

    <T> T check(T node) {
        if (node == null) {
            this.errorIndicator = true;
        }
        return node;
    }

    <T> T checkVersion(int version, String msg, T node) {
        this.checkVersion(version, msg);
        return node;
    }

    <T> T checkVersion(int version, String msg, Supplier<T> node) {
        this.checkVersion(version, msg);
        return node.get();
    }

    private void checkVersion(int version, String msg) {
        if (this.featureVersion < version) {
            this.raiseSyntaxError("%s only supported in Python 3.%d and greater", msg, version);
        }
    }

    private int getFill() {
        return this.tokens.size();
    }

    private Token peekToken() {
        if (this.currentPos == this.tokens.size()) {
            Token t = this.tokenizer.next();
            if (t.type != 57) {
                this.tokens.add(t);
            }
            return t;
        }
        return this.tokens.get(this.currentPos);
    }

    protected final Token peekToken(int position) {
        assert (position < this.tokens.size());
        return this.tokens.get(position);
    }

    public static enum Flags {
        BARRY_AS_BDFL,
        TYPE_COMMENTS,
        INTERACTIVE_TERMINAL,
        ASYNC_HACKS;

    }

    public static final class KeyValuePair {
        final ExprTy key;
        final ExprTy value;

        KeyValuePair(ExprTy key, ExprTy value) {
            this.key = key;
            this.value = value;
        }
    }

    public static final class KeyPatternPair {
        final ExprTy key;
        final PatternTy pattern;

        KeyPatternPair(ExprTy key, PatternTy pattern) {
            this.key = key;
            this.pattern = pattern;
        }
    }

    public static final class KeywordOrStarred {
        final SSTNode element;
        final boolean isKeyword;

        KeywordOrStarred(SSTNode element, boolean isKeyword) {
            this.element = element;
            this.isKeyword = isKeyword;
        }
    }

    public static enum TargetsType {
        STAR_TARGETS,
        DEL_TARGETS,
        FOR_TARGETS;

    }

    public static final class StarEtc {
        final ArgTy varArg;
        final NameDefaultPair[] kwOnlyArgs;
        final ArgTy kwArg;

        StarEtc(ArgTy varArg, NameDefaultPair[] kwOnlyArgs, ArgTy kwArg) {
            this.varArg = varArg;
            this.kwOnlyArgs = kwOnlyArgs;
            this.kwArg = kwArg;
        }
    }

    public static final class SlashWithDefault {
        final ArgTy[] plainNames;
        final NameDefaultPair[] namesWithDefaults;

        SlashWithDefault(ArgTy[] plainNames, NameDefaultPair[] namesWithDefaults) {
            this.plainNames = plainNames;
            this.namesWithDefaults = namesWithDefaults;
        }
    }

    public static final class NameDefaultPair {
        final ArgTy name;
        final ExprTy def;

        NameDefaultPair(ArgTy name, ExprTy def) {
            this.name = name;
            this.def = def;
        }
    }

    public static final class CmpopExprPair {
        final CmpOpTy op;
        final ExprTy expr;

        CmpopExprPair(CmpOpTy op, ExprTy expr) {
            this.op = op;
            this.expr = expr;
        }
    }
}

